<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class InternshipReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('InternshipReport_model');
        
            if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
        
    }

public function Report()
{
    $data['alldata'] = []; // Empty by default
    $data['institutedata'] = $this->InternshipReport_model->getinstitu();
    $data['branchdata'] = $this->InternshipReport_model->getbranch();
    $data['classdata'] = $this->InternshipReport_model->getclass();
    $data['catdata'] = $this->InternshipReport_model->getcat();
    $data['companydata'] = $this->InternshipReport_model->getcompany();
    $data['yeardata'] = $this->InternshipReport_model->getyear();
    $activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
    $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;

    $this->load->view('admin/header_view');
    $this->load->view('admin/InternshipReport_view.php', $data);
    $this->load->view('admin/footer_view');
}

public function getInternshipData()
{
    $institu_id = $this->input->post('fk_institu');
    $branch_ids = $this->input->post('fkbranch_id');
    $class_ids = $this->input->post('fk_class');
    $cat_ids = $this->input->post('fk_cat');
    $company_ids = $this->input->post('fk_company');
    $year = $this->input->post('year');
    $start_date = $this->input->post('start_date'); // 👈 new
    $end_date   = $this->input->post('end_date');   // 👈 new

    if (!$institu_id) {
        echo json_encode([]);
        return;
    }

    $result = $this->InternshipReport_model->getInternshipDataFiltered(
        $institu_id, $branch_ids, $class_ids, $cat_ids, $company_ids, $year,$start_date, $end_date
    );
    echo json_encode($result);
}

public function getPrintHeadings()
{
    $data = $this->InternshipReport_model->getPrintHeadings();
    echo json_encode($data);
}

// new 

public function getYearwiseData()
{
    $year = $this->input->post('year');
    $branches  = $this->input->post('branches');   // may be an array
 
    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->InternshipReport_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year
        $summary = $this->InternshipReport_model->getSingleYearData($year,$branches);
        $types   = $this->InternshipReport_model->getYearwiseTypes($year,$branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $start_date = $this->input->post('start_date');  // match JS
    $end_date   = $this->input->post('end_date');    // match JS
 
    $result = $this->InternshipReport_model->getBranchwiseCount($institu, $branches, $year, $start_date, $end_date);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $start_date = $this->input->post('start_date');  // match JS
    $end_date   = $this->input->post('end_date');    // match JS
 
    $result = $this->InternshipReport_model->getBranchDetailsData($branch_id, $institu, $year, $start_date, $end_date);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
    $start_date = $this->input->post('start_date');
    $end_date   = $this->input->post('end_date');
 
    $result = $this->InternshipReport_model->getCombinedData($institu, $branches, $years, $start_date, $end_date);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}
 




  
}
