<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inventory extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Inventory_model');
        $this->load->library('upload');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    public function index()
    {
        $data['alldata'] = $this->Inventory_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Inventory_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['supplierdata'] = $this->Inventory_model->getsupplier();
        $data['categorydata'] = $this->Inventory_model->getcategory();
        $data['itemdata'] = $this->Inventory_model->getitem();
        $data['unitdata'] = $this->Inventory_model->getunit();
        
// ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Inventory_view', $data);
        $this->load->view('admin/footer_view');
    }

    // AJAX method to get supplier details
    public function getSupplierDetails()
    {
        $supplier_id = $this->input->post('supplier_id');
        
        if ($supplier_id) {
            $supplier = $this->Inventory_model->getSupplierById($supplier_id);
            
            if ($supplier) {
                echo json_encode([
                    'success' => true,
                    'data' => $supplier
                ]);
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Supplier not found'
                ]);
            }
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Supplier ID required'
            ]);
        }
    }

     // ============ NEW METHOD: Get Item Stock Quantity ============
    public function getItemStockQty()
    {
        $itemId = $this->input->post('item_id');
        
        if ($itemId) {
            // Get stock quantity from model
            $stockQty = $this->Inventory_model->getStockQuantity($itemId);
            
            if ($stockQty !== false) {
                echo json_encode([
                    'success' => true,
                    'stock_qty' => $stockQty
                ]);
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Stock not found',
                    'stock_qty' => 0
                ]);
            }
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Invalid item ID'
            ]);
        }
    }

    public function insertInventory()
    {
        // Get institute id
        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $institute_id = $institute ? $institute->Institu_id : null;

        // Get current financial year
        $finiYear = $this->db->select('finiYear_id')->from('finiyear_master')->where('Active_Deactive', 1)->get()->row();
        $finicial_year = $finiYear ? $finiYear->finiYear_id : null;

        // Calculate Grand Total from totals array
    $totals = $this->input->post('Total');
    $fk_submenuId = $this->input->post('fk_submenuId');
    $grandTotal = 0;
    if (!empty($totals)) {
        foreach ($totals as $total) {
            $grandTotal += floatval($total);
        }
    }

        // Get main form data
        $mainData = array(
            'Date' => $this->input->post('Date'),
            'fkSupplier_id' => $this->input->post('fkSupplier_id'),
            'Con_person_name' => $this->input->post('Con_person_name'),
            'Phone' => $this->input->post('Phone'),
            'GST_no' => $this->input->post('GST_no'),
            'Description' => $this->input->post('Description'),
             'Grand_Total' => $grandTotal, 
            'institute' => $institute_id,
            'finicial_Year' => $finicial_year,
            'created_by'=>$_SESSION['userID']
        );
        
        // Insert main data and get the ID
        $mainId = $this->Inventory_model->insertMainData($mainData);
 
        // Insert log - Action 1 (Insert)
        $action = 1;
        $record_id = $mainId;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

        
        if ($mainId) {
            // Get table data arrays
            $categoryIds = $this->input->post('fkCategory_ID');
            $itemIds = $this->input->post('fkItem_id');
            $unitIds = $this->input->post('fkUnit_ID');
            $quantities = $this->input->post('Quantity');
            $rates = $this->input->post('Rate');
            $totals = $this->input->post('Total');
            
            // Loop through arrays and insert child data
            if (!empty($categoryIds)) {
                foreach ($categoryIds as $key => $categoryId) {
                    // Skip empty rows
                    if (empty($categoryId) && empty($itemIds[$key])) {
                        continue;
                    }
                    
                    $childData = array(
                        'fkInventory_main_id' => $mainId,
                        'fkCategory_ID' => $categoryId,
                        'fkItem_id' => $itemIds[$key],
                        'fkUnit_ID' => $unitIds[$key],
                        'Quantity' => $quantities[$key],
                        'Rate' => $rates[$key],
                        'Total' => $totals[$key]
                    );
                    
                    // Insert child data
                    $this->Inventory_model->insertChildData($childData);
                }
            }
            
            echo json_encode(['success' => true, 'message' => 'Inventory added successfully']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to insert inventory data']);
        }
    }

    public function update()
{
    $id = $this->uri->segment(4);
    $data['data'] = $this->Inventory_model->getMainById($id);
    
    // Fetch and verify child data
    $childData = $this->Inventory_model->getChildByMainId($id);
    
    // Debug: Check what's in childData
    if (!empty($childData)) {
        log_message('debug', 'Child Data Keys: ' . print_r(array_keys((array)$childData[0]), true));
    }
    
    $data['childData'] = $childData;
    $data['supplierdata'] = $this->Inventory_model->getsupplier();
    $data['categorydata'] = $this->Inventory_model->getcategory();
    $data['itemdata'] = $this->Inventory_model->getitem();
    $data['unitdata'] = $this->Inventory_model->getunit();
    
$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
    $this->load->view('admin/Inventory_view', $data);
    $this->load->view('admin/footer_view');
}

    public function updateInventory()
    {
        // Get main form data
        $mainId = $this->input->post('Inventory_main_id');
        $fk_submenuId = $this->input->post('fk_submenuId');

        if (!$mainId) {
            echo json_encode(['success' => false, 'message' => 'Invalid inventory ID']);
            return;
        }
        
        // Get institute id
        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $institute_id = $institute ? $institute->Institu_id : null;

        // Get current financial year
        $finiYear = $this->db->select('finiYear_id')->from('finiyear_master')->where('Active_Deactive', 1)->get()->row();
        $finicial_year = $finiYear ? $finiYear->finiYear_id : null;

         // Calculate Grand Total from totals array
    $totals = $this->input->post('Total');
    $grandTotal = 0;
    if (!empty($totals)) {
        foreach ($totals as $total) {
            $grandTotal += floatval($total);
        }
    }

        $mainData = array(
            'Date' => $this->input->post('Date'),
            'fkSupplier_id' => $this->input->post('fkSupplier_id'),
            'Con_person_name' => $this->input->post('Con_person_name'),
            'Phone' => $this->input->post('Phone'),
            'GST_no' => $this->input->post('GST_no'),
            'Description' => $this->input->post('Description'),
             'Grand_Total' => $grandTotal, 
            'institute' => $institute_id,
            'finicial_Year' => $finicial_year,
            'modified_by'=>$_SESSION['userID']
        );
        
        // Start transaction for data integrity
        $this->db->trans_start();
        
        // Update main data
        $this->Inventory_model->updateMainData($mainId, $mainData);
// Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $mainId;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

        
        // ===== CRITICAL FIX: Delete ALL old child records =====
        // This ensures removed items are actually deleted
        $this->Inventory_model->deleteChildByMainId($mainId);
        
        log_message('debug', 'Deleted all child records for Inventory_main_id: ' . $mainId);
        
        // Get table data arrays
        $categoryIds = $this->input->post('fkCategory_ID');
        $itemIds = $this->input->post('fkItem_id');
        $unitIds = $this->input->post('fkUnit_ID');
        $quantities = $this->input->post('Quantity');
        $rates = $this->input->post('Rate');
        $totals = $this->input->post('Total');
        
        // Insert ALL current records as fresh data
        if (!empty($categoryIds)) {
            $insertCount = 0;
            foreach ($categoryIds as $key => $categoryId) {
                // Skip empty rows
                if (empty($categoryId) && empty($itemIds[$key])) {
                    continue;
                }
                
                $childData = array(
                    'fkInventory_main_id' => $mainId,
                    'fkCategory_ID' => $categoryId,
                    'fkItem_id' => $itemIds[$key],
                    'fkUnit_ID' => $unitIds[$key],
                    'Quantity' => $quantities[$key],
                    'Rate' => $rates[$key],
                    'Total' => $totals[$key]
                );
                
                // Insert as new record
                $this->Inventory_model->insertChildData($childData);
                $insertCount++;
            }
            
            log_message('debug', 'Inserted ' . $insertCount . ' new child records');
        }
        
        // Complete transaction
        $this->db->trans_complete();
        
        if ($this->db->trans_status() === FALSE) {
            log_message('error', 'Update transaction failed for Inventory_main_id: ' . $mainId);
            echo json_encode(['success' => false, 'message' => 'Failed to update inventory']);
        } else {
            echo json_encode(['success' => true, 'message' => 'Inventory updated successfully']);
        }
    }

    // Debug method - remove in production
    public function debugUpdate()
    {
        $id = $this->uri->segment(4);
        
        if (!$id) {
            echo "Please provide an ID: /admin/Inventory/debugUpdate/1";
            return;
        }
        
        echo "<h2>Debug Information for Inventory ID: {$id}</h2>";
        
        // Check main data
        $mainData = $this->Inventory_model->getMainById($id);
        echo "<h3>Main Data:</h3>";
        echo "<pre>";
        print_r($mainData);
        echo "</pre>";
        
        // Check child data with joins
        $childData = $this->Inventory_model->getChildByMainId($id);
        echo "<h3>Child Data (with joins) - Count: " . count($childData) . "</h3>";
        echo "<pre>";
        print_r($childData);
        echo "</pre>";
        
        // Check raw child data
        $rawChildData = $this->Inventory_model->debugChildData($id);
        echo "<h3>Raw Child Data (no joins) - Count: " . count($rawChildData) . "</h3>";
        echo "<pre>";
        print_r($rawChildData);
        echo "</pre>";
        
        // Check table structure
        echo "<h3>Inventory Master Table Structure:</h3>";
        $fields = $this->db->field_data('inventory_master');
        echo "<pre>";
        print_r($fields);
        echo "</pre>";
    }

    // Delete method (bonus)
    public function delete()
    {
        $id = $this->uri->segment(4);
        
        if ($id) {
            $result = $this->Inventory_model->deleteInventory($id);
            
            if ($result) {
                $this->session->set_flashdata('success', 'Inventory deleted successfully');
            } else {
                $this->session->set_flashdata('error', 'Failed to delete inventory');
            }
        }
        
        redirect('admin/Inventory/index');
    }

       // Add this method in your Outward controller
public function getItemUnit()
{
    $itemId = $this->input->post('item_id');
    
    if ($itemId) {
        // Get unit_id from store_item_master table
        $this->db->select('fkUnit_ID as unit_id');
        $this->db->from('store_item_master');
        $this->db->where('Item_id', $itemId);
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            $result = $query->row();
            echo json_encode([
                'success' => true,
                'unit_id' => $result->unit_id
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Unit not found'
            ]);
        }
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Invalid item ID'
        ]);
    }
}





}
?>