<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Library extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Library_model');
        $this->load->library('upload');
        $this->load->library('session');
        $this->load->helper('url');
        $this->load->database();
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    // ============ VIEW METHODS ============

    public function create()
{
    // $data['studentList'] = $this->Library_model->getStudents();
    // $data['branchList'] = $this->Library_model->getBranches();
    // $data['levelList'] = $this->Library_model->getLevels();
    $data['cardList'] = $this->Library_model->getCardTypes();
    $data['yearList'] = $this->Library_model->getYears();

    // Active year
    $data['activeYear'] = $this->Library_model->getActiveYear();

    // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
    $this->load->view('admin/Library_view.php',$data);
    $this->load->view('admin/footer_view');
}


    public function index()
    {
        $data['alldata'] = $this->Library_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Library_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Library_dash_view');
        $this->load->view('admin/footer_view');
    }

    public function Report()
    {
        $data['branchList'] = $this->Library_model->getBranches();
        $data['levelList'] = $this->Library_model->getLevels();
        $data['casteList'] = $this->Library_model->getCastes();
        $data['yearList'] = $this->Library_model->getYears();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Scholership_Report.php', $data);
        $this->load->view('admin/footer_view');
    }

    // ============ INSERT METHODS ============
 public function insertLibrarydata()
    {
        try {
            $this->output->set_content_type('application/json');

            // ------------------ INPUTS ------------------
            $posted_data   = $this->input->post();
            $fk_submenuId  = $this->input->post('fk_submenuId');
            $created_by    = isset($_SESSION['userID']) ? $_SESSION['userID'] : null;

            log_message('debug', '========== Library Insert Start ==========');
            log_message('debug', 'Record Count: ' . (isset($posted_data['CardNo']) ? count($posted_data['CardNo']) : 0));

            // ------------------ VALIDATION ------------------
            if (empty($posted_data['FiniYear'])) {
                echo json_encode(['status' => 'error', 'message' => 'Please select an Academic Year']);
                return;
            }

            if (empty($posted_data['fkCardType'])) {
                echo json_encode(['status' => 'error', 'message' => 'Please select a Card Type']);
                return;
            }

            $selectedYear = $posted_data['FiniYear'];
            $cardType     = $posted_data['fkCardType'];

            // ------------------ INSTITUTE ------------------
            $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
            $instituteId = $institute ? $institute->Institu_id : null;

            // ------------------ FILE UPLOAD ------------------
            $excelFileName = 'Manual_Entry_' . date('Ymd_His');

            if (!empty($_FILES['activity_excel']['name'])) {
                $config = [
                    'upload_path'   => './uploads/library_excel/',
                    'allowed_types' => 'xls|xlsx',
                    'file_name'     => 'Library_' . date('Ymd_His') . '_' . uniqid(),
                    // 'max_size'      => 10240
                ];

                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path'], 0777, true);
                }

                $this->upload->initialize($config);

                if ($this->upload->do_upload('activity_excel')) {
                    $uploadData = $this->upload->data();
                    $excelFileName = $uploadData['file_name'];
                }
            }

            // ------------------ TRANSACTION START ------------------
            $this->db->trans_start();

            // ------------------ PARENT INSERT ------------------
            $mainData = [
                'ExcelName'  => $excelFileName,
                'created_by' => $created_by
            ];

            $this->db->insert('library_excel', $mainData);
            $excel_id = $this->db->insert_id();

            if (!$excel_id) {
                throw new Exception('Failed to create excel record');
            }

            // ------------------ INSERT LOG ------------------
            $Fk_branch = isset($posted_data['fkBranch_id']) ? $posted_data['fkBranch_id'] : null;

            insert_log(
                $this,
                $fk_submenuId,
                1,                  // Action: Insert
                $excel_id,
                $excelFileName,
                $Fk_branch,
                $created_by
            );

            // ------------------ BATCH INSERT FOR CHILD RECORDS ------------------
            if (empty($posted_data['CardNo']) || !is_array($posted_data['CardNo'])) {
                throw new Exception('No library card data found');
            }

            $insertCount = 0;
            $batchSize = 100; // Insert 100 records at a time
            $batchData = [];

            foreach ($posted_data['CardNo'] as $i => $cardNo) {

                if (empty($cardNo) || empty($posted_data['Name'][$i])) {
                    continue;
                }

                $childData = [
                    'excel_upload_id' => $excel_id,
                    'CardNo'          => trim($cardNo),
                    'Name'            => trim($posted_data['Name'][$i]),
                    'Class'           => $posted_data['Class'][$i] ?? null,
                    'Department'      => $posted_data['Department'][$i] ?? null,
                    'Date'            => $posted_data['Date'][$i] ?? date('Y-m-d'),
                    'ContactNO'       => $posted_data['ContactNO'][$i] ?? null,
                    'fkCardType'      => $cardType,
                    'FiniYear'        => $selectedYear,
                    'fkInstitute_Id'  => $instituteId,
                    'is_default'      => 0,
                    'is_on'           => 1,
                    'is_active'       => 1,
                    'created_by'      => $created_by
                ];

                $batchData[] = $childData;

                // Insert when batch is full
                if (count($batchData) >= $batchSize) {
                    $this->db->insert_batch('library_master', $batchData);
                    $insertCount += count($batchData);
                    $batchData = []; // Reset batch
                }
            }

            // Insert remaining records
            if (!empty($batchData)) {
                $this->db->insert_batch('library_master', $batchData);
                $insertCount += count($batchData);
            }

            // ------------------ TRANSACTION END ------------------
            $this->db->trans_complete();

            if ($this->db->trans_status() === FALSE) {
                throw new Exception('Database transaction failed');
            }

            echo json_encode([
                'status'          => 'success',
                'message'         => "Successfully saved {$insertCount} library records",
                'excel_id'        => $excel_id,
                'inserted_count'  => $insertCount
            ]);

            log_message('debug', '========== Library Insert End ==========');

        } catch (Exception $e) {
            log_message('error', $e->getMessage());

            echo json_encode([
                'status'  => 'error',
                'message' => $e->getMessage()
            ]);
        }
    }

// Helper function to get year label
private function getYearLabel($yearId)
{
    $year = $this->Library_model->getYearById($yearId);
    return $year ? $year->fini_Label : $yearId;
}


    // ============ UPDATE METHODS ============
  public function update($excel_upload_id = null)
{
    if (!$excel_upload_id) {
        $excel_upload_id = $this->uri->segment(4);
    }
    
    if (!$excel_upload_id) {
        $this->session->set_flashdata('error', 'Invalid ID');
        redirect('Library/index');
        return;
    }
    
    // Get excel record
    $data['mainData'] = $this->Library_model->getExcelById($excel_upload_id);
    
    if (!$data['mainData']) {
        $this->session->set_flashdata('error', 'Record not found!');
        redirect('Library/index');
        return;
    }
    
    // Get all library records for this excel upload
    $data['childData'] = $this->Library_model->getLibraryByExcelId($excel_upload_id);
    
    // Debug: Check what's being loaded
    log_message('debug', 'Child Data: ' . print_r($data['childData'], true));
    
    // Get dropdowns
    $data['cardList'] = $this->Library_model->getCardTypes();
    $data['yearList'] = $this->Library_model->getYears();
    $data['activeYear'] = $this->Library_model->getActiveYear();
    
    // Pass first record's data for form defaults
    $data['data'] = !empty($data['childData']) ? [$data['childData'][0]] : null;

    $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);
    
    $this->load->view('admin/header_view');
    $this->load->view('admin/Library_view.php', $data);
    $this->load->view('admin/footer_view');
}
  // ============ OPTIMIZED UPDATE METHOD FOR LARGE FILES ============
    public function updateLibrarydata()
    {
        try {
            $this->output->set_content_type('application/json');

            // ---------------- INPUTS ----------------
            $posted_data  = $this->input->post();
            $fk_submenuId = $this->input->post('fk_submenuId');
            $modified_by  = isset($_SESSION['userID']) ? $_SESSION['userID'] : null;

            log_message('debug', '========== Library Update Start ==========');
            log_message('debug', 'Record Count: ' . (isset($posted_data['CardNo']) ? count($posted_data['CardNo']) : 0));

            // ---------------- VALIDATION ----------------
            $excel_id = $posted_data['main_excel_id'] ?? null;
            if (!$excel_id) {
                echo json_encode(['status' => 'error', 'message' => 'Excel ID is required']);
                return;
            }

            if (empty($posted_data['FiniYear'])) {
                echo json_encode(['status' => 'error', 'message' => 'Please select an Academic Year']);
                return;
            }

            if (empty($posted_data['fkCardType'])) {
                echo json_encode(['status' => 'error', 'message' => 'Please select a Card Type']);
                return;
            }

            $selectedYear = $posted_data['FiniYear'];
            $cardType     = $posted_data['fkCardType'];

            // ---------------- INSTITUTE ----------------
            $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
            $instituteId = $institute ? $institute->Institu_id : null;

            // ---------------- FILE UPLOAD (OPTIONAL) ----------------
            if (!empty($_FILES['activity_excel']['name'])) {
                $config = [
                    'upload_path'   => './uploads/library_excel/',
                    'allowed_types' => 'xls|xlsx',
                    'file_name'     => 'Library_' . date('Ymd_His') . '_' . uniqid(),
                    // 'max_size'      => 10240
                ];

                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path'], 0777, true);
                }

                $this->upload->initialize($config);

                if ($this->upload->do_upload('activity_excel')) {
                    $uploadData = $this->upload->data();
                    $this->db->where('excel_id', $excel_id)
                             ->update('library_excel', ['ExcelName' => $uploadData['file_name']]);
                }
            }

            // ---------------- TRANSACTION ----------------
            $this->db->trans_start();

            // Delete all existing records for this excel upload
            $this->db->where('excel_upload_id', $excel_id)->delete('library_master');

            // Batch insert all new records
            $insertCount = 0;
            $batchSize = 100;
            $batchData = [];

            foreach ($posted_data['CardNo'] as $i => $cardNo) {

                if (empty($cardNo) || empty($posted_data['Name'][$i])) {
                    continue;
                }

                $childData = [
                    'excel_upload_id' => $excel_id,
                    'CardNo'          => trim($cardNo),
                    'Name'            => trim($posted_data['Name'][$i]),
                    'Class'           => $posted_data['Class'][$i] ?? null,
                    'Department'      => $posted_data['Department'][$i] ?? null,
                    'Date'            => $posted_data['Date'][$i] ?? date('Y-m-d'),
                    'ContactNO'       => $posted_data['ContactNO'][$i] ?? null,
                    'fkCardType'      => $cardType,
                    'FiniYear'        => $selectedYear,
                    'fkInstitute_Id'  => $instituteId,
                    'is_default'      => 0,
                    'is_on'           => 1,
                    'is_active'       => 1,
                    'modified_by'     => $modified_by
                ];

                $batchData[] = $childData;

                if (count($batchData) >= $batchSize) {
                    $this->db->insert_batch('library_master', $batchData);
                    $insertCount += count($batchData);
                    $batchData = [];
                }
            }

            if (!empty($batchData)) {
                $this->db->insert_batch('library_master', $batchData);
                $insertCount += count($batchData);
            }

            $this->db->trans_complete();

            if ($this->db->trans_status() === FALSE) {
                throw new Exception('Database transaction failed');
            }

            // ---------------- UPDATE LOG (ACTION = 2) ----------------
            $Fk_branch = $posted_data['fkBranch_id'] ?? null;

            insert_log(
                $this,
                $fk_submenuId,
                2,              // Action: Update
                $excel_id,      // Record ID
                null,           // Excel name not changed
                $Fk_branch,
                $modified_by
            );

            // ---------------- RESPONSE ----------------
            echo json_encode([
                'status'          => 'success',
                'message'         => 'Library data updated successfully',
                'excel_id'        => $excel_id,
                'inserted_count'  => $insertCount
            ]);

            log_message('debug', '========== Library Update End ==========');

        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }



public function getScholarshipData()
{
    $this->output->set_content_type('application/json');
    
    $branch_ids = $this->input->post('branch_ids');
    $level_ids = $this->input->post('level_ids');
    $caste_ids = $this->input->post('caste_ids');
    $year_ids = $this->input->post('year_ids');
    
    // Debug logging
    log_message('debug', '=== Scholarship Filter Request ===');
    log_message('debug', 'Branch IDs: ' . json_encode($branch_ids));
    log_message('debug', 'Level IDs: ' . json_encode($level_ids));
    log_message('debug', 'Caste IDs: ' . json_encode($caste_ids));
    log_message('debug', 'Year IDs: ' . json_encode($year_ids));
    
    try {
        $data = $this->Library_model->getScholarshipDataFiltered(
            $branch_ids, 
            $level_ids, 
            $caste_ids, 
            $year_ids
        );
        
        log_message('debug', 'Query Result Count: ' . count($data));
        log_message('debug', 'SQL Query: ' . $this->db->last_query());
        
        // Return data with proper encoding
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        
    } catch (Exception $e) {
        log_message('error', 'getScholarshipData error: ' . $e->getMessage());
        echo json_encode([
            'error' => true,
            'message' => $e->getMessage()
        ]);
    }
}

    // ============ CHART DATA METHODS ============
    
    /**
     * Get combined chart data (branch + year wise)
     */
    public function getCombinedChartData()
    {
        $this->output->set_content_type('application/json');
        
        try {
            $branches = $this->input->post('branches');
            $years = $this->input->post('years');
            
            log_message('debug', 'Chart filters - Branches: ' . json_encode($branches) . ', Years: ' . json_encode($years));
            
            $result = $this->Library_model->getCombinedData($branches, $years);
            
            echo json_encode([
                "status" => "success",
                "branchData" => $result['branchData'],
                "yearData" => $result['yearData']
            ]);
            
        } catch (Exception $e) {
            log_message('error', 'getCombinedChartData error: ' . $e->getMessage());
            echo json_encode([
                "status" => "error",
                "message" => $e->getMessage(),
                "branchData" => [],
                "yearData" => []
            ]);
        }
    }

    /**
     * Get detailed data for specific branch
     */
    public function getBranchDetailsData()
    {
        $this->output->set_content_type('application/json');
        
        try {
            $branch_id = $this->input->post('branch_id');
            $years = $this->input->post('years');
            
            log_message('debug', 'Branch details - ID: ' . $branch_id . ', Years: ' . json_encode($years));
            
            $result = $this->Library_model->getBranchDetailsData($branch_id, $years);
            
            echo json_encode($result);
            
        } catch (Exception $e) {
            log_message('error', 'getBranchDetailsData error: ' . $e->getMessage());
            echo json_encode([]);
        }
    }

    /**
     * Get detailed data for specific year
     */
    public function getYearDetailsData()
    {
        $this->output->set_content_type('application/json');
        
        try {
            $year_id = $this->input->post('year_id');
            $branches = $this->input->post('branches');
            
            log_message('debug', 'Year details - ID: ' . $year_id . ', Branches: ' . json_encode($branches));
            
            $result = $this->Library_model->getYearDetailsData($year_id, $branches);
            
            echo json_encode([
                "status" => "success",
                "data" => $result
            ]);
            
        } catch (Exception $e) {
            log_message('error', 'getYearDetailsData error: ' . $e->getMessage());
            echo json_encode([
                "status" => "error",
                "message" => $e->getMessage(),
                "data" => []
            ]);
        }
    }

    // ============ HELPER METHODS ============
    

// Add these methods to your Scholership controller

public function createStudentIfNotExists() {
    header('Content-Type: application/json');
    
    $name = $this->input->post('name');
    
    if (empty($name)) {
        echo json_encode(['status' => 'error', 'message' => 'Name is required']);
        return;
    }
    
    // Check if student already exists
    $this->db->where('FullName', trim($name));
    $existing = $this->db->get('student_reg')->row();
    
    if ($existing) {
        echo json_encode(['status' => 'success', 'id' => $existing->Student_id]);
        return;
    }
    
    // Create new student
    $data = [
        'FullName' => trim($name)
        // 'created_at' => date('Y-m-d H:i:s')
    ];
    
    $this->db->insert('student_reg', $data);
    $insert_id = $this->db->insert_id();
    
    if ($insert_id) {
        echo json_encode(['status' => 'success', 'id' => $insert_id]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to create student']);
    }
}

public function createBranchIfNotExists() {
    header('Content-Type: application/json');
    
    $name = $this->input->post('name');
    
    if (empty($name)) {
        echo json_encode(['status' => 'error', 'message' => 'Branch name is required']);
        return;
    }
    
    // Check if branch already exists
    $this->db->where('branch_name', trim($name));
    $existing = $this->db->get('branch_master')->row();
    
    if ($existing) {
        echo json_encode(['status' => 'success', 'id' => $existing->branch_id]);
        return;
    }
    
    // Create new branch
    $data = [
        'branch_name' => trim($name)
        // 'created_at' => date('Y-m-d H:i:s')
    ];
    
    $this->db->insert('branch_master', $data);
    $insert_id = $this->db->insert_id();
    
    if ($insert_id) {
        echo json_encode(['status' => 'success', 'id' => $insert_id]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to create branch']);
    }
}

public function createLevelIfNotExists() {
    header('Content-Type: application/json');
    
    $name = $this->input->post('name');
    
    if (empty($name)) {
        echo json_encode(['status' => 'error', 'message' => 'Level name is required']);
        return;
    }
    
    // Check if level already exists
    $this->db->where('ScholerName', trim($name));
    $existing = $this->db->get('scholerlevel_master')->row();
    
    if ($existing) {
        echo json_encode(['status' => 'success', 'id' => $existing->ScholerLevel_id]);
        return;
    }
    
    // Create new level
    $data = [
        'ScholerName' => trim($name)
        // 'created_at' => date('Y-m-d H:i:s')
    ];
    
    $this->db->insert('scholerlevel_master', $data);
    $insert_id = $this->db->insert_id();
    
    if ($insert_id) {
        echo json_encode(['status' => 'success', 'id' => $insert_id]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to create level']);
    }
}

public function createCasteIfNotExists() {
    header('Content-Type: application/json');
    
    $name = $this->input->post('name');
    
    if (empty($name)) {
        echo json_encode(['status' => 'error', 'message' => 'Caste name is required']);
        return;
    }
    
    // Check if caste already exists
    $this->db->where('caste_name', trim($name));
    $existing = $this->db->get('caste_master')->row();
    
    if ($existing) {
        echo json_encode(['status' => 'success', 'id' => $existing->caste_id]);
        return;
    }
    
    // Create new caste
    $data = [
        'caste_name' => trim($name)
        // 'created_at' => date('Y-m-d H:i:s')
    ];
    
    $this->db->insert('caste_master', $data);
    $insert_id = $this->db->insert_id();
    
    if ($insert_id) {
        echo json_encode(['status' => 'success', 'id' => $insert_id]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to create caste']);
    }
}
    /**
     * Get print headings for reports
     */
    public function getPrintHeadings()
    {
        $this->output->set_content_type('application/json');
        
        try {
            $headings = $this->Library_model->getPrintHeadings();
            
            if ($headings) {
                echo json_encode($headings);
            } else {
                // Return default headings if none found
                echo json_encode([
                    'logo' => 'Assets/images/sit_logo.png',
                    'head' => 'Scholarship Management System',
                    'subHead1' => 'Institution Name',
                    'subHead2' => 'Address Line',
                    'subHead3' => 'Contact Information'
                ]);
            }
            
        } catch (Exception $e) {
            log_message('error', 'getPrintHeadings error: ' . $e->getMessage());
            echo json_encode([
                'logo' => 'Assets/images/sit_logo.png',
                'head' => 'Scholarship Report',
                'subHead1' => '',
                'subHead2' => '',
                'subHead3' => ''
            ]);
        }
    }

    /**
     * Get student by PRN for autocomplete
     */
    public function getStudentByPRN()
    {
        $this->output->set_content_type('application/json');
        $prn = $this->input->post('prn');
        
        if (empty($prn)) {
            echo json_encode(['status' => 'error', 'message' => 'PRN is required']);
            return;
        }
        
        try {
            $this->db->select('Student_id, FullName, PRN');
            $this->db->from('student_reg');
            $this->db->where('PRN', $prn);
            $student = $this->db->get()->row();
            
            if ($student) {
                echo json_encode([
                    'status' => 'success',
                    'data' => $student
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Student not found'
                ]);
            }
            
        } catch (Exception $e) {
            log_message('error', 'getStudentByPRN error: ' . $e->getMessage());
            echo json_encode([
                'status' => 'error',
                'message' => 'Server error: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Export scholarship data to Excel
     */
    public function exportToExcel()
    {
        try {
            $branch_ids = $this->input->post('branch_ids');
            $level_ids = $this->input->post('level_ids');
            $caste_ids = $this->input->post('caste_ids');
            $year_ids = $this->input->post('year_ids');
            
            $data = $this->Library_model->getScholarshipDataFiltered(
                $branch_ids, 
                $level_ids, 
                $caste_ids, 
                $year_ids
            );
            
            // Load Excel library (PHPExcel or PhpSpreadsheet)
            // This is a basic implementation
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="Scholarship_Report_' . date('Y-m-d') . '.xls"');
            header('Cache-Control: max-age=0');
            
            echo '<table border="1">';
            echo '<thead>';
            echo '<tr>';
            echo '<th>Sr.No.</th>';
            echo '<th>Student Name</th>';
            echo '<th>PRN</th>';
            echo '<th>Branch</th>';
            echo '<th>Scholarship Level</th>';
            echo '<th>Scholarship Name</th>';
            echo '<th>Caste</th>';
            echo '<th>Year</th>';
            echo '</tr>';
            echo '</thead>';
            echo '<tbody>';
            
            $sr = 1;
            foreach ($data as $row) {
                echo '<tr>';
                echo '<td>' . $sr++ . '</td>';
                echo '<td>' . ($row->student_name ?? '-') . '</td>';
                echo '<td>' . ($row->PRN ?? '-') . '</td>';
                echo '<td>' . ($row->branch_name ?? '-') . '</td>';
                echo '<td>' . ($row->level_name ?? '-') . '</td>';
                echo '<td>' . ($row->ScholershipName ?? '-') . '</td>';
                echo '<td>' . ($row->caste_name ?? '-') . '</td>';
                echo '<td>' . ($row->year_label ?? '-') . '</td>';
                echo '</tr>';
            }
            
            echo '</tbody>';
            echo '</table>';
            
        } catch (Exception $e) {
            log_message('error', 'exportToExcel error: ' . $e->getMessage());
            echo 'Error generating Excel file';
        }
    }

    /**
     * Validate scholarship data before insert/update
     */
    private function validateScholarshipData($data)
    {
        $errors = [];
        
        if (empty($data['fkStudentName'])) {
            $errors[] = 'Student name is required';
        }
        
        if (empty($data['fkbranch_id'])) {
            $errors[] = 'Branch is required';
        }
        
        if (empty($data['fkscholerLevel_id'])) {
            $errors[] = 'Scholarship level is required';
        }
        
        if (empty($data['FiniYear'])) {
            $errors[] = 'Financial year is required';
        }
        
        return $errors;
    }
}