<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Library_IN_Out extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Library_IN_Out_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    public function index()
    {
        $data['alldata'] = $this->Library_IN_Out_model->getdetailview();
        $this->load->view('admin/header_view');
        $this->load->view('admin/Library_IN_Out_detailview', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Library_IN_Out_view',$data);
        $this->load->view('admin/footer_view');
    }

    // ✅ UPDATED: Now includes WorkingType in response
    public function getStudentByCard()
    {
        $card_no = $this->input->post('card_no');
        $date = $this->input->post('date');
        
        header('Content-Type: application/json');

        log_message('debug', 'Card No received: ' . $card_no . ', Date: ' . $date);

        if (!$card_no) {
            echo json_encode(['status' => 'error', 'message' => 'Card number missing']);
            return;
        }

        if (!$date) {
            echo json_encode(['status' => 'error', 'message' => 'Date missing']);
            return;
        }

        $this->load->model('Library_IN_Out_model');
        
        // STEP 1: Check if there's a pending entry (no Out-Time) for this card TODAY
        $pendingEntry = $this->Library_IN_Out_model->getPendingEntryByCard($card_no, $date);
        
        if ($pendingEntry) {
            // Pending entry found - return it with a special flag
            log_message('debug', 'Pending entry found for card: ' . $card_no);
            
            $payload = [
                'library_ID' => $pendingEntry->library_ID,
                'Name' => $pendingEntry->Name ?? '',
                'Class' => $pendingEntry->Class ?? '',
                'Department' => $pendingEntry->Department ?? '',
                'WorkingType' => $pendingEntry->WorkingType ?? '',
                'fkLibDept_id' => $pendingEntry->fkLibDept_id ?? '',
                'LibDep_Name' => $pendingEntry->LibDep_Name ?? '',
                'In_Time' => $pendingEntry->In_Time ?? '',
                'Date' => $pendingEntry->Date ?? '',
                'CardNo' => $pendingEntry->Cardnumber ?? $card_no
            ];

            echo json_encode([
                'status' => 'success', 
                'has_pending' => true,
                'data' => $payload,
                'message' => 'Pending Out-Time found for this card!'
            ]);
            return;
        }

        // STEP 2: No pending entry - get basic student info for new entry
        $studentData = $this->Library_IN_Out_model->getStudentByCard($card_no);

        log_message('debug', 'Student data from model: ' . print_r($studentData, true));

        if ($studentData) {
            $payload = [
                'Name' => $studentData->Name ?? '',
                'Class' => $studentData->Class ?? '',
                'Department' => $studentData->Department ?? '',
                'fkInstitute_id' => $studentData->fkInstitute_id ?? '',
                'CardNo' => $card_no
            ];

            echo json_encode([
                'status' => 'success', 
                'has_pending' => false,
                'data' => $payload
            ]);
        } else {
            echo json_encode([
                'status' => 'error', 
                'has_pending' => false,
                'message' => 'No record found for this card number'
            ]);
        }
    }

    public function getLibraryDepartments()
    {
        header('Content-Type: application/json');
        
        $this->db->select('Libdep_id, LibDep_Name');
        $this->db->from('librarydept_master');
        $this->db->order_by('LibDep_Name', 'DESC');
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            echo json_encode([
                'status' => 'success',
                'data' => $query->result()
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'No library departments found'
            ]);
        }
    }

    // ✅ UPDATED: Now saves WorkingType
    public function smartSaveEntry() 
    {
        header('Content-Type: application/json');
        
        $date = $this->input->post('Date');
        $cardNo = $this->input->post('CardNo');
        $name = $this->input->post('Name');
        $class = $this->input->post('Class');
        $department = $this->input->post('Department');
        $workingType = $this->input->post('WorkingType'); // ✅ NEW: Get WorkingType
        $libDeptId = $this->input->post('fkLibDept_id');
        $inTime = $this->input->post('In_Time');
        $outTime = $this->input->post('Out_Time');
        $hours = $this->input->post('Hours');
        $saveType = $this->input->post('save_type');
        $libraryID = $this->input->post('library_ID');
         $fk_submenuId = $this->input->post('fk_submenuId');
         
        // Log for debugging
        log_message('debug', '=== SMART SAVE ENTRY START ===');
        log_message('debug', 'Save Type: ' . $saveType);
        log_message('debug', 'Card: ' . $cardNo . ', LibDept: ' . $libDeptId . ', Date: ' . $date);
        log_message('debug', 'WorkingType: ' . $workingType); // ✅ Log WorkingType
        log_message('debug', 'In-Time: ' . $inTime . ', Out-Time: ' . $outTime);
        log_message('debug', 'Library ID: ' . $libraryID);
        
        // Basic validation
        if (!$date || !$cardNo || !$libDeptId) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Date, Card Number, and Library Department are required'
            ]);
            return;
        }
        
        // ✅ NEW: Validate WorkingType
        if (empty($workingType) && $saveType !== 'update_out') {
            echo json_encode([
                'status' => 'error',
                'message' => 'Working Type is required for new entries'
            ]);
            return;
        }
        
        // Check if In_Time required (only for new entries, not for updates)
        if ($saveType !== 'update_out' && empty($inTime)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'In-Time is required for new entries'
            ]);
            return;
        }
        
        // If library_ID is provided, update that specific entry
        if (!empty($libraryID)) {
            log_message('debug', 'UPDATE PATH - Updating entry ID: ' . $libraryID);
            
            $updateData = [
                'Out_Time' => $outTime,
                'Hours' => $hours,
                'modified_by'=>$_SESSION['userID']
            ];
            
            // ✅ OPTIONAL: Update WorkingType if provided during update
            if (!empty($workingType)) {
                $updateData['WorkingType'] = $workingType;
            }
            
            $this->db->where('library_ID', $libraryID);
            $update = $this->db->update('libinout_master', $updateData);
            // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $libraryID;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
            
            
            if ($update) {
                log_message('debug', 'UPDATE SUCCESS');
                echo json_encode([
                    'status' => 'success',
                    'message' => 'Out-Time updated successfully!',
                    'action' => 'updated',
                    'entry_id' => $libraryID
                ]);
            } else {
                log_message('error', 'UPDATE FAILED');
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Failed to update entry'
                ]);
            }
            return;
        }
        
        // Otherwise, check for existing incomplete entry
        $this->db->where('Date', $date);
        $this->db->where('Cardnumber', $cardNo);
        $this->db->where('fkLibDept_id', $libDeptId);
        $this->db->where('(Out_Time IS NULL OR Out_Time = "")');
        $this->db->order_by('library_ID', 'DESC');
        $this->db->limit(1);
        $existingEntry = $this->db->get('libinout_master')->row();
        
        log_message('debug', 'Existing Incomplete Entry: ' . ($existingEntry ? 'YES (ID: '.$existingEntry->library_ID.')' : 'NO'));
        
        if ($existingEntry) {
            // ===== INCOMPLETE ENTRY EXISTS - UPDATE SCENARIO =====
            
            log_message('debug', 'UPDATE PATH - Updating incomplete entry');
            
            // Update Out-Time if provided
            if (!empty($outTime)) {
                $updateData = [
                    'Out_Time' => $outTime,
                    'Hours' => $hours
                ];
                
                // ✅ OPTIONAL: Update WorkingType if provided
                if (!empty($workingType)) {
                    $updateData['WorkingType'] = $workingType;
                }
                
                log_message('debug', 'Updating entry with Out_Time: ' . $outTime);
                
                $this->db->where('library_ID', $existingEntry->library_ID);
                $update = $this->db->update('libinout_master', $updateData);
                
                if ($update) {
                    log_message('debug', 'UPDATE SUCCESS');
                    echo json_encode([
                        'status' => 'success',
                        'message' => 'Out-Time updated successfully!',
                        'action' => 'updated',
                        'entry_id' => $existingEntry->library_ID
                    ]);
                } else {
                    log_message('error', 'UPDATE FAILED');
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Failed to update entry'
                    ]);
                }
            } else {
                // No Out-Time provided but incomplete entry exists
                echo json_encode([
                    'status' => 'error',
                    'message' => 'An incomplete entry already exists. Please provide Out-Time to update.'
                ]);
            }
            
        } else {
            // ===== NEW ENTRY - INSERT SCENARIO =====
            
            log_message('debug', 'INSERT PATH - Creating new entry');
            
            $insertData = [
                'Date' => $date,
                'Cardnumber' => $cardNo,
                'WorkingType' => $workingType, // ✅ NEW: Save WorkingType
                'fkLibDept_id' => $libDeptId,
                'In_Time' => $inTime,
                'Out_Time' => !empty($outTime) ? $outTime : NULL,
                'Hours' => !empty($hours) ? $hours : NULL,
                'created_by'=>$_SESSION['userID']
            ];
            
            log_message('debug', 'Insert Data: ' . json_encode($insertData));
            
            $insert = $this->db->insert('libinout_master', $insertData);
            $insertId = $this->db->insert_id();
            // Insert log - Action 1 (Insert)
        $action = 1;
        $record_id = $insertId;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
        //  $sub_id = $this->db->insert_id();
            
            
            if ($insert) {
                log_message('debug', 'INSERT SUCCESS - ID: ' . $insertId);
                
                $message = (empty($outTime)) 
                    ? 'In-Time saved! You can add Out-Time later.' 
                    : 'Entry saved successfully with both In-Time and Out-Time!';
                
                echo json_encode([
                    'status' => 'success',
                    'message' => $message,
                    'action' => 'inserted',
                    'entry_id' => $insertId
                ]);
            } else {
                log_message('error', 'INSERT FAILED - DB Error: ' . $this->db->error()['message']);
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Failed to save entry'
                ]);
            }
        }
        
        log_message('debug', '=== SMART SAVE ENTRY END ===');
    }

    // ✅ UPDATED: Now includes WorkingType in response
    public function getTodayEntries() 
    {
        header('Content-Type: application/json');
        
        $date = $this->input->post('date');
        
        if (!$date) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Date is required',
                'data' => []
            ]);
            return;
        }

        $this->db->select('
            li.library_ID,
            li.Date,
            li.Cardnumber,
            li.WorkingType,
            li.fkLibDept_id,
            li.In_Time,
            li.Out_Time,
            li.Hours,
            lm.Name,
            lm.Class,
            lm.Department,
            ld.LibDep_Name
        ');
        $this->db->from('libinout_master li');
        $this->db->join('library_master lm', 'lm.CardNo = li.Cardnumber', 'left');
        $this->db->join('librarydept_master ld', 'ld.Libdep_id = li.fkLibDept_id', 'left');
        $this->db->where('li.Date', $date);
        $this->db->order_by('li.library_ID', 'DESC');
        
        $query = $this->db->get();
        $entries = $query->result_array();
        
        if ($entries && count($entries) > 0) {
            echo json_encode([
                'status' => 'success',
                'data' => $entries
            ]);
        } else {
            echo json_encode([
                'status' => 'success',
                'message' => 'No entries found',
                'data' => []
            ]);
        }
    }

    // ✅ UPDATED: Now saves WorkingType
    public function insertLibraryInOutdata()
    {
        header('Content-Type: application/json');
        
        if (!$this->input->post('Date')) {
            echo json_encode(['status' => 'error', 'message' => 'Date is required']);
            return;
        }

        $date = $this->input->post('Date');
        $cardNumbers = $this->input->post('CardNo');
        $workingTypes = $this->input->post('WorkingType'); // ✅ NEW: Get WorkingType array
        $libDepts = $this->input->post('fkLibDept_id');
        $inTimes = $this->input->post('In_Time');
        $outTimes = $this->input->post('Out_Time');
        $hours = $this->input->post('Hours');

        if (!$cardNumbers || count($cardNumbers) == 0) {
            echo json_encode(['status' => 'error', 'message' => 'No records found']);
            return;
        }

        $batchData = [];

        for ($i = 0; $i < count($cardNumbers); $i++) {
            $cardNo = isset($cardNumbers[$i]) ? trim($cardNumbers[$i]) : '';
            $libDept = isset($libDepts[$i]) ? trim($libDepts[$i]) : '';
            $workingType = isset($workingTypes[$i]) ? trim($workingTypes[$i]) : ''; // ✅ NEW: Get WorkingType
            
            if ($cardNo == '' || $libDept == '') {
                continue;
            }

            $batchData[] = [
                'Date'          => $date,
                'Cardnumber'    => $cardNo,
                'WorkingType'   => $workingType, // ✅ NEW: Save WorkingType
                'fkLibDept_id'  => $libDept,
                'In_Time'       => isset($inTimes[$i]) ? $inTimes[$i] : null,
                'Out_Time'      => isset($outTimes[$i]) ? $outTimes[$i] : null,
                'Hours'         => isset($hours[$i]) ? $hours[$i] : null,
            ];
        }

        if (empty($batchData)) {
            echo json_encode(['status' => 'error', 'message' => 'No valid data to save']);
            return;
        }

        $this->load->model('Library_IN_Out_model');
        $result = $this->Library_IN_Out_model->insert_batch($batchData);

        if ($result) {
            echo json_encode(['status' => 'success', 'message' => 'Library In-Out saved successfully!']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Database insert failed']);
        }
    }

    public function searchWorkingTypes()
{
    $search = $this->input->post('search');
    
    header('Content-Type: application/json');
    
    if (empty($search)) {
        echo json_encode([
            'success' => false,
            'message' => 'Search term required',
            'data' => []
        ]);
        return;
    }
    
    $this->load->model('Library_IN_Out_model');
    $workingTypes = $this->Library_IN_Out_model->searchWorkingTypes($search);
    
    echo json_encode([
        'success' => true,
        'data' => $workingTypes
    ]);
}
}
?>