<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Library_Report extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Library_Report_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    public function Report()
    {
        $data['branchList'] = $this->Library_Report_model->getBranches();
        $data['CardList'] = $this->Library_Report_model->getCards();
        $data['LibDeptList'] = $this->Library_Report_model->getLibDep();
        $data['yearList'] = $this->Library_Report_model->getYears();
        $data['activeYear'] = $this->Library_Report_model->getActiveYear();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Library_Report_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    // Get filtered library data
   public function getLibraryData()
{
    $this->output->set_content_type('application/json');
    
    $branch_ids = $this->input->post('branch_ids');
    $card_type_ids = $this->input->post('card_type_ids');
    $dept_ids = $this->input->post('dept_ids');
    $year_ids = $this->input->post('year_ids');
    $start_date = $this->input->post('startdate');
    $end_date = $this->input->post('enddate');
    
    // Debug logging
    log_message('debug', '=== Library Filter Request ===');
    log_message('debug', 'Department Names: ' . json_encode($branch_ids));
    log_message('debug', 'Card Type IDs: ' . json_encode($card_type_ids));
    log_message('debug', 'Library Dept IDs: ' . json_encode($dept_ids));
    log_message('debug', 'Year IDs: ' . json_encode($year_ids));
    log_message('debug', 'Start Date: ' . $start_date);
    log_message('debug', 'End Date: ' . $end_date);
    
    try {
        $data = $this->Library_Report_model->getLibraryDataFiltered(
            $branch_ids, 
            $card_type_ids, 
            $dept_ids, 
            $year_ids,
            $start_date,
            $end_date
        );
        
        log_message('debug', 'Query Result Count: ' . count($data));
        log_message('debug', 'SQL Query: ' . $this->db->last_query());
        
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        
    } catch (Exception $e) {
        log_message('error', 'getLibraryData error: ' . $e->getMessage());
        echo json_encode([
            'error' => true,
            'message' => $e->getMessage()
        ]);
    }
}

// Get combined chart data (branch + year wise)
public function getCombinedChartData()
{
    $this->output->set_content_type('application/json');
    
    try {
        $branches = $this->input->post('branches'); // This receives department names
        $years = $this->input->post('years');
        
        log_message('debug', 'Chart filters - Branches: ' . json_encode($branches) . ', Years: ' . json_encode($years));
        
        $result = $this->Library_Report_model->getCombinedData($branches, $years);
        
        // Debug log the results
        log_message('debug', 'Branch Data Count: ' . count($result['branchData']));
        log_message('debug', 'Year Data Count: ' . count($result['yearData']));
        
        echo json_encode([
            "status" => "success",
            "branchData" => $result['branchData'],
            "yearData" => $result['yearData']
        ]);
        
    } catch (Exception $e) {
        log_message('error', 'getCombinedChartData error: ' . $e->getMessage());
        echo json_encode([
            "status" => "error",
            "message" => $e->getMessage(),
            "branchData" => [],
            "yearData" => []
        ]);
    }
}
    // Get detailed data for specific branch
    public function getBranchDetailsData()
    {
        $this->output->set_content_type('application/json');
        
        try {
            $branch_id = $this->input->post('branch_id');
            $years = $this->input->post('years');
            
            log_message('debug', 'Branch details - ID: ' . $branch_id . ', Years: ' . json_encode($years));
            
            $result = $this->Library_Report_model->getBranchDetailsData($branch_id, $years);
            
            echo json_encode($result);
            
        } catch (Exception $e) {
            log_message('error', 'getBranchDetailsData error: ' . $e->getMessage());
            echo json_encode([]);
        }
    }

    // Get detailed data for specific year
    public function getYearDetailsData()
    {
        $this->output->set_content_type('application/json');
        
        try {
            $year_id = $this->input->post('year_id');
            $branches = $this->input->post('branches');
            
            log_message('debug', 'Year details - ID: ' . $year_id . ', Branches: ' . json_encode($branches));
            
            $result = $this->Library_Report_model->getYearDetailsData($year_id, $branches);
            
            echo json_encode([
                "status" => "success",
                "data" => $result
            ]);
            
        } catch (Exception $e) {
            log_message('error', 'getYearDetailsData error: ' . $e->getMessage());
            echo json_encode([
                "status" => "error",
                "message" => $e->getMessage(),
                "data" => []
            ]);
        }
    }

    // Get print headings for reports
    public function getPrintHeadings()
    {
        $this->output->set_content_type('application/json');
        
        try {
            $headings = $this->Library_Report_model->getPrintHeadings();
            
            if ($headings) {
                echo json_encode($headings);
            } else {
                echo json_encode([
                    'logo' => 'Assets/images/sit_logo.png',
                    'head' => 'Library Management System',
                    'subHead1' => 'Institution Name',
                    'subHead2' => 'Address Line',
                    'subHead3' => 'Contact Information'
                ]);
            }
            
        } catch (Exception $e) {
            log_message('error', 'getPrintHeadings error: ' . $e->getMessage());
            echo json_encode([
                'logo' => 'Assets/images/sit_logo.png',
                'head' => 'Library Report',
                'subHead1' => '',
                'subHead2' => '',
                'subHead3' => ''
            ]);
        }
    }
}