<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Logfile extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Logfile_model');
    }

    public function create()
    {
        $data['current_date'] = date('Y-m-d');
        $this->load->view('admin/header_view');
         $this->load->view('admin/Logfile_view', $data);  
        $this->load->view('admin/footer_view');
    }
    
    public function get_logs()
    {
        $start_date = $this->input->post('start_date');
        $end_date = $this->input->post('end_date');

        
        
        $logs = $this->Logfile_model->get_logs($start_date, $end_date);
        
        if (empty($logs)) {
            return; // Empty response handled by frontend
        }
        
        foreach ($logs as $log) {
            $date = date('d M Y', strtotime($log->date));
            $time = date('h:i A', strtotime($log->time));
            
            // Determine badge class based on action
            $badge_class = $this->get_badge_class($log->action);
            $action_icon = $this->get_action_icon($log->action);
            $action_text = $log->action_text;
            
            // Add Excel name if action is Excel File
            if ($log->action == 4 && !empty($log->ExcelName)) {
                $action_text .= '<br><small style="font-size:9px; opacity:0.9;">' . htmlspecialchars($log->ExcelName) . '</small>';
            }
            
            echo '<tr>';
            echo '<td>' . htmlspecialchars($log->Id) . '</td>';
            echo '<td>' . htmlspecialchars($log->UserName) . '</td>';
            echo '<td>' . htmlspecialchars($log->MenuName) . '</td>';
            echo '<td>' . htmlspecialchars($log->Name) . '</td>';
            echo '<td>' . $date . '</td>';
            echo '<td>' . $time . '</td>';
            echo '<td>' . htmlspecialchars($log->branch_name) . '</td>';
            echo '<td><span class="badge-action ' . $badge_class . '"><i class="' . $action_icon . '"></i> ' . $action_text . '</span></td>';
            echo '</tr>';
        }
    }
    
    private function get_badge_class($action)
    {
        switch($action) {
            case 1: return 'inserted';
            case 2: return 'updated';
            case 3: return 'uploaded';
            case 4: return 'excel';
            default: return 'inserted';
        }
    }
    
    private function get_action_icon($action)
    {
        switch($action) {
            case 1: return 'fa fa-plus';
            case 2: return 'fa fa-edit';
            case 3: return 'fa fa-image';
            case 4: return 'fa fa-file-excel';
            default: return 'fa fa-circle';
        }
    }
}