<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Maintance extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Maintance_model');
    }


      public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Maintance_dash_view.php');
        $this->load->view('admin/footer_view');
    }

    public function index()
    {
        $data['alldata'] = $this->Maintance_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Maintance_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['branchdata'] = $this->Maintance_model->getBranches();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Maintance_view.php', $data);
        $this->load->view('admin/footer_view');
    }

     // Helper function for file upload
    private function upload_document($field_name, $upload_path)
    {
        if (!empty($_FILES[$field_name]['name'])) {
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
            $config['max_size'] = 5120;
            $config['file_name'] = time() . '_' . $_FILES[$field_name]['name'];
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload($field_name)) {
                $upload_data = $this->upload->data();
                return $upload_data['file_name'];
            }
        }
        return null;
    }

    public function insertMaintance()
    {
        $fkbranch_id = $this->input->post('fkbranch_id');
        $Maintance_date = $this->input->post('Maintance_date');
        $person_name = $this->input->post('person_name');
        $person_contact = $this->input->post('person_contact');
        $fkMaintype_id = $this->input->post('fkMaintype_id');
        $fkMainsub_id = $this->input->post('fkMainsub_id');
        $Maintance_details = $this->input->post('Maintance_details');
        $Photo_url = $this->input->post('Photo_url');

      // Get institute id
    $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
    $institute_id = $institute ? $institute->Institu_id : null;

    // Get current financial year
    $finiYear = $this->db->select('finiYear_id')->from('finiyear_master')->where('Active_Deactive', 1)->get()->row();
    $finicial_year = $finiYear ? $finiYear->finiYear_id : null;


        // Handle file upload for Certificate & Photos
        $this->load->library('upload');
        $Document = '';
        
        if (!empty($_FILES['Document']['name'])) {
            $config['upload_path'] = './uploads/maintenance/';
            $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
            $config['max_size'] = 5120; // 5MB
            $config['file_name'] = 'certi_' . time() . '_' . $_FILES['Document']['name'];
            
            // Create directory if it doesn't exist
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('Document')) {
                $upload_data = $this->upload->data();
                $Document = 'uploads/maintenance/' . $upload_data['file_name'];
            }
        }

        $fields = array(
            'fkbranch_id' => $fkbranch_id,
            'Maintance_date' => $Maintance_date,
            'person_name' => $person_name,
            'person_contact' => $person_contact,
            'fkMaintype_id' => $fkMaintype_id,
            'fkMainsub_id' => $fkMainsub_id,
            'Maintance_details' => $Maintance_details,
            'Photo_url' => $Photo_url,
            'Document' => $Document,
            'institute' => $institute_id,
            'finicial_Year' => $finicial_year,
            'created_by' => $created_by // ✅ FIXED LINE 106
        );

        

        $this->Maintance_model->insertdata($fields);
        echo json_encode(array('success' => true, 'message' => 'Maintenance record saved successfully'));
    }
    
    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->Maintance_model->getbyid($id);
        $data['branchdata'] = $this->Maintance_model->getBranches();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Maintance_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function updateMaintance()
    {
        $Maintance_id = $this->input->post('Maintance_id');
        $fkbranch_id = $this->input->post('fkbranch_id');
        $Maintance_date = $this->input->post('Maintance_date');
        $person_name = $this->input->post('person_name');
        $person_contact = $this->input->post('person_contact');
        $fkMaintype_id = $this->input->post('fkMaintype_id');
        $fkMainsub_id = $this->input->post('fkMainsub_id');
        $Maintance_details = $this->input->post('Maintance_details');
        $Photo_url = $this->input->post('Photo_url');


        // Get institute id
    $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
    $institute_id = $institute ? $institute->Institu_id : null;

    // Get current financial year
    $finiYear = $this->db->select('finiYear_id')->from('finiyear_master')->where('Active_Deactive', 1)->get()->row();
    $finicial_year = $finiYear ? $finiYear->finiYear_id : null;

       

        // Get existing file
        $existing_Document = $this->input->post('hidden_Document');
        $Document = $existing_Document;

        // Handle file upload
        $this->load->library('upload');
        
        if (!empty($_FILES['Document']['name'])) {
            $config['upload_path'] = './uploads/maintenance/';
            $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
            $config['max_size'] = 5120;
            $config['file_name'] = 'certi_' . time() . '_' . $_FILES['Document']['name'];
            
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('Document')) {
                $upload_data = $this->upload->data();
                $Document = 'uploads/maintenance/' . $upload_data['file_name'];
                
                // Delete old file if exists
                if (!empty($existing_Document) && file_exists(FCPATH . $existing_Document)) {
                    unlink(FCPATH . $existing_Document);
                }
            }
        }

        $fields = array(
            'Maintance_id' => $Maintance_id,
            'fkbranch_id' => $fkbranch_id,
            'Maintance_date' => $Maintance_date,
            'person_name' => $person_name,
            'person_contact' => $person_contact,
            'fkMaintype_id' => $fkMaintype_id,
            'fkMainsub_id' => $fkMainsub_id,
            'Maintance_details' => $Maintance_details,
            'Photo_url' => $Photo_url,
            'Document' => $Document,
            'institute' => $institute_id,
            'finicial_Year' => $finicial_year,
            'modified_by' => $modified_by // ✅ FIXED
        );
        
        $this->Maintance_model->update($fields);
        echo json_encode(array('success' => true, 'message' => 'Maintenance record updated successfully'));
    }

    // Search Maintenance Type for typeahead
    public function searchMaintenanceType()
    {
        $query = $this->input->post('query');
        $results = $this->Maintance_model->searchMaintenanceType($query);
        echo json_encode($results);
    }

    // Search Maintenance Sub Type for typeahead
    public function searchMaintenanceSubType()
    {
        $query = $this->input->post('query');
        $results = $this->Maintance_model->searchMaintenanceSubType($query);
        echo json_encode($results);
    }

    // Add new Maintenance Type
    public function addMaintenanceType()
    {
        $Maintype_name = $this->input->post('Maintype_name');
        
        // Check if already exists
        $exists = $this->Maintance_model->checkMaintenanceTypeExists($Maintype_name);
        
        if ($exists) {
            echo json_encode(array(
                'success' => false,
                'message' => 'This Maintenance Type already exists'
            ));
            return;
        }
        
        $data = array(
            'Maintype_name' => $Maintype_name,
            'is_active' => 1,
            'is_on' => 1,
            'is_default' => 0,
            'created_date' => date('Y-m-d H:i:s')
        );
        
        $insert_id = $this->Maintance_model->addMaintenanceType($data);
        
        if ($insert_id) {
            echo json_encode(array(
                'success' => true,
                'data' => array(
                    'Maintype_id' => $insert_id,
                    'Maintype_name' => $Maintype_name
                )
            ));
        } else {
            echo json_encode(array(
                'success' => false,
                'message' => 'Failed to add Maintenance Type'
            ));
        }
    }

    // Add new Maintenance Sub Type
    public function addMaintenanceSubType()
    {
        $Mainsub_name = $this->input->post('Mainsub_name');
        
        // Check if already exists
        $exists = $this->Maintance_model->checkMaintenanceSubTypeExists($Mainsub_name);
        
        if ($exists) {
            echo json_encode(array(
                'success' => false,
                'message' => 'This Maintenance Sub Type already exists'
            ));
            return;
        }
        
        $data = array(
            'Mainsub_name' => $Mainsub_name,
            'is_active' => 1,
            'is_on' => 1,
            'is_default' => 0,
            'created_date' => date('Y-m-d H:i:s')
        );
        
        $insert_id = $this->Maintance_model->addMaintenanceSubType($data);
        
        if ($insert_id) {
            echo json_encode(array(
                'success' => true,
                'data' => array(
                    'Mainsub_id' => $insert_id,
                    'Mainsub_name' => $Mainsub_name
                )
            ));
        } else {
            echo json_encode(array(
                'success' => false,
                'message' => 'Failed to add Maintenance Sub Type'
            ));
        }
    }
}