<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class MaintanceReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('MaintanceReport_model');
        
    }

public function Report()
    {
        $data['yeardata'] = $this->MaintanceReport_model->getyear();
        $data['MaintypeTypedata'] = $this->MaintanceReport_model->getMaintypetype();
        $data['MaintypeSubTypedata'] = $this->MaintanceReport_model->getMaintypesubtype();
        $data['institutedata'] = $this->MaintanceReport_model->getinstitu();
        $data['branchdata'] = $this->MaintanceReport_model->getbranch();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/MaintanceReport_view.php', $data);
        $this->load->view('admin/footer_view');
    }

public function getReportData()
{
   $institu = $this->input->post('fk_institu');
            $branches = $this->input->post('fkbranch_id');
            $maintype = $this->input->post('fkMaintype_id');
            $mainsub = $this->input->post('fkMainsub_id');
            $year = $this->input->post('year');
            $startDate = $this->input->post('startdate');
            $endDate = $this->input->post('enddate');

    $data = $this->MaintanceReport_model->getFilteredData(
        $institu,
                $branches,
                $maintype,
                $mainsub,
                $year,
                $startDate,
                $endDate
        );
    echo json_encode($data);
}

public function getPrintHeadings()
{
    $data = $this->MaintanceReport_model->getPrintHeadings();
    echo json_encode($data);
}



// new 

public function getYearwiseData()
{
    $year = $this->input->post('year');
    $branches  = $this->input->post('branches');   // may be an array
    

    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->MaintanceReport_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year
        $summary = $this->MaintanceReport_model->getSingleYearData($year,$branches);
        $types   = $this->MaintanceReport_model->getYearwiseTypes($year,$branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS
 
    $result = $this->MaintanceReport_model->getBranchwiseCount($institu, $branches, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS
 
    $result = $this->MaintanceReport_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');
 
    $result = $this->MaintanceReport_model->getCombinedData($institu, $branches, $years, $startDate, $endDate);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}
 



}