<?php
if(!defined('BASEPATH')) exit('No direct script access allowed');

class MenuLogin extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();        
        $this->load->model(['MenuLogin_model']);
        $this->load->helper(['form', 'url']);
    } 
    
    public function index()
    {
        $heading_data = $this->MenuLogin_model->get_heading_data(1);
        $data['heading_data'] = $heading_data;
        $data['slider_images'] = $this->MenuLogin_model->get_slider_images(1);
        
        $this->load->view('admin/MenuLogin_view', $data);
    }
    

    public function create()
    {
        $heading_data = $this->MenuLogin_model->get_heading_data(1);
        $data['heading_data'] = $heading_data;
        $data['slider_images'] = $this->MenuLogin_model->get_slider_images(1);
        
        $this->load->view('admin/MenuLogin_view2', $data);
    }

    
    public function login_validation()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('userName', 'Username', 'required');
        $this->form_validation->set_rules('password', 'Password', 'required|min_length[5]');
        
        if ($this->form_validation->run() == TRUE) {
            $userName = $this->input->post('userName');
            $password = $this->input->post('password');
            
            $data = $this->MenuLogin_model->can_login($userName, $password);
            
            if (!empty($data)) {
                // ✅ Ensure correct property name
                $session_data = array(
                    'userName' => $data[0]->UserName,
                    'Password' => $data[0]->Password,
                    'userID' => $data[0]->UserID,
                    'fkfaculty_ID' => $data[0]->fkfaculty_ID, 
                    'fkRole_id' => $data[0]->fkRole_id,
                    'fkHostel_Id' => $data[0]->fkHostel_Id,
                    
					'fkBranch_Id' => $data[0]->fkBranch_Id
                );
                $this->session->set_userdata($session_data);
                redirect('admin/Getlink/create');
            } else {
                $this->session->set_flashdata('error', 'Invalid username or password');
                redirect('admin/MenuLogin');
            }
        } else {
            $this->index();
        }
    }
}