<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class MiniImport extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('MiniImport_model');
    }

    // Load Import View
    public function create()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/MiniImport_view');
        $this->load->view('admin/footer_view');
    }

       public function index()
    {
        $data['alldata']=$this->MiniImport_model->getdetailview();
        

        $this->load->view('admin/header_view');
        $this->load->view('admin/Mini_detailview',$data);
        $this->load->view('admin/footer_view');
    }

        public function dashboard()
    {
        // $data['alldata']=$this->MiniImport_model->getdetailview();

        $this->load->view('admin/header_view');
        $this->load->view('admin/MiniProject_dash_view');
        $this->load->view('admin/footer_view');
    }
         public function Report()
	{
    //   $data['alldata']=$this->MiniImport_model->getdetailview();
$data['institutedata'] = $this->MiniImport_model->get_all_institute();
 $data['Branch'] = $this->MiniImport_model->get_all_Branch();
    $data['branchdata'] = $this->MiniImport_model->getbranch();   
$data['yeardata'] = $this->MiniImport_model->getyear();
$data['guidenamedata'] = $this->MiniImport_model->getGuideNames();
$data['projectTitledata'] = $this->MiniImport_model->getProjectTitles();
 $activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/MiniReport',$data);
		$this->load->view('admin/footer_view');

	}


public function import_excel_save() {
    try {
        // ✅ Check if file is uploaded
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];

            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

            $filename = 'miniproject_excel_' . date('Ymd_His') . '_' . basename($originalName);
            $targetFile = $uploadDir . $filename;
            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "file_error";
                return;
            }
        }

        // ✅ Decode table data
        $postData = $this->input->post('tableData');
        if (empty($postData)) {
            echo "no_data";
            return;
        }

        $rows = json_decode($postData, true);
        if (empty($rows)) {
            echo "no_data";
            return;
        }

        // Initialize lookup maps
        $sponserMap = [];
        $branchMap = [];
        $typeMap = [];
        $yearMap = [];

        // Load existing master data into maps
        foreach ($this->db->get_where('sponser_master', ['is_on' => 1])->result() as $g) {
            $sponserMap[strtolower(trim($g->SponserName))] = $g->id;
        }
        foreach ($this->db->get_where('type_master', ['is_active' => 1])->result() as $d) {
            $typeMap[strtolower(trim($d->type_name))] = $d->type_id;
        }
        foreach ($this->db->get_where('finiyear_master', ['is_active' => 1])->result() as $g) {
            $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
        }
        foreach ($this->db->get_where('branch_master', ['is_active' => 1])->result() as $b) {
            $branchMap[strtolower(trim($b->branch_name))] = $b->branch_id;
        }

        // ✅ Loop rows and insert data
        foreach ($rows as $index => $row) {
            if ($index === 0) continue; // skip header row

            // --- Handle Year ---
            $yearStr = strtolower(trim($row['FiniYear'] ?? ''));
            if ($yearStr !== '') {
                if (!isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', [
                        'fini_Label' => ucfirst($yearStr),
                        'is_active' => 1
                    ]);
                    $yearMap[$yearStr] = $this->db->insert_id();
                }
                $finiYear_id = $yearMap[$yearStr];
            } else $finiYear_id = null;

            // --- Handle Branch ---
            $branchStr = strtolower(trim($row['fkBranch_id'] ?? ''));
            if ($branchStr !== '') {
                if (!isset($branchMap[$branchStr])) {
                    $this->db->insert('branch_master', [
                        'branch_name' => ucfirst($branchStr),
                        'is_active' => 1
                    ]);
                    $branchMap[$branchStr] = $this->db->insert_id();
                }
                $branch_id = $branchMap[$branchStr];
            } else $branch_id = null;

            // --- Handle Sponsor ---
            $sponserStr = strtolower(trim($row['fk_sponsored'] ?? ''));
            if ($sponserStr !== '') {
                if (!isset($sponserMap[$sponserStr])) {
                    $this->db->insert('sponser_master', [
                        'SponserName' => ucfirst($sponserStr),
                        'is_on' => 1
                    ]);
                    $sponserMap[$sponserStr] = $this->db->insert_id();
                }
                $sponser_id = $sponserMap[$sponserStr];
            } else $sponser_id = null;

            // --- Handle Seed Money Type ---
            $typeStr = strtolower(trim($row['fk_seed_money'] ?? ''));
            if ($typeStr !== '') {
                if (!isset($typeMap[$typeStr])) {
                    $this->db->insert('type_master', [
                        'type_name' => ucfirst($typeStr),
                        'is_active' => 1
                    ]);
                    $typeMap[$typeStr] = $this->db->insert_id();
                }
                $type_id = $typeMap[$typeStr];
            } else $type_id = null;

            // ✅ Insert into miniproject_master
            $masterData = [
                'FiniYear'        => $finiYear_id,
                'fkBranch_id'     => $branch_id,
                'project_title'   => $row['project_title'] ?? '',
                'guide_name'      => $row['guide_name'] ?? '',
                'fk_sponsored'    => $sponser_id,
                'rank'            => $row['rank'] ?? '',
                // 'project_type'    => $row['project_type'] ?? '',
                'fk_seed_money'   => $type_id,
                'money'           => $row['money'] ?? ''
            ];

            $this->db->insert('miniproject_master', $masterData);
            $project_id = $this->db->insert_id();

            // ✅ Insert into miniproject_students
            if (!empty($row['student_name']) || !empty($row['prn'])) {
                $studentData = [
                    'fk_project_id' => $project_id,
                    'student_name'  => $row['student_name'] ?? '',
                    'prn'           => $row['prn'] ?? ''
                ];
                $this->db->insert('miniproject_students', $studentData);
            }
        }

        echo "success";

    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}

public function showDataByInstitute()
{
    $institute_id    = $this->input->post('InstituteId');
    $branches        = $this->input->post('fkbranch_id');  
    $guide_names     = $this->input->post('guide_name');
    $project_titles  = $this->input->post('project_title');
    $years  = $this->input->post('years');

    $data = $this->MiniImport_model->getDataByInstitute(
        $institute_id,
        $branches,
        $guide_names,
        $project_titles,
        $years
    );

    echo json_encode($data);
}

public function getStudentsByProject()
{
    $project_id = $this->input->post('project_id');
    $students = $this->MiniImport_model->getStudentsByProject($project_id);
    echo json_encode($students);
}

public function getPrintHeadings()
{
    $data = $this->MiniImport_model->getPrintHeadings();
    echo json_encode($data);
}


public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu'); 
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
    // $startDate = $this->input->post('StartDate');
    // $endDate   = $this->input->post('EndDate');

    $result = $this->MiniImport_model->getCombinedData($institu, $branches, $years);

    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}


public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id');
    $institu   = $this->input->post('fk_institu');
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');

    // Debug
    if (!$branch_id) {
        die(json_encode(['error' => 'Branch ID missing']));
    }

    try {
        $result = $this->MiniImport_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate);
        echo json_encode($result);
    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
    }
}

public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // may be an array
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');

    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->MiniImport_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year — pass all filters
        $summary = $this->MiniImport_model->getSingleYearData($year, $institu, $branches, $startDate, $endDate);
        $types   = $this->MiniImport_model->getYearwiseTypes($year, $institu, $branches, $startDate, $endDate);
    }

    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 public function getStudentList()
    {
        $project_id = $this->input->post('project_id');
        if (!$project_id) {
            echo json_encode([]);
            return;
        }

        $students = $this->MiniImport_model->getStudentsByMeetId($project_id);
        echo json_encode($students);
    }

public function getGuideNames()
{
    $this->load->model('MiniImport_model');
    $data = $this->MiniImport_model->getGuideNames();
    echo json_encode($data);
}

}
