<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class NPTLReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('NPTLReport_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }


   
   
    public function create()
	{
  $data['domainbranch'] = $this->NPTLReport_model->getdomainbranch();
  $data['institutedata'] = $this->NPTLReport_model->getinstitu();
$data['yeardata'] = $this->NPTLReport_model->getyear();


$activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();

$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        //  echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
		$this->load->view('admin/NPTLReport_view',$data);
		$this->load->view('admin/footer_view');
	

	}



public function showDataByInstitute()
{
    $institute_id = $this->input->post('fk_institu');
    $year = $this->input->post('year');
  $typeids = $this->input->post('fk_domainbranch'); 
$startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');


    $data = $this->NPTLReport_model->getDataByInstitute(
        $institute_id,
        $year,
        $typeids,
         $startdate,
        $enddate
        
    );

    echo json_encode($data);
}

// for print
public function getPrintHeadings()
{
    $data = $this->NPTLReport_model->getPrintHeadings();
    echo json_encode($data);
}


// year and branch chart
 
 
// public function getYearwiseData()
// {
//     $year = $this->input->post('year');
 
//     if ($year == "0" || empty($year)) {
//         // All years
//         $summary = $this->NPTLReport_model->getAllYearsData();
//         $types   = [];
//     } else {
//         // Single year
//         $summary = $this->NPTLReport_model->getSingleYearData($year);
//         $types   = $this->NPTLReport_model->getYearwiseTypes($year);
//     }
 
//     echo json_encode([
//         "status"  => "success",
//         "summary" => $summary,
//         "types"   => $types
//     ]);
// }

 public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $branches  = $this->input->post('branches');   // may be an array
    
 
    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->NPTLReport_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year — pass all filters
        $summary = $this->NPTLReport_model->getSingleYearData($year, $branches);
        $types   = $this->NPTLReport_model->getYearwiseTypes($year,$branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkBranchName_id'); // match JS
    $year      = $this->input->post('year');
   
 
    $result = $this->NPTLReport_model->getBranchwiseCount($institu, $branches, $year);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkBranchName_id'); // match JS
    $year      = $this->input->post('year');
  
    $result = $this->NPTLReport_model->getBranchDetailsData($branch_id, $institu, $year);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    // $branches  = $this->input->post('branches');   // ❌ Commented - not using
    $years     = $this->input->post('years');
  
    $result = $this->NPTLReport_model->getCombinedData($institu, [], $years); // Empty array for branches
 
    echo json_encode([
        "status"      => "success",
        // "branchData"  => $result['branchData'], // ❌ Commented - not needed
        "yearData"    => $result['yearData']
    ]);
}
 
public function getStudentList()
{
    $fkmain_id = $this->input->post('fkmain_id');
    if (!$fkmain_id) {
        echo json_encode([]);
        return;
    }
 
    // $this->load->model('ParentMeet_model');
    $students = $this->NPTLReport_model->getStudentsByMeetId($fkmain_id);
 
    echo json_encode($students);
}
 

}
