<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class NSS_StudList extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('NSS_StudList_model');
          $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
        
    }

     public function index()
	{
      $data['alldata']=$this->NSS_StudList_model->getdetailview();

        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/NSS_Stud_detailview',$data);
		$this->load->view('admin/footer_view');
	

	}

   
    public function create()
	{
       $data['yeardata'] = $this->NSS_StudList_model->getyear();

       // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
 
		$this->load->view('admin/header_view');
		$this->load->view('admin/NSS_StudList_view',$data);
		$this->load->view('admin/footer_view');
	

	}


public function insertNSSStud()
{
    $this->output->set_content_type('application/json');

    // ============================================================
    // STEP 1: Save Excel / Manual Entry (PARENT RECORD)
    // ============================================================
    $fk_submenuId = $this->input->post('fk_submenuId');
    $Fk_branch    =  null;
    $excel_name  = 'Manual Entry';

    if (!empty($_FILES['activity_excel']['name'])) {

        // Excel uploaded
        $excel_name = $_FILES['activity_excel']['name'];

        $excelData = [
            'ExcelName'  => $excel_name,
            'entry_type' => 'excel'
        ];

        $this->db->insert('nssstudexcel', $excelData);
        $excel_id = $this->db->insert_id();

        /* ===== INSERT LOG (ACTION = 1) ===== */
        $action    = 1;
        $record_id = $excel_id;

        insert_log(
            $this,
            $fk_submenuId,
            $action,
            $record_id,
            $excel_name,
            $Fk_branch,
            $_SESSION['userID']
        );
        /* ================================== */

    } else {

        // Manual Entry
        $this->db->where('ExcelName', 'Manual Entry');
        $query = $this->db->get('nssstudexcel');

        if ($query->num_rows() > 0) {

            // Use existing Manual Entry
            $excel_id = $query->row()->id;

        } else {

            // Create new Manual Entry
            $excelData = [
                'ExcelName'  => 'Manual Entry',
                'entry_type' => 'manual'
            ];

            $this->db->insert('nssstudexcel', $excelData);
            $excel_id = $this->db->insert_id();

            /* ===== INSERT LOG (ACTION = 1) ===== */
            $action    = 1;
            $record_id = $excel_id;

            insert_log(
                $this,
                $fk_submenuId,
                $action,
                $record_id,
                'Manual Entry',
                $Fk_branch,
                $_SESSION['userID']
            );
            /* ================================== */
        }
    }

    // ============================================================
    // STEP 2: Insert NSS Student Records (CHILD RECORDS)
    // ============================================================
    $Financial_Year = $this->input->post('Financial_Year');
    $NameVolun      = $this->input->post('NameVolun');
    $Gender         = $this->input->post('Gender');
    $DOB            = $this->input->post('DOB');
    $Branch         = $this->input->post('Branch');
    $Class          = $this->input->post('Class');
    $Category       = $this->input->post('Category');
    $EmailID        = $this->input->post('EmailID');
    $MobileNo       = $this->input->post('MobileNo');
    $AadharNo       = $this->input->post('AadharNo');
    $NSSID          = $this->input->post('NSSID');

    if (!empty($NameVolun)) {
        foreach ($NameVolun as $i => $name) {

            if (trim($name) == '') {
                continue;
            }

            $nssData = [
                'Financial_Year'  => $Financial_Year[$i] ?? null,
                'NameVolun'       => $name,
                'Gender'          => $Gender[$i] ?? null,
                'DOB'             => $DOB[$i] ?? null,
                'Branch'          => $Branch[$i] ?? null,
                'Class'           => $Class[$i] ?? null,
                'Category'        => $Category[$i] ?? null,
                'EmailID'         => $EmailID[$i] ?? null,
                'MobileNo'        => $MobileNo[$i] ?? null,
                'AadharNo'        => $AadharNo[$i] ?? null,
                'excel_upload_id' => $excel_id,
                'created_by'      => $_SESSION['userID']
            ];

            if (!empty($NSSID[$i])) {
                $this->db->where('NSSID', $NSSID[$i]);
                $this->db->update('nssstud_master', $nssData);
            } else {
                $this->db->insert('nssstud_master', $nssData);
            }
        }
    }

    // ============================================================
    // STEP 3: RESPONSE
    // ============================================================
    echo json_encode([
        'status'  => 'success',
        'message' => 'NSS Summary saved successfully!'
    ]);
}

	
 public function update()
{
    $excel_upload_id = $this->uri->segment(4);
    
    // Get main record data
    $data['data'] = $this->NSS_StudList_model->getbyid($excel_upload_id);
    
    // Get child records (NSS activities) for this excel upload
    $data['childData'] = $this->NSS_StudList_model->getChildByMainId($excel_upload_id);
    
    // Get year data for dropdown
    $data['yeardata'] = $this->NSS_StudList_model->getyear();

    $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
    $this->load->view('admin/NSS_StudList_view', $data);
    $this->load->view('admin/footer_view');
}

public function updateNSSStud()
{
    // ✅ Load dependencies
    $this->load->library('upload');
    $this->load->helper(['form', 'url']);
    $this->load->database();

    $fixed_institute_id = 1; // ✅ Always save Institute_id = 1 (if needed)

    // ============================================================
    // ✅ STEP 1: Get the existing excel_upload_id
    // ============================================================
    $NSSID = $this->input->post('NSSID');
    $excel_id = $this->input->post('main_excel_id'); // ✅ Get from hidden field first
    
    // ✅ If not in hidden field, try to get from existing record
    if (empty($excel_id)) {
        if (!empty($NSSID) && is_array($NSSID)) {
            foreach ($NSSID as $id) {
                if (!empty($id) && $id != '' && $id != '0') {
                    $this->db->select('excel_upload_id');
                    $this->db->where('NSSID', $id);
                    $query = $this->db->get('nssstud_master');
                    
                    if ($query->num_rows() > 0) {
                        $excel_id = $query->row()->excel_upload_id;
                        break;
                    }
                }
            }
        }
    }
    
    log_message('debug', "Initial excel_upload_id: " . ($excel_id ? $excel_id : 'NULL'));

    // ============================================================
    // ✅ STEP 2: Handle Excel Upload or Keep Existing excel_upload_id
    // ============================================================
    $new_excel_uploaded = false;
    
    // Check if a NEW Excel file is uploaded
    if (!empty($_FILES['activity_excel']['name']) && $_FILES['activity_excel']['error'] == 0) {
        $excel_name = $_FILES['activity_excel']['name'];

        // ✅ Create new excel entry ONLY when new file is uploaded
        $excelData = [
            'ExcelName'    => $excel_name,
            'entry_type'   => 'excel',
            // 'institute_id' => $fixed_institute_id // Add if your table has this column
        ];
        $this->db->insert('nssstudexcel', $excelData);
        $excel_id = $this->db->insert_id();
        $new_excel_uploaded = true;
        
        log_message('debug', "New Excel file uploaded. Created new excel_upload_id: {$excel_id}");
    }
    
    // ✅ If still no excel_id, create/get Manual Entry record
    if (empty($excel_id)) {
        // Check if Manual Entry exists
        $this->db->select('id');
        $this->db->where('entry_type', 'manual');
        $this->db->where('ExcelName', 'Manual Entry');
        $manual_query = $this->db->get('nssstudexcel');
        
        if ($manual_query->num_rows() > 0) {
            // Use existing Manual Entry
            $excel_id = $manual_query->row()->id;
            log_message('debug', "Using existing Manual Entry excel_upload_id: {$excel_id}");
        } else {
            // Create new Manual Entry
            $excelData = [
                'ExcelName'    => 'Manual Entry',
                'entry_type'   => 'manual',
                // 'institute_id' => $fixed_institute_id // Add if your table has this column
            ];
            $this->db->insert('nssstudexcel', $excelData);
            $excel_id = $this->db->insert_id();
            log_message('debug', "Created new Manual Entry excel_upload_id: {$excel_id}");
        }
    }
    
    log_message('debug', "Final excel_upload_id to be used: {$excel_id}");

    // ============================================================
    // ✅ STEP 3: DELETE REMOVED RECORDS
    // ============================================================
    // Get all existing NSSIDs for this excel_upload_id
    $this->db->select('NSSID');
    $this->db->where('excel_upload_id', $excel_id);
    $existing_records = $this->db->get('nssstud_master');
    
    $existing_ids = [];
    if ($existing_records->num_rows() > 0) {
        foreach ($existing_records->result() as $row) {
            $existing_ids[] = $row->NSSID;
        }
    }
    
    // Clean the submitted IDs (remove empty/null values)
    $submitted_ids = [];
    if (!empty($NSSID) && is_array($NSSID)) {
        foreach ($NSSID as $id) {
            if (!empty($id) && $id != '' && $id != '0') {
                $submitted_ids[] = $id;
            }
        }
    }
    
    // Find IDs to delete (exist in DB but not submitted)
    $ids_to_delete = array_diff($existing_ids, $submitted_ids);
    
    // Delete records that were removed from the form
    if (!empty($ids_to_delete)) {
        $this->db->where_in('NSSID', $ids_to_delete);
        $this->db->delete('nssstud_master');
        
        log_message('debug', 'Deleted NSSIDs: ' . implode(', ', $ids_to_delete));
    }

    // ============================================================
    // ✅ STEP 4: Collect NSS Student Data from Form
    // ============================================================
    $Financial_Year = $this->input->post('Financial_Year');
    $NameVolun      = $this->input->post('NameVolun');
    $Gender         = $this->input->post('Gender');
    $DOB            = $this->input->post('DOB');
    $Branch         = $this->input->post('Branch');
    $Class          = $this->input->post('Class');
    $Category       = $this->input->post('Category');
    $EmailID        = $this->input->post('EmailID');
    $MobileNo       = $this->input->post('MobileNo');
    $AadharNo       = $this->input->post('AadharNo');
    $fk_submenuId = $this->input->post('fk_submenuId');

    // ============================================================
    // ✅ STEP 5: Update or Insert NSS Student Records
    // ============================================================
    if (!empty($NameVolun) && is_array($NameVolun)) {
        foreach ($NameVolun as $i => $volunteerName) {
            if (trim($volunteerName) == '') continue;

            $nssData = [
                'Financial_Year'  => isset($Financial_Year[$i]) ? $Financial_Year[$i] : null,
                'NameVolun'       => $volunteerName,
                'Gender'          => isset($Gender[$i]) ? $Gender[$i] : null,
                'DOB'             => isset($DOB[$i]) ? $DOB[$i] : null,
                'Branch'          => isset($Branch[$i]) ? $Branch[$i] : null,
                'Class'           => isset($Class[$i]) ? $Class[$i] : null,
                'Category'        => isset($Category[$i]) ? $Category[$i] : null,
                'EmailID'         => isset($EmailID[$i]) ? $EmailID[$i] : null,
                'MobileNo'        => isset($MobileNo[$i]) ? $MobileNo[$i] : null,
                'AadharNo'        => isset($AadharNo[$i]) ? $AadharNo[$i] : null,
                'excel_upload_id' => $excel_id,
                'modified_by'=>$_SESSION['userID'] // ✅ Use the SAME excel_id for ALL records
            ];

            // ✅ Check if this row has an existing NSSID
            $currentNSSID = isset($NSSID[$i]) ? trim($NSSID[$i]) : '';
            
            if (!empty($currentNSSID) && $currentNSSID != '' && $currentNSSID != '0') {
                // UPDATE existing record
                $this->db->where('NSSID', $currentNSSID);
                $updated = $this->db->update('nssstud_master', $nssData);
                
                log_message('debug', "Updated NSSID: {$currentNSSID}, Success: " . ($updated ? 'Yes' : 'No'));
            } else {
                // INSERT new record - ✅ Uses the SAME excel_upload_id
                $inserted = $this->db->insert('nssstud_master', $nssData);
                
                log_message('debug', "Inserted new record for: {$volunteerName} with excel_upload_id: {$excel_id}, Success: " . ($inserted ? 'Yes' : 'No'));
            }
        }
    }
/* ============================================================
   INSERT LOG – ACTION 2 (UPDATE)
============================================================ */
$action     = 2;               // Update
$record_id  = $excel_id;       // ✅ Parent excel record ID
$excel_name = null;
$Fk_branch  = null;

insert_log(
    $this,
    $fk_submenuId,
    $action,
    $record_id,
    $excel_name,
    $Fk_branch,
    $_SESSION['userID']
);
    // ============================================================
    // ✅ STEP 6: Send JSON Response
    // ============================================================
    echo json_encode(['status' => 'success', 'message' => 'NSS Student details updated successfully!']);
}

// Delete all students for a specific excel upload
public function deleteAllStudents()
{
    $this->load->database();
    
    $nssid = $this->input->post('nssid');
    $excel_upload_id = $this->input->post('excel_upload_id');
    
    // Try to get excel_upload_id from either source
    if (empty($excel_upload_id) && !empty($nssid)) {
        $this->db->select('excel_upload_id');
        $this->db->where('NSSID', $nssid);
        $query = $this->db->get('nssstud_master');
        
        if ($query->num_rows() > 0) {
            $excel_upload_id = $query->row()->excel_upload_id;
        }
    }
    
    if (empty($excel_upload_id)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid request - no excel upload ID found']);
        return;
    }
    
    // Delete all records with this excel_upload_id
    $this->db->where('excel_upload_id', $excel_upload_id);
    $deleted = $this->db->delete('nssstud_master');
    
    if ($deleted) {
        // ✅ Return the excel_upload_id so it can be kept in the form
        echo json_encode([
            'status' => 'success', 
            'message' => 'All students deleted successfully',
            'excel_upload_id' => $excel_upload_id  // ✅ This is important!
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to delete students']);
    }
}


}
