<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class NewConference extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('NewConference_model');
        $this->load->library('upload');
          $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }
    

    public function Dashboard()
    {
     
        
        // echo "<pre>";
        // print_r($data);
 
       
        $this->load->view('admin/header_view');
        $this->load->view('admin/New_confDash.php');
        $this->load->view('admin/footer_view');
   
   
 
    }


    public function create()
    {
        //  $data['allocationdata'] = $this->NewConference_model->getallocationData();
        $data['yeardata'] = $this->NewConference_model->getYearData();
        $data['active_year_id'] = date('Y');
         $data['activeYear'] = $this->NewConference_model->getActiveYear();
        $data['mainData'] = null;
        $data['childData'] = [];
        
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/NewConference_view.php', $data);
        $this->load->view('admin/footer_view');
    }

     public function index()
    {
        // Load list view
        $data['alldata'] = $this->NewConference_model->getAlldata();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/NewConference_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }


       // ЁЯФ╣ HELPER FUNCTION for single file upload
    private function upload_file($field_name, $upload_path)
    {
        if (!empty($_FILES[$field_name]['name'])) {
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }

            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
            // $config['max_size'] = 5120;
            $config['file_name'] = $field_name . '_' . time() . '_' . $_FILES[$field_name]['name'];
            $config['encrypt_name'] = FALSE;

            $this->upload->initialize($config);

            if ($this->upload->do_upload($field_name)) {
                $uploadData = $this->upload->data();
                return $uploadData['file_name'];
            }
        }
        return null;
    }


public function insertconf()
{

    error_reporting(E_ALL);
ini_set('display_errors', 1);

    $this->load->library('upload');
    try {
        $this->output->set_content_type('application/json');
        
        $posted_data = $this->input->post();
        $Financial_year = $this->input->post('Financial_year');
        $conf_name = $this->input->post('conf_name');
        $start_date = $this->input->post('start_date');
        $end_date = $this->input->post('end_date');
        $Photo_url = $this->input->post('Photo_url');
$fk_submenuId = $this->input->post('fk_submenuId');

        if (empty($posted_data['Guest_name']) || !is_array($posted_data['Guest_name'])) {
            echo json_encode(['status' => 'error', 'message' => 'At least one expense record is required']);
            return;
        }
        
        // Handle excel file upload
        $excel_name = null;
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'xlsx|xls';
            $config['max_size'] = 10240;
            $config['file_name'] = 'NewConference_excel_' . time();
            $config['overwrite'] = FALSE;
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
            }
        } else {
            // Manual entry - save as "Manual Entry"
            $excel_name = 'Manual Entry';
        }


$photo6_filename = $this->upload_file('document', './uploads/newconference/');
$document = $photo6_filename ? '/uploads/newconference/' . $photo6_filename : '';


        // Save parent data
        $parentData = array(
            'excel_file' => $excel_name,
            'Financial_year' => $Financial_year,
            'conf_name' => $conf_name,
            'start_date' => $start_date,
            'end_date' => $end_date,
            'Photo_url' => $Photo_url,
            'document' => $document,
            'created_by'=>$_SESSION['userID']

        );

        $institute = $this->db
    ->select('Institu_id')
    ->from('institute_master')
    ->get()
    ->row();

if ($institute) {
    $fields['Institute'] = $institute->Institu_id;
}

        
        $Id = $this->NewConference_model->insertMain($parentData);
        
 
        // Insert log - Action 1 (Insert)
        $action = 1;
        $record_id = $Id;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
       
        
        
        if (!$Id) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to insert main record']);
            return;
        }

        // Child data arrays
        $Guest_name = $this->input->post('Guest_name');
        $guest_details = $this->input->post('guest_details');
       
        // Process all file uploads
        $document_1_paths = $this->processFileUploads('document_1');
        $document_2_paths = $this->processFileUploads('document_2');
       
       
        $inserted_count = 0;

        // Insert child records
        if (!empty($Guest_name)) {
            foreach ($Guest_name as $i => $name) {
                // if (trim($name) == '') continue;
                
                $childData = array(
                    'fk_confmain' => $Id,
                    'Guest_name' => $name,
                    'guest_details' => isset($guest_details[$i]) ? $guest_details[$i] : null,
                    'document_1' => isset($document_1_paths[$i]) ? $document_1_paths[$i] : null,
                    'document_2' => isset($document_2_paths[$i]) ? $document_2_paths[$i] : null,
                    
                );

                if ($this->NewConference_model->insertChild($childData)) {
                    $inserted_count++;
                }
            }
        }

        if ($inserted_count > 0) {
            echo json_encode([
                'status' => 'success', 
                'main_id' => $Id,
                'inserted_count' => $inserted_count,
                'message' => "Successfully saved {$inserted_count} expense records"
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No expense records were saved']);
        }
        
    } catch (Exception $e) {
        log_message('error', 'Budget insertion error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}

public function update($id)
{
    // Load all required data for dropdowns
   
        $data['yeardata'] = $this->NewConference_model->getYearData();
        $data['active_year_id'] = date('Y');
         $data['activeYear'] = $this->NewConference_model->getActiveYear();
    // Load existing data
    $data['mainData'] = $this->NewConference_model->getMainById($id);
    $data['childData'] = $this->NewConference_model->getChildByMainId($id);
    
    // IMPORTANT: Pass the data array to view
    $data['data'] = $data['childData']; // This creates the $data[0] variable in view
    $data['active_year_id'] = $data['mainData']->finicial_Year ?? date('Y');
    
    $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);
    
    $this->load->view('admin/header_view');
        $this->load->view('admin/NewConference_view.php', $data);
    $this->load->view('admin/footer_view');
}



public function updateconf()
{
    $this->load->library('upload');
    try {
        $this->output->set_content_type('application/json');
        
        $posted_data = $this->input->post();
 $Financial_year = $this->input->post('Financial_year');
        $conf_name = $this->input->post('conf_name');
        $start_date = $this->input->post('start_date');
        $end_date = $this->input->post('end_date');
        $Photo_url = $this->input->post('Photo_url');
        $fk_submenuId = $this->input->post('fk_submenuId');
                $Id = $posted_data['new_id'] ?? null;
        
        if (empty($Id)) {
            echo json_encode(['status' => 'error', 'message' => 'Main ID is required']);
            return;
        }
        
        if (empty($posted_data['Guest_name']) || !is_array($posted_data['Guest_name'])) {
            echo json_encode(['status' => 'error', 'message' => 'At least one cultural record is required']);
            return;
        }
        
        // Get existing main data
        $existingMain = $this->NewConference_model->getMainById($Id);
        $excel_name = $existingMain->excel_file ?? null;
        
        // Handle excel file upload (if new file uploaded)
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            // Delete old excel file if exists and not "Manual Entry"
            if (!empty($excel_name) && $excel_name != 'Manual Entry' && file_exists($upload_path . $excel_name)) {
                unlink($upload_path . $excel_name);
            }
            
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'xlsx|xls';
            $config['max_size'] = 10240;
            $config['file_name'] = 'NewConference_excel_' . time();
            $config['overwrite'] = FALSE;
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
            }
        }

        $existing_photo6 = $this->input->post('hidden_company');
$photo6_filename = $this->upload_file('document', './uploads/newconference/');
$document = $photo6_filename ? '/uploads/newconference/' . $photo6_filename : $existing_photo6;

        // Update parent data
        $parentData = array(
             'excel_file' => $excel_name,
            'Financial_year' => $Financial_year,
            'conf_name' => $conf_name,
            'start_date' => $start_date,
            'end_date' => $end_date,
            'Photo_url' => $Photo_url,
            'document' => $document,
            'modified_by'=>$_SESSION['userID']
        );
        
        if (!$this->NewConference_model->updateMain($Id, $parentData)) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update main record']);
            return;
        }
        
        // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $Id;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

        // Delete existing child records
        $this->NewConference_model->deleteChildByMainId($Id);

       // Child data arrays
        $Guest_name = $this->input->post('Guest_name');
        $guest_details = $this->input->post('guest_details');
       
// Get existing file paths
        $existing_document_1 = $this->input->post('existing_document_1');
        $existing_document_2 = $this->input->post('existing_document_2');

        // Process all file uploads
        $document_1_paths = $this->processFileUploads('document_1');
        $document_2_paths = $this->processFileUploads('document_2');
        
      
        
        $inserted_count = 0;
        
        // Insert updated child records
        if (!empty($Guest_name)) {
            foreach ($Guest_name as $i => $name) {
                
                // Use new file if uploaded, otherwise use existing
                $doc1 = !empty($document_1_paths[$i]) ? $document_1_paths[$i] : (isset($existing_document_1[$i]) ? $existing_document_1[$i] : null);
                $doc2 = !empty($document_2_paths[$i]) ? $document_2_paths[$i] : (isset($existing_document_2[$i]) ? $existing_document_2[$i] : null);
                
                $childData = array(
                     'fk_confmain' => $Id,
                    'Guest_name' => $name,
                    'guest_details' => isset($guest_details[$i]) ? $guest_details[$i] : null,
                    'document_1' => $doc1,
                    'document_2' => $doc2,
                   
                );

                if ($this->NewConference_model->insertChild($childData)) {
                    $inserted_count++;
                }
            }
        }

        if ($inserted_count > 0) {
            echo json_encode([
                'status' => 'success', 
                'main_id' => $Id,
                'updated_count' => $inserted_count,
                'message' => "Successfully updated with {$inserted_count} records"
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No records were saved']);
        }
        
    } catch (Exception $e) {
        log_message('error', 'Update error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}


  // Helper function to process multiple file uploads
   private function processFileUploads($field_name)
{
    $file_paths = [];
    
    if (!empty($_FILES[$field_name]['name'])) {
        $total_files = count($_FILES[$field_name]['name']);
        
        for ($key = 0; $key < $total_files; $key++) {
            $file_name = $_FILES[$field_name]['name'][$key];
            
            // Agar file empty hai to null set karo but index maintain karo
            if (empty($file_name) || $_FILES[$field_name]['error'][$key] == UPLOAD_ERR_NO_FILE) {
                $file_paths[$key] = null;
                continue;
            }
            
            $_FILES['upload_file']['name'] = $_FILES[$field_name]['name'][$key];
            $_FILES['upload_file']['type'] = $_FILES[$field_name]['type'][$key];
            $_FILES['upload_file']['tmp_name'] = $_FILES[$field_name]['tmp_name'][$key];
            $_FILES['upload_file']['error'] = $_FILES[$field_name]['error'][$key];
            $_FILES['upload_file']['size'] = $_FILES[$field_name]['size'][$key];

            $config['upload_path'] = './uploads/newconference/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx';
            $config['max_size'] = 5120;
            $config['file_name'] = $field_name . '_' . time() . '_' . $key . '_' . $file_name;
            $config['encrypt_name'] = FALSE;

            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, TRUE);
            }

            $this->upload->initialize($config);

            if ($this->upload->do_upload('upload_file')) {
                $uploadData = $this->upload->data();
                $file_paths[$key] = '/uploads/newconference/' . $uploadData['file_name'];
            } else {
                $file_paths[$key] = null;
            }
        }
    }
    
    return $file_paths;
}

    // тнР NEW: Helper for single file upload (for update mode)
    private function processSingleFileUpload($field_name, $existing_field)
    {
        // Check if new file is uploaded
        if (!empty($_FILES[$field_name]['name']) && !empty($_FILES[$field_name]['name'][0])) {
            $config['upload_path'] = './uploads/newconference/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx';
            $config['max_size'] = 5120;
            $config['file_name'] = $field_name . '_' . time() . '_' . $_FILES[$field_name]['name'][0];
            $config['encrypt_name'] = FALSE;

            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, TRUE);
            }

            // Temporarily move array file to single file for upload
            $_FILES['temp_file']['name'] = $_FILES[$field_name]['name'][0];
            $_FILES['temp_file']['type'] = $_FILES[$field_name]['type'][0];
            $_FILES['temp_file']['tmp_name'] = $_FILES[$field_name]['tmp_name'][0];
            $_FILES['temp_file']['error'] = $_FILES[$field_name]['error'][0];
            $_FILES['temp_file']['size'] = $_FILES[$field_name]['size'][0];

            $this->upload->initialize($config);

            if ($this->upload->do_upload('temp_file')) {
                $uploadData = $this->upload->data();
                return '/uploads/newconference/' . $uploadData['file_name'];
            }
        }
        
        // Return existing file if no new file uploaded
        $existing = $this->input->post($existing_field);
        return is_array($existing) ? $existing[0] : $existing;
    }

}