<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ni_Report1 extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Ni_Report1_model');
        if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
        }
    }
    
    public function Report()
    {
        $data['yeardata'] = $this->Ni_Report1_model->getyear();
        $data['branchdata'] = $this->Ni_Report1_model->getbranch();
        
        // Debug - यह lines temporarily add करें check करने के लिए
        // echo '<pre>'; print_r($data['branchdata']); exit;
        
        $activeYear = $this->db
            ->select('finiYear_id')
            ->from('finiyear_master')
            ->where('Active_Deactive', 1)
            ->get()
            ->row();
     
        $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Ni_Report1_view.php', $data);
        $this->load->view('admin/footer_view');
    }
    
    public function getYearWiseCount()
    {
        $institu_id = $this->input->post('fk_institu');
        $branch_ids = $this->input->post('fkbranch_id');
        $year = $this->input->post('year');
        
        if (is_array($year)) {
            $year = array_filter($year, function($val) {
                return !empty($val) && $val != "0" && $val !== "";
            });
            $year = array_values($year);
            if (empty($year)) {
                $year = null;
            }
        } else if ($year == "0" || $year == "" || $year === null) {
            $year = null;
        }
        
        if (is_array($branch_ids)) {
            $branch_ids = array_filter($branch_ids, function($val) {
                return !empty($val) && $val != "0" && $val !== "";
            });
            $branch_ids = array_values($branch_ids);
            if (empty($branch_ids)) {
                $branch_ids = null;
            }
        } else if ($branch_ids == "0" || $branch_ids == "" || $branch_ids === null) {
            $branch_ids = null;
        }
        
        $result = $this->Ni_Report1_model->getYearWiseMOUCount($institu_id, $branch_ids, $year);
        echo json_encode($result);
    }
    
    public function getMOUData()
    {
        $institu_id = $this->input->post('fk_institu');
        $branch_ids = $this->input->post('fkbranch_id');
        $year = $this->input->post('year');
        $specific_year_id = $this->input->post('specific_year_id');
        
        if (is_array($year)) {
            $year = array_filter($year, function($val) {
                return !empty($val) && $val != "0" && $val !== "";
            });
            $year = array_values($year);
            if (empty($year)) {
                $year = null;
            }
        } else if ($year == "0" || $year == "" || $year === null) {
            $year = null;
        }
        
        if (is_array($branch_ids)) {
            $branch_ids = array_filter($branch_ids, function($val) {
                return !empty($val) && $val != "0" && $val !== "";
            });
            $branch_ids = array_values($branch_ids);
            if (empty($branch_ids)) {
                $branch_ids = null;
            }
        } else if ($branch_ids == "0" || $branch_ids == "" || $branch_ids === null) {
            $branch_ids = null;
        }
        
        $result = $this->Ni_Report1_model->getMOUDataFiltered(
            $institu_id, 
            $branch_ids, 
            $year, 
            $specific_year_id
        );
        
        echo json_encode($result);
    }
    
    public function getPrintHeadings()
    {
        $result = $this->Ni_Report1_model->getPrintHeadings();
        echo json_encode($result);
    }
}