<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Outward extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Outward_model');
        $this->load->library('upload');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
        
    }

    public function index()
    {
        $data['alldata'] = $this->Outward_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Outward_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
         $data['departmentdata'] = $this->Outward_model->getdepartment(); // ADD THIS
         $data['mainuserdata'] = $this->Outward_model->getmainuser();
        $data['categorydata'] = $this->Outward_model->getcategory();
        $data['itemdata'] = $this->Outward_model->getitem();
        $data['unitdata'] = $this->Outward_model->getunit();
        
// ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Outward_view', $data);
        $this->load->view('admin/footer_view');
    }

   public function searchDepartments()
{
    $search = $this->input->post('search');
    
    if ($search) {
        $this->db->like('Department_name', $search);
        $this->db->where('is_active', 1);
        $this->db->order_by('Department_name', 'ASC');
        $query = $this->db->get('outward_department_master'); // Update table name as per your DB
        
        if ($query->num_rows() > 0) {
            echo json_encode([
                'success' => true,
                'data' => $query->result()
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'data' => []
            ]);
        }
    } else {
        echo json_encode([
            'success' => false,
            'data' => []
        ]);
    }
}

public function addNewDepartment()
{
    // Suppress PHP errors
    error_reporting(0);
    header('Content-Type: application/json');
    
    try {
        $departmentName = trim($this->input->post('department_name'));
        
        if (empty($departmentName)) {
            echo json_encode([
                'success' => false,
                'message' => 'Department name is required'
            ]);
            exit;
        }
        
        // Check if department already exists
        $this->db->where('Department_name', $departmentName);
        $this->db->where('is_active', 1);
        $existing = $this->db->get('outward_department_master');
        
        if ($existing->num_rows() > 0) {
            $dept = $existing->row();
            echo json_encode([
                'success' => true,
                'message' => 'Department already exists',
                'department_id' => $dept->department_id,
                'department_name' => $dept->Department_name
            ]);
            exit;
        }
        
        // Prepare data for insertion
        $data = array(
            'Department_name' => $departmentName,
            'is_active' => 1,
            'is_on' => 1,
            'created_date' => date('Y-m-d H:i:s')
        );
        
        // Add created_by only if session exists
        if (isset($_SESSION['userID']) && !empty($_SESSION['userID'])) {
            $data['created_by'] = $_SESSION['userID'];
        }
        
        // Insert new department
        $insert = $this->db->insert('outward_department_master', $data);
        
        if ($insert) {
            $newDeptId = $this->db->insert_id();
            
            echo json_encode([
                'success' => true,
                'message' => 'New department added successfully',
                'department_id' => $newDeptId,
                'department_name' => $departmentName
            ]);
        } else {
            // Get DB error
            $error = $this->db->error();
            echo json_encode([
                'success' => false,
                'message' => 'Database error: ' . $error['message']
            ]);
        }
        
    } catch (Exception $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Error: ' . $e->getMessage()
        ]);
    }
    exit;
}

 // ============ NEW METHOD: Get Item Stock Quantity ============
    public function getItemStockQty()
    {
        $itemId = $this->input->post('item_id');
        
        if ($itemId) {
            // Get stock quantity from model
            $stockQty = $this->Outward_model->getStockQuantity($itemId);
            
            if ($stockQty !== false) {
                echo json_encode([
                    'success' => true,
                    'stock_qty' => $stockQty
                ]);
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Stock not found',
                    'stock_qty' => 0
                ]);
            }
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Invalid item ID'
            ]);
        }
    }


   public function insertOutward()
{
    // ✅ Suppress PHP errors in JSON response
    error_reporting(0);
    header('Content-Type: application/json');
    
    // Get institute id
    $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
    $institute_id = $institute ? $institute->Institu_id : null;

    // Get current financial year
    $finiYear = $this->db->select('finiYear_id')->from('finiyear_master')->where('Active_Deactive', 1)->get()->row();
    $finicial_year = $finiYear ? $finiYear->finiYear_id : null;

    // Calculate Grand Total from totals array
    $totals = $this->input->post('Total');
    $fk_submenuId = $this->input->post('fk_submenuId');

    $grandTotal = 0;
    if (!empty($totals)) {
        foreach ($totals as $total) {
            $grandTotal += floatval($total);
        }
    }

    // ✅ FIX: Check if session userID exists
    $created_by = isset($_SESSION['userID']) ? $_SESSION['userID'] : null;

    // Get main form data
    $mainData = array(
        'fkdepartment_id' => $this->input->post('fkdepartment_id'),
        'Date' => $this->input->post('Date'),
        'fkmainuser_id' => $this->input->post('fkmainuser_id'),
        'Applicant_name' => $this->input->post('Applicant_name'),
        'Applicant_id' => $this->input->post('Applicant_id'),
        'Grand_Total' => $grandTotal, 
        'institute' => $institute_id,
        'finicial_Year' => $finicial_year,
        'created_by' => $created_by // ✅ FIXED LINE 106
    );
    
    // Insert main data and get the ID
    $mainId = $this->Outward_model->insertMainData($mainData);

    // Insert log - Action 1 (Insert)
    $action = 1;
    $record_id = $mainId;
    $excel_name = null;
    $Fk_branch = null;
    insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch, $created_by); // ✅ FIXED LINE 117

    if ($mainId) {
        // Get table data arrays
        $categoryIds = $this->input->post('fkCategory_ID');
        $itemIds = $this->input->post('fkItem_id');
        $unitIds = $this->input->post('fkUnit_ID');
        $quantities = $this->input->post('Quantity');
        $rates = $this->input->post('Rate');
        $totals = $this->input->post('Total');
        
        // Loop through arrays and insert child data
        if (!empty($categoryIds)) {
            foreach ($categoryIds as $key => $categoryId) {
                // Skip empty rows
                if (empty($categoryId) && empty($itemIds[$key])) {
                    continue;
                }
                
                $childData = array(
                    'fkOutward_main_id' => $mainId,
                    'fkCategory_ID' => $categoryId,
                    'fkItem_id' => $itemIds[$key],
                    'fkUnit_ID' => $unitIds[$key],
                    'Quantity' => $quantities[$key],
                    'Rate' => $rates[$key],
                    'Total' => $totals[$key]
                );
                
                // Insert child data
                $this->Outward_model->insertChildData($childData);
            }
        }
        
        echo json_encode(['success' => true, 'message' => 'Outward added successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to insert Outward data']);
    }
    exit;
}



    public function update()
{
    $id = $this->uri->segment(4);
    $data['data'] = $this->Outward_model->getMainById($id);
    
    // Fetch and verify child data
    $childData = $this->Outward_model->getChildByMainId($id);
    
    // Debug: Check what's in childData
    if (!empty($childData)) {
        log_message('debug', 'Child Data Keys: ' . print_r(array_keys((array)$childData[0]), true));
    }
    
    $data['childData'] = $childData;

    // ✅ ADD THIS - Fetch department name for update mode
    if (!empty($data['data']) && isset($data['data'][0]->fkdepartment_id)) {
        $department = $this->Outward_model->getDepartmentById($data['data'][0]->fkdepartment_id);
        $data['data'][0]->Department_name = $department ? $department->Department_name : '';
    }

     $data['departmentdata'] = $this->Outward_model->getdepartment(); // ADD THIS
   $data['mainuserdata'] = $this->Outward_model->getmainuser();
    $data['categorydata'] = $this->Outward_model->getcategory();
    $data['itemdata'] = $this->Outward_model->getitem();
    $data['unitdata'] = $this->Outward_model->getunit();
    
$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
    $this->load->view('admin/Outward_view', $data);
    $this->load->view('admin/footer_view');
}

  public function updateOutward()
{
    // ✅ Suppress PHP errors in JSON response
    error_reporting(0);
    header('Content-Type: application/json');
    
    // Get main form data
    $mainId = $this->input->post('Outward_main_id');
    $fk_submenuId = $this->input->post('fk_submenuId');

    if (!$mainId) {
        echo json_encode(['success' => false, 'message' => 'Invalid Outward ID']);
        exit;
    }
    
    // Get institute id
    $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
    $institute_id = $institute ? $institute->Institu_id : null;

    // Get current financial year
    $finiYear = $this->db->select('finiYear_id')->from('finiyear_master')->where('Active_Deactive', 1)->get()->row();
    $finicial_year = $finiYear ? $finiYear->finiYear_id : null;

    // Calculate Grand Total from totals array
    $totals = $this->input->post('Total');
    $grandTotal = 0;
    if (!empty($totals)) {
        foreach ($totals as $total) {
            $grandTotal += floatval($total);
        }
    }

    // ✅ FIX: Check if session userID exists
    $modified_by = isset($_SESSION['userID']) ? $_SESSION['userID'] : null;

    $mainData = array(
        'fkdepartment_id' => $this->input->post('fkdepartment_id'),
        'Date' => $this->input->post('Date'),
        'fkmainuser_id' => $this->input->post('fkmainuser_id'),
        'Applicant_name' => $this->input->post('Applicant_name'),
        'Applicant_id' => $this->input->post('Applicant_id'),
        'Grand_Total' => $grandTotal, 
        'institute' => $institute_id,
        'finicial_Year' => $finicial_year,
        'modified_by' => $modified_by // ✅ FIXED
    );
    
    // Start transaction for data integrity
    $this->db->trans_start();
    
    // Update main data
    $this->Outward_model->updateMainData($mainId, $mainData);
    
    // Insert log - Action 2 (Update)
    $action = 2;
    $record_id = $mainId;
    $excel_name = null;
    $Fk_branch = null;
    insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch, $modified_by); // ✅ FIXED
    
    // Delete ALL old child records
    $this->Outward_model->deleteChildByMainId($mainId);
    
    // Get table data arrays
    $categoryIds = $this->input->post('fkCategory_ID');
    $itemIds = $this->input->post('fkItem_id');
    $unitIds = $this->input->post('fkUnit_ID');
    $quantities = $this->input->post('Quantity');
    $rates = $this->input->post('Rate');
    $totals = $this->input->post('Total');
    
    // Insert ALL current records as fresh data
    if (!empty($categoryIds)) {
        foreach ($categoryIds as $key => $categoryId) {
            // Skip empty rows
            if (empty($categoryId) && empty($itemIds[$key])) {
                continue;
            }
            
            $childData = array(
                'fkOutward_main_id' => $mainId,
                'fkCategory_ID' => $categoryId,
                'fkItem_id' => $itemIds[$key],
                'fkUnit_ID' => $unitIds[$key],
                'Quantity' => $quantities[$key],
                'Rate' => $rates[$key],
                'Total' => $totals[$key]
            );
            
            // Insert as new record
            $this->Outward_model->insertChildData($childData);
        }
    }
    
    // Complete transaction
    $this->db->trans_complete();
    
    if ($this->db->trans_status() === FALSE) {
        echo json_encode(['success' => false, 'message' => 'Failed to update Outward']);
    } else {
        echo json_encode(['success' => true, 'message' => 'Outward updated successfully']);
    }
    exit;
}

   
    public function debugUpdate()
    {
        $id = $this->uri->segment(4);
        
        if (!$id) {
            echo "Please provide an ID: /admin/Outward/debugUpdate/1";
            return;
        }
        
        echo "<h2>Debug Information for Outward ID: {$id}</h2>";
        
        // Check main data
        $mainData = $this->Outward_model->getMainById($id);
        echo "<h3>Main Data:</h3>";
        echo "<pre>";
        print_r($mainData);
        echo "</pre>";
        
        // Check child data with joins
        $childData = $this->Outward_model->getChildByMainId($id);
        echo "<h3>Child Data (with joins) - Count: " . count($childData) . "</h3>";
        echo "<pre>";
        print_r($childData);
        echo "</pre>";
        
        // Check raw child data
        $rawChildData = $this->Outward_model->debugChildData($id);
        echo "<h3>Raw Child Data (no joins) - Count: " . count($rawChildData) . "</h3>";
        echo "<pre>";
        print_r($rawChildData);
        echo "</pre>";
        
        // Check table structure
        echo "<h3>Outward Master Table Structure:</h3>";
        $fields = $this->db->field_data('Outward_master');
        echo "<pre>";
        print_r($fields);
        echo "</pre>";
    }

    // Delete method (bonus)
    public function delete()
    {
        $id = $this->uri->segment(4);
        
        if ($id) {
            $result = $this->Outward_model->deleteOutward($id);
            
            if ($result) {
                $this->session->set_flashdata('success', 'Outward deleted successfully');
            } else {
                $this->session->set_flashdata('error', 'Failed to delete Outward');
            }
        }
        
        redirect('admin/Outward/index');
    }

    // Add this method in your Outward controller
public function getItemUnit()
{
    $itemId = $this->input->post('item_id');
    
    if ($itemId) {
        // Get unit_id from store_item_master table
        $this->db->select('fkUnit_ID as unit_id');
        $this->db->from('store_item_master');
        $this->db->where('Item_id', $itemId);
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            $result = $query->row();
            echo json_encode([
                'success' => true,
                'unit_id' => $result->unit_id
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Unit not found'
            ]);
        }
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Invalid item ID'
        ]);
    }
}



}
?>