<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PO_Mapping extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('PO_Mapping_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

     public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/PO_Mapping_dash_view.php');
        $this->load->view('admin/footer_view');
    }


   
     public function index()
	{
      $data['alldata']=$this->PO_Mapping_model->getdetailview();

        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/PO_Mapping_detailview.php',$data);
        $this->load->view('admin/footer_view');

	}


    public function create()
	{
            //    $data['load_script'] = 'Department';
        $data['branchdata'] = $this->PO_Mapping_model->getbranch();
        $data['yeardata'] = $this->PO_Mapping_model->getyear();
            

       
	    $this->load->view('admin/header_view');
        $this->load->view('admin/PO_Mapping_view.php',$data);
        $this->load->view('admin/footer_view');
	

	}

  public function getCourses()
    {
        $branchId = $this->input->post('branchId');
        $yearId   = $this->input->post('yearId');

        if (empty($branchId) || empty($yearId)) {
            echo json_encode(array(
                'status'  => 'error',
                'message' => 'Please select both Department and Academic Year'
            ));
            return;
        }

        // Courses fetch
        $courses = $this->PO_Mapping_model->getCoursesByBranchAndYear($branchId, $yearId);

        // PO Labels fetch — yearwise_po_master se branch + year ke hisaab se
        $poLabels = $this->PO_Mapping_model->getPOLabelsByBranchAndYear($branchId, $yearId);

        if (empty($poLabels)) {
            echo json_encode(array(
                'status'  => 'error',
                'message' => 'No PO Labels found for selected Department and Year. Please configure PO labels first.'
            ));
            return;
        }

        // Success response
        $response = array(
            'status'   => 'success',
            'data'     => $courses,
            'poLabels' => $poLabels   // PO1, PO2...PSO3 labels
        );

        echo json_encode($response);
    }

    // AJAX: Existing mappings load (edit mode)
   // ============================================================
// AJAX: Existing mappings load (edit mode)
// ============================================================
public function getExistingMappings()
{
    $branchId = $this->input->post('branchId');
    $yearId   = $this->input->post('yearId');

    $this->PO_Mapping_model->db->select('fkCourse_id, fkPO_lable_id, mapping_value');
    $this->PO_Mapping_model->db->from('co_po_mapping');
    $this->PO_Mapping_model->db->where('fkbranch_id', $branchId);
    $this->PO_Mapping_model->db->where('finicial_Year', $yearId);
    $this->PO_Mapping_model->db->where('is_active', 1);
    $query = $this->PO_Mapping_model->db->get();
    $mappings = $query->result();

    echo json_encode(array(
        'status' => 'success',
        'data'   => $mappings
    ));
}

// ============================================================
// AJAX: Save mapping data with INSERT and UPDATE logic
// ============================================================
public function insertPO_Mapping()
{
    $branchId   = $this->input->post('branchId');
    $yearId     = $this->input->post('yearId');
    $submenuId  = $this->input->post('fk_submenuId');
    $mappingRaw = $this->input->post('mappingData');

    $mappingData = json_decode($mappingRaw, true);

    if (empty($mappingData)) {
        echo json_encode(array(
            'status'  => 'error',
            'message' => 'No mapping data received'
        ));
        return;
    }

    // Pehle existing mappings fetch karo
    $this->db->select('mapping_id, fkCourse_id, fkPO_lable_id, mapping_value');
    $this->db->from('co_po_mapping');
    $this->db->where('fkbranch_id', $branchId);
    $this->db->where('finicial_Year', $yearId);
    $this->db->where('is_active', 1);
    $query = $this->db->get();
    $existingMappings = $query->result();

    // Existing mappings ko array mein convert karo (courseId_poLabelId => mapping_id)
    $existingMap = array();
    foreach ($existingMappings as $existing) {
        $key = $existing->fkCourse_id . '_' . $existing->fkPO_lable_id;
        $existingMap[$key] = array(
            'mapping_id'    => $existing->mapping_id,
            'mapping_value' => $existing->mapping_value
        );
    }

    // Track karo ki konse mappings process hue
    $processedKeys = array();

    // Ab har mapping ko process karo
    foreach ($mappingData as $course) {
        foreach ($course['mappings'] as $mapping) {
            $key = $course['courseId'] . '_' . $mapping['poLabelId'];
            $processedKeys[] = $key;

            $data = array(
                'fkCourse_id'   => $course['courseId'],
                'fkPO_lable_id' => $mapping['poLabelId'],
                'mapping_value' => $mapping['value'],
                'fkbranch_id'   => $branchId,
                'finicial_Year' => $yearId,
                'fk_submenuId'  => $submenuId,
                'institute'     => $this->session->userdata('institute'),
                'is_active'     => 1
            );

            // Check karo ki yeh mapping pehle se exist karti hai
            if (isset($existingMap[$key])) {
                // Agar value different hai to UPDATE karo
                if ($existingMap[$key]['mapping_value'] != $mapping['value']) {
                    $data['updated_date'] = date('Y-m-d H:i:s');
                    $data['updated_by']   = $this->session->userdata('user_id');

                    $this->db->where('mapping_id', $existingMap[$key]['mapping_id']);
                    $this->db->update('co_po_mapping', $data);
                }
                // Agar value same hai to kuch nahi karo (skip)
            } else {
                // Naya mapping hai to INSERT karo
                $data['created_date'] = date('Y-m-d H:i:s');
                $data['created_by']   = $this->session->userdata('user_id');
                $this->db->insert('co_po_mapping', $data);
            }
        }
    }

    // Jo mappings ab nahi aayi (user ne delete ki) unhe soft delete karo
    foreach ($existingMap as $key => $existing) {
        if (!in_array($key, $processedKeys)) {
            $this->db->set('deleted_date', date('Y-m-d H:i:s'));
            $this->db->set('deleted_by', $this->session->userdata('user_id'));
            $this->db->set('is_active', 0);
            $this->db->where('mapping_id', $existing['mapping_id']);
            $this->db->update('co_po_mapping');
        }
    }

    echo json_encode(array(
        'status'  => 'success',
        'message' => 'CO-PO Mapping saved successfully!'
    ));
}
}