<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class ParentImport extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('ParentImport_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    // Load Import View
    public function create()
    {
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        $this->load->view('admin/header_view');
        $this->load->view('admin/ParentImport_view',$data);
        $this->load->view('admin/footer_view');
    }

    // Load Import View
    public function Report()
    {

        $data['Branch'] = $this->ParentImport_model->getDistinctDepartments();

        $data['institutedata'] = $this->ParentImport_model->get_all_institute();
//  $data['Branch'] = $this->Import_techExcel_model->get_all_Branch();
      
$data['yeardata'] = $this->ParentImport_model->getyear();
 $activeYear = $this->db
    ->select('branch_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
$data['active_year_id'] = $activeYear ? $activeYear->branch_id : 0;

        $this->load->view('admin/header_view');
        $this->load->view('admin/NSS_Report',$data);
        $this->load->view('admin/footer_view');
    }



public function showDataByInstitute()
{
    $license_Institu_id = $this->input->post('InstituteId');
    $startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');
    $departments  = $this->input->post('Department');  // coming from multi-select

    $data = $this->ParentImport_model->getDataByInstitute(
        $license_Institu_id,
        $startdate,
        $enddate,
        $departments
    );

    echo json_encode($data);
}


public function getPrintHeadings()
{
    $data = $this->ParentImport_model->getPrintHeadings();
    echo json_encode($data);
}
public function import_excel_save() {
    try {
        $fk_submenuId = $this->input->post('fk_submenuId');
        // ✅ Save Excel File
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];

            $uploadPath = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            $filename = 'parent_excel_' . date('Ymd_His') . '_' . $originalName;
            $targetFile = $uploadPath . $filename;

            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "Error saving file!";
                return;
            }
        } else {
            echo "No file uploaded!";
            return;
        }

        // ✅ Process tableData
        $postData = $this->input->post('tableData');
        if (empty($postData)) {
            echo "no_data";
            return;
        }

        $rows = json_decode($postData, true);
        if (!$rows || count($rows) == 0) {
            echo "no_data";
            return;
        }

        // ✅ Get Institute ID
        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $Institute_id = $institute ? $institute->Institu_id : null;

        // ✅ Branch & Year Maps
        $branchMap = [];
        foreach ($this->db->get_where('branch_master', ['is_active' => 1])->result() as $b) {
            $branchMap[strtolower(trim($b->branch_name))] = $b->branch_id;
        }

        $yearMap = [];
        foreach ($this->db->get_where('finiyear_master', ['is_active' => 1])->result() as $y) {
            $yearMap[strtolower(trim($y->fini_Label))] = $y->finiYear_id;
        }

        $insertData = [];
        $rowCount = 0;

        foreach ($rows as $row) {
            $rowCount++;
            if ($rowCount === 1) continue; // skip header row

            // ✅ Year
            $yearStr = strtolower(trim($row['FiniYear'] ?? ''));
            if ($yearStr !== '') {
                if (!isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', ['fini_Label' => ucfirst($yearStr), 'is_active' => 1]);
                    $finiYear_id = $this->db->insert_id();
                    $yearMap[$yearStr] = $finiYear_id;
                } else {
                    $finiYear_id = $yearMap[$yearStr];
                }
            } else $finiYear_id = null;

            // ✅ Branch
            $branchStr = strtolower(trim($row['fkBranch_id'] ?? ''));
            if ($branchStr !== '') {
                if (!isset($branchMap[$branchStr])) {
                    $this->db->insert('branch_master', ['branch_name' => ucfirst($branchStr), 'is_active' => 1]);
                    $branch_id = $this->db->insert_id();
                    $branchMap[$branchStr] = $branch_id;
                } else {
                    $branch_id = $branchMap[$branchStr];
                }
            } else $branch_id = null;

            // ✅ Date
            $MeetDate = null;
            if (!empty($row['MeetDate'])) {
                $dateValue = $row['MeetDate'];
                if (is_numeric($dateValue)) {
                    $unix_date = ($dateValue - 25569) * 86400;
                    $MeetDate = gmdate("Y-m-d", $unix_date);
                } else {
                    $MeetDate = date('Y-m-d', strtotime(str_replace('/', '-', $dateValue)));
                }
            }

            $insertData[] = [
                'fkBranch_id'       => $branch_id,
                'MeetDate'          => $MeetDate,
                'NoParent'          => $row['NoParent'] ?? '',
                'Institute_id'      => $Institute_id,
                'FiniYear'          => $finiYear_id,
                'created_by'=>$_SESSION['userID']
            ];
        }

        if (!empty($insertData)) {
            $this->db->insert_batch('parentmeet_master', $insertData);
            echo "success";
        } else {
            echo "no_data";
        }

        // Insert log - Action 4 (Excel)
 
        $action = 4;

        $record_id = null;

        $excel_name = $originalName;

        $Fk_branch = null;

        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);
 

    } catch (Exception $e) {
        log_message('error', 'Import Excel Save Error: ' . $e->getMessage());
        echo "Error: " . $e->getMessage();
    }
}
}
