<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Practiced extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Practiced_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Practiced_dash_view.php');
        $this->load->view('admin/footer_view');
    }
   
    public function index()
    {
        $data['alldata'] = $this->Practiced_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Practiced_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['facultydata'] = $this->Practiced_model->getFac();
        $data['studentdata'] = $this->Practiced_model->getstudent();
        $data['mainuserdata'] = $this->Practiced_model->getmainuser();
        $data['durationdata'] = $this->Practiced_model->getduration();
        $data['Platformtdata'] = $this->Practiced_model->getplatform();
        $data['gradedata'] = $this->Practiced_model->getgrade();
        $data['statusdata'] = $this->Practiced_model->getstatus();
        $data['yeardata'] = $this->Practiced_model->getyear();
         $data['activeYear'] = $this->Practiced_model->getActiveYear();
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Practiced_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function insertPracticed()
    {
        // Get all form data
        $fkmainuser_id = $this->input->post('fkmainuser_id');
        $fkPlatform_id = $this->input->post('fkPlatform_id');
        $fkduration_id = $this->input->post('fkduration_id');
        $Applicant_name = $this->input->post('Applicant_name');
        $Applicant_id = $this->input->post('Applicant_id');
        $Course_name = $this->input->post('Course_name');
        $Practice_prece = $this->input->post('Practice_prece');
        $fkGrade_id = $this->input->post('fkGrade_id');
       $finicial_Year = $this->input->post('finicial_Year');
        $fkStatus_id = $this->input->post('fkStatus_id');
        $StartDate = $this->input->post('StartDate');
        $EndDate = $this->input->post('EndDate');
$fk_submenuId = $this->input->post('fk_submenuId');

        // Handle file upload for Certificate & Photos
        $this->load->library('upload');
        $Certi_photo = '';
        
        if (!empty($_FILES['Certi_photo']['name'])) {
            $config['upload_path'] = './uploads/practiced/';
            $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
            $config['max_size'] = 5120; // 5MB
            $config['file_name'] = 'certi_' . time() . '_' . $_FILES['Certi_photo']['name'];
            
            // Create directory if it doesn't exist
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('Certi_photo')) {
                $upload_data = $this->upload->data();
                $Certi_photo = 'uploads/practiced/' . $upload_data['file_name'];
            }
        }

        // Prepare data array
        $fields = array(
            'fkmainuser_id' => $fkmainuser_id,
            'fkPlatform_id' => $fkPlatform_id,
            'fkduration_id' => $fkduration_id,
            'Applicant_name' => $Applicant_name,
            'Applicant_id' => $Applicant_id,
            'Course_name' => $Course_name,
            'Practice_prece' => $Practice_prece,
            'fkGrade_id' => $fkGrade_id,
             'finicial_Year' => $finicial_Year,
            'fkStatus_id' => $fkStatus_id,
            'StartDate' => $StartDate,
            'EndDate' => $EndDate,
            'Certi_photo' => $Certi_photo,
            'created_by'=>$_SESSION['userID']
        );

        // Get institute id (similar to your Guestlec controller)
        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        if ($institute) {
            $fields['institute'] = $institute->Institu_id;
        }

        // Insert data
        $result = $this->Practiced_model->insertdata($fields);
  
 
        // Insert log - Action 1 (Insert)

        $action = 1;

        $record_id = $result;

        $excel_name = null;

        $Fk_branch = null;

        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

        //  $sub_id = $this->db->insert_id();
 


        if ($result) {
            echo json_encode(['success' => true, 'message' => 'Data inserted successfully', 'data' => $fields]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to insert data']);
        }
    }

    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->Practiced_model->getbyid($id);
        $data['facultydata'] = $this->Practiced_model->getFac();
        $data['studentdata'] = $this->Practiced_model->getstudent();
        $data['mainuserdata'] = $this->Practiced_model->getmainuser();
        $data['durationdata'] = $this->Practiced_model->getduration();
        $data['Platformtdata'] = $this->Practiced_model->getplatform();
        $data['gradedata'] = $this->Practiced_model->getgrade();
        $data['statusdata'] = $this->Practiced_model->getstatus();
        $data['yeardata'] = $this->Practiced_model->getyear();
        $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Practiced_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function updatePracticed()
    {
        // Get all form data
        $Practiced_id = $this->input->post('Practiced_id');
        $fkmainuser_id = $this->input->post('fkmainuser_id');
        $fkPlatform_id = $this->input->post('fkPlatform_id');
        $fkduration_id = $this->input->post('fkduration_id');
        $Applicant_name = $this->input->post('Applicant_name');
        $Applicant_id = $this->input->post('Applicant_id');
        $Course_name = $this->input->post('Course_name');
        $Practice_prece = $this->input->post('Practice_prece');
        $fkGrade_id = $this->input->post('fkGrade_id');
        $finicial_Year = $this->input->post('finicial_Year');
        $fkStatus_id = $this->input->post('fkStatus_id');
        $StartDate = $this->input->post('StartDate');
        $EndDate = $this->input->post('EndDate');
$fk_submenuId = $this->input->post('fk_submenuId');

        // Get existing file
        $existing_Certi_photo = $this->input->post('hidden_Remuneration');
        $Certi_photo = $existing_Certi_photo;

        // Handle file upload
        $this->load->library('upload');
        
        if (!empty($_FILES['Certi_photo']['name'])) {
            $config['upload_path'] = './uploads/practiced/';
            $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
            $config['max_size'] = 5120;
            $config['file_name'] = 'certi_' . time() . '_' . $_FILES['Certi_photo']['name'];
            
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('Certi_photo')) {
                $upload_data = $this->upload->data();
                $Certi_photo = 'uploads/practiced/' . $upload_data['file_name'];
                
                // Delete old file if exists
                if (!empty($existing_Certi_photo) && file_exists(FCPATH . $existing_Certi_photo)) {
                    unlink(FCPATH . $existing_Certi_photo);
                }
            }
        }

        // Prepare data array
        $fields = array(
            'Practiced_id' => $Practiced_id,
            'fkmainuser_id' => $fkmainuser_id,
            'fkPlatform_id' => $fkPlatform_id,
            'fkduration_id' => $fkduration_id,
            'Applicant_name' => $Applicant_name,
            'Applicant_id' => $Applicant_id,
            'Course_name' => $Course_name,
            'Practice_prece' => $Practice_prece,
            'fkGrade_id' => $fkGrade_id,
             'finicial_Year' => $finicial_Year,
            'fkStatus_id' => $fkStatus_id,
            'StartDate' => $StartDate,
            'EndDate' => $EndDate,
            'Certi_photo' => $Certi_photo,
            'modified_by'=>$_SESSION['userID']
        );

        // Update data
        $result = $this->Practiced_model->update($fields);
// Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $Practiced_id;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

        if ($result) {
            echo json_encode(['success' => true, 'message' => 'Data updated successfully', 'data' => $fields]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update data']);
        }
    }

    // Helper function for file upload
    private function upload_document($field_name, $upload_path)
    {
        if (!empty($_FILES[$field_name]['name'])) {
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
            $config['max_size'] = 5120;
            $config['file_name'] = time() . '_' . $_FILES[$field_name]['name'];
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload($field_name)) {
                $upload_data = $this->upload->data();
                return $upload_data['file_name'];
            }
        }
        return null;
    }
}
?>