<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Proctor extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Proctor_model');
              $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    public function index()
    {
        $data['alldata'] = $this->Proctor_model->getdetailview();
        $this->load->view('admin//header_view');
        $this->load->view('admin/Proctor_detailview', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['yeardata'] = $this->Proctor_model->getyear();

        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Proctor_view', $data);
        $this->load->view('admin/footer_view');
    }
    
    
    public function dashboard()
    {
        // $data['yeardata'] = $this->Proctor_model->getyear();
        $this->load->view('admin/header_view');
        $this->load->view('admin/Proctor_dash_view');
        $this->load->view('admin/footer_view');
    }
    
public function insertProctor()
{
    // ✅ Load dependencies
    $this->load->library('upload');
    $this->load->helper(['form', 'url']);
    $this->load->database();

    // ============================================================
    // ✅ STEP 1: Save Excel file info (Excel or Manual Entry)
    // ============================================================
    if (!empty($_FILES['activity_excel']['name'])) {
        // Case 1: Excel file uploaded
        $excel_name = $_FILES['activity_excel']['name'];

        $excelData = [
            'ExcelName'   => $excel_name,
            'entry_type'  => 'excel'
        ];
        $this->db->insert('proctor_excel', $excelData);
        $excel_id = $this->db->insert_id();

    } else {
        // Case 2: Manual entry → Always create a NEW record
        $excelData = [
            'ExcelName'   => 'Manual Entry_' . date('Ymd_His'), // Unique name
            'entry_type'  => 'manual'
        ];
        $this->db->insert('proctor_excel', $excelData);
        $excel_id = $this->db->insert_id();
    }

    // ============================================================
    // ✅ STEP 2: Fetch POST Data
    // ============================================================
    $Year            = $this->input->post('Year');
    $Branch          = $this->input->post('Branch');
        $Class           = $this->input->post('Class');
        $fk_sem           = $this->input->post('fk_sem');
    $Proctor_Batch   = $this->input->post('Proctor_Batch');
    $Fac_Name        = $this->input->post('Fac_Name');
    $Fac_No          = $this->input->post('Fac_No');
    $Pro_id          = $this->input->post('Pro_id');
    $existing_report = $this->input->post('existing_report');
    $fk_submenuId = $this->input->post('fk_submenuId');

    // ============================================================
    // ✅ STEP 3: Upload Report PDFs
    // ============================================================
    $report_pdf_paths = [];
    if (!empty($_FILES['Pdf']['name'])) {
        foreach ($_FILES['Pdf']['name'] as $key => $pdf_name) {
            if (!empty($pdf_name)) {
                $_FILES['proctor_report']['name']     = $_FILES['Pdf']['name'][$key];
                $_FILES['proctor_report']['type']     = $_FILES['Pdf']['type'][$key];
                $_FILES['proctor_report']['tmp_name'] = $_FILES['Pdf']['tmp_name'][$key];
                $_FILES['proctor_report']['error']    = $_FILES['Pdf']['error'][$key];
                $_FILES['proctor_report']['size']     = $_FILES['Pdf']['size'][$key];

                $config['upload_path']   = './uploads/Proctor_pdf/';
                            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx';
                $config['max_size']      = 5120; // 5MB
                $config['file_name']     = uniqid() . '_' . $pdf_name;

                if (!is_dir($config['upload_path'])) {
                    @mkdir($config['upload_path'], 0777, TRUE);
                }

                $this->upload->initialize($config);

                if ($this->upload->do_upload('proctor_report')) {
                    $uploadData = $this->upload->data();
                    $report_pdf_paths[$key] = '/uploads/Proctor_pdf/' . $uploadData['file_name'];
                } else {
                    // Upload failed → retain old file if any
                    $report_pdf_paths[$key] = $existing_report[$key] ?? null;
                }
            } else {
                $report_pdf_paths[$key] = $existing_report[$key] ?? null;
            }
        }
    }

    // ============================================================
    // ✅ STEP 4: Save Proctor Data
    // ============================================================
    if (!empty($Branch)) {
        foreach ($Branch as $i => $branchName) {
            if (trim($branchName) == '') continue;

            $proctorData = [
                'Financial_Year'  => $Year[$i] ?? null,
                'Branch'          => $branchName,
                      'Class'           => $Class[$i] ?? null, 
                      'fk_sem'           => $fk_sem[$i] ?? null,
                'Pro_Batch'       => $Proctor_Batch[$i] ?? null,
                'Fac_Name'        => $Fac_Name[$i] ?? null,
                'Fac_No'          => $Fac_No[$i] ?? null,
                'Pdf'             => $report_pdf_paths[$i] ?? null,
                'excel_upload_id' => $excel_id,
                'created_by'=>$_SESSION['userID']
            ];

            if (!empty($Pro_id[$i])) {
                $this->db->where('Pro_id', $Pro_id[$i]);
                $this->db->update('proctor_master', $proctorData);
            } else {
                $this->db->insert('proctor_master', $proctorData);
            }
        }
    }

        // ============================================================
    // ✅ STEP 5: Insert Log (Action = Insert)
    // ============================================================

    $action     = 1;            // Insert
    $record_id  = $excel_id;    // Parent record for this insert
    $excel_name = null;
    $Fk_branch  = null; // optional, safe fallback

    insert_log(
        $this,
        $fk_submenuId,
        $action,
        $record_id,
        $excel_name,
        $Fk_branch,
        $_SESSION['userID']
    );

    // ============================================================
    // ✅ STEP 6: Success Response
    // ============================================================
    echo json_encode([
        'status'  => 'success',
        'message' => 'Proctor data saved successfully!'
    ]);
}

   
public function update()
{
    $id = $this->uri->segment(4); // This is the Excel Upload ID
    
    // ✅ Get Excel upload record (parent)
    $data['data'] = $this->Proctor_model->getExcelById($id);
    
    // ✅ Get child records (Proctor activities) for this excel upload
    $data['childData'] = $this->Proctor_model->getChildByMainId($id);
    
    // Get year data for dropdown
    $data['yeardata'] = $this->Proctor_model->getyear();


    $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
    $this->load->view('admin/Proctor_view', $data);
    $this->load->view('admin/footer_view');
}

// ✅ Add this method to handle deletion of child records before updating
public function deleteChildRecords($excel_id)
{
    $this->db->where('excel_upload_id', $excel_id);
    return $this->db->delete('proctor_master');
}

 public function updateProctor()
{
    // ✅ Load dependencies
    $this->load->library('upload');
    $this->load->helper(['form', 'url']);
    $this->load->database();

    // ✅ Get the Excel ID being updated
    $excel_id = $this->input->post('excel_id');

    // ============================================================
    // ✅ STEP 1: Handle Excel or Manual Entry Reference
    // ============================================================
    if (!empty($_FILES['activity_excel']['name'])) {
        // Case 1: New Excel uploaded - create new Excel record
        $excel_name = $_FILES['activity_excel']['name'];

        $excelData = [
            'ExcelName'    => $excel_name,
            'entry_type'   => 'excel'
        ];
        $this->db->insert('proctor_excel', $excelData);
        $new_excel_id = $this->db->insert_id();
        
        // Delete old child records linked to old excel_id
        if ($excel_id) {
            $this->Proctor_model->deleteChildRecords($excel_id);
        }
        
        $excel_id = $new_excel_id;
    } else {
        // Case 2: No new Excel - keep using existing excel_id
        if (!$excel_id) {
            // Fallback to Manual Entry if no excel_id
            $this->db->where('ExcelName', 'Manual Entry');
            $query = $this->db->get('proctor_excel');

            if ($query->num_rows() > 0) {
                $excel_id = $query->row()->ID;
            } else {
                $excelData = [
                    'ExcelName'    => 'Manual Entry',
                    'entry_type'   => 'manual'
                ];
                $this->db->insert('proctor_excel', $excelData);
                $excel_id = $this->db->insert_id();
            }
        }
    }

    // ============================================================
    // ✅ STEP 2: Collect Posted Proctor Data
    // ============================================================
    $Year            = $this->input->post('Year');
    $Branch          = $this->input->post('Branch');
        $Class           = $this->input->post('Class');
        $fk_sem           = $this->input->post('fk_sem');
    $Proctor_Batch   = $this->input->post('Proctor_Batch');
    $Fac_Name        = $this->input->post('Fac_Name');
    $Fac_No          = $this->input->post('Fac_No');
    $Pro_id          = $this->input->post('Pro_id');
    $existing_report = $this->input->post('existing_report');
    $fk_submenuId = $this->input->post('fk_submenuId');

    // ============================================================
    // ✅ NEW: Get existing Pro_ids from database for this excel_id
    // ============================================================
    $existing_pro_ids = [];
    $this->db->select('Pro_id');
    $this->db->where('excel_upload_id', $excel_id);
    $existing_records = $this->db->get('proctor_master')->result();
    foreach ($existing_records as $record) {
        $existing_pro_ids[] = $record->Pro_id;
    }

    // ✅ Collect Pro_ids from the form submission (handle null case)
    $submitted_pro_ids = [];
    if (!empty($Pro_id) && is_array($Pro_id)) {
        $submitted_pro_ids = array_filter($Pro_id); // Remove empty values
    }

    // ✅ Find Pro_ids that need to be deleted (exist in DB but not in form)
    $pro_ids_to_delete = array_diff($existing_pro_ids, $submitted_pro_ids);

    // ✅ Delete removed records
    if (!empty($pro_ids_to_delete)) {
        $this->db->where_in('Pro_id', $pro_ids_to_delete);
        $this->db->delete('proctor_master');
    }

    // ============================================================
    // ✅ STEP 3: Handle Report PDF Uploads
    // ============================================================
    $report_pdf_paths = [];
    if (!empty($_FILES['Pdf']['name'])) {
        foreach ($_FILES['Pdf']['name'] as $key => $pdf_name) {
            if (!empty($pdf_name)) {
                $_FILES['proctor_report']['name']     = $_FILES['Pdf']['name'][$key];
                $_FILES['proctor_report']['type']     = $_FILES['Pdf']['type'][$key];
                $_FILES['proctor_report']['tmp_name'] = $_FILES['Pdf']['tmp_name'][$key];
                $_FILES['proctor_report']['error']    = $_FILES['Pdf']['error'][$key];
                $_FILES['proctor_report']['size']     = $_FILES['Pdf']['size'][$key];

                $config['upload_path']   = './uploads/Proctor_pdf/';
                $config['allowed_types'] = 'pdf';
                $config['max_size']      = 5120;
                $config['file_name']     = uniqid() . '_' . $pdf_name;
                $config['encrypt_name']  = FALSE;

                if (!is_dir($config['upload_path'])) {
                    @mkdir($config['upload_path'], 0777, TRUE);
                }

                $this->upload->initialize($config);

                if ($this->upload->do_upload('proctor_report')) {
                    $uploadData = $this->upload->data();
                    $report_pdf_paths[$key] = '/uploads/Proctor_pdf/' . $uploadData['file_name'];
                } else {
                    $report_pdf_paths[$key] = isset($existing_report[$key]) ? $existing_report[$key] : null;
                }
            } else {
                $report_pdf_paths[$key] = isset($existing_report[$key]) ? $existing_report[$key] : null;
            }
        }
    }

    // ============================================================
    // ✅ STEP 4: Update Proctor Master Records
    // ============================================================
    if (!empty($Branch)) {
        foreach ($Branch as $i => $branchName) {
            if (trim($branchName) == '') continue;

            $proctorData = [
                'Financial_Year'  => $Year[$i] ?? null,
                'Branch'          => $branchName,
                      'Class'           => $Class[$i] ?? null,  
                      'fk_sem'           => $fk_sem[$i] ?? null,
                'Pro_Batch'       => $Proctor_Batch[$i] ?? null,
                'Fac_Name'        => $Fac_Name[$i] ?? null,
                'Fac_No'          => $Fac_No[$i] ?? null,
                'Pdf'             => $report_pdf_paths[$i] ?? null,
                'excel_upload_id' => $excel_id,
                'modified_by'=>$_SESSION['userID']
            ];

            if (!empty($Pro_id[$i])) {
                // ✅ Update existing record
                $this->db->where('Pro_id', $Pro_id[$i]);
                $this->db->update('proctor_master', $proctorData);
            } else {
                // ✅ Insert new record
                $this->db->insert('proctor_master', $proctorData);
            }
        }
    }

       // ============================================================
    // ✅ STEP 5: Insert Update Log (ONLY ONCE)
    // ============================================================

    $action     = 2;            // Update
    $record_id  = $excel_id;    // Use excel_id as the parent reference
    $excel_name = null;
    $Fk_branch  = $Branch[0] ?? null; // optional / safe

    insert_log(
        $this,
        $fk_submenuId,
        $action,
        $record_id,
        $excel_name,
        $Fk_branch,
        $_SESSION['userID']
    );

    // ============================================================
    // ✅ STEP 6: Return Success Response
    // ============================================================
    echo json_encode([
        'status'  => 'success',
        'message' => 'Proctor record updated successfully!'
    ]);

}


    public function Report()
{
    // Get distinct branches and years from proctor_master table
    $data['branchdata'] = $this->Proctor_model->getDistinctBranches();
    $data['yeardata'] = $this->Proctor_model->getDistinctYears();
    $data['institutedata'] = $this->Proctor_model->get_all_institute();
    
    // Get active year
    $activeYear = $this->db
        ->select('finiYear_id')
        ->from('finiyear_master')
        ->where('Active_Deactive', 1)
        ->get()
        ->row();
    
    $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
    
    $this->load->view('admin/header_view');
    $this->load->view('admin/ProctorReport', $data);
    $this->load->view('admin/footer_view');
}

// Get filtered proctor data for table
public function getFilteredData()
{
    $branches = $this->input->post('branches'); // Now receives array
    $years = $this->input->post('years');       // Now receives array
    
    // Ensure they are arrays (handle empty selections)
    $branches = is_array($branches) ? $branches : [];
    $years = is_array($years) ? $years : [];
    
    // Pass arrays to model
    $data = $this->Proctor_model->getFilteredProctorData($branches, $years);
    
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'success',
        'data' => $data
    ]);
    exit;
}

// Get combined chart data
public function getChartData()
{
    $branches = $this->input->post('branches'); // Array
    $years = $this->input->post('years');       // Array
    
    $data = $this->Proctor_model->getProctorCombinedData($branches, $years);
    
    echo json_encode([
        'status' => 'success',
        'branchData' => $data['branchData'],
        'yearData' => $data['yearData']
    ]);
}

// Get branch details when clicked
public function getBranchDetails()
{
    $branches = $this->input->post('branches'); // Array
    $years = $this->input->post('years');       // Array
    
    $data = $this->Proctor_model->getProctorBranchDetails($branches, $years);
    
    echo json_encode([
        'status' => 'success',
        'data' => $data
    ]);
}

// Get year details when clicked
public function getYearDetails()
{
    $years = $this->input->post('years');       // Array
    $branches = $this->input->post('branches'); // Array
    
    $data = $this->Proctor_model->getProctorYearDetails($years, $branches);
    
    echo json_encode([
        'status' => 'success',
        'data' => $data
    ]);
}

public function showDataByInstitute()
{
    $institute_id = $this->input->post('InstituteId');
    $startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');
    $branches     = $this->input->post('fkbranch_id');   // ✅ array from multi-select

    $data = $this->ParentMeet_model->getDataByInstitute(
        $institute_id,
        $startdate,
        $enddate,
        $branches
    );

    echo json_encode($data);
}


public function getPrintHeadings()
{
    $data = $this->Proctor_model->getPrintHeadings();
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

  

public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // may be an array
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');

    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->ParentMeet_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year — pass all filters
        $summary = $this->ParentMeet_model->getSingleYearData($year, $institu, $branches, $startDate, $endDate);
        $types   = $this->ParentMeet_model->getYearwiseTypes($year, $institu, $branches, $startDate, $endDate);
    }

    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}

 
public function getProctorDataByFilters($institute_id, $branches = [], $years = [], $startdate = null, $enddate = null)
{
    $this->db->select('proctor_master.*, 
                       finiyear_master.fini_Label as year_label');
    $this->db->from('proctor_master');
    $this->db->join('finiyear_master', 'proctor_master.Financial_Year = finiyear_master.finiYear_id', 'left');

    // Filter by branch names (text values stored in Branch column)
    if (!empty($branches)) {
        // Get branch names from branch_master using branch_ids
        $this->db->select('branch_name');
        $this->db->from('branch_master');
        $this->db->where_in('branch_id', $branches);
        $branchQuery = $this->db->get();
        $branchNames = array_column($branchQuery->result_array(), 'branch_name');
        
        if (!empty($branchNames)) {
            $this->db->where_in('proctor_master.Branch', $branchNames);
        }
    }

    // Filter by years
    if (!empty($years) && $years != '0') {
        if (is_array($years)) {
            $this->db->where_in('proctor_master.Financial_Year', $years);
        } else {
            $this->db->where('proctor_master.Financial_Year', $years);
        }
    }

    // Filter by date range if provided
    if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('proctor_master.created_at >=', $startdate);
        $this->db->where('proctor_master.created_at <=', $enddate);
    }

    $this->db->order_by('proctor_master.Pro_id', 'DESC');
    $query = $this->db->get();
    return $query->result();
}

public function getProctorBranchwiseCount($branches = [], $years = [])
{
    $this->db->select('proctor_master.Branch as branch_name, 
                       COUNT(proctor_master.Pro_id) as count');
    $this->db->from('proctor_master');
    
    // Filter by branch names
    if (!empty($branches)) {
        // Get branch names from branch_ids
        $this->db->select('branch_name');
        $this->db->from('branch_master');
        $this->db->where_in('branch_id', $branches);
        $branchQuery = $this->db->get();
        $branchNames = array_column($branchQuery->result_array(), 'branch_name');
        
        $this->db->reset_query();
        $this->db->select('proctor_master.Branch as branch_name, 
                           COUNT(proctor_master.Pro_id) as count');
        $this->db->from('proctor_master');
        
        if (!empty($branchNames)) {
            $this->db->where_in('proctor_master.Branch', $branchNames);
        }
    }
    
    if (!empty($years)) {
        $this->db->where_in('proctor_master.Financial_Year', $years);
    }
    
    $this->db->group_by('proctor_master.Branch');
    $this->db->order_by('proctor_master.Branch', 'ASC');
    
    return $this->db->get()->result();
}

public function getProctorYearwiseCount($branches = [], $years = [])
{
    $this->db->select('finiyear_master.finiYear_id as year_id, 
                       finiyear_master.fini_Label as year, 
                       COUNT(proctor_master.Pro_id) as count');
    $this->db->from('proctor_master');
    $this->db->join('finiyear_master', 'proctor_master.Financial_Year = finiyear_master.finiYear_id', 'left');
    
    if (!empty($branches)) {
        // Get branch names from branch_ids
        $this->db->select('branch_name');
        $this->db->from('branch_master');
        $this->db->where_in('branch_id', $branches);
        $branchQuery = $this->db->get();
        $branchNames = array_column($branchQuery->result_array(), 'branch_name');
        
        $this->db->reset_query();
        $this->db->select('finiyear_master.finiYear_id as year_id, 
                           finiyear_master.fini_Label as year, 
                           COUNT(proctor_master.Pro_id) as count');
        $this->db->from('proctor_master');
        $this->db->join('finiyear_master', 'proctor_master.Financial_Year = finiyear_master.finiYear_id', 'left');
        
        if (!empty($branchNames)) {
            $this->db->where_in('proctor_master.Branch', $branchNames);
        }
    }
    
    if (!empty($years)) {
        $this->db->where_in('proctor_master.Financial_Year', $years);
    }
    
    $this->db->group_by('finiyear_master.finiYear_id, finiyear_master.fini_Label');
    $this->db->order_by('finiyear_master.finiYear_id', 'ASC');
    
    return $this->db->get()->result();
}
public function getProctorBranchDetails()
{
    $branch_name = $this->input->post('branch_name'); // Now expects branch name directly
    $years = $this->input->post('years');
    
    $years = is_array($years) ? $years : [];
    
    $data = $this->Proctor_model->getProctorBranchDetails([$branch_name], $years);
    
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

public function getProctorYearDetails()
{
    $year_id = $this->input->post('year_id');
    $branches = $this->input->post('branches');
    
    $branches = is_array($branches) ? $branches : [];
    
    $data = $this->Proctor_model->getProctorYearDetails([$year_id], $branches);
    
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}


public function getProctorCombinedData()
{
    $branches = $this->input->post('branches'); // Array from multi-select
    $years = $this->input->post('years');       // Array from multi-select
    
    // Ensure arrays
    $branches = is_array($branches) ? $branches : [];
    $years = is_array($years) ? $years : [];
    
    $data = $this->Proctor_model->getProctorCombinedData($branches, $years);
    
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'success',
        'branchData' => $data['branchData'],
        'yearData' => $data['yearData']
    ]);
    exit;
}



}