<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Question extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Question_model');

        if (empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
        }
    }

    // ==================== PAGE LOAD FUNCTIONS ====================

    // List page
    public function index()
    {
        $data['alldata'] = $this->Question_model->getAllQuestions();

        $this->load->view('admin/header_view');
        $this->load->view('admin/Question_detailview', $data);
        $this->load->view('admin/footer_view');
    }

    // Create (Add new) page
    public function create()
    {
        $data['feedbackdata']   = $this->Question_model->getFeedbackFor();
        $data['answertypedata'] = $this->Question_model->getAnswerType();

        $this->load->view('admin/header_view');
        $this->load->view('admin/Question_view', $data);
        $this->load->view('admin/footer_view');
    }

    // Edit (Update) page
    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->Question_model->getbyid($id);

        $data['feedbackdata']   = $this->Question_model->getFeedbackFor();
        $data['answertypedata'] = $this->Question_model->getAnswerType();

        $this->load->view('admin/header_view');
        $this->load->view('admin/Question_view', $data);
        $this->load->view('admin/footer_view');
    }

    // ==================== INSERT ====================

    public function insertQuestion()
    {
        $questionName    = trim($this->input->post('question_name'));
        $feedbackId      = $this->input->post('feedbackid');
        $answerOrText    = $this->input->post('isanswerortext');
        $isDefault       = $this->input->post('is_default');
        $isOn            = $this->input->post('is_on');
        $isActive        = $this->input->post('is_active');
        
        // Validate
        if (!$questionName || !$feedbackId || !$answerOrText) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Question Name, Feedback For, and Answer Type are required'
            ));
            return;
        }
        
  
        
        $data = array(
            'question_name'  => $questionName,
            'feedbackid'     => $feedbackId,
            'isanswerortext' => $answerOrText,
            'is_active'      => 1
        );
        
        $result = $this->Question_model->insertQuestion($data);
        
        if ($result['status']) {
            echo json_encode(array(
                'status'  => true,
                'message' => 'Question added successfully',
                'id'      => $result['question_id']
            ));
        } else {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Failed to add question'
            ));
        }
    }

    // ==================== UPDATE ====================

    public function updateQuestion()
    {
        $questionId      = $this->input->post('questionid');
        $questionName    = trim($this->input->post('question_name'));
        $feedbackId      = $this->input->post('feedbackid');
        $answerOrText    = $this->input->post('isanswerortext');
        $isDefault       = $this->input->post('is_default');
        $isOn            = $this->input->post('is_on');
        $isActive        = $this->input->post('is_active');
        
        if (empty($questionId)) {
            echo json_encode(['status' => false, 'message' => 'Invalid ID']);
            return;
        }

        // Validate
        if (!$questionName || !$feedbackId || !$answerOrText) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Question Name, Feedback For, and Answer Type are required'
            ));
            return;
        }
        
   

        $data = array(
            'question_name'  => $questionName,
            'feedbackid'     => $feedbackId,
            'isanswerortext' => $answerOrText,
            'is_active'      =>  1 
        );
        
        $result = $this->Question_model->updateQuestion($questionId, $data);
        
        if ($result) {
            echo json_encode(['status' => true, 'message' => 'Question updated successfully']);
        } else {
            echo json_encode(['status' => false, 'message' => 'Failed to update question']);
        }
    }

    // ==================== TOGGLE ACTIVE STATUS ====================

    public function toggleActiveStatus()
    {
        $questionid = $this->input->post('questionid');
        $is_active  = $this->input->post('is_active');
        
        if (!isset($questionid)) {
            echo json_encode(array(
                'status'  => false,
                'message' => 'ID is required'
            ));
            return;
        }
        
        $result = $this->Question_model->toggleActiveStatus($questionid, $is_active);
        
        if ($result) {
            echo json_encode(array(
                'status'  => true,
                'message' => 'Status updated successfully'
            ));
        } else {
            echo json_encode(array(
                'status'  => false,
                'message' => 'Failed to update status'
            ));
        }
    }
}
?>