<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Report_Patent extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Report_Patent_model');
        if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
        }
    }

    public function Report()
    {
        $data['yeardata'] = $this->Report_Patent_model->getyear();
        $data['branchdata'] = $this->Report_Patent_model->getbranch();
        
        // Get active year if needed
        $activeYear = $this->db
            ->select('finiYear_id')
            ->from('finiyear_master')
            ->where('Active_Deactive', 1)
            ->get()
            ->row();
     
        $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;

        $this->load->view('admin/header_view');
        $this->load->view('admin/Report_Patent_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    // Method to get year-wise count
    public function getYearWiseCount()
    {
        $institu_id = $this->input->post('fk_institu');
        $branch_ids = $this->input->post('fkbranch_id'); // This is already array
        $year = $this->input->post('year'); // This is array from multiple select
        
        // Clean up year data - remove null, empty, or "0" values
        if (is_array($year)) {
            $year = array_filter($year, function($val) {
                return !empty($val) && $val != "0";
            });
            // If array is now empty, set to null
            if (empty($year)) {
                $year = null;
            }
        } else if ($year == "0" || $year == "") {
            $year = null;
        }
        
        // Clean up branch data
        if (is_array($branch_ids)) {
            $branch_ids = array_filter($branch_ids, function($val) {
                return !empty($val) && $val != "0";
            });
            if (empty($branch_ids)) {
                $branch_ids = null;
            }
        } else if ($branch_ids == "0" || $branch_ids == "") {
            $branch_ids = null;
        }
        
        // Debug log (optional - remove in production)
        log_message('debug', 'Year data after cleanup: ' . print_r($year, true));
        log_message('debug', 'Branch data after cleanup: ' . print_r($branch_ids, true));
        
        $result = $this->Report_Patent_model->getYearWisePatentCount($institu_id, $branch_ids, $year);
        echo json_encode($result);
    }

    // Method to get detailed patent data
    public function getPatentData()
    {
        $institu_id = $this->input->post('fk_institu');
        $branch_ids = $this->input->post('fkbranch_id'); // Array
        $year = $this->input->post('year'); // Array from multiple select
        $specific_year = $this->input->post('specific_year'); // Single value when clicking year
        $startdate = $this->input->post('startdate');
        $enddate = $this->input->post('enddate');

        // Clean up year data
        if (is_array($year)) {
            $year = array_filter($year, function($val) {
                return !empty($val) && $val != "0";
            });
            if (empty($year)) {
                $year = null;
            }
        } else if ($year == "0" || $year == "") {
            $year = null;
        }
        
        // Clean up branch data
        if (is_array($branch_ids)) {
            $branch_ids = array_filter($branch_ids, function($val) {
                return !empty($val) && $val != "0";
            });
            if (empty($branch_ids)) {
                $branch_ids = null;
            }
        } else if ($branch_ids == "0" || $branch_ids == "") {
            $branch_ids = null;
        }

        // Debug log (optional - remove in production)
        log_message('debug', 'Specific Year: ' . $specific_year);
        log_message('debug', 'Year filter after cleanup: ' . print_r($year, true));

        $result = $this->Report_Patent_model->getPatenttDataFiltered(
            $institu_id, 
            $branch_ids, 
            $year, 
            $startdate, 
            $enddate,
            $specific_year
        );
        
        echo json_encode($result);
    }

    public function getPrintHeadings()
    {
        $result = $this->Report_Patent_model->getPrintHeadings();
        echo json_encode($result);
    }
}