<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Si_Report1 extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Si_Report1_model');
        if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
        }
    }

    public function Report()
    {
        $data['yeardata'] = $this->Si_Report1_model->getyear();
        $data['branchdata'] = $this->Si_Report1_model->getbranch();
        
        // Get active year if needed
        $activeYear = $this->db
            ->select('finiYear_id')
            ->from('finiyear_master')
            ->where('Active_Deactive', 1)
            ->get()
            ->row();
     
        $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;

        $this->load->view('admin/header_view');
        $this->load->view('admin/Si_Report1_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    // Method to get year-wise count
   // Method to get year-wise count
public function getYearWiseCount()
{
    $institu_id = $this->input->post('fk_institu');
    $branch_ids = $this->input->post('fkbranch_id');
    $year = $this->input->post('year');
    
    // Clean up year data
    if (is_array($year)) {
        $year = array_filter($year, function($val) {
            return !empty($val) && $val != "0" && $val !== "";
        });
        $year = array_values($year);
        if (empty($year)) {
            $year = null;
        }
    } else if ($year == "0" || $year == "" || $year === null) {
        $year = null;
    }
    
    // Clean up branch data
    if (is_array($branch_ids)) {
        $branch_ids = array_filter($branch_ids, function($val) {
            return !empty($val) && $val != "0" && $val !== "";
        });
        $branch_ids = array_values($branch_ids);
        if (empty($branch_ids)) {
            $branch_ids = null;
        }
    } else if ($branch_ids == "0" || $branch_ids == "" || $branch_ids === null) {
        $branch_ids = null;
    }
    
    $result = $this->Si_Report1_model->getYearWisePatentCount($institu_id, $branch_ids, $year);
    echo json_encode($result);
}

// Method to get detailed patent data
public function getPatentData()
{
    $institu_id = $this->input->post('fk_institu');
    $branch_ids = $this->input->post('fkbranch_id');
    $year = $this->input->post('year');
    $specific_year_id = $this->input->post('specific_year_id'); // Financial Year ID

    // Clean up year data
    if (is_array($year)) {
        $year = array_filter($year, function($val) {
            return !empty($val) && $val != "0" && $val !== "";
        });
        $year = array_values($year);
        if (empty($year)) {
            $year = null;
        }
    } else if ($year == "0" || $year == "" || $year === null) {
        $year = null;
    }
    
    // Clean up branch data
    if (is_array($branch_ids)) {
        $branch_ids = array_filter($branch_ids, function($val) {
            return !empty($val) && $val != "0" && $val !== "";
        });
        $branch_ids = array_values($branch_ids);
        if (empty($branch_ids)) {
            $branch_ids = null;
        }
    } else if ($branch_ids == "0" || $branch_ids == "" || $branch_ids === null) {
        $branch_ids = null;
    }

    $result = $this->Si_Report1_model->getPatenttDataFiltered(
        $institu_id, 
        $branch_ids, 
        $year, 
        $specific_year_id
    );
    
    echo json_encode($result);
}
    public function getPrintHeadings()
    {
        $result = $this->Si_Report1_model->getPrintHeadings();
        echo json_encode($result);
    }
}