<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Soft_report extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Soft_report_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }


   
   
    public function create()
	{
  $data['branchdata'] = $this->Soft_report_model->getbranch();
 $data['duratdata'] = $this->Soft_report_model->getduration();
  $data['institutedata'] = $this->Soft_report_model->getinstitu();
    
$data['yeardata'] = $this->Soft_report_model->getyear();


$activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();

$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        //  echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
		$this->load->view('admin/Soft_report_view',$data);
		$this->load->view('admin/footer_view');
	

	}



public function showDataByInstitute()
{
    $institute_id = $this->input->post('fk_institu');
    $branch_ids = $this->input->post('fkbranch_id'); 
    $duration_ids = $this->input->post('fk_duration');
    $year = $this->input->post('year');
$startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');
  $licence_withlicence = $this->input->post('licence_withlicence'); 

    $data = $this->Soft_report_model->getDataByInstitute(
        $institute_id,
        $year,
        $branch_ids,
        $duration_ids,
         $startdate,
        $enddate,
        $licence_withlicence
    );

    echo json_encode($data);
}

// for print
public function getPrintHeadings()
{
    $data = $this->Soft_report_model->getPrintHeadings();
    echo json_encode($data);
}


// year and branch chart
 
 
// public function getYearwiseData()
// {
//     $year = $this->input->post('year');
 
//     if ($year == "0" || empty($year)) {
//         // All years
//         $summary = $this->Soft_report_model->getAllYearsData();
//         $types   = [];
//     } else {
//         // Single year
//         $summary = $this->Soft_report_model->getSingleYearData($year);
//         $types   = $this->Soft_report_model->getYearwiseTypes($year);
//     }
 
//     echo json_encode([
//         "status"  => "success",
//         "summary" => $summary,
//         "types"   => $types
//     ]);
// }

 public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $branches  = $this->input->post('branches');   // may be an array
    
 
    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->Soft_report_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year — pass all filters
        $summary = $this->Soft_report_model->getSingleYearData($year, $branches);
        $types   = $this->Soft_report_model->getYearwiseTypes($year,$branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkBranchName_id'); // match JS
    $year      = $this->input->post('year');
   
 
    $result = $this->Soft_report_model->getBranchwiseCount($institu, $branches, $year);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkBranchName_id'); // match JS
    $year      = $this->input->post('year');
   
    $result = $this->Soft_report_model->getBranchDetailsData($branch_id, $institu, $year);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
  
    $result = $this->Soft_report_model->getCombinedData($institu, $branches, $years);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}
 


}
