<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sttp_Fdp_report extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Sttp_Fdp_report_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }


   
   
    public function create()
	{
  $data['branchdata'] = $this->Sttp_Fdp_report_model->getbranch();
 $data['duratdata'] = $this->Sttp_Fdp_report_model->getduration();
  $data['institutedata'] = $this->Sttp_Fdp_report_model->getinstitu();
    $data['typedata'] = $this->Sttp_Fdp_report_model->gettype();
$data['yeardata'] = $this->Sttp_Fdp_report_model->getyear();
$data['formtypes'] = $this->Sttp_Fdp_report_model->getFormTypes();


$activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();

$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        //  echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
		$this->load->view('admin/Sttp_Fdp_report_view',$data);
		$this->load->view('admin/footer_view');
	

	}



public function showDataByInstitute()
{
    $institute_id = $this->input->post('fk_institu');
    $branch_ids = $this->input->post('fkbranch_id'); 
    $duration_ids = $this->input->post('fk_duration');
    $year = $this->input->post('year');
$startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');
  $typeIDs = $this->input->post('fk_typest'); 
$form_type = $this->input->post('form_type');

    $data = $this->Sttp_Fdp_report_model->getDataByInstitute(
        $institute_id,
        $year,
        $branch_ids,
        $duration_ids,
        $typeIDs,
         $startdate,
        $enddate,
        $form_type 
        
    );

    echo json_encode($data);
}

// for print
public function getPrintHeadings()
{
    $data = $this->Sttp_Fdp_report_model->getPrintHeadings();
    echo json_encode($data);
}


// year and branch chart
 
 public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $branches  = $this->input->post('branches');
    $form_type = $this->input->post('form_type');
 
    if ($year == "0" || empty($year)) {
        $summary = $this->Sttp_Fdp_report_model->getAllYearsData($form_type);
        $types   = [];
    } else {
        $summary = $this->Sttp_Fdp_report_model->getSingleYearData($year, $branches, $form_type);
        $types   = $this->Sttp_Fdp_report_model->getYearwiseTypes($year, $branches, $form_type);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}

public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');
    $year      = $this->input->post('year');
    $form_type = $this->input->post('form_type');
 
    $result = $this->Sttp_Fdp_report_model->getBranchwiseCount($institu, $branches, $year, $form_type);
    echo json_encode($result);
}

public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id');
    $institu   = $this->input->post('fk_institu');
    $year      = $this->input->post('year');
    $form_type = $this->input->post('form_type');
    
    $result = $this->Sttp_Fdp_report_model->getBranchDetailsData($branch_id, $institu, $year, $form_type);
    echo json_encode($result);
}

public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');
    $years     = $this->input->post('years');
    $form_type = $this->input->post('form_type');
  
    $result = $this->Sttp_Fdp_report_model->getCombinedData($institu, $branches, $years, $form_type);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}


//  public function getYearwiseData()
// {
//     $year      = $this->input->post('year');
//     $branches  = $this->input->post('branches');   // may be an array
    
 
//     if ($year == "0" || empty($year)) {
//         // All years
//         $summary = $this->Sttp_Fdp_report_model->getAllYearsData();
//         $types   = [];
//     } else {
//         // Single year — pass all filters
//         $summary = $this->Sttp_Fdp_report_model->getSingleYearData($year, $branches);
//         $types   = $this->Sttp_Fdp_report_model->getYearwiseTypes($year,$branches);
//     }
 
//     echo json_encode([
//         "status"  => "success",
//         "summary" => $summary,
//         "types"   => $types
//     ]);
// }
 
 
 
// // Add these methods to your VAPReport controller
 
// public function getBranchwiseData()
// {
//     $institu   = $this->input->post('fk_institu'); // match JS
//     $branches  = $this->input->post('fkBranchName_id'); // match JS
//     $year      = $this->input->post('year');
   
 
//     $result = $this->Sttp_Fdp_report_model->getBranchwiseCount($institu, $branches, $year);
//     echo json_encode($result);
// }
 
// public function getBranchDetails()
// {
//     $branch_id = $this->input->post('branch_id'); // correct
//     $institu   = $this->input->post('fkBranchName_id'); // match JS
//     $year      = $this->input->post('year');
   
//     $result = $this->Sttp_Fdp_report_model->getBranchDetailsData($branch_id, $institu, $year);
//     echo json_encode($result);
// }
 
 
// public function getCombinedData()
// {
//     $institu   = $this->input->post('fk_institu');
//     $branches  = $this->input->post('branches');   // array
//     $years     = $this->input->post('years');      // array
  
//     $result = $this->Sttp_Fdp_report_model->getCombinedData($institu, $branches, $years);
 
//     echo json_encode([
//         "status"      => "success",
//         "branchData"  => $result['branchData'],
//         "yearData"    => $result['yearData']
//     ]);
// }
 
public function getStudentList()
{
    $fk_sttID = $this->input->post('fk_sttID');
    if (!$fk_sttID) {
        echo json_encode([]);
        return;
    }
 
    // $this->load->model('ParentMeet_model');
    $students = $this->Sttp_Fdp_report_model->getStudentsByMeetId($fk_sttID);
 
    echo json_encode($students);
}
 

}
