<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class StudAssociation extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('StudAssociation_model');
        
    }



   
     public function index()
	{
      $data['alldata']=$this->StudAssociation_model->getdetailview();

        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/StudAssociation_detailview',$data);
		$this->load->view('admin/footer_view');
	

	}

   
    public function create()
	{
       $data['yeardata'] = $this->StudAssociation_model->getyear();
         $data['branchdata'] = $this->StudAssociation_model->getbranch();

		$this->load->view('admin/header_view');
		$this->load->view('admin/StudAssociation_view',$data);
		$this->load->view('admin/footer_view');
	

	}


     public function dashboard()
	{
       
		$this->load->view('admin/header_view');
		$this->load->view('admin/StudAssociation_dashview');
		$this->load->view('admin/footer_view');
	

	}


    // File upload method with improved error handling
    private function upload_file($file_name, $upload_path = './upload/')
    {
        // Ensure upload directory exists and is writable
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, TRUE);
        }
 
        $config['upload_path'] = $upload_path;
        $config['allowed_types'] = 'gif|jpg|png|jpeg|pdf';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE; // Use encrypted file names
 
        $this->upload->initialize($config);
 
        if (!$this->upload->do_upload($file_name)) {
            // If upload fails, return false or the current file
            return $this->input->post("hidden_photo{$file_name}");
        } else {
            $upload_data = $this->upload->data();
            return $upload_data['file_name'];
        }
    }

    
// function insertAssociation()
// {
//     $year = $this->input->post('year');
//     $objectives = $this->input->post('objectives');
//     $goals = $this->input->post('goals');
   
//     $this->load->library('upload');

//         $new_branches = json_decode($this->input->post('new_branches'), true) ?: [];

//         // Create mapping arrays for new entries
//         $branch_mapping = [];

//            $masters_created = [
//             'branches' => 0, 
//         ];

//          // Insert new branches and create mapping
//         foreach ($new_branches as $branch_name) {
//             if (!empty($branch_name)) {
//                 $existing_id = $this->StudAssociation_model->getBranchIdByName($branch_name);
                
//                 if ($existing_id) {
//                     $branch_mapping['NEW::' . $branch_name] = $existing_id;
//                     log_message('debug', "Branch already exists: {$branch_name} with ID: {$existing_id}");
//                 } else {
//                     $branch_data = [
//                         'branch_name' => $branch_name,
//                         'is_active' => 1,
//                         'created_date' => date('Y-m-d H:i:s')
//                     ];
                    
//                     $new_branch_id = $this->StudAssociation_model->insertBranch($branch_data);
//                     if ($new_branch_id) {
//                         $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
//                         $masters_created['branches']++;
//                         log_message('debug', "Created new branch: {$branch_name} with ID: {$new_branch_id}");
//                     }
//                 }
//             }
//         }

//     // ✅ FIX 1: Upload student_list PDF
//     $summ_report_filename = $this->upload_file('summ_report', './uploads/induction/');
//     $summ_report = $summ_report_filename ? '/uploads/induction/' . $summ_report_filename : '';

//     // Handle excel files
//     $excel_file = null;
//     if (!empty($_FILES['excel_file']['name'])) {
//         $excel_file = $_FILES['excel_file']['name'];
//     }

//     $excel_file1 = null;
//     if (!empty($_FILES['excel_file1']['name'])) {
//         $excel_file1 = $_FILES['excel_file1']['name'];
//     }

//     $fields = array(
//         'year' => $year,
//         'objectives' => $objectives,
//         'goals' => $goals,
//         'summ_report' => $summ_report,  // ✅ Changed from $photo6_filename
//         'excel_file' => $excel_file,
//         'excel_file1' => $excel_file1
//     );

//     $institute = $this->db
//         ->select('Institu_id')
//         ->from('institute_master')
//         ->get()
//         ->row();

//     if ($institute) {
//         $fields['Institute'] = $institute->Institu_id;
//     }

//     $this->StudAssociation_model->insertdata($fields);
//     $sub_id = $this->db->insert_id();


//     // ✅ FIX 2: Upload Activity Plan photos
//     $student_name = $this->input->post('student_name');
//     $fk_branch = $this->input->post('fk_branch');
//     $designation = $this->input->post('designation');
//         $PRN = $this->input->post('PRN');
//     $mobile = $this->input->post('mobile');

    
//     if (!empty($student_name)) {
//         foreach ($student_name as $i => $name) {
//             if (trim($name) == '') continue;
//             $childData = array(
//                 'fk_assID' => $sub_id,
//                 'student_name' => $name,
//                 'fk_branch' => $fk_branch[$i] ?? null,
//                 'designation' => $designation[$i] ?? null,  // ✅ Save uploaded photo path
//                 'PRN' => $PRN[$i] ?? null,
//              'mobile' => $mobile[$i] ?? null,

//             );
//             $this->StudAssociation_model->insertChild($childData);
//         }
//     }

//     // Guest lecture data
//     $activity_name = $this->input->post('activity_name');
//     $date = $this->input->post('date');
//     $photo_link = $this->input->post('photo_link');

//     if (!empty($activity_name)) {
//         foreach ($activity_name as $i => $name) {
//             if (trim($name) == '') continue;
//             $childDatasec = array(
//                 'fk_associID' => $sub_id,
//                 'activity_name' => $name,
//                 'date' => $date[$i] ?? null,
//                 'photo_link' => $photo_link[$i] ?? null,
//             );
//             $this->StudAssociation_model->insertChildguest($childDatasec);
//         }
//     }

//     echo json_encode(['status' => 'success']);
// }

public function insertAssociation()
{
    $year = $this->input->post('year');
    $objectives = $this->input->post('objectives');
    $goals = $this->input->post('goals');

    $this->load->library('upload');

    // ✅ New branch logic (same style as reference code)
    $new_branches = json_decode($this->input->post('new_branches'), true) ?: [];

    // Create mapping arrays for new entries
    $branch_mapping = [];
    $masters_created = ['branches' => 0];

    // Insert new branches and create mapping
    foreach ($new_branches as $branch_name) {
        if (!empty($branch_name)) {
            $existing_id = $this->StudAssociation_model->getBranchIdByName($branch_name);

            if ($existing_id) {
                $branch_mapping['NEW::' . $branch_name] = $existing_id;
                log_message('debug', "Branch already exists: {$branch_name} with ID: {$existing_id}");
            } else {
                $branch_data = [
                    'branch_name' => $branch_name,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ];

                $new_branch_id = $this->StudAssociation_model->insertBranch($branch_data);
                if ($new_branch_id) {
                    $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
                    $masters_created['branches']++;
                    log_message('debug', "Created new branch: {$branch_name} with ID: {$new_branch_id}");
                }
            }
        }
    }

    // ✅ Upload summary report
    $summ_report_filename = $this->upload_file('summ_report', './uploads/induction/');
    $summ_report = $summ_report_filename ? '/uploads/induction/' . $summ_report_filename : '';

    // Handle excel files
    $excel_file = null;
    if (!empty($_FILES['excel_file']['name'])) {
        $excel_file = $_FILES['excel_file']['name'];
    }

    $excel_file1 = null;
    if (!empty($_FILES['excel_file1']['name'])) {
        $excel_file1 = $_FILES['excel_file1']['name'];
    }

    $fields = array(
        'year' => $year,
        'objectives' => $objectives,
        'goals' => $goals,
        'summ_report' => $summ_report,
        'excel_file' => $excel_file,
        'excel_file1' => $excel_file1
    );

    $institute = $this->db
        ->select('Institu_id')
        ->from('institute_master')
        ->get()
        ->row();

    if ($institute) {
        $fields['Institute'] = $institute->Institu_id;
    }

    $this->StudAssociation_model->insertdata($fields);
    $sub_id = $this->db->insert_id();

    // ✅ Student child table
    $student_name = $this->input->post('student_name');
    $fk_branch = $this->input->post('fk_branch');
    $designation = $this->input->post('designation');
    $PRN = $this->input->post('PRN');
    $mobile = $this->input->post('mobile');

    if (!empty($student_name)) {
        foreach ($student_name as $i => $name) {
            if (trim($name) == '') continue;

            // ✅ Check and replace "NEW::branch" with mapped ID
            $branch_id = $fk_branch[$i] ?? null;
            if ($branch_id && strpos($branch_id, 'NEW::') === 0 && isset($branch_mapping[$branch_id])) {
                $branch_id = $branch_mapping[$branch_id];
            }

            $childData = array(
                'fk_assID' => $sub_id,
                'student_name' => $name,
                'fk_branch' => $branch_id,
                'designation' => $designation[$i] ?? null,
                'PRN' => $PRN[$i] ?? null,
                'mobile' => $mobile[$i] ?? null,
            );

            $this->StudAssociation_model->insertChild($childData);
        }
    }

    // ✅ Guest lecture data
    $activity_name = $this->input->post('activity_name');
    $date = $this->input->post('date');
    $photo_link = $this->input->post('photo_link');

    if (!empty($activity_name)) {
        foreach ($activity_name as $i => $name) {
            if (trim($name) == '') continue;
            $childDatasec = array(
                'fk_associID' => $sub_id,
                'activity_name' => $name,
                'date' => $date[$i] ?? null,
                'photo_link' => $photo_link[$i] ?? null,
            );
            $this->StudAssociation_model->insertChildguest($childDatasec);
        }
    }

    echo json_encode(['status' => 'success']);
}

	
  public function update()
	{
		$id=$this->uri->segment(4);
        $data['data']=$this->StudAssociation_model->getbyid($id);    
	        $data['childData'] = $this->StudAssociation_model->getChildByMainId($id);
              $data['childDatasec'] = $this->StudAssociation_model->getChildsecByMainId($id);

		 $data['yeardata'] = $this->StudAssociation_model->getyear();
         $data['branchdata'] = $this->StudAssociation_model->getbranch();

		$this->load->view('admin/header_view');
		$this->load->view('admin/StudAssociation_view',$data);
		$this->load->view('admin/footer_view');
	

	}

 

public function updateAssociation()
{
    $ass_id = $this->input->post('ass_id'); // Main ID
    $year = $this->input->post('year');
    $objectives = $this->input->post('objectives');
    $goals = $this->input->post('goals');

    $this->load->library('upload');

    // ========== HANDLE NEW BRANCH CREATION ==========
    $new_branches = json_decode($this->input->post('new_branches'), true) ?: [];
    $branch_mapping = [];
    $masters_created = ['branches' => 0];

    foreach ($new_branches as $branch_name) {
        if (!empty($branch_name)) {
            $existing_id = $this->StudAssociation_model->getBranchIdByName($branch_name);

            if ($existing_id) {
                $branch_mapping['NEW::' . $branch_name] = $existing_id;
                log_message('debug', "Branch already exists: {$branch_name} with ID: {$existing_id}");
            } else {
                $branch_data = [
                    'branch_name' => $branch_name,
                    'is_active' => 1,
                    'created_date' => date('Y-m-d H:i:s')
                ];
                $new_branch_id = $this->StudAssociation_model->insertBranch($branch_data);
                if ($new_branch_id) {
                    $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
                    $masters_created['branches']++;
                    log_message('debug', "Created new branch: {$branch_name} with ID: {$new_branch_id}");
                }
            }
        }
    }

    // ========== UPLOAD SUMMARY REPORT ==========
    $existing_summ_report = $this->input->post('existing_summ_report');
    $summ_report_filename = $this->upload_file('summ_report', './uploads/induction/');
    $summ_report = $summ_report_filename 
        ? '/uploads/induction/' . $summ_report_filename 
        : $existing_summ_report;

    // ========== HANDLE EXCEL FILES ==========
    $excel_file = !empty($_FILES['excel_file']['name']) ? $_FILES['excel_file']['name'] : $this->input->post('existing_excel_file');
    $excel_file1 = !empty($_FILES['excel_file1']['name']) ? $_FILES['excel_file1']['name'] : $this->input->post('existing_excel_file1');

    // ========== MAIN TABLE UPDATE ==========
    // ⭐ FIX: Include ass_id in the array for model's update method
    $fields = [
        'ass_id' => $ass_id,  // ⭐ CRITICAL: Add this line
        'year' => $year,
        'objectives' => $objectives,
        'goals' => $goals,
        'summ_report' => $summ_report,
        'excel_file' => $excel_file,
        'excel_file1' => $excel_file1
    ];

    // ⭐ FIX: Pass the complete array to update method
    $update_result = $this->StudAssociation_model->update($fields);

    if (!$update_result) {
        log_message('error', 'Failed to update main table for ass_id: ' . $ass_id);
        echo json_encode(['status' => 'error', 'message' => 'Failed to update main data']);
        return;
    }

    // ===================================================
    // ========== UPDATE STUDENT TABLE (CHILD 1) ==========
    // ===================================================
    $existing_students = $this->StudAssociation_model->getChildByMainId($ass_id);
    $existing_ids = array_column($existing_students, 'Id');
    $processed_ids = [];

    $Ids = $this->input->post('Id') ?: [];
    $student_names = $this->input->post('student_name') ?: [];
    $fk_branch = $this->input->post('fk_branch') ?: [];
    $designation = $this->input->post('designation') ?: [];
    $PRN = $this->input->post('PRN') ?: [];
    $mobile = $this->input->post('mobile') ?: [];

    if (!empty($student_names)) {
        foreach ($student_names as $i => $name) {
            if (trim($name) == '') continue;

            // Replace NEW::branch with new branch ID
            $branch_id = $fk_branch[$i] ?? null;
            if ($branch_id && strpos($branch_id, 'NEW::') === 0 && isset($branch_mapping[$branch_id])) {
                $branch_id = $branch_mapping[$branch_id];
                log_message('debug', "Replaced {$fk_branch[$i]} with branch_id: {$branch_id}");
            }

            $childData = [
                'fk_assID' => $ass_id,
                'student_name' => $name,
                'fk_branch' => $branch_id,
                'designation' => $designation[$i] ?? null,
                'PRN' => $PRN[$i] ?? null,
                'mobile' => $mobile[$i] ?? null,
            ];

            $existing_id = isset($Ids[$i]) && !empty($Ids[$i]) ? $Ids[$i] : null;

            if ($existing_id && is_numeric($existing_id)) {
                // Update existing student
                $this->StudAssociation_model->updateChild($existing_id, $childData);
                $processed_ids[] = $existing_id;
                log_message('debug', "Updated student ID: {$existing_id}");
            } else {
                // Insert new student
                $new_id = $this->StudAssociation_model->insertChild($childData);
                log_message('debug', "Inserted new student, ID: {$new_id}");
            }
        }
    }

    // Delete removed student rows
    $ids_to_delete = array_diff($existing_ids, $processed_ids);
    if (!empty($ids_to_delete)) {
        foreach ($ids_to_delete as $delete_id) {
            $this->StudAssociation_model->deleteChild($delete_id);
            log_message('debug', "Deleted student ID: {$delete_id}");
        }
    }

    // ===================================================
    // ========== UPDATE ACTIVITY TABLE (CHILD 2) =========
    // ===================================================
    $existing_activities = $this->StudAssociation_model->getChildsecByMainId($ass_id);
    $existing_act_ids = array_column($existing_activities, 'actID');
    $processed_act_ids = [];

    $actIDs = $this->input->post('actID') ?: [];
    $activity_name = $this->input->post('activity_name') ?: [];
    $date = $this->input->post('date') ?: [];
    $photo_link = $this->input->post('photo_link') ?: [];

    if (!empty($activity_name)) {
        foreach ($activity_name as $i => $name) {
            if (trim($name) == '') continue;

            $childDatasec = [
                'fk_associID' => $ass_id,
                'activity_name' => $name,
                'date' => $date[$i] ?? null,
                'photo_link' => $photo_link[$i] ?? null,
            ];

            $existing_act_id = isset($actIDs[$i]) && !empty($actIDs[$i]) ? $actIDs[$i] : null;

            if ($existing_act_id && is_numeric($existing_act_id)) {
                // Update existing activity
                $this->StudAssociation_model->updateChildsec($existing_act_id, $childDatasec);
                $processed_act_ids[] = $existing_act_id;
                log_message('debug', "Updated activity ID: {$existing_act_id}");
            } else {
                // Insert new activity
                $new_act_id = $this->StudAssociation_model->insertChildguest($childDatasec);
                log_message('debug', "Inserted new activity, ID: {$new_act_id}");
            }
        }
    }

    // Delete removed activities
    $ids_to_delete = array_diff($existing_act_ids, $processed_act_ids);
    if (!empty($ids_to_delete)) {
        foreach ($ids_to_delete as $delete_id) {
            $this->StudAssociation_model->deleteChildsec($delete_id);
            log_message('debug', "Deleted activity ID: {$delete_id}");
        }
    }

    log_message('debug', 'Update completed successfully for ass_id: ' . $ass_id);
    echo json_encode([
        'status' => 'success', 
        'message' => 'data updated successfully',
        'branches_created' => $masters_created['branches']
    ]);
}


}
