<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class StudentFeedback extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('StudentFeedback_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }


   
     public function index()
	{
      $data['alldata']=$this->StudentFeedback_model->getAllGeneratedURLs();

        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/StudentFeedback_detailview',$data);
		$this->load->view('admin/footer_view');
	

	}
    public function create()
	{
            //    $data['load_script'] = 'Department';
        $data['institutedata']=$this->StudentFeedback_model->getinstitute();
        $data['Hosteldata']=$this->StudentFeedback_model->getHostel();
          $data['yeardata'] = $this->StudentFeedback_model->getyear();
         $data['activeYear'] = $this->StudentFeedback_model->getActiveYear();

        //  echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
		$this->load->view('admin/StudentFeedback_view',$data);
		$this->load->view('admin/footer_view');
	

	}

public function generateURL()
{
    // This method is now optional - we're doing client-side URL generation
    // But keeping it for validation if needed
    
    $hostel_type = $this->input->post('hostel_type');
    $year = $this->input->post('year');
    $institute_id = $this->input->post('institute_id');
    
    // Validate inputs
    if (!$hostel_type || !$year) {
        echo json_encode(array(
            'status' => false,
            'message' => 'Please select both Hostel Type and Academic Year'
        ));
        return;
    }
    
    // Just return the URL without saving to database
    $generated_url = base_url() . 'admin/Survey/create?hostel_type=' . $hostel_type . '&year=' . $year;
    
    echo json_encode(array(
        'status' => true,
        'url' => $generated_url,
        'message' => 'URL generated successfully'
    ));
}

// Insert method - ONLY saves when user clicks Save button
public function insertFeedbackURL()
{
    $instituteId = $this->input->post('fkInsitute_id');
    $hostelType = $this->input->post('fkHostelType_id');
    $year = $this->input->post('FiniYear');
    $url = $this->input->post('AwardedBy');
    $isActive = $this->input->post('is_active'); // Get is_active value
    
    // Validate inputs
    if (!$instituteId || !$hostelType || !$year || !$url) {
        echo json_encode(array(
            'status' => false,
            'message' => 'All fields are required'
        ));
        return;
    }
    
    // Prepare data for insertion
    $data = array(
        'institute_id' => $instituteId,
        'hostel_type' => $hostelType,
        'year' => $year,
        'url' => $url,
        'is_active' => ($isActive == 1) ? 1 : 0  // Add this line
    );
    
    // Save to database
    $result = $this->StudentFeedback_model->saveGeneratedURL($data);
    
    if ($result['status']) {
        echo json_encode(array(
            'status' => true,
            'message' => 'Data saved successfully',
            'url_id' => $result['url_id']
        ));
    } else {
        echo json_encode(array(
            'status' => false,
            'message' => 'Failed to save data'
        ));
    }
}
// public function insertFeedbackURL()
// {
//     $instituteId = $this->input->post('fkInsitute_id');
//     $hostelType = $this->input->post('fkHostelType_id');
//     $year = $this->input->post('FiniYear');
//     $url = $this->input->post('AwardedBy');
    
//     // Validate inputs
//     if (!$instituteId || !$hostelType || !$year || !$url) {
//         echo json_encode(array(
//             'status' => false,
//             'message' => 'All fields are required'
//         ));
//         return;
//     }
    
//     // Check if URL already exists for this combination
//     $existing = $this->StudentFeedback_model->checkExistingURL($hostelType, $year, $instituteId);
    
//     if ($existing) {
//         echo json_encode(array(
//             'status' => false,
//             'message' => 'URL already exists for this Hostel Type and Academic Year combination'
//         ));
//         return;
//     }
    
//     // Prepare data for insertion
//     $data = array(
//         'institute_id' => $instituteId,
//         'hostel_type' => $hostelType,
//         'year' => $year,
//         'url' => $url
//     );
    
//     // Save to database
//     $result = $this->StudentFeedback_model->saveGeneratedURL($data);
    
//     if ($result['status']) {
//         echo json_encode(array(
//             'status' => true,
//             'message' => 'Data saved successfully',
//             'url_id' => $result['url_id']
//         ));
//     } else {
//         echo json_encode(array(
//             'status' => false,
//             'message' => 'Failed to save data'
//         ));
//     }
// }

 public function update()
	{
		$id=$this->uri->segment(4);
        $data['data']=$this->StudentFeedback_model->getbyid($id);
        // $data['load_script'] = 'Department';

            $data['institutedata']=$this->StudentFeedback_model->getinstitute();
        $data['Hosteldata']=$this->StudentFeedback_model->getHostel();
          $data['yeardata'] = $this->StudentFeedback_model->getyear();
         $data['activeYear'] = $this->StudentFeedback_model->getActiveYear();

        //  echo "<pre>";
        // print_r($data);

       
           $this->load->view('admin/header_view');
	$this->load->view('admin/StudentFeedback_view',$data);
           $this->load->view('admin/footer_view');
	}

// Update method
// Update method in StudentFeedback controller
public function updateFeedbackURL()
{
    $urlId = $this->input->post('url_id');
    
    // **ADD THIS DEBUG LOGGING**
    log_message('debug', '=== UPDATE FEEDBACK URL DEBUG ===');
    log_message('debug', 'Received url_id: ' . var_export($urlId, true));
    log_message('debug', 'All POST data: ' . print_r($this->input->post(), true));
    
    $instituteId = $this->input->post('fkInsitute_id');
    $hostelType = $this->input->post('fkHostelType_id');
    $year = $this->input->post('FiniYear');
    $url = $this->input->post('AwardedBy');
    $isActive = $this->input->post('is_active');
    
    // **CRITICAL FIX**: Better validation
    if (empty($urlId) || $urlId == '0') {
        log_message('error', 'Update failed: Invalid url_id');
        echo json_encode(array(
            'status' => false,
            'message' => 'Invalid URL ID for update'
        ));
        return;
    }
    
    if (!$instituteId || !$hostelType || !$year || !$url) {
        echo json_encode(array(
            'status' => false,
            'message' => 'All fields are required'
        ));
        return;
    }
    
    $data = array(
        'fkInsitute_id' => $instituteId,
        'fkHostelType_id' => $hostelType,
        'FiniYear' => $year,
        'generated_url' => $url,
        'is_active' => ($isActive == 1) ? 1 : 0
    );
    
    log_message('debug', 'Update data: ' . print_r($data, true));
    
    $result = $this->StudentFeedback_model->updateURL($urlId, $data);
    
    log_message('debug', 'Update result: ' . var_export($result, true));
    
    if ($result) {
        echo json_encode(array(
            'status' => true,
            'message' => 'Data updated successfully'
        ));
    } else {
        echo json_encode(array(
            'status' => false,
            'message' => 'Failed to update data'
        ));
    }
}


// public function updateFeedbackURL()
// {
//     $awardId = $this->input->post('Award_id');
//     $instituteId = $this->input->post('fkInsitute_id');
//     $hostelType = $this->input->post('fkHostelType_id');
//     $year = $this->input->post('FiniYear');
//     $url = $this->input->post('AwardedBy');
    
//     // Validate inputs
//     if (!$awardId || !$instituteId || !$hostelType || !$year || !$url) {
//         echo json_encode(array(
//             'status' => false,
//             'message' => 'All fields are required'
//         ));
//         return;
//     }
    
//     // Prepare data for update
//     $data = array(
//         'fkInsitute_id' => $instituteId,
//         'fkHostelType_id' => $hostelType,
//         'FiniYear' => $year,
//         'generated_url' => $url
//     );
    
//     // Update in database
//     $result = $this->StudentFeedback_model->updateURL($awardId, $data);
    
//     if ($result) {
//         echo json_encode(array(
//             'status' => true,
//             'message' => 'Data updated successfully'
//         ));
//     } else {
//         echo json_encode(array(
//             'status' => false,
//             'message' => 'Failed to update data'
//         ));
//     }
// }


// Add this new method to your StudentFeedback controller
public function toggleActiveStatus()
{
    $url_id = $this->input->post('url_id');
    $is_active = $this->input->post('is_active'); // Should be 0 or 1
    
    if (!isset($url_id)) {
        echo json_encode(array(
            'status' => false,
            'message' => 'URL ID is required'
        ));
        return;
    }
    
    $data = array(
        'is_active' => $is_active == 1 ? 1 : 0 // Ensure it's 0 or 1
    );
    
    $result = $this->StudentFeedback_model->updateURL($url_id, $data);
    
    if ($result) {
        echo json_encode(array(
            'status' => true,
            'message' => 'Status updated successfully'
        ));
    } else {
        echo json_encode(array(
            'status' => false,
            'message' => 'Failed to update status'
        ));
    }
}

   
}
