<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class StudentFeedback_list extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('StudentFeedback_list_model');
        $this->load->library('upload');
        $this->load->library('session');
        $this->load->helper('url');
        $this->load->database();
              $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    // ============ VIEW METHODS ============

   public function create()
{
$data['institutedata'] = $this->StudentFeedback_list_model->getInstitute();
    
    // Get current user ID from session
    $userId = $this->session->userdata('userID');
    
    if ($userId) {
        // Direct query to get user's hostel IDs
        $this->db->select('fkHostel_Id');
        $this->db->from('user_master');
        $this->db->where('UserID', $userId);
        $user = $this->db->get()->row();
        
        if ($user && !empty($user->fkHostel_Id)) {
            $hostelIds = explode(',', $user->fkHostel_Id);
            $hostelIds = array_map('trim', $hostelIds);
            $hostelIds = array_filter($hostelIds);
            
            $data['Hosteldata'] = $this->StudentFeedback_list_model->getHostelsByIds($hostelIds);
        } else {
            $data['Hosteldata'] = $this->StudentFeedback_list_model->getHostel();
        }
    } else {
        $data['Hosteldata'] = $this->StudentFeedback_list_model->getHostel();
    }
    
    $data['yearList'] = $this->StudentFeedback_list_model->getYears();
    $data['activeYear'] = $this->StudentFeedback_list_model->getActiveYear();
    $data['childData'] = null; // No existing data for create mode
    $data['data'] = null;

    // ✅ Get current URL dynamically
    $current_url = $this->uri->uri_string();        
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
    $this->load->view('admin/StudentFeedback_list_view.php', $data);
    $this->load->view('admin/footer_view');
}

    public function index()
    {
        $data['alldata'] = $this->StudentFeedback_list_model->getDetailView();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/StudentFeedback_list_deatilview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/StudentFeedback_dash_view');
        $this->load->view('admin/footer_view');
    }

    // ============ INSERT METHOD ============
    public function insertLibrarydata()
    {
        try {
            $this->output->set_content_type('application/json');
            $posted_data = $this->input->post();
            $fk_submenuId  = $this->input->post('fk_submenuId');
$createdBy     = $_SESSION['userID'];
            
            log_message('debug', '========== Student Feedback Insert Start ==========');
            log_message('debug', 'Posted Data: ' . print_r($posted_data, true));

            // Validate Academic Year
            if (empty($posted_data['FiniYear'])) {
                echo json_encode([
                    'status' => 'error', 
                    'message' => 'Please select an Academic Year'
                ]);
                return;
            }

            // Validate Institute
            if (empty($posted_data['fkInsitute_id'])) {
                echo json_encode([
                    'status' => 'error', 
                    'message' => 'Please select Institute'
                ]);
                return;
            }

            // Validate Hostel Type
            if (empty($posted_data['fkHostelType_id'])) {
                echo json_encode([
                    'status' => 'error', 
                    'message' => 'Please select Hostel Type'
                ]);
                return;
            }

            $selectedYear = $posted_data['FiniYear'];
            $instituteId = $posted_data['fkInsitute_id'];
            $hostelTypeId = $posted_data['fkHostelType_id'];

            // Handle Excel file upload (optional)
            $excelFileName = null;
            
            if (!empty($_FILES['activity_excel']['name'])) {
                $config['upload_path']   = './uploads/student_feedback_excel/';
                $config['allowed_types'] = 'xls|xlsx';
                $config['file_name']     = 'StudentFeedback_' . date('Ymd_His') . '_' . uniqid();
                // $config['max_size']      = 10240; // 10MB
                
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path'], 0777, true);
                }

                $this->upload->initialize($config);
                
                if ($this->upload->do_upload('activity_excel')) {
                    $uploadData = $this->upload->data();
                    $excelFileName = $uploadData['file_name'];
                    log_message('debug', 'Excel uploaded: ' . $excelFileName);
                } else {
                    $upload_error = $this->upload->display_errors('', '');
                    log_message('error', 'Excel upload failed: ' . $upload_error);
                }
            }

            // Validate we have data to insert
            if (empty($posted_data['PRN']) || !is_array($posted_data['PRN'])) {
                echo json_encode([
                    'status' => 'error', 
                    'message' => 'No student data found to insert'
                ]);
                return;
            }

            // Insert student records
            $insertCount = 0;
            $errors = [];
            $count = count($posted_data['PRN']);
            
            // Start transaction
            $this->db->trans_start();
            
            for ($i = 0; $i < $count; $i++) {
                // Skip completely empty rows
                if (empty($posted_data['PRN'][$i]) && empty($posted_data['Student_Name'][$i])) {
                    continue;
                }

                // Validate required fields
                // if (empty($posted_data['PRN'][$i])) {
                //     $errors[] = "Row " . ($i+1) . ": PRN is required";
                //     continue;
                // }

                if (empty($posted_data['Student_Name'][$i])) {
                    $errors[] = "Row " . ($i+1) . ": Student Name is required";
                    continue;
                }

                // Prepare studentfeedlist_master data
                $studentData = [
                   'PRN'               => !empty($posted_data['PRN'][$i]) ? trim($posted_data['PRN'][$i]) : null,
                'Student_Name'      => trim($posted_data['Student_Name'][$i]),
                'Class'             => !empty($posted_data['Class'][$i]) ? trim($posted_data['Class'][$i]) : null,
                'Branch'            => !empty($posted_data['Branch'][$i]) ? trim($posted_data['Branch'][$i]) : null,
                'Division'          => !empty($posted_data['Division'][$i]) ? trim($posted_data['Division'][$i]) : null,
                'ContactNO'         => !empty($posted_data['ContactNO'][$i]) ? trim($posted_data['ContactNO'][$i]) : null,
                'Address'           => !empty($posted_data['Address'][$i]) ? trim($posted_data['Address'][$i]) : null,
                'Birth_date'        => !empty($posted_data['Birth_date'][$i]) ? trim($posted_data['Birth_date'][$i]) : null,
                'Blood_group'       => !empty($posted_data['Blood_group'][$i]) ? trim($posted_data['Blood_group'][$i]) : null,
                'AdharCard_no'      => !empty($posted_data['AdharCard_no'][$i]) ? trim($posted_data['AdharCard_no'][$i]) : null,
                'Parent_Contact'    => !empty($posted_data['Parent_Contact'][$i]) ? trim($posted_data['Parent_Contact'][$i]) : null,
                'FiniYear'          => $selectedYear,
                'fkInsitute_id'     => $instituteId,
                'fkHostelType_id'   => $hostelTypeId,
                'excel_name'        => $excelFileName,
                'is_active'         => 1,
                'created_date'      => date('Y-m-d H:i:s'),
                     'created_by'      => $createdBy,
                    'is_default'        => 0,
                    'is_on'             => 1,
                    'is_active'         => 1
                ];

                log_message('debug', 'Inserting row ' . ($i+1) . ': ' . print_r($studentData, true));

                if ($this->db->insert('studentfeedlist_master', $studentData)) {
                    $insertCount++;
                    log_message('debug', 'Row ' . ($i+1) . ' inserted successfully');
                } else {
                    $db_error = $this->db->error();
                    $errors[] = "Row " . ($i+1) . " failed: " . $db_error['message'];
                    log_message('error', 'Row ' . ($i+1) . ' insert failed: ' . print_r($db_error, true));
                }
                $inserted_id = $this->db->insert_id(); // correct inserted ID
$insertCount++;

// ---- INSERT LOG (Action = 1 → Insert) ----
$action     = 1;
$record_id = $inserted_id;
$excel_name = $excelFileName;
$Fk_branch  = isset($posted_data['fk_branch']) ? $posted_data['fk_branch'] : null;

insert_log(
    $this,
    $fk_submenuId,
    $action,
    $record_id,
    $excel_name,
    $Fk_branch,
    $createdBy
);

            }

            // Complete transaction
            $this->db->trans_complete();

            // Return response
            if ($insertCount > 0) {
                $year = $this->StudentFeedback_list_model->getYearById($selectedYear);
                $yearLabel = $year ? $year->fini_Label : $selectedYear;
                
                $message = "Successfully saved {$insertCount} student feedback records";
                if ($yearLabel) {
                    $message .= " for {$yearLabel}";
                }
                
                if (!empty($errors)) {
                    $message .= "<br><small>Warnings: " . implode("<br>", $errors) . "</small>";
                }
                
                echo json_encode([
                    'status' => 'success', 
                    'message' => $message,
                    'inserted_count' => $insertCount
                ]);
            } else {
                $errorMsg = !empty($errors) ? implode(", ", $errors) : "No valid records to save";
                
                echo json_encode([
                    'status' => 'error', 
                    'message' => $errorMsg
                ]);
            }

            log_message('debug', '========== Student Feedback Insert End ==========');

        } catch (Exception $e) {
            log_message('error', 'Student feedback insert exception: ' . $e->getMessage());
            log_message('error', 'Stack trace: ' . $e->getTraceAsString());
            
            echo json_encode([
                'status' => 'error', 
                'message' => 'Server error: ' . $e->getMessage()
            ]);
        }
    }

    // ============ UPDATE METHODS ============
    public function update($student_id = null)
{
    if (!$student_id) {
        $student_id = $this->uri->segment(4);
    }
    
    if (!$student_id) {
        $this->session->set_flashdata('error', 'Invalid ID');
        redirect('admin/StudentFeedback_list/index');
        return;
    }
    
    // Get student record
    $data['mainData'] = $this->StudentFeedback_list_model->getStudentById($student_id);
    
    if (!$data['mainData']) {
        $this->session->set_flashdata('error', 'Record not found!');
        redirect('admin/StudentFeedback_list/index');
        return;
    }
    
    // Get all related student records (if you have grouping by excel_name or similar)
    // $data['childData'] = $this->StudentFeedback_list_model->getStudentsByGroup($student_id);
     $data['childData'] = array($data['mainData']);
     
    // Get dropdowns
    $data['institutedata'] = $this->StudentFeedback_list_model->getInstitute();
    
    // Get the logged-in user's hostel ID from session
    $userHostelId = $this->session->userdata('fkHostel_Id');
    
    // If user has a specific hostel ID, get only that hostel
    if (!empty($userHostelId)) {
        $data['Hosteldata'] = $this->StudentFeedback_list_model->getHostelById($userHostelId);
        // Convert single object to array for consistent handling in view
        if ($data['Hosteldata']) {
            $data['Hosteldata'] = [$data['Hosteldata']];
        }
    } else {
        // If no specific hostel, get all hostels (fallback)
        $data['Hosteldata'] = $this->StudentFeedback_list_model->getHostel();
    }
    
    $data['yearList'] = $this->StudentFeedback_list_model->getYears();
    $data['activeYear'] = $this->StudentFeedback_list_model->getActiveYear();
    
    // Pass first record's data for form defaults
    // $data['data'] = !empty($data['childData']) ? [$data['childData'][0]] : [$data['mainData']];
    $data['data'] = $data['childData'];


    $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);
        
    $this->load->view('admin/header_view');
    $this->load->view('admin/StudentFeedback_list_view.php', $data);
    $this->load->view('admin/footer_view');
}

//     public function updateLibrarydata()
//     {
//         try {
//             $this->output->set_content_type('application/json');
//             $posted_data = $this->input->post();
//             $fk_submenuId  = $this->input->post('fk_submenuId');
// $modifiedBy   = $_SESSION['userID'];
//             log_message('debug', '========== Student Feedback Update Start ==========');
//             log_message('debug', 'Posted Data: ' . print_r($posted_data, true));

//             // Get student_id from first record (for identifying the group)
//             $first_student_id = !empty($posted_data['Student_id'][0]) ? $posted_data['Student_id'][0] : null;
            
//             if (!$first_student_id) {
//                 echo json_encode([
//                     'status' => 'error', 
//                     'message' => 'Student ID is required for update'
//                 ]);
//                 return;
//             }

//             // Validate Academic Year
//             if (empty($posted_data['FiniYear'])) {
//                 echo json_encode([
//                     'status' => 'error', 
//                     'message' => 'Please select an Academic Year'
//                 ]);
//                 return;
//             }

//             // Validate Institute
//             if (empty($posted_data['fkInsitute_id'])) {
//                 echo json_encode([
//                     'status' => 'error', 
//                     'message' => 'Please select Institute'
//                 ]);
//                 return;
//             }

//             // Validate Hostel Type
//             if (empty($posted_data['fkHostelType_id'])) {
//                 echo json_encode([
//                     'status' => 'error', 
//                     'message' => 'Please select Hostel Type'
//                 ]);
//                 return;
//             }

//             $selectedYear = $posted_data['FiniYear'];
//             $instituteId = $posted_data['fkInsitute_id'];
//             $hostelTypeId = $posted_data['fkHostelType_id'];

//             // Get existing excel filename
//             $existingRecord = $this->StudentFeedback_list_model->getStudentById($first_student_id);
//             $excelFileName = $existingRecord ? $existingRecord->excel_name : null;

//             // Handle new Excel file upload (optional)
//             if (!empty($_FILES['activity_excel']['name'])) {
//                 $config['upload_path']   = './uploads/student_feedback_excel/';
//                 $config['allowed_types'] = 'xls|xlsx';
//                 $config['file_name']     = 'StudentFeedback_' . date('Ymd_His') . '_' . uniqid();
//                 // $config['max_size']      = 10240;
                
//                 if (!is_dir($config['upload_path'])) {
//                     mkdir($config['upload_path'], 0777, true);
//                 }

//                 $this->upload->initialize($config);
                
//                 if ($this->upload->do_upload('activity_excel')) {
//                     $uploadData = $this->upload->data();
//                     $excelFileName = $uploadData['file_name'];
//                     log_message('debug', 'New Excel uploaded: ' . $excelFileName);
//                 }
//             }

//             // Get existing records by excel_name or first student's group
//             $existing_records = $this->StudentFeedback_list_model->getStudentsByGroup($first_student_id);
//             $existing_student_ids = [];
//             foreach ($existing_records as $record) {
//                 $existing_student_ids[] = $record->Student_id;
//             }
            
//             log_message('debug', 'Existing Student_Ids: ' . print_r($existing_student_ids, true));

//             // Validate we have data to update
//             if (empty($posted_data['PRN']) || !is_array($posted_data['PRN'])) {
//                 echo json_encode([
//                     'status' => 'error', 
//                     'message' => 'No student data found to update'
//                 ]);
//                 return;
//             }

//             // Start transaction
//             $this->db->trans_start();

//             $updateCount = 0;
//             $insertCount = 0;
//             $errors = [];
//             $count = count($posted_data['PRN']);
            
//             for ($i = 0; $i < $count; $i++) {
//                 // Skip completely empty rows
//                 if (empty($posted_data['PRN'][$i]) && empty($posted_data['Student_Name'][$i])) {
//                     continue;
//                 }

//                 // Validate required fields
//                 // if (empty($posted_data['PRN'][$i])) {
//                 //     $errors[] = "Row " . ($i+1) . ": PRN is required";
//                 //     continue;
//                 // }

//                 if (empty($posted_data['Student_Name'][$i])) {
//                     $errors[] = "Row " . ($i+1) . ": Student Name is required";
//                     continue;
//                 }

//                 // Prepare student data
//                 $studentData = [
//                     'PRN'               => !empty($posted_data['PRN'][0]) ? trim($posted_data['PRN'][0]) : null,
//             'Student_Name'      => trim($posted_data['Student_Name'][0]),
//             'Class'             => !empty($posted_data['Class'][0]) ? trim($posted_data['Class'][0]) : null,
//             'Branch'            => !empty($posted_data['Branch'][0]) ? trim($posted_data['Branch'][0]) : null,
//             'Division'          => !empty($posted_data['Division'][0]) ? trim($posted_data['Division'][0]) : null,
//             'ContactNO'         => !empty($posted_data['ContactNO'][0]) ? trim($posted_data['ContactNO'][0]) : null,
//             'Address'           => !empty($posted_data['Address'][0]) ? trim($posted_data['Address'][0]) : null,
//             'Birth_date'        => !empty($posted_data['Birth_date'][0]) ? trim($posted_data['Birth_date'][0]) : null,
//             'Blood_group'       => !empty($posted_data['Blood_group'][0]) ? trim($posted_data['Blood_group'][0]) : null,
//             'AdharCard_no'      => !empty($posted_data['AdharCard_no'][0]) ? trim($posted_data['AdharCard_no'][0]) : null,
//             'Parent_Contact'    => !empty($posted_data['Parent_Contact'][0]) ? trim($posted_data['Parent_Contact'][0]) : null,
//             'FiniYear'          => $selectedYear,
//             'fkInsitute_id'     => $instituteId,
//             'fkHostelType_id'   => $hostelTypeId,
//             'excel_name'        => $excelFileName,
//             'modified_date'     => date('Y-m-d H:i:s'),
//             'is_active'         => 1,
//                     'modified_by'     => $modifiedBy, 
//                     'is_default'        => 0,
//                     'is_on'             => 1,
//                     'is_active'         => 1
//                 ];

//                 // If we have an existing Student_id for this row index, UPDATE it
//                 if (isset($existing_student_ids[$i])) {
//                     $student_id = $existing_student_ids[$i];
                    
//                     log_message('debug', 'Updating row ' . ($i+1) . ' with Student_id: ' . $student_id);
                    
//                     $this->db->where('Student_id', $student_id);
//                     if ($this->db->update('studentfeedlist_master', $studentData)) {
//                         $updateCount++;
//                         log_message('debug', 'Row ' . ($i+1) . ' updated successfully');
//                     } else {
//                         $db_error = $this->db->error();
//                         $errors[] = "Row " . ($i+1) . " update failed: " . $db_error['message'];
//                         log_message('error', 'Row ' . ($i+1) . ' update failed: ' . print_r($db_error, true));
//                     }

//                     $updateCount++;

// // ---- INSERT LOG (Action = 2 → Update) ----
// $action     = 2;
// $record_id  = $student_id; // updated record id
// $excel_name = $excelFileName;
// $Fk_branch  = isset($posted_data['fk_branch']) ? $posted_data['fk_branch'] : null;

// insert_log(
//     $this,
//     $fk_submenuId,
//     $action,
//     $record_id,
//     $excel_name,
//     $Fk_branch,
//     $modifiedBy
// );

//                 } 
//                 // Otherwise, INSERT new record
//                 else {
//                     log_message('debug', 'Inserting new row ' . ($i+1));
                    
//                     if ($this->db->insert('studentfeedlist_master', $studentData)) {
//                         $insertCount++;
//                         log_message('debug', 'Row ' . ($i+1) . ' inserted successfully');
//                     } else {
//                         $db_error = $this->db->error();
//                         $errors[] = "Row " . ($i+1) . " insert failed: " . $db_error['message'];
//                         log_message('error', 'Row ' . ($i+1) . ' insert failed: ' . print_r($db_error, true));
//                     }
//                 }
//             }

//             // Delete any extra records that were removed in the form
//             if ($count < count($existing_student_ids)) {
//                 $ids_to_delete = array_slice($existing_student_ids, $count);
                
//                 log_message('debug', 'Deleting extra records: ' . print_r($ids_to_delete, true));
                
//                 $this->db->where_in('Student_id', $ids_to_delete);
//                 $this->db->delete('studentfeedlist_master');
//             }

//             // Complete transaction
//             $this->db->trans_complete();

//             // Check if transaction was successful
//             if ($this->db->trans_status() === FALSE) {
//                 echo json_encode([
//                     'status' => 'error',
//                     'message' => 'Transaction failed. Please try again.'
//                 ]);
//                 return;
//             }

//             // Return response
//             $totalProcessed = $updateCount + $insertCount;
            
//             if ($totalProcessed > 0) {
//                 $year = $this->StudentFeedback_list_model->getYearById($selectedYear);
//                 $yearLabel = $year ? $year->fini_Label : $selectedYear;
                
//                 $message = "Successfully processed {$totalProcessed} student feedback records";
//                 if ($updateCount > 0) {
//                     $message .= " ({$updateCount} updated";
//                 }
//                 if ($insertCount > 0) {
//                     $message .= ($updateCount > 0 ? ", " : " (") . "{$insertCount} added";
//                 }
//                 $message .= ")";
                
//                 if ($yearLabel) {
//                     $message .= " for {$yearLabel}";
//                 }
                
//                 if (!empty($errors)) {
//                     $message .= "<br><small>Warnings: " . implode("<br>", $errors) . "</small>";
//                 }
                
//                 echo json_encode([
//                     'status' => 'success', 
//                     'message' => $message,
//                     'updated_count' => $updateCount,
//                     'inserted_count' => $insertCount
//                 ]);
//             } else {
//                 $errorMsg = !empty($errors) ? implode(", ", $errors) : "No valid records to update";
                
//                 echo json_encode([
//                     'status' => 'error', 
//                     'message' => $errorMsg
//                 ]);
//             }

//             log_message('debug', '========== Student Feedback Update End ==========');

//         } catch (Exception $e) {
//             log_message('error', 'Student feedback update exception: ' . $e->getMessage());
//             log_message('error', 'Stack trace: ' . $e->getTraceAsString());
            
//             echo json_encode([
//                 'status' => 'error', 
//                 'message' => 'Server error: ' . $e->getMessage()
//             ]);
//         }
//     }

public function updateLibrarydata()
{
    try {
        $this->output->set_content_type('application/json');
        $posted_data = $this->input->post();
         $fk_submenuId  = $this->input->post('fk_submenuId');
$modifiedBy   = $_SESSION['userID'];

        log_message('debug', '========== Student Feedback Update Start ==========');
        log_message('debug', 'Posted Data: ' . print_r($posted_data, true));

        // Get the specific student ID from the hidden field (not from array)
        $student_id = $this->input->post('Student_id');
        
        if (!$student_id) {
            echo json_encode([
                'status' => 'error', 
                'message' => 'Student ID is required for update'
            ]);
            return;
        }

        // Validate Academic Year
        if (empty($posted_data['FiniYear'])) {
            echo json_encode([
                'status' => 'error', 
                'message' => 'Please select an Academic Year'
            ]);
            return;
        }

        // Validate Institute
        if (empty($posted_data['fkInsitute_id'])) {
            echo json_encode([
                'status' => 'error', 
                'message' => 'Please select Institute'
            ]);
            return;
        }

        // Validate Hostel Type
        if (empty($posted_data['fkHostelType_id'])) {
            echo json_encode([
                'status' => 'error', 
                'message' => 'Please select Hostel Type'
            ]);
            return;
        }

        $selectedYear = $posted_data['FiniYear'];
        $instituteId = $posted_data['fkInsitute_id'];
        $hostelTypeId = $posted_data['fkHostelType_id'];

        // Get existing record to preserve excel_name
        $existingRecord = $this->StudentFeedback_list_model->getStudentById($student_id);
        
        if (!$existingRecord) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Student record not found'
            ]);
            return;
        }
        
        $excelFileName = $existingRecord->excel_name;

        // Handle new Excel file upload
        if (!empty($_FILES['activity_excel']['name'])) {
            $config['upload_path']   = './uploads/student_feedback_excel/';
            $config['allowed_types'] = 'xls|xlsx';
            $config['file_name']     = 'StudentFeedback_' . date('Ymd_His') . '_' . uniqid();
            $config['max_size']      = 10240;
            
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }

            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('activity_excel')) {
                $uploadData = $this->upload->data();
                $excelFileName = $uploadData['file_name'];
                log_message('debug', 'New Excel uploaded: ' . $excelFileName);
            } else {
                $upload_error = $this->upload->display_errors('', '');
                log_message('error', 'Excel upload failed: ' . $upload_error);
            }
        }

        // Validate student data exists
        if (empty($posted_data['Student_Name']) || !is_array($posted_data['Student_Name'])) {
            echo json_encode([
                'status' => 'error', 
                'message' => 'No student data found to update'
            ]);
            return;
        }

        // Validate Student Name (required)
        if (empty($posted_data['Student_Name'][0])) {
            echo json_encode([
                'status' => 'error', 
                'message' => 'Student Name is required'
            ]);
            return;
        }

        // Start transaction
        $this->db->trans_start();

        // Prepare ONLY the first row data (single record update)
        $studentData = [
            'PRN'               => !empty($posted_data['PRN'][0]) ? trim($posted_data['PRN'][0]) : null,
            'Student_Name'      => trim($posted_data['Student_Name'][0]),
            'Class'             => !empty($posted_data['Class'][0]) ? trim($posted_data['Class'][0]) : null,
            'Branch'            => !empty($posted_data['Branch'][0]) ? trim($posted_data['Branch'][0]) : null,
            'Division'          => !empty($posted_data['Division'][0]) ? trim($posted_data['Division'][0]) : null,
            'ContactNO'         => !empty($posted_data['ContactNO'][0]) ? trim($posted_data['ContactNO'][0]) : null,
            'Address'           => !empty($posted_data['Address'][0]) ? trim($posted_data['Address'][0]) : null,
            'Birth_date'        => !empty($posted_data['Birth_date'][0]) ? trim($posted_data['Birth_date'][0]) : null,
            'Blood_group'       => !empty($posted_data['Blood_group'][0]) ? trim($posted_data['Blood_group'][0]) : null,
            'AdharCard_no'      => !empty($posted_data['AdharCard_no'][0]) ? trim($posted_data['AdharCard_no'][0]) : null,
            'Parent_Contact'    => !empty($posted_data['Parent_Contact'][0]) ? trim($posted_data['Parent_Contact'][0]) : null,
            'FiniYear'          => $selectedYear,
            'fkInsitute_id'     => $instituteId,
            'fkHostelType_id'   => $hostelTypeId,
            'excel_name'        => $excelFileName,
            'modified_date'     => date('Y-m-d H:i:s'),
            'is_active'         => 1,
                    'modified_by'     => $modifiedBy, 
                    'is_default'        => 0,
                    'is_on'             => 1,
                    'is_active'         => 1
                    
        ];

        log_message('debug', 'Updating Student_id: ' . $student_id);
        log_message('debug', 'Update Data: ' . print_r($studentData, true));

        // Update the specific record
        $this->db->where('Student_id', $student_id);
        $updateResult = $this->db->update('studentfeedlist_master', $studentData);

// ---- INSERT LOG (Action = 2 → Update) ----
$action     = 2;
$record_id  = $student_id; // updated record id
$excel_name = $excelFileName;
$Fk_branch  = isset($posted_data['fk_branch']) ? $posted_data['fk_branch'] : null;

insert_log(
    $this,
    $fk_submenuId,
    $action,
    $record_id,
    $excel_name,
    $Fk_branch,
    $modifiedBy
);


        // Complete transaction
        $this->db->trans_complete();

        // Check transaction status
        if ($this->db->trans_status() === FALSE || !$updateResult) {
            $db_error = $this->db->error();
            log_message('error', 'Update failed: ' . print_r($db_error, true));
            
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to update record. Please try again.'
            ]);
            return;
        }

        // Success response
        $year = $this->StudentFeedback_list_model->getYearById($selectedYear);
        $yearLabel = $year ? $year->fini_Label : $selectedYear;
        
        $message = "Successfully updated student record";
        if ($yearLabel) {
            $message .= " for {$yearLabel}";
        }
        
        echo json_encode([
            'status' => 'success', 
            'message' => $message,
            'updated_count' => 1
        ]);

        log_message('debug', '========== Student Feedback Update End ==========');

    } catch (Exception $e) {
        log_message('error', 'Student feedback update exception: ' . $e->getMessage());
        log_message('error', 'Stack trace: ' . $e->getTraceAsString());
        
        echo json_encode([
            'status' => 'error', 
            'message' => 'Server error: ' . $e->getMessage()
        ]);
    }
}

    // ============ DELETE METHODS ============
    
    public function deleteActivity()
    {
        $this->output->set_content_type('application/json');
        
        $student_id = $this->input->post('Student_id');
        
        if (empty($student_id)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Student ID is required'
            ]);
            return;
        }

        // Soft delete
        $result = $this->StudentFeedback_list_model->softDeleteStudent($student_id);
        
        if ($result) {
            echo json_encode([
                'status' => 'success',
                'message' => 'Record deleted successfully'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to delete record'
            ]);
        }
    }

    public function deleteAllActivities()
    {
        $this->output->set_content_type('application/json');
        
        $student_id = $this->input->post('Student_id');
        
        if (empty($student_id)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Student ID is required'
            ]);
            return;
        }

        // Get all records in the same group
        $records = $this->StudentFeedback_list_model->getStudentsByGroup($student_id);
        
        if (empty($records)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'No records found'
            ]);
            return;
        }

        // Delete all records in the group
        $result = $this->StudentFeedback_list_model->deleteStudentGroup($student_id);
        
        if ($result) {
            echo json_encode([
                'status' => 'success',
                'message' => 'All records deleted successfully'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to delete records'
            ]);
        }
    }
}