<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Student_transfortfrom extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Student_transfortfrom_model');
    }

    public function index()
    {
        $data['alldata'] = $this->Student_transfortfrom_model->getdetailview();
        $this->load->view('admin/header_view');
        $this->load->view('admin/Student_transfortfrom_detailview', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['rootdata']     = $this->Student_transfortfrom_model->getrootstop();
        $data['rootstopdata'] = $this->Student_transfortfrom_model->getrootstopname();
        $data['vehicledata']  = $this->Student_transfortfrom_model->getvehicle();
        $data['usertypedata'] = $this->Student_transfortfrom_model->getusermaster();
        $data['yeardata']     = $this->Student_transfortfrom_model->getfiniyear();

        $this->load->view('admin/header_view');
        $this->load->view('admin/Student_transfortfrom_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function insertsoftware()
    {
        $rows = $this->_makeRows();

        if (count($rows) == 0) {
            echo json_encode(['status' => 'error', 'msg' => 'No student data found']);
            return;
        }

        $this->Student_transfortfrom_model->insertBatch($rows);
        echo json_encode(['status' => 'success']);
    }

    // public function update($id)
    // {
    //     $data['alldata'] = $this->Student_transfortfrom_model->getById($id);

    //     $data['rootdata']     = $this->Student_transfortfrom_model->getrootstop();
    //     $data['rootstopdata'] = $this->Student_transfortfrom_model->getrootstopname();
    //     $data['vehicledata']  = $this->Student_transfortfrom_model->getvehicle();
    //     $data['usertypedata'] = $this->Student_transfortfrom_model->getusermaster();
    //     $data['yeardata']     = $this->Student_transfortfrom_model->getfiniyear();

    //     $this->load->view('admin/header_view');
    //     $this->load->view('admin/Student_transfortfrom_view', $data);
    //     $this->load->view('admin/footer_view');
    // }

    public function update($id)
{
    // Single record fetch karo
    $result = $this->Student_transfortfrom_model->getById($id);
    
    if (!empty($result)) {
        $data['alldata'] = $result;
    } else {
        $data['alldata'] = [];
    }

    // Dropdowns
    $data['rootdata']     = $this->Student_transfortfrom_model->getrootstop();
    $data['rootstopdata'] = $this->Student_transfortfrom_model->getrootstopname();
    $data['vehicledata']  = $this->Student_transfortfrom_model->getvehicle();
    $data['usertypedata'] = $this->Student_transfortfrom_model->getusermaster();
    $data['yeardata']     = $this->Student_transfortfrom_model->getfiniyear();

    $this->load->view('admin/header_view');
    $this->load->view('admin/Student_transfortfrom_view', $data);
    $this->load->view('admin/footer_view');
}

public function updatesoftware()
{
    $id = $this->input->post('id');

    $data = [
        'fk_rootmaster'   => $this->input->post('fk_rootmaster'),
        'fk_stopname'     => $this->input->post('fk_stopname'),
        'fk_vehiclenames' => $this->input->post('fk_vehiclenames'),
        'fk_usertype'     => $this->input->post('fk_usertype'),
        'fk_finalyear'    => $this->input->post('fk_finalyear'),
        'prn'             => $this->input->post('prn'),
        'student_name'    => $this->input->post('student_name'),
        'branch'          => $this->input->post('branch'),
        'class'           => $this->input->post('class'),
        'division'        => $this->input->post('division'),
        'contact_no'      => $this->input->post('contact_no'),
        'address'         => $this->input->post('address'),
        'aadhar_no'       => $this->input->post('aadhar_no'),
        'portal_mobile'   => $this->input->post('portal_mobile')
    ];

    $this->Student_transfortfrom_model->updateById($id, $data);
    echo json_encode(['status' => 'success']);
}

    public function delete($id)
    {
        $this->Student_transfortfrom_model->deleteById($id);
        redirect('admin/Student_transfortfrom/index');
    }

   private function _makeRows()
{
    $fk_rootmaster   = $this->input->post('fk_rootmaster');
    $fk_stopname     = $this->input->post('fk_stopname');
    $fk_vehiclenames = $this->input->post('fk_vehiclenames');
    $fk_usertype     = $this->input->post('fk_usertype');
    $fk_finalyear    = $this->input->post('fk_finalyear');

    $prn           = $this->input->post('prn');
    $name          = $this->input->post('student_name');
    $branch        = $this->input->post('branch');
    $class         = $this->input->post('class');
    $div           = $this->input->post('division');
    $mobile        = $this->input->post('contact_no');
    $addr          = $this->input->post('address');
    $aadhar        = $this->input->post('aadhar_no');
    $portal_mobile = $this->input->post('portal_mobile');

    if (!is_array($prn)) {
        return [];
    }

    $rows = [];

    for ($i = 0; $i < count($prn); $i++) {
        if (trim($prn[$i]) == '' && trim($name[$i]) == '') {
            continue;
        }

        $rows[] = [
            'fk_rootmaster'   => $fk_rootmaster,
            'fk_stopname'     => $fk_stopname,
            'fk_vehiclenames' => $fk_vehiclenames,
            'fk_usertype'     => $fk_usertype,
            'fk_finalyear'    => $fk_finalyear,
            'prn'             => $prn[$i],
            'student_name'    => $name[$i],
            'branch'          => isset($branch[$i]) ? $branch[$i] : '',
            'class'           => isset($class[$i]) ? $class[$i] : '',
            'division'        => isset($div[$i]) ? $div[$i] : '',
            'contact_no'      => isset($mobile[$i]) ? $mobile[$i] : '',
            'address'         => isset($addr[$i]) ? $addr[$i] : '',
            'aadhar_no'       => isset($aadhar[$i]) ? $aadhar[$i] : '',
            'portal_mobile'   => isset($portal_mobile[$i]) ? $portal_mobile[$i] : '',
            'created_at'      => date('Y-m-d H:i:s')
        ];
    }

    return $rows;
}
}