<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Talukamaster extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Talukamaster_model');
    }
    
    public function index()
    {
        $data['alldata'] = $this->Talukamaster_model->getdetailview();
        $this->load->view('admin/header_view');
        $this->load->view('admin/Talukamaster_detailview', $data);
        $this->load->view('admin/footer_view');
    }
    
    public function create()
    {
        $data['countrydata'] = $this->Talukamaster_model->getcountry();
        $data['statedata'] = array(); // Empty rakhenge - dynamically load hoga
        $data['Districtdata'] = array(); // Empty rakhenge - dynamically load hoga
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Talukamaster_view', $data);
        $this->load->view('admin/footer_view');
    }
    
    public function dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Talukamaster_dash_view');
        $this->load->view('admin/footer_view');
    }
    
    function insertsoftware()
    {
        $taulkaName = $this->input->post('taulkaName');
        $fk_Country = $this->input->post('fk_Country');
        $fk_State = $this->input->post('fk_State');
        $fk_District = $this->input->post('fk_District');
        
        $fields = array(
            'taulkaName' => $taulkaName,
            'fk_Country' => $fk_Country,
            'fk_State' => $fk_State,
            'fk_District' => $fk_District,
        );
        
        $this->Talukamaster_model->insertdata($fields);
        echo json_encode(['status' => 'success']);
    }
    
    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->Talukamaster_model->getbyid($id);
        $data['countrydata'] = $this->Talukamaster_model->getcountry();
        
        // Edit mode: Selected country ke states load karo
        if(!empty($data['data'][0]->fk_Country)) {
            $data['statedata'] = $this->Talukamaster_model->getstate_by_country($data['data'][0]->fk_Country);
        } else {
            $data['statedata'] = array();
        }
        
        // Edit mode: Selected state ke districts load karo
        if(!empty($data['data'][0]->fk_State)) {
            $data['Districtdata'] = $this->Talukamaster_model->getdistrict_by_state($data['data'][0]->fk_State);
        } else {
            $data['Districtdata'] = array();
        }
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Talukamaster_view', $data);
        $this->load->view('admin/footer_view');
    }
    
    public function updatesoftware()
    {
        $taluka_id = $this->input->post('taluka_id');
        $taulkaName = $this->input->post('taulkaName');
        $fk_Country = $this->input->post('fk_Country');
        $fk_State = $this->input->post('fk_State');
        $fk_District = $this->input->post('fk_District');
        
        $fields = [
            'taluka_id' => $taluka_id,
            'taulkaName' => $taulkaName,
            'fk_Country' => $fk_Country,
            'fk_State' => $fk_State,
            'fk_District' => $fk_District,
        ];
        
        $this->Talukamaster_model->update($fields);
    }
    
    // ============ AJAX Methods for Dropdown Dependency ============
    
    // Country ke basis par States get karo
    public function get_states_by_country() {
        $country_id = $this->input->post('country_id');
        
        if(!empty($country_id)) {
            $this->db->select('stateId, stateName');
            $this->db->where('fk_Country', $country_id);
            $this->db->order_by('stateName', 'ASC');
            $query = $this->db->get('state_master');
            $states = $query->result();
            
            echo json_encode(array('status' => 'success', 'data' => $states));
        } else {
            echo json_encode(array('status' => 'error', 'message' => 'Country ID not found'));
        }
    }
    
    // State ke basis par Districts get karo
    public function get_districts_by_state() {
        $state_id = $this->input->post('state_id');
        
        if(!empty($state_id)) {
            $this->db->select('district_id, district_name');
            $this->db->where('fk_State', $state_id);
            $this->db->order_by('district_name', 'ASC');
            $query = $this->db->get('district_master');
            $districts = $query->result();
            
            echo json_encode(array('status' => 'success', 'data' => $districts));
        } else {
            echo json_encode(array('status' => 'error', 'message' => 'State ID not found'));
        }
    }
}