<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class UGfellow extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('UGfellow_model');
        $this->load->library('upload');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }
    
    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/UGfellow_dash_view.php');
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
      
        $data['studentdata'] = $this->UGfellow_model->getstudent();
        $data['branchdata'] = $this->UGfellow_model->getbranch();
        $data['classdata'] = $this->UGfellow_model->getclass();

         $data['institutedata'] = $this->UGfellow_model->getinstitute();
        $data['yeardata'] = $this->UGfellow_model->getyear();
        
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/UGfellow_view.php', $data);
        $this->load->view('admin/footer_view');
    }

     public function index()
    {
        // Load list view
        $data['alldata'] = $this->UGfellow_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/UGfellow_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

  public function insertUGfellow()
{
    try {
        $this->output->set_content_type('application/json');
        
        // Get arrays from POST
        $prn = $this->input->post('prn');
        $fkStudent_id = $this->input->post('fkStudent_id');
        $fkbranch_id = $this->input->post('fkbranch_id'); // ADDED
        $fkclass_id = $this->input->post('fkclass_id');
        $Division = $this->input->post('Division');
        $project_name = $this->input->post('project_name');
        $Contact = $this->input->post('Contact');
        $institute = $this->input->post('institute');
        $Photo_Url = $this->input->post('Photo_Url');
        $gurd_name = $this->input->post('gurd_name');
        $finicial_Year = $this->input->post('finicial_Year');
        $fk_submenuId = $this->input->post('fk_submenuId');

        // Get new master data
        $new_students = json_decode($this->input->post('new_students'), true) ?: [];
        $new_branches = json_decode($this->input->post('new_branches'), true) ?: []; // ADDED
        $new_classes = json_decode($this->input->post('new_classes'), true) ?: [];
        $new_institutes = json_decode($this->input->post('new_institutes'), true) ?: [];
        $new_years = json_decode($this->input->post('new_years'), true) ?: [];
        
        log_message('debug', 'Student IDs received: ' . print_r($fkStudent_id, true));
        log_message('debug', 'Branch IDs received: ' . print_r($fkbranch_id, true)); // ADDED
        log_message('debug', 'New Students to create: ' . print_r($new_students, true));
        log_message('debug', 'New Branches to create: ' . print_r($new_branches, true)); // ADDED
        
        // Validation
        if (empty($fkStudent_id) || !is_array($fkStudent_id)) {
            echo json_encode(['status' => 'error', 'message' => 'At least one record is required']);
            return;
        }
        
        // Create mapping arrays
        $student_mapping = [];
        $branch_mapping = []; // ADDED
        $class_mapping = [];
        $institute_mapping = [];
        $year_mapping = [];
        
        $masters_created = [
            'students' => 0,
            'branches' => 0, // ADDED
            'classes' => 0,
            'institutes' => 0,
            'years' => 0
        ];
        
        // Insert new students
        foreach ($new_students as $student_name) {
            if (!empty($student_name)) {
                $existing_id = $this->UGfellow_model->getStudentIdByName($student_name);
                
                if ($existing_id) {
                    $student_mapping['NEW::' . $student_name] = $existing_id;
                } else {
                    $student_data = [
                        'FullName' => $student_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_student_id = $this->UGfellow_model->insertstudent($student_data);
                    if ($new_student_id) {
                        $student_mapping['NEW::' . $student_name] = $new_student_id;
                        $masters_created['students']++;
                    }
                }
            }
        }
        
        // Insert new branches - ADDED
        foreach ($new_branches as $branch_name) {
            if (!empty($branch_name)) {
                $existing_id = $this->UGfellow_model->getBranchIdByName($branch_name);
                
                if ($existing_id) {
                    $branch_mapping['NEW::' . $branch_name] = $existing_id;
                    log_message('debug', "Branch already exists: {$branch_name} with ID: {$existing_id}");
                } else {
                    $branch_data = [
                        'branch_name' => $branch_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_branch_id = $this->UGfellow_model->insertbranch($branch_data);
                    if ($new_branch_id) {
                        $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
                        $masters_created['branches']++;
                        log_message('debug', "Created new branch: {$branch_name} with ID: {$new_branch_id}");
                    }
                }
            }
        }
        
        // Insert new classes
        foreach ($new_classes as $class_name) {
            if (!empty($class_name)) {
                $existing_id = $this->UGfellow_model->getClassIdByName($class_name);
                
                if ($existing_id) {
                    $class_mapping['NEW::' . $class_name] = $existing_id;
                } else {
                    $class_data = [
                        'classname' => $class_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_class_id = $this->UGfellow_model->insertclass($class_data);
                    if ($new_class_id) {
                        $class_mapping['NEW::' . $class_name] = $new_class_id;
                        $masters_created['classes']++;
                    }
                }
            }
        }
        
        // Insert new institutes
        foreach ($new_institutes as $institute_name) {
            if (!empty($institute_name)) {
                $existing_id = $this->UGfellow_model->getinstituteIdByName($institute_name);
                
                if ($existing_id) {
                    $institute_mapping['NEW::' . $institute_name] = $existing_id;
                } else {
                    $institute_data = [
                        'Institu_name' => $institute_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_institute_id = $this->UGfellow_model->insertinstitute($institute_data);
                    if ($new_institute_id) {
                        $institute_mapping['NEW::' . $institute_name] = $new_institute_id;
                        $masters_created['institutes']++;
                    }
                }
            }
        }
        
        // Insert new years
        foreach ($new_years as $year_name) {
            if (!empty($year_name)) {
                $existing_id = $this->UGfellow_model->getYearIdByName($year_name);
                
                if ($existing_id) {
                    $year_mapping['NEW::' . $year_name] = $existing_id;
                } else {
                    $year_data = [
                        'fini_Label' => $year_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_year_id = $this->UGfellow_model->insertYear($year_data);
                    if ($new_year_id) {
                        $year_mapping['NEW::' . $year_name] = $new_year_id;
                        $masters_created['years']++;
                    }
                }
            }
        }
        
        log_message('debug', 'Branch Mapping: ' . print_r($branch_mapping, true)); // ADDED
        
        // Handle excel file upload
        $excel_name = null;
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'xlsx|xls';
            $config['max_size'] = 10240;
            $config['file_name'] = 'ugfellow_excel_' . time() . '_' . $_FILES['excel_file']['name'];
            $config['overwrite'] = FALSE;
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
            }
        }

        $inserted_count = 0;
        $failed_count = 0;
        $total_rows = count($fkStudent_id);

        // Insert all UG Fellowship records
        for ($i = 0; $i < $total_rows; $i++) {
            // Get and resolve student ID
            $student_id = $fkStudent_id[$i];
            if (empty($student_id)) {
                $failed_count++;
                continue;
            }
            
            if (strpos($student_id, 'NEW::') === 0) {
                if (isset($student_mapping[$student_id])) {
                    $student_id = $student_mapping[$student_id];
                } else {
                    $failed_count++;
                    continue;
                }
            }
            
            // Get and resolve branch ID - ADDED
            $branch_id = isset($fkbranch_id[$i]) && !empty($fkbranch_id[$i]) ? $fkbranch_id[$i] : null;
            if ($branch_id && strpos($branch_id, 'NEW::') === 0) {
                if (isset($branch_mapping[$branch_id])) {
                    $branch_id = $branch_mapping[$branch_id];
                    log_message('debug', "Row {$i}: Mapped branch to ID: {$branch_id}");
                } else {
                    log_message('warning', "Row {$i}: Branch mapping not found for: {$branch_id}, setting to null");
                    $branch_id = null;
                }
            }
           
            // Get and resolve class ID
            $class_id = isset($fkclass_id[$i]) && !empty($fkclass_id[$i]) ? $fkclass_id[$i] : null;
            if ($class_id && strpos($class_id, 'NEW::') === 0) {
                if (isset($class_mapping[$class_id])) {
                    $class_id = $class_mapping[$class_id];
                } else {
                    $class_id = null;
                }
            }
            
            // Get and resolve institute ID
            $institute_id = isset($institute[$i]) && !empty($institute[$i]) ? $institute[$i] : null;
            if ($institute_id && strpos($institute_id, 'NEW::') === 0) {
                if (isset($institute_mapping[$institute_id])) {
                    $institute_id = $institute_mapping[$institute_id];
                } else {
                    $institute_id = null;
                }
            }
            
            // Get and resolve year ID
            $year_id = isset($finicial_Year[$i]) && !empty($finicial_Year[$i]) ? $finicial_Year[$i] : null;
            if ($year_id && strpos($year_id, 'NEW::') === 0) {
                if (isset($year_mapping[$year_id])) {
                    $year_id = $year_mapping[$year_id];
                } else {
                    $year_id = null;
                }
            }
            
            // Prepare data for insertion
            $fellowData = array(
                'prn' => isset($prn[$i]) && !empty($prn[$i]) ? $prn[$i] : null,
                'fkStudent_id' => $student_id,
                'fkbranch_id' => $branch_id, // ADDED
                'fkclass_id' => $class_id,
                'Division' => isset($Division[$i]) && !empty($Division[$i]) ? $Division[$i] : null,
                'project_name' => isset($project_name[$i]) && !empty($project_name[$i]) ? $project_name[$i] : null,
                'Contact' => isset($Contact[$i]) && !empty($Contact[$i]) ? $Contact[$i] : null,
                'institute' => $institute_id,
                'Photo_Url' => isset($Photo_Url[$i]) && !empty($Photo_Url[$i]) ? $Photo_Url[$i] : null,
                'gurd_name' => isset($gurd_name[$i]) && !empty($gurd_name[$i]) ? $gurd_name[$i] : null,
                'finicial_Year' => $year_id,
                'excel_file' => $excel_name,
                'is_on' => 1,
                'is_active' => 1,
                'created_date' => date('Y-m-d H:i:s'),
                'created_by'=>$_SESSION['userID']
            );

            log_message('debug', "Inserting row {$i}: " . print_r($fellowData, true));
$inserted_id = $this->UGfellow_model->insertICTTool($fellowData);

if ($inserted_id) {

    $inserted_count++;

    // $sub_id = $inserted_id;

    // Insert log - Action 1 (Insert)
    $action     = 1;
    $record_id = $inserted_id;
    $excel_name = null;
    $Fk_branch  = $branch_id;

    insert_log(
        $this,
        $fk_submenuId,
        $action,
        $record_id,
        $excel_name,
        $Fk_branch,
        $_SESSION['userID']
    );
}

            // if ($this->UGfellow_model->insertICTTool($fellowData)) {
            //     $inserted_count++;
            // }
             else {
                $failed_count++;
            }
        }

        // Prepare response
        if ($inserted_count > 0) {
            $message = "Successfully saved {$inserted_count} out of {$total_rows} UG Fellowship records";
            if ($failed_count > 0) {
                $message .= ". {$failed_count} records failed or were skipped.";
            }
            
            echo json_encode([
                'status' => 'success', 
                'inserted_count' => $inserted_count,
                'failed_count' => $failed_count,
                'total_rows' => $total_rows,
                'masters_created' => $masters_created,
                'message' => $message
            ]);
        } else {
            echo json_encode([
                'status' => 'error', 
                'message' => "No records were saved. Total rows: {$total_rows}, Failed: {$failed_count}"
            ]);
        }
        
    } catch (Exception $e) {
        log_message('error', 'UG Fellowship insertion error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}
    // ICTtools Controller mein yeh methods add karein

// UGfellow Controller mein ye methods add karein

public function update($UG_id)
{
    // Get existing record
    $data['record'] = $this->UGfellow_model->getUGfellowById($UG_id);
    
    if (!$data['record']) {
        show_404();
        return;
    }
    
    // Get master data for dropdowns
    $data['studentdata'] = $this->UGfellow_model->getstudent();
    $data['branchdata'] = $this->UGfellow_model->getbranch();
     $data['classdata'] = $this->UGfellow_model->getclass();
    $data['institutedata'] = $this->UGfellow_model->getinstitute();
    $data['yeardata'] = $this->UGfellow_model->getyear();
    $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
    $this->load->view('admin/UGfellow_view.php', $data);
    $this->load->view('admin/footer_view');
}

public function updateUGfellow()
{
    try {
        $this->output->set_content_type('application/json');
        
        $UG_id = $this->input->post('UG_id');
        
        if (empty($UG_id)) {
            echo json_encode(['status' => 'error', 'message' => 'UG Fellowship ID is required']);
            return;
        }
        
        // Get form data - Arrays
        $prn = $this->input->post('prn');
        $fkStudent_id = $this->input->post('fkStudent_id');
        $fkbranch_id = $this->input->post('fkbranch_id'); // ADDED
        $fkclass_id = $this->input->post('fkclass_id');
        $Division = $this->input->post('Division');
        $project_name = $this->input->post('project_name');
        $Contact = $this->input->post('Contact');
        $institute = $this->input->post('institute');
        $Photo_Url = $this->input->post('Photo_Url');
        $gurd_name = $this->input->post('gurd_name');
        $finicial_Year = $this->input->post('finicial_Year');
        $fk_submenuId = $this->input->post('fk_submenuId');

        if (empty($fkStudent_id) || !is_array($fkStudent_id) || empty($fkStudent_id[0])) {
            echo json_encode(['status' => 'error', 'message' => 'Student is required']);
            return;
        }
        
        // Get new master data
        $new_students = json_decode($this->input->post('new_students'), true) ?: [];
        $new_branches = json_decode($this->input->post('new_branches'), true) ?: []; // ADDED
        $new_classes = json_decode($this->input->post('new_classes'), true) ?: [];
        $new_institutes = json_decode($this->input->post('new_institutes'), true) ?: [];
        $new_years = json_decode($this->input->post('new_years'), true) ?: [];
        
        // Create mapping arrays
        $student_mapping = [];
        $branch_mapping = []; // ADDED
        $class_mapping = [];
        $institute_mapping = [];
        $year_mapping = [];
        
        // Insert new students
        foreach ($new_students as $student_name) {
            if (!empty($student_name)) {
                $existing_id = $this->UGfellow_model->getStudentIdByName($student_name);
                
                if ($existing_id) {
                    $student_mapping['NEW::' . $student_name] = $existing_id;
                } else {
                    $student_data = [
                        'FullName' => $student_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_student_id = $this->UGfellow_model->insertstudent($student_data);
                    if ($new_student_id) {
                        $student_mapping['NEW::' . $student_name] = $new_student_id;
                    }
                }
            }
        }
        
        // Insert new branches - ADDED
        foreach ($new_branches as $branch_name) {
            if (!empty($branch_name)) {
                $existing_id = $this->UGfellow_model->getBranchIdByName($branch_name);
                
                if ($existing_id) {
                    $branch_mapping['NEW::' . $branch_name] = $existing_id;
                } else {
                    $branch_data = [
                        'branch_name' => $branch_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_branch_id = $this->UGfellow_model->insertbranch($branch_data);
                    if ($new_branch_id) {
                        $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
                    }
                }
            }
        }
        
        // Insert new classes
        foreach ($new_classes as $class_name) {
            if (!empty($class_name)) {
                $existing_id = $this->UGfellow_model->getClassIdByName($class_name);
                
                if ($existing_id) {
                    $class_mapping['NEW::' . $class_name] = $existing_id;
                } else {
                    $class_data = [
                        'classname' => $class_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_class_id = $this->UGfellow_model->insertclass($class_data);
                    if ($new_class_id) {
                        $class_mapping['NEW::' . $class_name] = $new_class_id;
                    }
                }
            }
        }
        
        // Insert new institutes
        foreach ($new_institutes as $institute_name) {
            if (!empty($institute_name)) {
                $existing_id = $this->UGfellow_model->getinstituteIdByName($institute_name);
                
                if ($existing_id) {
                    $institute_mapping['NEW::' . $institute_name] = $existing_id;
                } else {
                    $institute_data = [
                        'Institu_name' => $institute_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_institute_id = $this->UGfellow_model->insertinstitute($institute_data);
                    if ($new_institute_id) {
                        $institute_mapping['NEW::' . $institute_name] = $new_institute_id;
                    }
                }
            }
        }
        
        // Insert new years
        foreach ($new_years as $year_name) {
            if (!empty($year_name)) {
                $existing_id = $this->UGfellow_model->getYearIdByName($year_name);
                
                if ($existing_id) {
                    $year_mapping['NEW::' . $year_name] = $existing_id;
                } else {
                    $year_data = [
                        'fini_Label' => $year_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_year_id = $this->UGfellow_model->insertYear($year_data);
                    if ($new_year_id) {
                        $year_mapping['NEW::' . $year_name] = $new_year_id;
                    }
                }
            }
        }
        
        // Get first row data
        $student_val = $fkStudent_id[0];
        $branch_val = isset($fkbranch_id[0]) ? $fkbranch_id[0] : null; // ADDED
        $class_val = isset($fkclass_id[0]) ? $fkclass_id[0] : null;
        $prn_val = isset($prn[0]) ? $prn[0] : null;
        $division_val = isset($Division[0]) ? $Division[0] : null;
        $project_val = isset($project_name[0]) ? $project_name[0] : null;
        $contact_val = isset($Contact[0]) ? $Contact[0] : null;
        $institute_val = isset($institute[0]) ? $institute[0] : null;
        $photo_url_val = isset($Photo_Url[0]) ? $Photo_Url[0] : null;
        $gurd_val = isset($gurd_name[0]) ? $gurd_name[0] : null;
        $year_val = isset($finicial_Year[0]) ? $finicial_Year[0] : null;
        
        // Resolve student ID
        $resolved_student_id = $student_val;
        if (strpos($student_val, 'NEW::') === 0) {
            if (isset($student_mapping[$student_val])) {
                $resolved_student_id = $student_mapping[$student_val];
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Student mapping not found']);
                return;
            }
        }
        
        // Resolve branch ID - ADDED
        $resolved_branch_id = $branch_val;
        if ($branch_val && strpos($branch_val, 'NEW::') === 0) {
            if (isset($branch_mapping[$branch_val])) {
                $resolved_branch_id = $branch_mapping[$branch_val];
            } else {
                $resolved_branch_id = null;
            }
        }
        
        // Resolve class ID
        $resolved_class_id = $class_val;
        if ($class_val && strpos($class_val, 'NEW::') === 0) {
            if (isset($class_mapping[$class_val])) {
                $resolved_class_id = $class_mapping[$class_val];
            } else {
                $resolved_class_id = null;
            }
        }
        
        // Resolve institute ID
        $resolved_institute_id = $institute_val;
        if ($institute_val && strpos($institute_val, 'NEW::') === 0) {
            if (isset($institute_mapping[$institute_val])) {
                $resolved_institute_id = $institute_mapping[$institute_val];
            } else {
                $resolved_institute_id = null;
            }
        }
        
        // Resolve year ID
        $resolved_year_id = $year_val;
        if ($year_val && strpos($year_val, 'NEW::') === 0) {
            if (isset($year_mapping[$year_val])) {
                $resolved_year_id = $year_mapping[$year_val];
            } else {
                $resolved_year_id = null;
            }
        }
        
        // Handle excel file upload
        $excel_name = null;
        $existing_record = $this->UGfellow_model->getUGfellowById($UG_id);
        
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'xlsx|xls';
            $config['max_size'] = 10240;
            $config['file_name'] = 'ugfellow_excel_' . time() . '_' . $_FILES['excel_file']['name'];
            $config['overwrite'] = FALSE;
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
                
                if ($existing_record && !empty($existing_record->excel_file)) {
                    $old_file = $upload_path . $existing_record->excel_file;
                    if (file_exists($old_file)) {
                        unlink($old_file);
                    }
                }
            }
        } else {
            $excel_name = $existing_record ? $existing_record->excel_file : null;
        }
        
        // Prepare update data - BRANCH ADDED
        $updateData = array(
            'fkStudent_id' => $resolved_student_id,
            'fkbranch_id' => $resolved_branch_id, // ADDED THIS LINE
            'fkclass_id' => $resolved_class_id,
            'prn' => $prn_val,
            'Division' => $division_val,
            'project_name' => $project_val,
            'Contact' => $contact_val,
            'institute' => $resolved_institute_id,
            'Photo_Url' => $photo_url_val,
            'gurd_name' => $gurd_val,
            'finicial_Year' => $resolved_year_id,
            'excel_file' => $excel_name,
            'modified_date' => date('Y-m-d H:i:s'),
            'modified_by'=>$_SESSION['userID']
        );
        
        log_message('debug', 'Update data: ' . print_r($updateData, true));
        
        if ($this->UGfellow_model->updateUGfellow($UG_id, $updateData)) {
// Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $UG_id;
        $excel_name = null;
        $Fk_branch = $resolved_branch_id;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

            echo json_encode([
                'status' => 'success',
                'message' => 'UG Fellowship updated successfully!'
            ]);
        }
        
        else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to update UG Fellowship'
            ]);
        }
        
    } catch (Exception $e) {
        log_message('error', 'UG Fellowship update error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}
}