<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('User_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    // List all users
    public function index()
    {
        $data['alldata'] = $this->User_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/User_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    // Create new user form
    public function create()
    {
        $data['facultydata'] = $this->User_model->getfaculty();
        $data['roledata'] = $this->User_model->getRole();
        $data['branchdata'] = $this->User_model->getBranch();
        $data['hosteldata'] = $this->User_model->getHostel();
        $data['menudata'] = $this->User_model->getMenusWithSubmenus();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/User_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    // Insert new user
    public function insertUser()
    {
        $UserName = $this->input->post('UserName');
        $Password = $this->input->post('Password');
        $fkfaculty_ID = $this->input->post('fkfaculty_ID');
        $fkRole_id = $this->input->post('fkRole_id');
        $fkBranch_Id = $this->input->post('fkBranch_Id'); // Array of branch IDs
        $fkHostel_Id = $this->input->post('fkHostel_Id'); 
        $RecoveryMail_ID = $this->input->post('RecoveryMail_ID');
        
        // Check if username already exists for this faculty
        if ($this->User_model->checkUsernameExists($UserName, $fkfaculty_ID)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Username already exists for this faculty. Please choose a different username.'
            ]);
            return;
        }
        
        // Validate that at least one branch is selected
        if (empty($fkBranch_Id) || !is_array($fkBranch_Id)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please select at least one branch.'
            ]);
            return;
        }
        
        // Get selected menus and submenus
        $menu_ids = $this->input->post('menu_ids'); // Array
        $submenu_ids = $this->input->post('submenu_ids'); // Array

        // Convert branch array to comma-separated string
        $branch_ids_string = implode(',', $fkBranch_Id);
        $hostel_ids_string = !empty($fkHostel_Id) ? implode(',', $fkHostel_Id) : ''; 

        // Prepare user data
        $fields = array(
            'UserName' => $UserName,
            'Password' => $Password, // Consider hashing password: password_hash($Password, PASSWORD_DEFAULT)
            'fkfaculty_ID' => $fkfaculty_ID,
            'fkRole_id' => $fkRole_id,
            'fkBranch_Id' => $branch_ids_string, // Store as comma-separated string
            'fkHostel_Id' => $hostel_ids_string,
            'RecoveryMail_ID' => $RecoveryMail_ID,
            'is_default' => 1,
            'is_on' => 1,
            'is_active' => 1,
            'created_date' => date('Y-m-d H:i:s')
        );

        // Insert user
        if ($this->User_model->insertdata($fields)) {
            $user_id = $this->db->insert_id();
            
            // Insert menu and submenu access
            $this->User_model->insertUserAccess($user_id, $menu_ids, $submenu_ids);
            
            echo json_encode([
                'status' => 'success',
                'message' => 'User created successfully'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to create user'
            ]);
        }
    }

    // Edit user form
    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->User_model->getbyid($id);
        $data['facultydata'] = $this->User_model->getfaculty();
        $data['roledata'] = $this->User_model->getRole();
        $data['branchdata'] = $this->User_model->getBranch();
        $data['hosteldata'] = $this->User_model->getHostel();
        $data['menudata'] = $this->User_model->getMenusWithSubmenus();
        
        // Get user's current menu access
        if (!empty($data['data'])) {
            $data['user_access'] = $this->User_model->getUserMenuAccess($id);
        }

        $this->load->view('admin/header_view');
        $this->load->view('admin/User_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    // Update existing user
    public function updateUser()
    {
        $UserID = $this->input->post('UserID');
        $UserName = $this->input->post('UserName');
        $Password = $this->input->post('Password');
        $fkfaculty_ID = $this->input->post('fkfaculty_ID');
        $fkRole_id = $this->input->post('fkRole_id');
        $fkBranch_Id = $this->input->post('fkBranch_Id'); // Array of branch IDs
        $fkHostel_Id = $this->input->post('fkHostel_Id');
        $RecoveryMail_ID = $this->input->post('RecoveryMail_ID');
        
        // Check if username already exists for this faculty (excluding current user)
        if ($this->User_model->checkUsernameExists($UserName, $fkfaculty_ID, $UserID)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Username already exists for this faculty. Please choose a different username.'
            ]);
            return;
        }
        
        // Validate that at least one branch is selected
        if (empty($fkBranch_Id) || !is_array($fkBranch_Id)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please select at least one branch.'
            ]);
            return;
        }
        
        // Get selected menus and submenus
        $menu_ids = $this->input->post('menu_ids');
        $submenu_ids = $this->input->post('submenu_ids');

        // Convert branch array to comma-separated string
        $branch_ids_string = implode(',', $fkBranch_Id);
         $hostel_ids_string = !empty($fkHostel_Id) ? implode(',', $fkHostel_Id) : '';

        // Prepare user data
        $fields = array(
            'UserID' => $UserID,
            'UserName' => $UserName,
            'fkfaculty_ID' => $fkfaculty_ID,
            'fkRole_id' => $fkRole_id,
            'fkBranch_Id' => $branch_ids_string, // Store as comma-separated string
            'fkHostel_Id' => $hostel_ids_string,
            'RecoveryMail_ID' => $RecoveryMail_ID
        );

        // Only update password if provided
        if (!empty($Password)) {
            $fields['Password'] = $Password; // Consider hashing: password_hash($Password, PASSWORD_DEFAULT)
        }

        // Update user
        if ($this->User_model->update($fields)) {
            // Update menu and submenu access
            $this->User_model->updateUserAccess($UserID, $menu_ids, $submenu_ids);
            
            echo json_encode([
                'status' => 'success',
                'message' => 'User updated successfully'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to update user'
            ]);
        }
    }

    // Dashboard
    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/dashboard_view');
        $this->load->view('admin/footer_view');
    }
}