<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class VAP extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('VAP_model');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->load->library('upload');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/VAP_dash_view.php');
        $this->load->view('admin/footer_view');
    }

    public function index()
    {
        $data['alldata'] = $this->VAP_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/VAP_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['branchdata'] = $this->VAP_model->getbranch();
        $data['classdata'] = $this->VAP_model->getclass();
        $data['companydata'] = $this->VAP_model->getcompany();
        $data['yeardata'] = $this->VAP_model->getyear();
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/VAP_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    
   public function insertvap()
{
    try {
        $this->output->set_content_type('application/json');

        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $institute_id = $institute ? $institute->Institu_id : null;
        
        // ✅ Get table data from JSON
        $table_data_json = $this->input->post('table_data');
        $table_data = json_decode($table_data_json, true);
        
        if (empty($table_data) || !is_array($table_data)) {
            echo json_encode(['status' => 'error', 'message' => 'No data received']);
            return;
        }

        $fk_submenuId = $this->input->post('fk_submenuId');
        $new_branches = json_decode($this->input->post('new_branches'), true) ?: [];
        $new_classes = json_decode($this->input->post('new_classes'), true) ?: [];
        $new_companies = json_decode($this->input->post('new_companies'), true) ?: [];
        $new_years = json_decode($this->input->post('new_years'), true) ?: [];
        
        log_message('debug', 'Table data received: ' . print_r($table_data, true));
        
        // Create mapping arrays
        $branch_mapping = [];
        $class_mapping = [];
        $company_mapping = [];
        $year_mapping = [];
        
        $masters_created = [
            'branches' => 0,
            'classes' => 0,
            'companies' => 0,
            'years' => 0
        ];
        
        // Insert new branches
        foreach ($new_branches as $branch_name) {
            if (!empty($branch_name)) {
                $existing_id = $this->VAP_model->getBranchIdByName($branch_name);
                
                if ($existing_id) {
                    $branch_mapping['NEW::' . $branch_name] = $existing_id;
                } else {
                    $new_branch_id = $this->VAP_model->insert_branch($branch_name);
                    if ($new_branch_id) {
                        $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
                        $masters_created['branches']++;
                    }
                }
            }
        }
        
        // Insert new classes
        foreach ($new_classes as $class_name) {
            if (!empty($class_name)) {
                $existing_id = $this->VAP_model->getClassIdByName($class_name);
                
                if ($existing_id) {
                    $class_mapping['NEW::' . $class_name] = $existing_id;
                } else {
                    $new_class_id = $this->VAP_model->insert_class($class_name);
                    if ($new_class_id) {
                        $class_mapping['NEW::' . $class_name] = $new_class_id;
                        $masters_created['classes']++;
                    }
                }
            }
        }
        
        // Insert new companies
        foreach ($new_companies as $company_name) {
            if (!empty($company_name)) {
                $existing_id = $this->VAP_model->getCompanyIdByName($company_name);
                
                if ($existing_id) {
                    $company_mapping['NEW::' . $company_name] = $existing_id;
                } else {
                    $new_company_id = $this->VAP_model->insert_company($company_name);
                    if ($new_company_id) {
                        $company_mapping['NEW::' . $company_name] = $new_company_id;
                        $masters_created['companies']++;
                    }
                }
            }
        }
        
        // Insert new years
        foreach ($new_years as $year_name) {
            if (!empty($year_name)) {
                $existing_id = $this->VAP_model->getYearIdByName($year_name);
                
                if ($existing_id) {
                    $year_mapping['NEW::' . $year_name] = $existing_id;
                } else {
                    $new_year_id = $this->VAP_model->insert_year($year_name);
                    if ($new_year_id) {
                        $year_mapping['NEW::' . $year_name] = $new_year_id;
                        $masters_created['years']++;
                    }
                }
            }
        }
        
        // Handle excel file upload
        $excel_name = null;
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'xlsx|xls';
            $config['max_size'] = 10240;
            $config['file_name'] = 'vap_excel_' . time() . '_' . $_FILES['excel_file']['name'];
            $config['overwrite'] = FALSE;
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
            }
        }
        
        // ✅ Handle feedback files with index mapping
        $feedback_indices = json_decode($this->input->post('feedback_indices'), true) ?: [];
        $feedback_files = [];
        
        if (!empty($feedback_indices)) {
            $feedback_path = './uploads/feedback/';
            if (!is_dir($feedback_path)) {
                mkdir($feedback_path, 0777, true);
            }
            
            foreach ($feedback_indices as $index) {
                $file_key = 'feedback_' . $index;
                
                if (isset($_FILES[$file_key]) && $_FILES[$file_key]['error'] == 0) {
                    $_FILES['single_feedback']['name'] = $_FILES[$file_key]['name'];
                    $_FILES['single_feedback']['type'] = $_FILES[$file_key]['type'];
                    $_FILES['single_feedback']['tmp_name'] = $_FILES[$file_key]['tmp_name'];
                    $_FILES['single_feedback']['error'] = $_FILES[$file_key]['error'];
                    $_FILES['single_feedback']['size'] = $_FILES[$file_key]['size'];
                    
                    $config['upload_path'] = $feedback_path;
                    $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
                    $config['max_size'] = 5120;
                    $config['file_name'] = 'feedback_' . time() . '_' . $index . '_' . $_FILES['single_feedback']['name'];
                    
                    $this->upload->initialize($config);
                    
                    if ($this->upload->do_upload('single_feedback')) {
                        $upload_data = $this->upload->data();
                        $feedback_files[$index] = $upload_data['file_name'];
                    }
                }
            }
        }

        $inserted_count = 0;
        $failed_count = 0;
        $total_rows = count($table_data);

        // ✅ Insert all VAP records from JSON data
        foreach ($table_data as $i => $row) {
            if (empty($row['prn']) || trim($row['prn']) == '') {
                $failed_count++;
                continue;
            }
            
            // Resolve IDs
            $resolved_branch_id = $row['branch_id'];
            if ($resolved_branch_id && strpos($resolved_branch_id, 'NEW::') === 0) {
                $resolved_branch_id = isset($branch_mapping[$resolved_branch_id]) ? $branch_mapping[$resolved_branch_id] : null;
            }
            
            $resolved_class_id = $row['class_id'];
            if ($resolved_class_id && strpos($resolved_class_id, 'NEW::') === 0) {
                $resolved_class_id = isset($class_mapping[$resolved_class_id]) ? $class_mapping[$resolved_class_id] : null;
            }
            
            $resolved_company_id = $row['company_id'];
            if ($resolved_company_id && strpos($resolved_company_id, 'NEW::') === 0) {
                $resolved_company_id = isset($company_mapping[$resolved_company_id]) ? $company_mapping[$resolved_company_id] : null;
            }
            
            $resolved_year_id = $row['year'];
            if ($resolved_year_id && strpos($resolved_year_id, 'NEW::') === 0) {
                $resolved_year_id = isset($year_mapping[$resolved_year_id]) ? $year_mapping[$resolved_year_id] : null;
            }
            
            $vapData = array(
                'prn' => trim($row['prn']),
                'Student_name' => trim($row['student_name']),
                'fkbranch_id' => $resolved_branch_id,
                'fkclass_id' => $resolved_class_id,
                'Division' => trim($row['division']),
                'Vap_tittle' => trim($row['vap_title']),
                'resource_person_name' => trim($row['resource_person_name']),
                'resource_person_contact' => trim($row['resource_person_contact']),
                'Company_name' => $resolved_company_id,
                'Address' => trim($row['address']),
                'Vap_Start' => !empty($row['vap_start_date']) ? $row['vap_start_date'] : null,
                'Vap_End' => !empty($row['vap_end_date']) ? $row['vap_end_date'] : null,
                'Photo_Url' => trim($row['photo_url']),
                'Feedback' => isset($feedback_files[$i]) ? $feedback_files[$i] : null,
                'finicial_Year' => $resolved_year_id,
                'institute' => $institute_id,
                'excel_file' => $excel_name,
                'created_by' => $_SESSION['userID']
            );

            log_message('debug', "Inserting row {$i}: " . print_r($vapData, true));

            $inserted_id = $this->VAP_model->insertVAP($vapData);

            if ($inserted_id) {
                $inserted_count++;

                $action = 1;
                $record_id = $inserted_id;
                $excel_name_log = null;
                $Fk_branch = null;

                insert_log(
                    $this,
                    $fk_submenuId,
                    $action,
                    $record_id,
                    $excel_name_log,
                    $Fk_branch,
                    $_SESSION['userID']
                );
            } else {
                $failed_count++;
            }
        }

        if ($inserted_count > 0) {
            $message = "Successfully saved {$inserted_count} out of {$total_rows} VAP records";
            if ($failed_count > 0) {
                $message .= ". {$failed_count} records failed or were skipped.";
            }
            
            echo json_encode([
                'status' => 'success', 
                'inserted_count' => $inserted_count,
                'failed_count' => $failed_count,
                'total_rows' => $total_rows,
                'masters_created' => $masters_created,
                'message' => $message
            ]);
        } else {
            echo json_encode([
                'status' => 'error', 
                'message' => "No records were saved. Total rows: {$total_rows}, Failed: {$failed_count}"
            ]);
        }
        
    } catch (Exception $e) {
        log_message('error', 'VAP insertion error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}
    


public function update($vap_id)
{
    // Get existing record
    $data['record'] = $this->VAP_model->getVAPById($vap_id);
    
    if (!$data['record']) {
        show_404();
        return;
    }
    
    // Get master data for dropdowns
    $data['branchdata'] = $this->VAP_model->getbranch();
    $data['classdata'] = $this->VAP_model->getclass();
    $data['companydata'] = $this->VAP_model->getcompany();
    $data['yeardata'] = $this->VAP_model->getyear();
    
    // Set empty childData for update mode (we only show single record)
    $data['childData'] = [];
    $data['mainData'] = $data['record']; // For hidden vap_id field
    
$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
    $this->load->view('admin/VAP_view.php', $data);
    $this->load->view('admin/footer_view');
}

public function updateVAP()
{
    try {
        $this->output->set_content_type('application/json');
        
        $vap_id = $this->input->post('vap_id');
        
        if (empty($vap_id)) {
            echo json_encode(['status' => 'error', 'message' => 'VAP ID is required']);
            return;
        }
        
        // ✅ Get single field values (not arrays)
        $prn = $this->input->post('prn');
        $student_name = $this->input->post('student_name');
        $branch_id = $this->input->post('branch_id');
        $class_id = $this->input->post('class_id');
        $division = $this->input->post('division');
        $vap_title = $this->input->post('vap_title');
        $resource_person_name = $this->input->post('resource_person_name');
        $resource_person_contact = $this->input->post('resource_person_contact');
        $company_id = $this->input->post('company_id');
        $address = $this->input->post('address');
        $year = $this->input->post('year');
        $vap_start_date = $this->input->post('vap_start_date');
        $vap_end_date = $this->input->post('vap_end_date');
        $photo_url = $this->input->post('photo_url');
        $fk_submenuId = $this->input->post('fk_submenuId');
        
        // Get new master data
        $new_branches = json_decode($this->input->post('new_branches'), true) ?: [];
        $new_classes = json_decode($this->input->post('new_classes'), true) ?: [];
        $new_companies = json_decode($this->input->post('new_companies'), true) ?: [];
        $new_years = json_decode($this->input->post('new_years'), true) ?: [];
        
        // Create mapping arrays
        $branch_mapping = [];
        $class_mapping = [];
        $company_mapping = [];
        $year_mapping = [];
        
        $masters_created = [
            'branches' => 0,
            'classes' => 0,
            'companies' => 0,
            'years' => 0
        ];
        
        // Insert new branches
        foreach ($new_branches as $branch_name) {
            if (!empty($branch_name)) {
                $existing_id = $this->VAP_model->getBranchIdByName($branch_name);
                
                if ($existing_id) {
                    $branch_mapping['NEW::' . $branch_name] = $existing_id;
                } else {
                    $new_branch_id = $this->VAP_model->insert_branch($branch_name);
                    if ($new_branch_id) {
                        $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
                        $masters_created['branches']++;
                    }
                }
            }
        }
        
        // Insert new classes
        foreach ($new_classes as $class_name) {
            if (!empty($class_name)) {
                $existing_id = $this->VAP_model->getClassIdByName($class_name);
                
                if ($existing_id) {
                    $class_mapping['NEW::' . $class_name] = $existing_id;
                } else {
                    $new_class_id = $this->VAP_model->insert_class($class_name);
                    if ($new_class_id) {
                        $class_mapping['NEW::' . $class_name] = $new_class_id;
                        $masters_created['classes']++;
                    }
                }
            }
        }
        
        // Insert new companies
        foreach ($new_companies as $company_name) {
            if (!empty($company_name)) {
                $existing_id = $this->VAP_model->getCompanyIdByName($company_name);
                
                if ($existing_id) {
                    $company_mapping['NEW::' . $company_name] = $existing_id;
                } else {
                    $new_company_id = $this->VAP_model->insert_company($company_name);
                    if ($new_company_id) {
                        $company_mapping['NEW::' . $company_name] = $new_company_id;
                        $masters_created['companies']++;
                    }
                }
            }
        }
        
        // Insert new years
        foreach ($new_years as $year_name) {
            if (!empty($year_name)) {
                $existing_id = $this->VAP_model->getYearIdByName($year_name);
                
                if ($existing_id) {
                    $year_mapping['NEW::' . $year_name] = $existing_id;
                } else {
                    $new_year_id = $this->VAP_model->insert_year($year_name);
                    if ($new_year_id) {
                        $year_mapping['NEW::' . $year_name] = $new_year_id;
                        $masters_created['years']++;
                    }
                }
            }
        }
        
        // Resolve IDs
        $resolved_branch_id = $branch_id;
        if ($branch_id && strpos($branch_id, 'NEW::') === 0) {
            $resolved_branch_id = isset($branch_mapping[$branch_id]) ? $branch_mapping[$branch_id] : null;
        }
        
        $resolved_class_id = $class_id;
        if ($class_id && strpos($class_id, 'NEW::') === 0) {
            $resolved_class_id = isset($class_mapping[$class_id]) ? $class_mapping[$class_id] : null;
        }
        
        $resolved_company_id = $company_id;
        if ($company_id && strpos($company_id, 'NEW::') === 0) {
            $resolved_company_id = isset($company_mapping[$company_id]) ? $company_mapping[$company_id] : null;
        }
        
        $resolved_year_id = $year;
        if ($year && strpos($year, 'NEW::') === 0) {
            $resolved_year_id = isset($year_mapping[$year]) ? $year_mapping[$year] : null;
        }
        
        // Get existing record
        $existing_record = $this->VAP_model->getVAPById($vap_id);
        
        if (!$existing_record) {
            echo json_encode(['status' => 'error', 'message' => 'VAP record not found']);
            return;
        }
        
        // Handle excel file upload
        $excel_name = $existing_record->excel_file;
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'xlsx|xls';
            $config['file_name'] = 'vap_excel_' . time() . '_' . $_FILES['excel_file']['name'];
            $config['overwrite'] = FALSE;
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
                
                // Delete old file
                if (!empty($existing_record->excel_file)) {
                    $old_file = $upload_path . $existing_record->excel_file;
                    if (file_exists($old_file)) {
                        @unlink($old_file);
                    }
                }
            }
        }
        
        // ✅ Handle feedback file upload - single file (not array)
        $feedback_name = $existing_record->Feedback;
        if (!empty($_FILES['feedback']['name'])) {
            $feedback_path = './uploads/feedback/';
            
            if (!is_dir($feedback_path)) {
                mkdir($feedback_path, 0777, true);
            }
            
            $config['upload_path'] = $feedback_path;
            $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
            $config['max_size'] = 5120;
            $config['file_name'] = 'feedback_' . time() . '_' . $_FILES['feedback']['name'];
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('feedback')) {
                $upload_data = $this->upload->data();
                $feedback_name = $upload_data['file_name'];
                
                // Delete old feedback file
                if (!empty($existing_record->Feedback)) {
                    $old_file = $feedback_path . $existing_record->Feedback;
                    if (file_exists($old_file)) {
                        @unlink($old_file);
                    }
                }
            }
        }
        
        // Get institute ID
        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $institute_id = $institute ? $institute->Institu_id : null;
        
        // ✅ Prepare update data - single values
        $updateData = array(
            'prn' => trim($prn),
            'Student_name' => trim($student_name),
            'fkbranch_id' => $resolved_branch_id,
            'fkclass_id' => $resolved_class_id,
            'Division' => trim($division),
            'Vap_tittle' => trim($vap_title),
            'resource_person_name' => trim($resource_person_name),
            'resource_person_contact' => trim($resource_person_contact),
            'Company_name' => $resolved_company_id,
            'Address' => trim($address),
            'finicial_Year' => $resolved_year_id,
            'Vap_Start' => !empty($vap_start_date) ? $vap_start_date : null,
            'Vap_End' => !empty($vap_end_date) ? $vap_end_date : null,
            'Photo_Url' => trim($photo_url),
            'Feedback' => $feedback_name,
            'institute' => $institute_id,
            'excel_file' => $excel_name,
            'modified_by' => $this->session->userdata('userID')
        );
        
        log_message('debug', 'Update data: ' . print_r($updateData, true));
        
        if ($this->VAP_model->updateVAP($vap_id, $updateData)) {
            // Insert log - Action 2 (Update)
            $action = 2;
            $record_id = $vap_id;
            $excel_name_log = null;
            $Fk_branch = null;
            insert_log($this, $fk_submenuId, $action, $record_id, $excel_name_log, $Fk_branch, $this->session->userdata('userID'));

            $message = 'VAP record updated successfully!';
            if ($masters_created['branches'] > 0 || $masters_created['classes'] > 0 || $masters_created['companies'] > 0 || $masters_created['years'] > 0) {
                $message .= ' New master data created.';
            }

            echo json_encode([
                'status' => 'success',
                'message' => $message,
                'masters_created' => $masters_created
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to update VAP record'
            ]);
        }
        
    } catch (Exception $e) {
        log_message('error', 'VAP update error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}
}
?>