<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class VAPReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('VAPReport_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

public function Report()
{
    $data['yeardata'] = $this->VAPReport_model->getyear();
    $data['companydata'] = $this->VAPReport_model->getcompany();
    $data['institutedata'] = $this->VAPReport_model->getinstitu();
    $data['branchdata'] = $this->VAPReport_model->getbranch();
    $data['classdata'] = $this->VAPReport_model->getclass(); // NEW
    
    $this->load->view('admin/header_view');
    $this->load->view('admin/VAPReport_view.php',$data);
    $this->load->view('admin/footer_view');
}

public function getReportData()
{
    $institu   = $this->input->post('fk_institu');   // Institute
    $branches  = $this->input->post('fkbranch_id');  // Branch (multiple)
    $classes   = $this->input->post('fkclass_id');   // Class (multiple) - NEW
    $companies = $this->input->post('Company_name'); // Company (multiple)
    $year_id   = $this->input->post('year');         // Year
    $startDate = $this->input->post('startdate');    // Start Date
    $endDate   = $this->input->post('enddate');      // End Date

    // Call model with all filters
    $data = $this->VAPReport_model->getFilteredData(
        $institu, 
        $branches, 
        $companies, 
        $year_id, 
        $startDate, 
        $endDate,
        $classes  // Pass class parameter
    );

    echo json_encode($data);
}

public function getPrintHeadings()
{
    $data = $this->VAPReport_model->getPrintHeadings();
    echo json_encode($data);
}




public function getYearwiseData()
{
    $year = $this->input->post('year');
    $branches  = $this->input->post('branches');   // may be an array
    

    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->VAPReport_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year
        $summary = $this->VAPReport_model->getSingleYearData($year,$branches);
        $types   = $this->VAPReport_model->getYearwiseTypes($year,$branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS
 
    $result = $this->VAPReport_model->getBranchwiseCount($institu, $branches, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS
 
    $result = $this->VAPReport_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');
 
    $result = $this->VAPReport_model->getCombinedData($institu, $branches, $years, $startDate, $endDate);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}
 



}