<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class YearwiseAmountReport extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('YearwiseAmountReport_model');
        
        if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
        }
    }

    // Main report view
    public function Report()
    {
        $data['yeardata'] = $this->YearwiseAmountReport_model->getyear();
        $data['branchdata'] = $this->YearwiseAmountReport_model->getbranch();
        $data['institutedata'] = $this->YearwiseAmountReport_model->getinstitu();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/YearwiseAmountReport_view', $data);
        $this->load->view('admin/footer_view');
    }

    // Get year-wise amounts
   public function getYearwiseData()
    {
        $years    = $this->input->post('years');
        $branches = $this->input->post('branches');

        // Normalize: convert null / empty string arrays to empty array
        if (empty($years) || $years === [null] || $years === ['']) {
            $years = [];
        }
        if (empty($branches) || $branches === [null] || $branches === ['']) {
            $branches = [];
        }

        $yearData = $this->YearwiseAmountReport_model->getYearwiseAmount($years, $branches);

        echo json_encode([
            'status'   => 'success',
            'yearData' => $yearData,
            'count'    => count($yearData)
        ]);
    }

    // Get detailed grant entries
   public function getGrantDetails()
    {
        $years    = $this->input->post('years');
        $branches = $this->input->post('branches');

        if (empty($years) || $years === [null] || $years === ['']) {
            $years = [];
        }
        if (empty($branches) || $branches === [null] || $branches === ['']) {
            $branches = [];
        }

        if (empty($years)) {
            echo json_encode([
                'status'  => 'error',
                'message' => 'No years specified'
            ]);
            return;
        }

        $details = $this->YearwiseAmountReport_model->getGrantDetails($years, $branches);

        echo json_encode([
            'status' => 'success',
            'data'   => $details,
            'count'  => count($details)
        ]);
    }
    // Get print headings
    public function getPrintHeadings()
    {
        $data = $this->YearwiseAmountReport_model->getPrintHeadings();
        echo json_encode($data);
    }
    
    // TEST METHOD - Remove in production
    public function testData()
    {
        echo "<h2>Testing Database Queries</h2>";
        
        // Test 1: Check total grants
        echo "<h3>Test 1: Total Grants</h3>";
        $total = $this->db->query("SELECT COUNT(*) as total FROM grantrec_master")->row();
        echo "Total grants in database: " . $total->total . "<br><br>";
        
        // Test 2: Check years
        echo "<h3>Test 2: Available Years</h3>";
        $years = $this->db->query("
            SELECT DISTINCT finicial_Year, COUNT(*) as count 
            FROM grantrec_master 
            GROUP BY finicial_Year
        ")->result();
        echo "<pre>";
        print_r($years);
        echo "</pre>";
        
        // Test 3: Test the main query
        echo "<h3>Test 3: Year-wise Amount Query</h3>";
        $query = "
            SELECT 
                finiyear_master.finiYear_id,
                finiyear_master.fini_Label as year,
                SUM(grantrec_master.Amount_rec) as total_amount,
                COUNT(grantrec_master.Grant_id) as grant_count
            FROM grantrec_master
            LEFT JOIN finiyear_master ON finiyear_master.finiYear_id = grantrec_master.finicial_Year
            GROUP BY finiyear_master.finiYear_id, finiyear_master.fini_Label
            ORDER BY finiyear_master.finiYear_id DESC
        ";
        
        $result = $this->db->query($query)->result();
        echo "Query: " . $query . "<br><br>";
        echo "Results:<br><pre>";
        print_r($result);
        echo "</pre>";
        
        // Test 4: Check Amount format
        echo "<h3>Test 4: Amount Format Check</h3>";
        $amounts = $this->db->query("
            SELECT Grant_id, Amount_rec, 
                   (Amount_rec / 100000) as lakhs
            FROM grantrec_master 
            LIMIT 5
        ")->result();
        echo "<pre>";
        print_r($amounts);
        echo "</pre>";
    }
}