<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Leave extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Heads_model');
        
    }


   
     public function index()
	{
        $login_fac_id = $this->session->userdata('fac_id'); // ✅ Get currently logged in faculty id
    $data['alldata'] = $this->Heads_model->getdetailview(); // ✅ pass fac_id
        $designation_id = $this->session->userdata('designation');
$data['designation'] = $designation_id; // ✅ pass to view

        
		$this->load->view('Heads/header_view');
        $this->load->view('Heads/Leave_detailview',$data);
		$this->load->view('Heads/footer_view');
	

	}
         public function Verify()
	{
        $login_fac_id = $this->session->userdata('fac_id'); // ✅ Get currently logged in faculty id
    $data['alldata'] = $this->Heads_model->getverifydetailview(); // ✅ pass fac_id
        
        
		$this->load->view('Heads/header_view');
        $this->load->view('Heads/Leave_verify',$data);
		$this->load->view('Heads/footer_view');
	

	}
             public function RegVerify()
	{
        $login_fac_id = $this->session->userdata('fac_id'); // ✅ Get currently logged in faculty id
    $data['alldata'] = $this->Heads_model->getRegverifydetailview(); // ✅ pass fac_id
        
        
		$this->load->view('Heads/header_view');
        $this->load->view('Heads/Leave_RegVerify',$data);
		$this->load->view('Heads/footer_view');
	

	}
    public function PrincipleVerify()
	{
        $login_fac_id = $this->session->userdata('fac_id'); // ✅ Get currently logged in faculty id
    $data['alldata'] = $this->Heads_model->getPrincipleverifydetailview(); // ✅ pass fac_id
        
        
		$this->load->view('Heads/header_view');
        $this->load->view('Heads/Leave_Principle',$data);
		$this->load->view('Heads/footer_view');
	

	}
public function create()
{
    $login_fac_id = $this->session->userdata('fac_id');
    $branch_id    = $this->session->userdata('branch_id'); // ✅ already set in login

    $data['facultyid'] = $this->Heads_model->getLoggedInFaculty($login_fac_id); 
    $data['faculty']   = $this->Heads_model->getBranchFaculty($branch_id, $login_fac_id); // ✅ Only same-branch faculty, exclude self
    $data['leave']     = $this->Heads_model->getallLeave();

    $this->load->view('Heads/header_view');
    $this->load->view('Heads/Leave_view', $data);
    $this->load->view('Heads/footer_view');
}


public function insertLeave()
{
    $fkfac_id    = $this->input->post('fkfac_id');
    $LeaveType   = $this->input->post('LeaveType');
    $No_of_days  = (int)$this->input->post('No_of_days');

    $this->db->select('SUM(No_of_days) as total');
    $this->db->from('leaveapp_master');
    $this->db->where('fkfac_id', $fkfac_id);
    $this->db->where('LeaveType', $LeaveType);
    $this->db->where('HOD_Approval !=', 2);
$this->db->where('REG_Approval !=', 2);
$this->db->where('Princ_Approval !=', 2);
    $used = (int)($this->db->get()->row()->total ?? 0);

    $cat = $this->db
                ->select('leave_name, No_of_leave')
                ->where('leaveCat_id', $LeaveType)
                ->get('leavecat_master')
                ->row();

    $max       = (int)($cat->No_of_leave  ?? 0);
    $leaveName =         ($cat->leave_name ?? 'This');

  
    // if (($used + $No_of_days) > $max) {
    //     echo json_encode([
    //         'status'  => false,
    //         'message' => "{$leaveName} is already completed ({$used}/{$max}). You cannot apply more."
    //     ]);
    //     return;
    // }
    if (($used + $No_of_days) > $max) {
        echo json_encode([
            'status'  => false,
            'message' => "{$leaveName} is already completed You cannot apply more."
        ]);
        return;
    }
    $login_fac_id = $this->session->userdata('fac_id');

// ✅ Get designation ID of logged-in user
$desig = $this->db->select('ah.fkdesig_id')
                  ->from('activeheads_master ah')
                  ->where('ah.fkfac_id', $login_fac_id)
                  ->where('ah.is_active', 1)
                  ->where('ah.Active_Deactive', 1)
                  ->get()
                  ->row();

$HOD_Approval    = 0;
$HOD_date        = null;
$REG_Approval    = 0;
$REG_date        = null;
$Princ_Approval  = 0;
$Princ_date      = null;

// ✅ Set flags based on designation
if ($desig) {
    $desig_id = (int)$desig->fkdesig_id;

    if ($desig_id == 1) { // HOD
        $HOD_Approval = 1;
        $HOD_date     = date('Y-m-d H:i:s');
    } elseif ($desig_id == 2) { // Registrar
        $HOD_Approval = 1;
        $HOD_date     = date('Y-m-d H:i:s');
        $REG_Approval = 1;
        $REG_date     = date('Y-m-d H:i:s');
    } 
}

    $fields = [
        'fkfac_id'         => $fkfac_id,
        'LeaveType'        => $LeaveType,
        'fkAlternative_id' => $this->input->post('fkAlternative_id'),
        'Leave_from'       => $this->input->post('Leave_from'),
        'Leave_to'         => $this->input->post('Leave_to'),
        'No_of_days'       => $No_of_days,
        'Leave_Reas'       => $this->input->post('Leave_Reas'),
        'created_date'     => date('Y-m-d H:i:s'),
        'created_by'       => 1,
         'HOD_Approval'     => $HOD_Approval,
    'HOD_date'         => $HOD_date,
    'REG_Approval'     => $REG_Approval,
    'REG_date'         => $REG_date,
    'Princ_Approval'   => $Princ_Approval,
    'Princ_date'       => $Princ_date
    ];

    $this->Heads_model->insertdata($fields);

    echo json_encode([
        'status'  => true,
        'message' => 'Leave applied successfully!'
    ]);
}
    public function update()
	{
		$id=$this->uri->segment(3);
       	$data['data']=$this->Heads_model->getbyid($id);
      $login_fac_id = $this->session->userdata('fac_id');
    $branch_id    = $this->session->userdata('branch_id'); // ✅ already set in login

    $data['facultyid'] = $this->Heads_model->getLoggedInFaculty($login_fac_id); 
    $data['faculty']   = $this->Heads_model->getBranchFaculty($branch_id, $login_fac_id); // ✅ Only same-branch faculty, exclude self
    $data['leave']     = $this->Heads_model->getallLeave();

         
        //  echo "<pre>";
        // print_r($data);
	$this->load->view('Heads/header_view');
		$this->load->view('Heads/Leave_view',$data);
		$this->load->view('Heads/footer_view');
       
           
	}
    public function updateverify()
	{
		$id=$this->uri->segment(4);
       	$data['data']=$this->Heads_model->getbyiddata($id);
     $login_fac_id = $this->session->userdata('fac_id');
    $branch_id    = $this->session->userdata('branch_id'); // ✅ already set in login
    
    $data['hod_approved'] = ($data['data'][0]->HOD_Approval == 1);
$data['reg_approved'] = ($data['data'][0]->REG_Approval == 1);

    
//    $data['facultyid'] = $this->Heads_model->getLoggedInFacultydata($branch_id,$login_fac_id); 
//     $data['faculty']   = $this->Heads_model->getBranchFaculty($branch_id, $login_fac_id); // ✅ Only same-branch faculty, exclude self
//     $data['leave']     = $this->Heads_model->getallLeave();

// print_r($data['data']);
         
        //  echo "<pre>";
        // print_r($data);
	$this->load->view('Heads/header_view');
		$this->load->view('Heads/Leave_verifyupdate',$data);
		$this->load->view('Heads/footer_view');
       
           
	}
    public function updateRegverify()
	{
		$id=$this->uri->segment(4);
       	$data['data']=$this->Heads_model->getbyiddata($id);
     $login_fac_id = $this->session->userdata('fac_id');
    $branch_id    = $this->session->userdata('branch_id'); // ✅ already set in login
    
    $data['hod_approved'] = ($data['data'][0]->HOD_Approval == 1);
$data['reg_approved'] = ($data['data'][0]->REG_Approval == 1);
$data['leaveTypes'] = $this->Heads_model->get_all_leave_types();
    
//    $data['facultyid'] = $this->Heads_model->getLoggedInFacultydata($branch_id,$login_fac_id); 
//     $data['faculty']   = $this->Heads_model->getBranchFaculty($branch_id, $login_fac_id); // ✅ Only same-branch faculty, exclude self
//     $data['leave']     = $this->Heads_model->getallLeave();

// print_r($data['data']);
         
        //  echo "<pre>";
        // print_r($data);
	$this->load->view('Heads/header_view');
		$this->load->view('Heads/Leave_Regverifyupdate',$data);
		$this->load->view('Heads/footer_view');
       
           
	}
       public function updatePricipleverify()
	{
		$id=$this->uri->segment(4);
       	$data['data']=$this->Heads_model->getbyiddata($id);
     $login_fac_id = $this->session->userdata('fac_id');
    $branch_id    = $this->session->userdata('branch_id'); // ✅ already set in login
    
    $data['hod_approved'] = ($data['data'][0]->HOD_Approval == 1);
$data['reg_approved'] = ($data['data'][0]->REG_Approval == 1);

    
//    $data['facultyid'] = $this->Heads_model->getLoggedInFacultydata($branch_id,$login_fac_id); 
//     $data['faculty']   = $this->Heads_model->getBranchFaculty($branch_id, $login_fac_id); // ✅ Only same-branch faculty, exclude self
//     $data['leave']     = $this->Heads_model->getallLeave();

// print_r($data['data']);
         
        //  echo "<pre>";
        // print_r($data);
	$this->load->view('Heads/header_view');
		$this->load->view('Heads/Leave_Principleverify',$data);
		$this->load->view('Heads/footer_view');
       
           
	}

    private function upload_image3()
{
    $config['upload_path']   = './Assets/Leaveapplication/';
    $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
    $config['max_size']      = 2048; // 2MB
    $config['encrypt_name']  = TRUE; // optional, for unique file names

    $this->load->library('upload', $config);

    if ($this->upload->do_upload('Leave_Document')) {
        $uploadData = $this->upload->data();
        return $uploadData['file_name']; // return only the file name, not full path
    } else {
        // Upload failed, handle error
        echo json_encode([
            'status' => false,
            'message' => 'File upload failed: ' . $this->upload->display_errors('', '')
        ]);
        exit;
    }
}

public function updateLeave()
{
    $LeaveApp_id = $this->input->post('LeaveApp_id');
     $form_role = $this->input->post('form_role');
    $fkfac_id    = $this->input->post('fkfac_id');
    $LeaveType   = $this->input->post('LeaveType');
    $No_of_days  = (int)$this->input->post('No_of_days');

//     // photo
//     $Leave_Document = '';  
// if ($_FILES["Leave_Document"]["name"] != '') {
//     $Leave_Document = $this->upload_image3(); // ✅ returns just file name
// } else {
//     $Leave_Document = $this->input->post("hidden_Leave_Document"); // for keeping old file
// }

if (isset($_FILES["Leave_Document"]) && $_FILES["Leave_Document"]["name"] != '') {
    $Leave_Document = $this->upload_image3(); // upload new
} else {
    $Leave_Document = $this->input->post("hidden_Leave_Document"); // keep existing file
}

    // Get previous record's days to exclude from total calculation
    $previousData = $this->db->select('No_of_days')
        ->where('LeaveApp_id', $LeaveApp_id)
        ->get('leaveapp_master')
        ->row();
    $old_days = (int)($previousData->No_of_days ?? 0);

    // Get total leave used for this faculty and type, excluding the current record
    $this->db->select('SUM(No_of_days) as total');
    $this->db->from('leaveapp_master');
    $this->db->where('fkfac_id', $fkfac_id);
    $this->db->where('LeaveType', $LeaveType);
    $this->db->where('LeaveApp_id !=', $LeaveApp_id); // exclude current record
    $used = (int)($this->db->get()->row()->total ?? 0);

    // Get max allowed from leave category
    $cat = $this->db
        ->select('leave_name, No_of_leave')
        ->where('leaveCat_id', $LeaveType)
        ->get('leavecat_master')
        ->row();

    $max = (int)($cat->No_of_leave ?? 0);
    $leaveName = ($cat->leave_name ?? 'This');

    // Calculate final total used if this update is accepted
    $totalAfterUpdate = $used + $No_of_days;

    if ($totalAfterUpdate > $max) {
        echo json_encode([
            'status'  => false,
            'message' => "{$leaveName} is already completed. You cannot apply more."
        ]);
        return;
    }

    // Prepare update fields (common)
    $fields = [
        'LeaveApp_id'      => $LeaveApp_id,
        'fkfac_id'         => $fkfac_id,
        'LeaveType'        => $LeaveType,
        'fkAlternative_id' => $this->input->post('fkAlternative_id'),
        'Leave_from'       => $this->input->post('Leave_from'),
        'Leave_to'         => $this->input->post('Leave_to'),
        'No_of_days'       => $No_of_days,
        'Leave_Document' => $Leave_Document, // ✅ use uploaded file name
        'Leave_Reas'       => $this->input->post('Leave_Reas'),
        'modified_date'    => date('Y-m-d H:i:s'),
        'modified_by'      => $this->session->userdata('fac_id')
    ];

    // Add approval fields conditionally
    if ($this->input->post('hod_approval') !== null) {
        $fields['HOD_Approval'] = $this->input->post('hod_approval');
        $fields['HOD_date']     = date('Y-m-d H:i:s');
        $fields['HOD_RejReas']  = $this->input->post('HOD_RejReas');
    }

    if ($this->input->post('reg_approval') !== null) {
        $fields['REG_Approval'] = $this->input->post('reg_approval');
        $fields['REG_date']     = date('Y-m-d H:i:s');
        $fields['REG_RejReas']  = $this->input->post('REG_RejReas');
    }

    if ($this->input->post('princ_approval') !== null) {
        $fields['Princ_Approval'] = $this->input->post('princ_approval');
        $fields['Princ_date']     = date('Y-m-d H:i:s');
        $fields['Princ_RejReas']  = $this->input->post('Princ_RejReas');
    }

    $this->Heads_model->update($fields);

     echo json_encode([
    'status'     => true,
    'message'    => 'Leave updated successfully!',
    'form_role'  => $form_role // ✅ Include role in response
]);
}

public function getleavedata() {
    $fac_id = $this->input->post('fkfac_id');
    $data = $this->Heads_model->getAllLeaveStatus($fac_id);


$extraDays = $this->Heads_model->getExtraLeaveDays($fac_id);

foreach ($data as $group) {


    $mainLeaveCount = $group['used'];


    $extraLeaveCount = 0;
    if (!empty($extraDays[$group['id']])) {
        foreach ($extraDays[$group['id']] as $row) {
            $extraLeaveCount += (int)$row->no_of_LeaveDays;
        }
    }

    $totalUsed = $mainLeaveCount + $extraLeaveCount;

    echo "<div class='table-responsive'><table class='table table-bordered'>";
    echo "<tr><td colspan='8'>
            <h5 style='background-color:#d4edda;padding:8px;border:1px solid green;'>
                {$group['name']} - No Of Leaves ({$totalUsed}/{$group['max']})
            </h5>
          </td></tr>";

    echo "<thead>
            <tr>
                <th>Alternative Faculty</th>
                <th>Apply Date</th>
                <th>From Date</th>
                <th>To Date</th>
                <th>Approve Days</th>
                <th>Apply Days</th>
                <th>Leave Reason</th>
                <th>Status</th>
            </tr>
          </thead><tbody>";

    if (empty($group['records'])) {
        echo "<tr><td colspan='8' class='text-center'>No Records</td></tr>";
    } else {
        foreach ($group['records'] as $rec) {

            $status = '';
            if ($rec->HOD_Approval == 0) $status = 'HOD_Processing';
            elseif ($rec->HOD_Approval == 1) $status = 'HOD_Approved';
            elseif ($rec->HOD_Approval == 2) $status = 'HOD_Rejected';

            if ($rec->HOD_Approval == 1) {
                if ($rec->REG_Approval == 0) $status = 'Registrar_Processing';
                elseif ($rec->REG_Approval == 1) $status = 'Registrar_Approved';
                elseif ($rec->REG_Approval == 2) $status = 'Registrar_Rejected';
            }

            if ($rec->HOD_Approval == 1 && $rec->REG_Approval == 1) {
                if ($rec->Princ_Approval == 0) $status = 'Principal_Processing';
                elseif ($rec->Princ_Approval == 1) $status = 'Principal_Approved';
                elseif ($rec->Princ_Approval == 2) $status = 'Principal_Rejected';
            }

            $rowStyle = ($rec->HOD_Approval == 0) ? "style='background-color:#fff3cd;'" :
                         (($rec->HOD_Approval == 2 || $rec->REG_Approval == 2 || $rec->Princ_Approval == 2) ? "style='background-color:#f8d7da;'" : "");

            echo "<tr $rowStyle>";
            echo "<td>{$rec->altFaculty}</td>";
            echo "<td>" . date("d-m-Y", strtotime($rec->created_date)) . "</td>";
            echo "<td>" . date("d-m-Y", strtotime($rec->Leave_from)) . "</td>";
            echo "<td>" . date("d-m-Y", strtotime($rec->Leave_to)) . "</td>";
            echo "<td>{$rec->No_of_days}</td>";
            echo "<td>{$rec->ApprovedDays}</td>";

            echo "<td>{$rec->Leave_Reas}</td>";
            echo "<td><b>{$status}</b></td>";
            echo "</tr>";
        }
    }

    if (!empty($extraDays[$group['id']])) {
     echo "<tr><td colspan='8'>
        <h5 style='margin-top:10px;color:red;'>
           Late Mark Leave Details-({$group['name']}) 
        </h5>
      </td></tr>";


        echo "<tr>
          <th>Leave Date</th>
           <th>Late Day</th>
                <th>No. of Days</th>
    
                <th colspan='2'>Remark</th>
               
    
                <th colspan='3'>Status</th>
              </tr>";

        foreach ($extraDays[$group['id']] as $row) {
            echo "<tr style='background-color:#f0f8ff;'>";
              echo "<td>" . date("d-m-Y", strtotime($row->Leave_date)) . "</td>";
               echo "<td>" . (!empty($row->Lateday) ? $row->Lateday : '-') . "</td>";
            echo "<td>{$row->no_of_LeaveDays}</td>";
          
            echo "<td colspan='2'>" . (!empty($row->LateMark) ? $row->LateMark : '-') . "</td>";
    
            echo "<td colspan='3'>This leave added by Registrar</td>";
            echo "</tr>";
        }
    }

    echo "</tbody></table></div><br>";
}



}
// public function getleavedata() {
//     $fac_id = $this->input->post('fkfac_id');
//     $data = $this->Heads_model->getAllLeaveStatus($fac_id);
 
//     foreach ($data as $group) {
//         echo "<div class='table-responsive'><table class='table table-bordered'>";
//         echo "<tr><td colspan='6'>
//                 <h5 style='background-color:#d4edda;padding:8px;border:1px solid green;'>
//                     {$group['name']} - No Of Leaves ({$group['used']}/{$group['max']})
//                 </h5>
//               </td></tr>";
 
//         echo "<thead>
//                 <tr>
//                     <th>Alternative Faculty</th>
//                     <th>Apply Date</th>
//                     <th>From Date</th>
//                     <th>To Date</th>
//                     <th>No. of Days</th>
//                     <th>Leave Reason</th>
//                 </tr>
//               </thead><tbody>";
 
//         if (empty($group['records'])) {
//             echo "<tr><td colspan='6' class='text-center'>No Records</td></tr>";
//         } else {
//             foreach ($group['records'] as $rec) {
//                 $isRejected = (
//                     $rec->HOD_Approval == 2 ||
//                     $rec->REG_Approval == 2 ||
//                     $rec->Princ_Approval == 2
//                 );
 
//                 $rowStyle = $isRejected ? "style='background-color:#f8d7da;'" : "";
 
//                 echo "<tr $rowStyle>";
//                 echo "<td>{$rec->altFaculty}</td>";
//                 echo "<td>" . date("d-m-Y", strtotime($rec->created_date)) . "</td>";
 
//                 echo "<td>" . date("d-m-Y", strtotime($rec->Leave_from)) . "</td>";
//                 echo "<td>" . date("d-m-Y", strtotime($rec->Leave_to)) . "</td>";
//                 echo "<td>{$rec->No_of_days}</td>";
//                 echo "<td>{$rec->Leave_Reas}</td>";
//                 echo "</tr>";
//             }
//         }
 
//         echo "</tbody></table></div><br>";
//     }
// }

}

	
	
   
   

   
