<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class LeaveReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('LeaveReport_model');
        
    }


   public function Report()
{
      $data['facultydata']=$this->LeaveReport_model->getFac();
   
      $data['branchdata']=$this->LeaveReport_model->getbranch();
         $data['yeardata']=$this->LeaveReport_model->getyear();
 
    $this->load->view('Heads/header_view');
    $this->load->view('Heads/Leave_Report_view.php',$data);
    $this->load->view('Heads/footer_view');
}
 
public function getLeaveByBranch()
{
    $branch_id  = $this->input->post('branch_id');
    $faculty_id = $this->input->post('faculty_id');
    $from_date  = $this->input->post('from_date');
    $to_date    = $this->input->post('to_date');
    $year_id    = $this->input->post('year_id');

    if (!empty($year_id)) {
        $yearRange = $this->LeaveReport_model->getYearRangeById($year_id);
        if ($yearRange) {
            $from_date = $yearRange->StartDate;
            $to_date   = $yearRange->EndDate;
        }
    }

    $leaves = $this->LeaveReport_model->getLeaveByBranch($branch_id, $from_date, $to_date, $faculty_id);

    if (!empty($leaves)) {
         $sr = 1; 
        foreach ($leaves as $leave) {
           echo '<tr data-reg="' . $leave->reg_status . '">
                 <td>' . $sr++ . '</td>
                <td>' . $leave->LeaveApp_id . '</td>
                <td>' . $leave->faculty_name . '</td>
                <td>' . $leave->branch_name . '</td>
                <td>' . $leave->alt_name . '</td>
                <td>' . $leave->leave_name . '</td>
                <td>' . date("d-m-Y", strtotime($leave->Leave_from)) . '</td>
                <td>' . date("d-m-Y", strtotime($leave->Leave_to)) . '</td>
                <td>' . date("d-m-Y", strtotime($leave->created_date)) . '</td>
                 <td>' . $leave->No_of_days . '</td>
                <td>' . $leave->ApprovedDays . '</td>
                <td  style="text-align:center; background-color:' . $leave->hod_color . ';">' . $leave->hod_status . '</td>
                <td style="text-align:center; background-color:' . $leave->reg_color . ';" class="reg_status">' . $leave->reg_status . '</td>
                <td style="text-align:center; background-color:' . $leave->princ_color . ';">' . $leave->princ_status . '</td>
            </tr>';
        }
    } else {
        echo '<tr><td colspan="10" class="text-center text-danger">No leave data found for selected filters.</td></tr>';
    }
}


public function getFacultyByBranch()
{
    $branch_id = $this->input->post('branch_id');

    if (!empty($branch_id)) {
        $faculties = $this->LeaveReport_model->getFacultyByBranch($branch_id);

        echo '<option value="">Select Faculty</option>';
        foreach ($faculties as $faculty) {
            echo '<option value="' . $faculty->fac_id . '">' . $faculty->fac_Fullname . '</option>';
        }
    } else {
        echo '<option value="">No Faculty Found</option>';
    }
}
public function getTotalLeaveSummary()
{
    $fac_id = $this->input->post('fac_id');
    
    if (!$fac_id) {
        echo json_encode(['error' => 'Invalid faculty ID']);
        return;
    }

    $data = $this->LeaveReport_model->getAllLeaveStatus($fac_id);
    $extraDays = $this->LeaveReport_model->getExtraLeaveDays($fac_id);

    $summary = [];

    foreach ($data as $group) {
        $mainLeaveCount = $group['used'];
        $extraLeaveCount = 0;

        if (!empty($extraDays[$group['id']])) {
            foreach ($extraDays[$group['id']] as $row) {
                $extraLeaveCount += (int)$row->no_of_LeaveDays;
            }
        }

        $totalUsed = $mainLeaveCount + $extraLeaveCount;
        $availableLeaves = $group['max'] - $totalUsed;

        $summary[] = [
            'leave_name'        => $group['name'],
            'total_leaves'      => $group['max'],
            'used_leaves'       => $mainLeaveCount,
            'late_mark_leaves'  => $extraLeaveCount,
            'available_leaves'  => max(0, $availableLeaves)
        ];
    }

    echo json_encode($summary);
}

public function ReportPri()
{
     $data['branchdata']=$this->LeaveReport_model->getbranch();
 
    $this->load->view('Heads/header_view');
    $this->load->view('Heads/Leave_ReportPri_view.php',$data);
    $this->load->view('Heads/footer_view');
}
 
public function getLeaveByBranchPri()
{
    $branch_id = $this->input->post('branch_id');
    $from_date = $this->input->post('from_date');
    $to_date = $this->input->post('to_date');

    $leaves = $this->LeaveReport_model->getLeaveByBranch($branch_id, $from_date, $to_date);

    if (!empty($leaves)) {
        foreach ($leaves as $leave) {
            echo '<tr>
                <td>' . $leave->LeaveApp_id . '</td>
                <td>' . $leave->fac_Fullname . '</td>
                <td>' . $leave->leave_name . '</td>
                <td>' . (isset($leave->created_date) ? date("d-m-Y", strtotime($leave->created_date)) : '') . '</td>
                <td>' . $leave->No_of_days . '</td>
                <td>' . $leave->status . '</td>
            </tr>';
        }
    } else {
        echo '<tr><td colspan="9" class="text-center text-danger">No leave data found for selected filters.</td></tr>';
    }
}

 
   
}
