<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Academicau_institutereport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Academicau_institutereport_model');
        
    }


   
   
    public function create()
	{
  $data['branchdata'] = $this->Academicau_institutereport_model->getbranch();
 $data['semdata'] = $this->Academicau_institutereport_model->getsem();
 $data['typedata'] = $this->Academicau_institutereport_model->gettype();
  $data['institutedata'] = $this->Academicau_institutereport_model->getinstitu();
$data['yeardata'] = $this->Academicau_institutereport_model->getyear();
$data['evendata'] = $this->Academicau_institutereport_model->geteven();

$activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();

$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        //  echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
		$this->load->view('admin/Academicau_institutereport_view',$data);
		$this->load->view('admin/footer_view');
	

	}



public function showDataByInstitute()
{
    $institute_id = $this->input->post('fk_institu');
    $ids = $this->input->post('fk_even'); 
    $IDs = $this->input->post('fk_auditType');
    $year = $this->input->post('year');
$startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');
  $SemIDs = $this->input->post('fk_sem'); 

    $data = $this->Academicau_institutereport_model->getDataByInstitute(
        $institute_id,
        $year,
        $ids,
        $IDs,
        $SemIDs,
         $startdate,
        $enddate
        
    );

    echo json_encode($data);
}

// for print
public function getPrintHeadings()
{
    $data = $this->Academicau_institutereport_model->getPrintHeadings();
    echo json_encode($data);
}



 public function getYearwiseData()
{
    $year = $this->input->post('year');
    
 
    if ($year == "0" || empty($year)) {
        $summary = $this->Academicau_institutereport_model->getAllYearsData();
        $types   = [];
    } else {
        // ✅ Remove $branches parameter
        $summary = $this->Academicau_institutereport_model->getSingleYearData($year);
        $types   = $this->Academicau_institutereport_model->getYearwiseTypes($year);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkBranchName_id'); // match JS
    $year      = $this->input->post('year');
   
 
    $result = $this->Academicau_institutereport_model->getBranchwiseCount($institu, $branches, $year);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkBranchName_id'); // match JS
    $year      = $this->input->post('year');
  
    $result = $this->Academicau_institutereport_model->getBranchDetailsData($branch_id, $institu, $year);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu = $this->input->post('fk_institu');
    
    $years = $this->input->post('years');
  
    // ✅ Remove $branches parameter
    $result = $this->Academicau_institutereport_model->getCombinedData($institu, $years);
 
    echo json_encode([
        "status"   => "success",
        "yearData" => $result['yearData']
        
    ]);
}
 
public function getStudentList()
{
    $fk_auditID = $this->input->post('fk_auditID');
    if (!$fk_auditID) {
        echo json_encode([]);
        return;
    }
 
    // $this->load->model('ParentMeet_model');
    $students = $this->Academicau_institutereport_model->getStudentsByMeetId($fk_auditID);
 
    echo json_encode($students);
}
 

}
