<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AnnualSports extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('AnnualSports_model');
              $this->load->model('Log_model');
        $this->load->helper('log');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
        
    }


   
     public function index()
	{
      $data['alldata']=$this->AnnualSports_model->getdetailview();

        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/AnnualSports_detailview',$data);
		$this->load->view('admin/footer_view');
	

	}
	
	 public function dashboard()
	{
    //   $data['alldata']=$this->AnnualSports_model->getdetailview();

        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/AnnualSports_dash_view');
		$this->load->view('admin/footer_view');
	

	}
    public function create()
	{
    //    $data['load_script'] = 'Designation';

           $data['Sports'] = $this->AnnualSports_model->get_all_Sports();
           $data['Name'] = $this->AnnualSports_model->get_all_Name();
        //  echo "<pre>";
        // print_r($data);

        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

		$this->load->view('admin/header_view');
		$this->load->view('admin/AnnualSports_view',$data);
		$this->load->view('admin/footer_view');
	

	}
	
public function insertAnnualSport()
{
    // Retrieve input fields
    $SportsLabel = $this->input->post('SportsLabel');
    $fkSportsLevel_id = $this->input->post('fkSportsLevel_id');
    $StartDate  = $this->input->post('StartDate');
    $DateComp   = $this->input->post('DateComp');
    $Summary    = $this->input->post('Summary');
    $StudentList = $this->input->post('StudentList');
    $fk_submenuId = $this->input->post('fk_submenuId');

    // Prepare data for annualsports_master
    $fields = array(
        'SportsLabel' => $SportsLabel,
        'fkSportsLevel_id' => $fkSportsLevel_id,
        'StartDate'  => $StartDate,
        'DateComp'   => $DateComp,
        'Summary'    => $Summary,
        'StudentList'=> $StudentList,
        'created_by'=>$_SESSION['userID']
    );

    // Get active financial year
    $finiYear = $this->db->select('finiYear_id')
                         ->from('finiyear_master')
                         ->where('Active_Deactive', 1)
                         ->get()
                         ->row();
    if ($finiYear) {
        $fields['FiniYear'] = $finiYear->finiYear_id;
    }

    // Get institute
    $institute = $this->db->select('Institu_id')
                          ->from('institute_master')
                          ->get()
                          ->row();
    if ($institute) {
        $fields['Institute_id'] = $institute->Institu_id;
    }

    // Insert into annualsports_master
    $inserted_id = $this->AnnualSports_model->insertdata($fields);
    $annual_id = $inserted_id;

    // 🔐 Insert log
    $action = 1; // Insert
    $record_id = $inserted_id;
    $excel_name = null;
    $Fk_branch = null;

    insert_log(
        $this,
        $fk_submenuId,
        $action,
        $record_id,
        $excel_name,
        $Fk_branch,
        $_SESSION['userID']
    );

    // ✅ Handle Multiple Image Uploads (Photos[])
    if (!empty($_FILES['Photos']['name'][0])) {
        $files = $_FILES['Photos'];
        $file_count = count($files['name']);

        for ($i = 0; $i < $file_count; $i++) {
            if (!empty($files['name'][$i])) {
                $ext = pathinfo($files['name'][$i], PATHINFO_EXTENSION);
                $new_name = uniqid() . '.' . $ext;
                $destination = FCPATH . 'uploads/annualsports/' . $new_name;

                if (!is_dir(FCPATH . 'uploads/annualsports/')) {
                    mkdir(FCPATH . 'uploads/annualsports/', 0777, true);
                }

                if (move_uploaded_file($files['tmp_name'][$i], $destination)) {
                    $file_path = 'uploads/annualsports/' . $new_name;
                    $photo_data = array(
                        'Annual_id' => $annual_id,
                        'file_path' => $file_path
                    );
                    $this->db->insert('annualsports_photos', $photo_data);
                }
            }
        }
    }

    // ✅ Process Student Details
    $prn = $this->input->post('prn');
    $student_name = $this->input->post('student_name');
    $fkbranch_id_names = $this->input->post('fkbranch_id');
    $fkSportsName_id_names = $this->input->post('fkSportsName_id');
    $winner = $this->input->post('winner');
    $price = $this->input->post('price');
    $FiniYear_names = $this->input->post('FiniYear');

    if (!empty($prn)) {
        $count = count($prn);
        for ($i = 0; $i < $count; $i++) {

            // Handle fkbranch_id by name
            $branch_name = isset($fkbranch_id_names[$i]) ? trim($fkbranch_id_names[$i]) : null;
            $fkbranch_id = null;
            if (!empty($branch_name)) {
                $branch = $this->db->select('branch_id')
                                   ->from('branch_master')
                                   ->where('branch_name', $branch_name)
                                   ->get()
                                   ->row();
                if ($branch) {
                    $fkbranch_id = $branch->branch_id;
                } else {
                    $this->db->insert('branch_master', ['branch_name' => $branch_name]);
                    $fkbranch_id = $this->db->insert_id();
                }
            }

            // Handle fkSportsName_id by name
            $sport_name = isset($fkSportsName_id_names[$i]) ? trim($fkSportsName_id_names[$i]) : null;
            $fkSportsName_id = null;
            if (!empty($sport_name)) {
                $sports = $this->db->select('sport_id')
                                   ->from('sports_master')
                                   ->where('sport_name', $sport_name)
                                   ->get()
                                   ->row();
                if ($sports) {
                    $fkSportsName_id = $sports->sport_id;
                } else {
                    $this->db->insert('sports_master', ['sport_name' => $sport_name]);
                    $fkSportsName_id = $this->db->insert_id();
                }
            }

            // Handle FiniYear by label
            $fini_label = isset($FiniYear_names[$i]) ? trim($FiniYear_names[$i]) : null;
            $FiniYear = null;
            if (!empty($fini_label)) {
                $fini = $this->db->select('finiYear_id')
                                 ->from('finiyear_master')
                                 ->where('fini_Label', $fini_label)
                                 ->get()
                                 ->row();
                if ($fini) {
                    $FiniYear = $fini->finiYear_id;
                } else {
                    $this->db->insert('finiyear_master', ['fini_Label' => $fini_label, 'Active_Deactive' => 1]);
                    $FiniYear = $this->db->insert_id();
                }
            }

            // ✅ FIXED: Handle certificate file (make it optional)
            $certificate_file = null;
            $file_field = "certificate_file{$i}";
            
            // Check if file exists and was uploaded
            if (isset($_FILES[$file_field]) && !empty($_FILES[$file_field]['name'])) {
                $ext = pathinfo($_FILES[$file_field]['name'], PATHINFO_EXTENSION);
                $new_name = uniqid() . '.' . $ext;
                $destination = FCPATH . 'uploads/annualsports/' . $new_name;

                if (!is_dir(FCPATH . 'uploads/annualsports/')) {
                    mkdir(FCPATH . 'uploads/annualsports/', 0777, true);
                }

                if (move_uploaded_file($_FILES[$file_field]['tmp_name'], $destination)) {
                    $certificate_file = 'uploads/annualsports/' . $new_name;
                }
            }

            // Insert student record
            $studentData = array(
                'Annual_id'      => $annual_id,
                'prn'            => isset($prn[$i]) ? $prn[$i] : '',
                'student_name'   => isset($student_name[$i]) ? $student_name[$i] : '',
                'fkbranch_id'    => $fkbranch_id,
                'fkSportsName_id'=> $fkSportsName_id,
                'FiniYear'       => $FiniYear,
                'winner'         => isset($winner[$i]) ? $winner[$i] : null,
                'price'          => isset($price[$i]) ? $price[$i] : null,
                'certificate'    => $certificate_file
            );

            $this->db->insert('annual_sports_students', $studentData);
        }
    }

    // ✅ Return success response
    echo json_encode(['status' => 'success', 'message' => 'Annual sport entry added successfully.']);
}


	
  public function update()
	{
		$id=$this->uri->segment(4);
        $data['data']=$this->AnnualSports_model->getbyid($id);
        $data['Sports'] = $this->AnnualSports_model->get_all_Sports();
           $data['Name'] = $this->AnnualSports_model->get_all_Name();
   $data['studentParentList'] = $this->AnnualSports_model->get_students_by_meet($id); 
         $data['selectedGallary'] = $this->AnnualSports_model->getClubGallery($id);

        //  $data['load_script'] = 'Designation';

        //  echo "<pre>";
        // print_r($data);
$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);
       
           $this->load->view('admin/header_view');
		$this->load->view('admin/AnnualSports_view',$data);
           $this->load->view('admin/footer_view');
	}
	
	
 public function updateAnnualSports()
{
    $Annual_id        = $this->input->post('Annual_id');
    $SportsLabel      = $this->input->post('SportsLabel');
    $fkSportsLevel_id = $this->input->post('fkSportsLevel_id');
    $StartDate        = $this->input->post('StartDate');
    $DateComp         = $this->input->post('DateComp');
    $Summary          = $this->input->post('Summary');
    $StudentList      = $this->input->post('StudentList');
    $fk_submenuId = $this->input->post('fk_submenuId');

    // Update fields for annualsports_master
    $fields = array(
        'SportsLabel' => $SportsLabel,
        'fkSportsLevel_id' => $fkSportsLevel_id,
        'StartDate'  => $StartDate,
        'DateComp'   => $DateComp,
        'Summary'    => $Summary,
        'StudentList'=> $StudentList,
        'modified_by'=>$_SESSION['userID']
    );

    // Get active financial year
    $finiYear = $this->db->select('finiYear_id')
                         ->from('finiyear_master')
                         ->where('Active_Deactive', 1)
                         ->get()
                         ->row();
    if ($finiYear) {
        $fields['FiniYear'] = $finiYear->finiYear_id;
    }

    // Get institute
    $institute = $this->db->select('Institu_id')
                          ->from('institute_master')
                          ->get()
                          ->row();
    if ($institute) {
        $fields['Institute_id'] = $institute->Institu_id;
    }


    // Update annualsports_master
$this->db->where('Annual_id', $Annual_id);
$this->db->update('annualsports_master', $fields);

// 🔐 Insert log - Action 2 (Update)
$action     = 2; // Update
$record_id = $Annual_id;   // IMPORTANT: use Annual_id
$excel_name = null;
   $Fk_branch = $fkbranch_id;// pass branch if you have it

insert_log(
    $this,
    $fk_submenuId,
    $action,
    $record_id,
    $excel_name,
    $Fk_branch,
    $_SESSION['userID']
);


// ✅ Handle removed photos
$removed_photos = $this->input->post('removed_photos');
if (!empty($removed_photos)) {
    $photosToRemove = explode(',', $removed_photos);
    foreach ($photosToRemove as $photoPath) {
        $photoPath = trim($photoPath);
        if (!empty($photoPath)) {
            // Delete DB record
            $this->db->where('Annual_id', $Annual_id)
                     ->where('file_path', $photoPath)
                     ->delete('annualsports_photos');

            // Delete file from server if it exists
            $fullPath = FCPATH . $photoPath;
            if (file_exists($fullPath)) {
                unlink($fullPath);
            }
        }
    }
}


if (!empty($_FILES['Photos']['name'][0])) {
    $files = $_FILES['Photos'];
    $file_count = count($files['name']);

    for ($i = 0; $i < $file_count; $i++) {
        if (!empty($files['name'][$i])) {
            $ext = pathinfo($files['name'][$i], PATHINFO_EXTENSION);
            $new_name = uniqid() . '.' . $ext;
            $destination = FCPATH . 'uploads/annualsports/' . $new_name;

            if (!is_dir(FCPATH . 'uploads/annualsports/')) {
                mkdir(FCPATH . 'uploads/annualsports/', 0777, true);
            }

            if (move_uploaded_file($files['tmp_name'][$i], $destination)) {
                $file_path = 'uploads/annualsports/' . $new_name;

                // Insert into annualsports_photos
                $photo_data = array(
                    'Annual_id' => $Annual_id,
                    'file_path' => $file_path
                );
                $this->db->insert('annualsports_photos', $photo_data);
            }
        }
    }
}


// Clear old student records
$this->db->where('Annual_id', $Annual_id);
$this->db->delete('annual_sports_students');


    // Re-insert student details
    $prn                 = $this->input->post('prn');
    $student_name        = $this->input->post('student_name');
    $fkbranch_id_names   = $this->input->post('fkbranch_id');
    $fkSportsName_id_names = $this->input->post('fkSportsName_id');
    $winner              = $this->input->post('winner');
    $price               = $this->input->post('price');
    $FiniYear_names      = $this->input->post('FiniYear');
    $certificate_old     = $this->input->post('certificate_old'); // array of old certificate paths

    if (!empty($prn)) {
        $count = count($prn);
        for ($i = 0; $i < $count; $i++) {

            // Handle fkbranch_id by name
            $branch_name = $fkbranch_id_names[$i] ?? null;
            $fkbranch_id = null;
            if ($branch_name) {
                $branch = $this->db->select('branch_id')
                                   ->from('branch_master')
                                   ->where('branch_name', trim($branch_name))
                                   ->get()
                                   ->row();
                if ($branch) {
                    $fkbranch_id = $branch->branch_id;
                } else {
                    $this->db->insert('branch_master', ['branch_name' => trim($branch_name)]);
                    $fkbranch_id = $this->db->insert_id();
                }
            }

            // Handle fkSportsName_id by name
            $sport_name = $fkSportsName_id_names[$i] ?? null;
            $fkSportsName_id = null;
            if ($sport_name) {
                $sports = $this->db->select('sport_id')
                                   ->from('sports_master')
                                   ->where('sport_name', trim($sport_name))
                                   ->get()
                                   ->row();
                if ($sports) {
                    $fkSportsName_id = $sports->sport_id;
                } else {
                    $this->db->insert('sports_master', ['sport_name' => trim($sport_name)]);
                    $fkSportsName_id = $this->db->insert_id();
                }
            }

            // Handle FiniYear by label
            $fini_label = $FiniYear_names[$i] ?? null;
            $FiniYear = null;
            if ($fini_label) {
                $fini = $this->db->select('finiYear_id')
                                 ->from('finiyear_master')
                                 ->where('fini_Label', trim($fini_label))
                                 ->get()
                                 ->row();
                if ($fini) {
                    $FiniYear = $fini->finiYear_id;
                } else {
                    $this->db->insert('finiyear_master', ['fini_Label' => trim($fini_label), 'Active_Deactive' => 1]);
                    $FiniYear = $this->db->insert_id();
                }
            }

            // Handle certificate file
            $certificate_file = null;
            $file_field = "certificate_file{$i}"; // dynamic input name
            if (!empty($_FILES[$file_field]['name'])) {
                $ext = pathinfo($_FILES[$file_field]['name'], PATHINFO_EXTENSION);
                $new_name = uniqid() . '.' . $ext;
                $destination = FCPATH . 'uploads/annualsports/' . $new_name;

                if (!is_dir(FCPATH . 'uploads/annualsports/')) {
                    mkdir(FCPATH . 'uploads/annualsports/', 0777, true);
                }

                if (move_uploaded_file($_FILES[$file_field]['tmp_name'], $destination)) {
                    $certificate_file = 'uploads/annualsports/' . $new_name;
                }
            } else {
                // Keep old certificate if no new file uploaded
                $certificate_file = $certificate_old[$i] ?? null;
            }

            // Insert student record
            $studentData = array(
                'Annual_id'    => $Annual_id,
                'prn'          => $prn[$i],
                'student_name' => $student_name[$i],
                'fkbranch_id'  => $fkbranch_id,
                'fkSportsName_id'=> $fkSportsName_id,
                'FiniYear'     => $FiniYear,
                'winner'       => $winner[$i] ?? null,
                'price'        => $price[$i] ?? null,
                'certificate'  => $certificate_file
            );

            $this->db->insert('annual_sports_students', $studentData);
        }
    }

    // Return success response
    echo json_encode(['status' => 'success', 'message' => 'Annual sports entry updated successfully.']);
}



         public function Report()
	{
    //   $data['alldata']=$this->AnnualSports_model->getdetailview();
$data['institutedata'] = $this->AnnualSports_model->get_all_institute();
  $data['Sports'] = $this->AnnualSports_model->get_all_Sports();
$data['Name'] = $this->AnnualSports_model->get_all_Name();
 $data['Branch'] = $this->AnnualSports_model->get_all_Branch();
$data['yeardata'] = $this->AnnualSports_model->getyear();
  
 $activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/AnnualSports_Report',$data);
		$this->load->view('admin/footer_view');

	}

    
public function showDataByInstitute()
{
    $institute_id  = $this->input->post('InstituteId');
    $StartDate     = $this->input->post('StartDate');
    $DateComp       = $this->input->post('DateComp');
    $sportsLevels  = $this->input->post('fkSportsLevel_id');  // multiselect
    $sportsNames   = $this->input->post('fkSportsName_id');   // multiselect

    $data = $this->AnnualSports_model->getDataByInstitute(
        $institute_id,
        $StartDate,
        $DateComp,
        $sportsLevels,
        $sportsNames
    );

    echo json_encode($data);
}


public function getPrintHeadings()
{
    $data = $this->AnnualSports_model->getPrintHeadings();
    echo json_encode($data);
}



public function getYearwiseData()
{
    $year = $this->input->post('year');
    $institu = $this->input->post('fk_institu');
    $startDate = $this->input->post('StartDate');
    $endDate = $this->input->post('EndDate');

    if ($year == "0" || empty($year)) {
        $summary = $this->AnnualSports_model->getAllYearsData();
        $types = [];
    } else {
        $summary = $this->AnnualSports_model->getSingleYearData($year);
        $types = $this->AnnualSports_model->getYearwiseTypes($year, $institu, $startDate, $endDate);
    }

    echo json_encode([
        "status" => "success",
        "summary" => $summary,
        "types" => $types
    ]);
}
 

public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu'); 
    $years     = $this->input->post('years');      // array
    $StartDate = $this->input->post('StartDate');
    $DateComp   = $this->input->post('DateComp');

    $result = $this->AnnualSports_model->getCombinedData($institu, $years, $StartDate, $DateComp);

    echo json_encode([
        "status"      => "success",
        "yearData"    => $result['yearData']
    ]);
}



   public function get_submenu_data()
{
    // Don't load views when returning JSON
    // Set JSON header
    $this->output->set_content_type('application/json');
    
    // Get fkMenuID from POST request
    $fkMenuID = $this->input->post('fkMenuID');
    if (!$fkMenuID) {
        $fkMenuID = 7; // default value
    }
    
    // Get data from model
    $data = $this->AnnualSports_model->get_submenu_by_menu_id($fkMenuID);
    
    // Debug: Log the data (you can remove this later)
    log_message('debug', 'Submenu data: ' . print_r($data, true));
    
    // Return JSON response
    $response = array(
        'success' => true,
        'data' => $data,
        'count' => count($data),
        'fkMenuID' => $fkMenuID
    );
    
    echo json_encode($response);
    exit; // Important: prevent CodeIgniter from loading views
}
}
