<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class AwardImport extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('AwardImport_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    // Load Import View
    public function create()
    {
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/AwardImport_view',$data);
        $this->load->view('admin/footer_view');
    }

    // Load Import View
    public function Report()
    {

        $data['Branch'] = $this->AwardImport_model->getDistinctDepartments();

        $data['institutedata'] = $this->AwardImport_model->get_all_institute();
//  $data['Branch'] = $this->Import_techExcel_model->get_all_Branch();
      
$data['yeardata'] = $this->AwardImport_model->getyear();
 $activeYear = $this->db
    ->select('level_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
$data['active_year_id'] = $activeYear ? $activeYear->level_id : 0;

        $this->load->view('admin/header_view');
        $this->load->view('admin/NSS_Report',$data);
        $this->load->view('admin/footer_view');
    }



public function showDataByInstitute()
{
    $license_Institu_id = $this->input->post('InstituteId');
    $startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');
    $departments  = $this->input->post('Department');  // coming from multi-select

    $data = $this->Import_techExcel_model->getDataByInstitute(
        $license_Institu_id,
        $startdate,
        $enddate,
        $departments
    );

    echo json_encode($data);
}


public function getPrintHeadings()
{
    $data = $this->Import_techExcel_model->getPrintHeadings();
    echo json_encode($data);
}


public function import_excel_save() {
    try {

$fk_submenuId = $this->input->post('fk_submenuId');
        // ✅ Handle Excel file upload
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];

            // Upload path
            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $filename = 'Award_excel_' . date('Ymd_His') . '_' . basename($originalName);
            $targetFile = $uploadDir . $filename;

            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "file_error";
                return;
            }
        }


        $postData = $this->input->post('tableData');
        if (empty($postData)) {
            echo "no_data";
            return;
        }

        $rows = json_decode($postData, true);
//         $insertData = [];
//  // ✅ Get Active Financial Year ID
//          $finiYear = $this->db
//          ->select('level_id')
//              ->from('finiyear_master')
//              ->where('Active_Deactive', 1)
//          ->get()
//              ->row();
//          $FiniYear = $finiYear ? $finiYear->level_id : null;

//  $institute = $this->db->select('Institu_id')
//          ->from('institute_master')
//          ->get()
//          ->row();
//              $fkInstitute_id = $institute ? $institute->Institu_id : null;
 

        // ✅ Load maps for existing master data
        $awardMap = [];
        $instituteMap = [];
        $yearMap = [];
        $licenceMap = [];
        $studentMap = [];
        $branchMap = [];
        $industryMap = [];

        foreach ($this->db->get_where('level_master', ['is_on' => 1, 'is_on' => 1])->result() as $g) {
            $awardMap[strtolower(trim($g->leval_name))] = $g->level_id;
        }
        foreach ($this->db->get_where('institute_master', ['is_active' => 1, 'is_active' => 1])->result() as $d) {
            $instituteMap[strtolower(trim($d->Institu_name))] = $d->Institu_id;
        }
         foreach ($this->db->get_where('finiyear_master', ['is_active' => 1, 'is_active' => 1])->result() as $g) {
            $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
        }
   
    
        $rowCount = 0;
        foreach ($rows as $row) {
            $rowCount++;

            // ✅ Header skip
            if ($rowCount === 1) {
                continue;
            }
            
              // ✅ Year Master
$yearStr = strtolower(trim($row['FiniYear'] ?? ''));
if ($yearStr !== '') {
    if (!isset($yearMap[$yearStr])) {
        $this->db->insert('finiyear_master', [
            'fini_Label' => ucfirst($yearStr),
            'is_active' => 1
        ]);
        $finiYear_id = $this->db->insert_id();
        $yearMap[$yearStr] = $finiYear_id;
    } else {
        $finiYear_id = $yearMap[$yearStr];
    }
} else {
    $finiYear_id = null;
}

// ✅ Award Master (Fix table name!)
$awardStr = strtolower(trim($row['fkAwardType_id'] ?? ''));
if ($awardStr !== '') {
    if (!isset($awardMap[$awardStr])) {
        $this->db->insert('level_master', [  // FIXED HERE
            'leval_name' => ucfirst($awardStr),
            'is_on' => 1
        ]);
        $level_id = $this->db->insert_id();
        $awardMap[$awardStr] = $level_id;
    } else {
        $level_id = $awardMap[$awardStr];
    }
} else {
    $level_id = null;
}

            // ✅ Enter Master
            $instituStr = strtolower(trim($row['fkInsitute_id'] ?? ''));
            if ($instituStr !== '') {
                if (!isset($instituteMap[$instituStr])) {
                    $this->db->insert('institute_master', [
                        'Institu_name' => ucfirst($instituStr),
                        'is_active' => 1,
                        'is_active' => 1
                    ]);
                    $Institu_id = $this->db->insert_id();
                    $instituteMap[$instituStr] = $Institu_id;
                } else {
                    $Institu_id = $instituteMap[$instituStr];
                }
            } else {
                $Institu_id = null;
            }

           
            // ✅ Insert row
            $insertData[] = [
    'Award_name'     => $row['Award_name'] ?? '',
    'fkAwardType_id' => $level_id,
    'AwardAmt'       => $row['AwardAmt'] ?? '',
    'AwardedBy'      => $row['AwardedBy'] ?? '',
    'fkInsitute_id'  => $Institu_id,
    'FiniYear'  => $finiYear_id,   // FIXED HERE
    'created_by'=>$_SESSION['userID']
];

        }

        if (!empty($insertData)) {
            $this->db->insert_batch('award_master', $insertData);
            echo "success";
        } else {
            echo "no_data";
        }
// Insert log - Action 4 (Excel)
 
        $action = 4;

        $record_id = null;

        $excel_name = $filename;

        $Fk_branch = null;

        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);
 

    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}

}