<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Chapter extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Chapter_model');
         $this->load->library('upload');
        
    }
     public function index()
	{
      $data['alldata']=$this->Chapter_model->getdetailview();

        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/Chapter_detailview',$data);
		$this->load->view('admin/footer_view');
	}

   public function dashboard()
	{
    //   $data['alldata']=$this->Award_model->getdetailview();

        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/Chapter_dash_view');
		$this->load->view('admin/footer_view');
	

	}
    public function create()
	{
    //    $data['load_script'] = 'Designation';

         $data['Branch'] = $this->Chapter_model->get_all_Branch();
          $data['Faculty'] = $this->Chapter_model->get_all_Faculty();
           $data['Student'] = $this->Chapter_model->get_all_Student();
             $data['Year'] = $this->Chapter_model->get_all_year();
        //    $data['InduType'] = $this->Chapter_model->get_all_InduType();
        //  echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
		$this->load->view('admin/Chapter_view',$data);
		$this->load->view('admin/footer_view');
	

	}


 public function insertChapter()
{
    $NameClub    = $this->input->post('NameClub');
    $fkbranch_id = $this->input->post('fkbranch_id');
    $fkFacCo_id  = $this->input->post('fkFacCo_id');
    $fkStudCo_id = $this->input->post('fkStudCo_id');
    $NoActivity  = $this->input->post('NoActivity');
    $NoStud      = $this->input->post('NoStud');
    $StudMobNo   = $this->input->post('StudMobNo');
    $FacMobNo    = $this->input->post('FacMobNo');
    $StudentImage = $this->input->post('hidden_photo');

    // Single Certificate Upload
    if (!empty($_FILES['StudentImage']['name'])) {
        $upload_path = FCPATH . 'uploads/StudentList/';

        $config['upload_path']   = $upload_path;
        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
        $config['max_size']      = 2048;
        $config['file_name']     = time() . '_' . preg_replace('/[^a-zA-Z0-9_\.-]/', '_', $_FILES['StudentImage']['name']);

        $this->load->library('upload');
        $this->upload->initialize($config);

        if ($this->upload->do_upload('StudentImage')) {
            $uploadData   = $this->upload->data();
            $StudentImage = 'uploads/StudentList/' . $uploadData['file_name'];
        } else {
            echo json_encode(['status' => 'error', 'message' => $this->upload->display_errors()]);
            exit;
        }
    }

    $FiniYear    = $this->input->post('FiniYear');
    $LinkDetails = $this->input->post('LinkDetails');
    $Acheivment  = $this->input->post('Acheivment');
    $Summary     = $this->input->post('Summary');

    // Save Main Club
    $fields = array(
        'NameClub'     => $NameClub,
        'fkbranch_id'  => $fkbranch_id,
        'fkFacCo_id'   => $fkFacCo_id,
        'fkStudCo_id'  => $fkStudCo_id,
        'NoActivity'   => $NoActivity,
        'NoStud'       => $NoStud,
        'StudMobNo'    => $StudMobNo,
        'FacMobNo'     => $FacMobNo,
        'StudentImage' => $StudentImage,
        'FiniYear'     => $FiniYear,
        'LinkDetails'  => $LinkDetails,
        'Acheivment'   => $Acheivment,
        'Summary'      => $Summary
    );

    $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
    if ($institute) {
        $fields['InstituteId'] = $institute->Institu_id;
    }

    $this->Chapter_model->insertdata($fields);
    $club_id = $this->db->insert_id();

    // ✅ FIX: Get arrays correctly
    $prns          = $this->input->post('prn');
    $student_names = $this->input->post('student_name');
    $mobile_nos    = $this->input->post('mobile_no');  // ✅ Now as array
    $branches      = $this->input->post('branch'); 
    $occupations   = $this->input->post('Occupation');

    if (!empty($prns)) {
        $studentData = [];

        foreach ($prns as $i => $prn) {
            if (!empty($prn) && !empty($student_names[$i])) {
                $studentData[] = [
                    'club_id'      => $club_id,
                    'prn'          => $prn,
                    'student_name' => $student_names[$i],
                    'mobile_no'    => isset($mobile_nos[$i]) ? $mobile_nos[$i] : null,  // ✅ Access by index
                    'branch'       => isset($branches[$i]) ? $branches[$i] : null,
                    'Occupation'   => isset($occupations[$i]) ? $occupations[$i] : null,
                    'created_at'   => date('Y-m-d H:i:s')
                ];
            }
        }

        if (!empty($studentData)) {
            $this->Chapter_model->insertStudents($studentData);
        }
    }

  // ============================================================
// ✅ FIXED: Insert Activities with Photo Upload
// ============================================================

$activity_Type  = $this->input->post('activity_Type');
$activity_names = $this->input->post('activity_name');
$activity_dates = $this->input->post('activity_date');
$student_counts = $this->input->post('student_count');
$remarks        = $this->input->post('remark');

if (!empty($activity_names)) {
    $activitiesData = [];

    for ($i = 0; $i < count($activity_names); $i++) {
        if (!empty($activity_names[$i])) {
            $photoPath = null;

            // ✅ Check if a file was uploaded for this specific row
            if (!empty($_FILES['activity_photo']['name'][$i])) {
                
                // ✅ Create individual file array for this upload
                $_FILES['activity_photo_file']['name']     = $_FILES['activity_photo']['name'][$i];
                $_FILES['activity_photo_file']['type']     = $_FILES['activity_photo']['type'][$i];
                $_FILES['activity_photo_file']['tmp_name'] = $_FILES['activity_photo']['tmp_name'][$i];
                $_FILES['activity_photo_file']['error']    = $_FILES['activity_photo']['error'][$i];
                $_FILES['activity_photo_file']['size']     = $_FILES['activity_photo']['size'][$i];

                // ✅ Configure upload settings
                $config['upload_path']   = FCPATH . 'uploads/Activities/';
                $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
                $config['max_size']      = 2048; // 2MB
                $config['file_name']     = uniqid() . '_' . preg_replace('/[^a-zA-Z0-9_\.-]/', '_', $_FILES['activity_photo_file']['name']);

                // ✅ Create directory if it doesn't exist
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path'], 0777, true);
                }

                $this->upload->initialize($config);

                if ($this->upload->do_upload('activity_photo_file')) {
                    $uploadData = $this->upload->data();
                    $photoPath  = 'uploads/Activities/' . $uploadData['file_name'];
                } else {
                    // ✅ Log the error instead of stopping execution
                    log_message('error', 'Activity Photo Upload Error: ' . $this->upload->display_errors());
                }
            }

            $activitiesData[] = [
                'club_id'       => $club_id,
                'activity_Type' => isset($activity_Type[$i]) ? $activity_Type[$i] : null,
                'activity_name' => $activity_names[$i],
                'date'          => !empty($activity_dates[$i]) ? $activity_dates[$i] : null,
                'student_count' => !empty($student_counts[$i]) ? $student_counts[$i] : 0,
                'remark'        => !empty($remarks[$i]) ? $remarks[$i] : null,
                'photo'         => $photoPath,
                'created_at'    => date('Y-m-d H:i:s')
            ];
        }
    }

    if (!empty($activitiesData)) {
        $this->Chapter_model->insertActivities($activitiesData);
    }
}

    // Faculty insert code
// ==================== FACULTY LIST INSERT ====================
$Faculty_Names   = $this->input->post('Faculty_Name');
$Mobiles         = $this->input->post('Mobile');
$Email_ids       = $this->input->post('Email_id');
$Branches        = $this->input->post('Branch');
$Membership_Nos  = $this->input->post('Membership_No');

if (!empty($Faculty_Names)) {
    $facultyData = [];

    foreach ($Faculty_Names as $i => $faculty_name) {
        if (!empty($faculty_name)) {
            $facultyData[] = [
                'club_id'        => $club_id,
                'Faculty_Name'   => $faculty_name,
                'Mobile'         => isset($Mobiles[$i]) ? $Mobiles[$i] : null,
                'Email_id'       => isset($Email_ids[$i]) ? $Email_ids[$i] : null,
                'Branch'         => isset($Branches[$i]) ? $Branches[$i] : null,
                'Membership_No'  => isset($Membership_Nos[$i]) ? $Membership_Nos[$i] : null,
                'created_at'     => date('Y-m-d H:i:s')
            ];
        }
    }

    if (!empty($facultyData)) {
        $this->Chapter_model->insertFacultylistxcel($facultyData);
    }
}

// Faculty code complete



    // Multiple Gallery Upload
    if (!empty($_FILES['Photos']['name'][0])) {
        $this->load->library('upload');
        $filesCount = count($_FILES['Photos']['name']);

        for ($i = 0; $i < $filesCount; $i++) {
            $_FILES['file']['name']     = $_FILES['Photos']['name'][$i];
            $_FILES['file']['type']     = $_FILES['Photos']['type'][$i];
            $_FILES['file']['tmp_name'] = $_FILES['Photos']['tmp_name'][$i];
            $_FILES['file']['error']    = $_FILES['Photos']['error'][$i];
            $_FILES['file']['size']     = $_FILES['Photos']['size'][$i];

            $config['upload_path']   = FCPATH . 'uploads/StudClub/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx|webp';
            $config['max_size']      = 2048;
            $config['file_name']     = uniqid() . '_' . $_FILES['file']['name'];

            $this->upload->initialize($config);

            if ($this->upload->do_upload('file')) {
                $uploadData = $this->upload->data();
                $filePath   = 'uploads/StudClub/' . $uploadData['file_name'];

                $this->db->insert('Chapter_gallery', [
                    'club_id'   => $club_id,
                    'file_path' => $filePath
                ]);
            } else {
                log_message('error', $this->upload->display_errors());
            }
        }
    }

    echo json_encode(['status' => 'success', 'club_id' => $club_id]);
}


public function update()
{
    $id = $this->uri->segment(4);

    // Use getClubFullDetails to fetch everything
    $data = $this->Chapter_model->getClubFullDetails($id);
    $data['studentParentList'] = $this->Chapter_model->get_students_by_club($id); 
    $data['activityList'] = $this->Chapter_model->get_students_by_activity($id);
    
    // ✅ ADD THIS LINE - Fetch Faculty List
    $data['facultyList'] = $this->Chapter_model->getFacultylistxcelByClub($id);
    
    $data['data'] = $this->Chapter_model->getbyid($id);
    
    // Extra dropdowns (branch, faculty, student) for your form
    $data['Branch'] = $this->Chapter_model->get_all_Branch();
    $data['Faculty'] = $this->Chapter_model->get_all_Faculty();
    $data['Student'] = $this->Chapter_model->get_all_Student();
    $data['selectedGallary'] = $this->Chapter_model->getClubGallery($id);
    $data['Year'] = $this->Chapter_model->get_all_year();

    $this->load->view('admin/header_view');
    $this->load->view('admin/Chapter_view', $data);
    $this->load->view('admin/footer_view');
}


public function updateChapter()
{
    ini_set('display_errors', 1);
    error_reporting(E_ALL);

    try {
        $club_id     = $this->input->post('club_id');
        $NameClub    = $this->input->post('NameClub');
        $fkbranch_id = $this->input->post('fkbranch_id');
        $fkFacCo_id  = $this->input->post('fkFacCo_id');
        $fkStudCo_id = $this->input->post('fkStudCo_id');
        $NoActivity  = $this->input->post('NoActivity');
        $NoStud      = $this->input->post('NoStud');
        $StudMobNo   = $this->input->post('StudMobNo');
        $FacMobNo    = $this->input->post('FacMobNo');
        $FiniYear    = $this->input->post('FiniYear');

        // Keep old photo if not replaced
        $StudentImage = $this->input->post('hidden_photo');
        if (!empty($_FILES['StudentImage']['name'])) {
            $config['upload_path']   = FCPATH . 'uploads/StudentList/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
            $config['max_size']      = 2048;
            $config['file_name']     = time() . '_' . $_FILES['StudentImage']['name'];

            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }

            $this->load->library('upload', $config);
            if ($this->upload->do_upload('StudentImage')) {
                $uploadData   = $this->upload->data();
                $StudentImage = 'uploads/StudentList/' . $uploadData['file_name'];
            }
        }

        // ---------------- Update Main Club ----------------
        $fields = [
            'NameClub'     => $NameClub,
            'fkbranch_id'  => $fkbranch_id,
            'fkFacCo_id'   => $fkFacCo_id,
            'fkStudCo_id'  => $fkStudCo_id,
            'NoActivity'   => $NoActivity,
            'NoStud'       => $NoStud,
            'StudMobNo'    => $StudMobNo,
            'FacMobNo'     => $FacMobNo,
            'StudentImage' => $StudentImage,
            'FiniYear'     => $FiniYear,
            'StartDate'    => $this->input->post('StartDate'),
            'LinkDetails'  => $this->input->post('LinkDetails'),
            'Acheivment'   => $this->input->post('Acheivment'),
            'Summary'      => $this->input->post('Summary')
        ];
        $this->Chapter_model->update($fields, $club_id);

        // ============================================================
        // ✅ UPDATE STUDENTS
        // ============================================================
        $this->Chapter_model->deleteStudentsByClub($club_id);

        $prns          = $this->input->post('prn');
        $student_names = $this->input->post('student_name');
        $mobile_nos    = $this->input->post('mobile_no');
        $branches      = $this->input->post('branch');
        $occupations   = $this->input->post('Occupation');

        if (!empty($prns)) {
            $studentData = [];
            foreach ($prns as $i => $prn) {
                if (!empty($prn) && !empty($student_names[$i])) {
                    $studentData[] = [
                        'club_id'      => $club_id,
                        'prn'          => $prn,
                        'student_name' => $student_names[$i],
                        'mobile_no'    => isset($mobile_nos[$i]) ? $mobile_nos[$i] : null,
                        'branch'       => isset($branches[$i]) ? $branches[$i] : null,
                        'Occupation'   => isset($occupations[$i]) ? $occupations[$i] : null,
                        'created_at'   => date('Y-m-d H:i:s')
                    ];
                }
            }
            
            if (!empty($studentData)) {
                $this->Chapter_model->insertStudents($studentData);
            }
        }

        // ============================================================
        // ✅ UPDATE ACTIVITIES
        // ============================================================
        $this->Chapter_model->deleteActivitiesByClub($club_id);
        
        $activity_Type  = $this->input->post('activity_Type');
        $activity_names = $this->input->post('activity_name');
        $activity_dates = $this->input->post('activity_date');
        $student_counts = $this->input->post('student_count');
        $remarks        = $this->input->post('remark');
        $old_photos     = $this->input->post('old_activity_photo');

        if (!empty($activity_names)) {
            $activitiesData = [];
            
            foreach ($activity_names as $i => $name) {
                if (!empty($name)) {
                    $photoPath = null;

                    if (!empty($_FILES['activity_photo']['name'][$i])) {
                        $_FILES['file']['name']     = $_FILES['activity_photo']['name'][$i];
                        $_FILES['file']['type']     = $_FILES['activity_photo']['type'][$i];
                        $_FILES['file']['tmp_name'] = $_FILES['activity_photo']['tmp_name'][$i];
                        $_FILES['file']['error']    = $_FILES['activity_photo']['error'][$i];
                        $_FILES['file']['size']     = $_FILES['activity_photo']['size'][$i];

                        $config['upload_path']   = FCPATH . 'uploads/Studassociation/';
                        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
                        $config['file_name']     = uniqid() . '_' . $_FILES['file']['name'];

                        if (!is_dir($config['upload_path'])) {
                            mkdir($config['upload_path'], 0777, true);
                        }

                        $this->upload->initialize($config);
                        if ($this->upload->do_upload('file')) {
                            $uploadData = $this->upload->data();
                            $photoPath  = 'uploads/Studassociation/' . $uploadData['file_name'];
                        }
                    } elseif (!empty($old_photos[$i])) {
                        $photoPath = $old_photos[$i];
                    }

                    $activitiesData[] = [
                        'club_id'       => $club_id,
                        'activity_Type' => isset($activity_Type[$i]) ? $activity_Type[$i] : null,
                        'activity_name' => $name,
                        'date'          => isset($activity_dates[$i]) ? $activity_dates[$i] : null,
                        'student_count' => isset($student_counts[$i]) ? $student_counts[$i] : 0,
                        'remark'        => isset($remarks[$i]) ? $remarks[$i] : null,
                        'photo'         => $photoPath,
                        'created_at'    => date('Y-m-d H:i:s')
                    ];
                }
            }
            
            if (!empty($activitiesData)) {
                $this->Chapter_model->insertActivities($activitiesData);
            }
        }

        // ============================================================
        // ✅ UPDATE FACULTY LIST
        // ============================================================
        $this->Chapter_model->deleteFacultylistxcelByClub($club_id);

        $Faculty_Names   = $this->input->post('Faculty_Name');
        $Mobiles         = $this->input->post('Mobile');
        $Email_ids       = $this->input->post('Email_id');
        $Branches        = $this->input->post('Branch');
        $Membership_Nos  = $this->input->post('Membership_No');

        if (!empty($Faculty_Names)) {
            $facultyData = [];

            foreach ($Faculty_Names as $i => $faculty_name) {
                if (!empty($faculty_name)) {
                    $facultyData[] = [
                        'club_id'        => $club_id,
                        'Faculty_Name'   => $faculty_name,
                        'Mobile'         => isset($Mobiles[$i]) ? $Mobiles[$i] : null,
                        'Email_id'       => isset($Email_ids[$i]) ? $Email_ids[$i] : null,
                        'Branch'         => isset($Branches[$i]) ? $Branches[$i] : null,
                        'Membership_No'  => isset($Membership_Nos[$i]) ? $Membership_Nos[$i] : null,
                        'created_at'     => date('Y-m-d H:i:s')
                    ];
                }
            }

            if (!empty($facultyData)) {
                $this->Chapter_model->insertFacultylistxcel($facultyData);
            }
        }

        // ============================================================
        // ✅ HANDLE GALLERY PHOTOS
        // ============================================================
        $removed_photos = $this->input->post('removed_photos');
        if (!empty($removed_photos)) {
            $removed_photos_array = explode(',', $removed_photos);
            $this->Chapter_model->deleteExistingPhotos($club_id, $removed_photos_array);
        }

        if (!empty($_FILES['Photos']['name'][0])) {
            $filesCount   = count($_FILES['Photos']['name']);
            $uploadedData = [];

            $config['upload_path']   = FCPATH . 'uploads/ClubGallery/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
            $config['max_size']      = 2048;

            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }

            $this->load->library('upload');

            for ($i = 0; $i < $filesCount; $i++) {
                if (!empty($_FILES['Photos']['name'][$i])) {
                    $_FILES['file']['name']     = $_FILES['Photos']['name'][$i];
                    $_FILES['file']['type']     = $_FILES['Photos']['type'][$i];
                    $_FILES['file']['tmp_name'] = $_FILES['Photos']['tmp_name'][$i];
                    $_FILES['file']['error']    = $_FILES['Photos']['error'][$i];
                    $_FILES['file']['size']     = $_FILES['Photos']['size'][$i];

                    $config['file_name'] = uniqid() . '_' . $_FILES['file']['name'];

                    $this->upload->initialize($config);

                    if ($this->upload->do_upload('file')) {
                        $uploadData = $this->upload->data();
                        $uploadedData[] = 'uploads/ClubGallery/' . $uploadData['file_name'];
                    }
                }
            }

            if (!empty($uploadedData)) {
                $this->Chapter_model->insertMultiplePhotos($club_id, $uploadedData);
            }
        }

        echo json_encode(['status' => 'success', 'club_id' => $club_id]);

    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
}
public function getFacultyByBranch() {
    $branch_id = $this->input->post('branch_id');
    $result = $this->Chapter_model->getFacultyByBranch($branch_id);
    echo json_encode($result);
}

public function getStudentsByBranch() {
    $branch_id = $this->input->post('branch_id');
    $result = $this->Chapter_model->getStudentsByBranch($branch_id);
    echo json_encode($result);
}

  


         public function Report()
	{
    //   $data['alldata']=$this->Chapter_model->getdetailview();
$data['institutedata'] = $this->Chapter_model->get_all_institute();
 $data['Branch'] = $this->Chapter_model->get_all_Branch();
          $data['Faculty'] = $this->Chapter_model->get_all_Faculty();
           $data['Student'] = $this->Chapter_model->get_all_Student();
$data['yeardata'] = $this->Chapter_model->getyear();
$data['clubNames'] = $this->Chapter_model->getAllClubNames();
$data['branchdata'] = $this->Chapter_model->getbranch();   

 $activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/Chapter_Report_view',$data);
		$this->load->view('admin/footer_view');

	}

public function showDataByInstitute()
{
    $institute_id = $this->input->post('InstituteId');
    $startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');
      $year         = $this->input->post('year'); 
    $branches     = $this->input->post('fkbranch_id');   // ✅ array from multi-select
    $faculties    = $this->input->post('fkFacCo_id');    // ✅ array from multi-select
    $students     = $this->input->post('fkStudCo_id');   // ✅ array from multi-select

    $data = $this->Chapter_model->getDataByInstitute(
        $institute_id,
        $startdate,
        $enddate,
        $year,
        $branches,
        $faculties,
        $students
    );

    echo json_encode($data);
}

public function getPrintHeadings()
{
    $data = $this->Chapter_model->getPrintHeadings();
    echo json_encode($data);
}


public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');

    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->Chapter_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year — pass filters
        $summary = $this->Chapter_model->getSingleYearData($year, $institu, $branches, $startDate, $endDate);
        $types   = $this->Chapter_model->getYearwiseTypes($year, $institu, $branches, $startDate, $endDate);
    }

    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}



 


// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS

    $result = $this->Chapter_model->getBranchwiseCount($institu, $branches, $year, $startDate, $endDate);
    echo json_encode($result);
}

public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS

    $result = $this->Chapter_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate);
    echo json_encode($result);
}


public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu'); 
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');

    $result = $this->Chapter_model->getCombinedData($institu, $branches, $years, $startDate, $endDate);

    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}


public function getClubData()
{
    $club_id = $this->input->post('club_id');

    $activities = $this->db->where('club_id', $club_id)->get('activities')->result();
    $students   = $this->db->where('club_id', $club_id)->get('student_list')->result();

    echo json_encode([
        'activities' => $activities,
        'students'   => $students
    ]);
}


}
