<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Citation_report extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Citation_report_model');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    public function create()
    {
        // Get faculty list from citation_master
        $data['facultydata'] = $this->Citation_report_model->getfaculty();
        $data['yeardata'] = $this->Citation_report_model->getyear();

        $activeYear = $this->db
            ->select('finiYear_id')
            ->from('finiyear_master')
            ->where('Active_Deactive', 1)
            ->get()
            ->row();

        $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Citation_report_view', $data);
        $this->load->view('admin/footer_view');
    }

    // Show master data by selected faculty (or all if empty)
    public function showDataByFaculty()
    {
        $faculty_name = $this->input->post('faculty_name');

        // Allow empty faculty_name to show all data
        $masterData = $this->Citation_report_model->getMasterDataByFaculty($faculty_name);
        echo json_encode(['status' => 'success', 'data' => $masterData]);
    }

    // Get citation articles for graph (year-wise)
    public function getCitationArticlesByYear()
    {
        $faculty_name = $this->input->post('faculty_name');
        $cit_id = $this->input->post('cit_id'); // From master table

        if (empty($cit_id)) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
            return;
        }

        $articleData = $this->Citation_report_model->getArticlesByYear($cit_id);
        echo json_encode(['status' => 'success', 'data' => $articleData]);
    }

    // Get all articles for a faculty member
    public function getAllArticlesByFaculty()
    {
        $cit_id = $this->input->post('cit_id');
        
        if (empty($cit_id)) {
            echo json_encode([]);
            return;
        }

        $articles = $this->Citation_report_model->getArticlesList($cit_id);
        echo json_encode($articles);
    }

    // For print
    public function getPrintHeadings()
    {
        $data = $this->Citation_report_model->getPrintHeadings();
        echo json_encode($data);
    }
}