<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Consultancy extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Consultancy_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
        
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    public function index()
    {
        $data['alldata'] = $this->Consultancy_model->getdetailview();
        $this->load->view('admin/header_view');
        $this->load->view('admin/Consultancy_detailview', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['yeardata'] = $this->Consultancy_model->getYearData();
        $data['facdata'] = $this->Consultancy_model->getfac();
        $data['branchdata'] = $this->Consultancy_model->getbranch();

// ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Consultancy_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Consultancy_dash');
        $this->load->view('admin/footer_view');
    }

    // ⭐ SIMPLIFIED: Update method - loads single record
    public function update()
    {
        $id = $this->uri->segment(4);
        
        // Get single record data
        $result = $this->Consultancy_model->getbyid($id);
        $data['data'] = $result;
        
        // ⭐ Put the single record in childData array format for the view
        $data['childData'] = $result;
        
        // Get dropdown data
        $data['yeardata'] = $this->Consultancy_model->getYearData();
        $data['facdata'] = $this->Consultancy_model->getfac();
        $data['branchdata'] = $this->Consultancy_model->getbranch();

$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Consultancy_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function insertConsultancy()
    {
        $this->load->library('upload');
        
        // Handle new branches
        $new_branches = json_decode($this->input->post('new_branches'), true) ?: [];
        $branch_mapping = [];
        $masters_created = ['branches' => 0, 'faculties' => 0, 'years' => 0];

        foreach ($new_branches as $branch_name) {
            if (!empty($branch_name)) {
                $existing_id = $this->Consultancy_model->getBranchIdByName($branch_name);
                if ($existing_id) {
                    $branch_mapping['NEW::' . $branch_name] = $existing_id;
                } else {
                    $branch_data = ['branch_name' => $branch_name, 'is_active' => 1, 'created_date' => date('Y-m-d H:i:s')];
                    $new_branch_id = $this->Consultancy_model->insertBranch($branch_data);
                    if ($new_branch_id) {
                        $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
                        $masters_created['branches']++;
                    }
                }
            }
        }

        // Handle new faculty
        $new_faculties = json_decode($this->input->post('new_faculties'), true) ?: [];
        $faculty_mapping = [];

        foreach ($new_faculties as $faculty_name) {
            if (!empty($faculty_name)) {
                $existing_id = $this->Consultancy_model->getFacultyIdByName($faculty_name);
                if ($existing_id) {
                    $faculty_mapping['NEW::' . $faculty_name] = $existing_id;
                } else {
                    $faculty_data = ['fac_Fullname' => $faculty_name, 'is_active' => 1, 'created_date' => date('Y-m-d H:i:s')];
                    $new_faculty_id = $this->Consultancy_model->insertFaculty($faculty_data);
                    if ($new_faculty_id) {
                        $faculty_mapping['NEW::' . $faculty_name] = $new_faculty_id;
                        $masters_created['faculties']++;
                    }
                }
            }
        }

        // Handle new years
        $new_years = json_decode($this->input->post('new_years'), true) ?: [];
        $year_mapping = [];

        foreach ($new_years as $year_label) {
            if (!empty($year_label)) {
                $existing_id = $this->Consultancy_model->getYearIdByLabel($year_label);
                if ($existing_id) {
                    $year_mapping['NEW::' . $year_label] = $existing_id;
                } else {
                    $year_data = ['fini_Label' => $year_label, 'is_active' => 1, 'created_date' => date('Y-m-d H:i:s')];
                    $new_year_id = $this->Consultancy_model->insertYear($year_data);
                    if ($new_year_id) {
                        $year_mapping['NEW::' . $year_label] = $new_year_id;
                        $masters_created['years']++;
                    }
                }
            }
        }

        // Handle excel file upload
        $excel_file = null;
        if (!empty($_FILES['excel_file']['name'])) {
            $config_excel['upload_path'] = './uploads/consultancy/excel/';
            $config_excel['allowed_types'] = 'xls|xlsx';
            $config_excel['file_name'] = 'consultancy_' . time() . '_' . $_FILES['excel_file']['name'];
            
            if (!is_dir($config_excel['upload_path'])) {
                mkdir($config_excel['upload_path'], 0777, TRUE);
            }
            
            $this->upload->initialize($config_excel);
            if ($this->upload->do_upload('excel_file')) {
                $excel_file = '/uploads/consultancy/excel/' . $this->upload->data()['file_name'];
            }
        }

        // Get form data arrays
        $fk_fac = $this->input->post('fk_fac');
        $fk_branch = $this->input->post('fk_branch');
        $Financial_year = $this->input->post('Financial_year');
        $startdate = $this->input->post('startdate');
        $enddate = $this->input->post('enddate');
        $Area = $this->input->post('Area');
        $Industry_name = $this->input->post('Industry_name');
        $project_name = $this->input->post('project_name');
        $Revenue = $this->input->post('Revenue');
$fk_submenuId = $this->input->post('fk_submenuId');

        // Process all file uploads
        $request_letter_paths = $this->processFileUploads('request_letter');
        $approve_letter_paths = $this->processFileUploads('approve_letter');
        $invoice_paths = $this->processFileUploads('invoice');
        $report_paths = $this->processFileUploads('report');

        // Get institute ID
        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $institute_id = $institute ? $institute->Institu_id : null;

        // Insert each row
        if (!empty($fk_fac)) {
            foreach ($fk_fac as $i => $faculty_id) {
                if (trim($faculty_id) == '') continue;

                // Map NEW:: values to actual IDs
                $branch_id = $fk_branch[$i] ?? null;
                if ($branch_id && strpos($branch_id, 'NEW::') === 0 && isset($branch_mapping[$branch_id])) {
                    $branch_id = $branch_mapping[$branch_id];
                }

                if ($faculty_id && strpos($faculty_id, 'NEW::') === 0 && isset($faculty_mapping[$faculty_id])) {
                    $faculty_id = $faculty_mapping[$faculty_id];
                }

                $year_id = $Financial_year[$i] ?? null;
                if ($year_id && strpos($year_id, 'NEW::') === 0 && isset($year_mapping[$year_id])) {
                    $year_id = $year_mapping[$year_id];
                }

                $fields = array(
                    'excel_file' => $excel_file,
                    'fk_branch' => $branch_id,
                    'fk_fac' => $faculty_id,
                    'Financial_year' => $year_id,
                    'startdate' => $startdate[$i] ?? null,
                    'enddate' => $enddate[$i] ?? null,
                    'Area' => $Area[$i] ?? null,
                    'Industry_name' => $Industry_name[$i] ?? null,
                    'project_name' => $project_name[$i] ?? null,
                    'Revenue' => $Revenue[$i] ?? null,
                    'request_letter' => $request_letter_paths[$i] ?? null,
                    'approve_letter' => $approve_letter_paths[$i] ?? null,
                    'invoice' => $invoice_paths[$i] ?? null,
                    'report' => $report_paths[$i] ?? null,
                    'Institute' => $institute_id,
                    'created_date' => date('Y-m-d H:i:s'),
                    'created_by'=>$_SESSION['userID']
                );

                // $this->Consultancy_model->insertdata($fields);
                  $inserted_id = $this->Consultancy_model->insertdata($fields);

 
        // Insert log - Action 1 (Insert)

        $action = 1;

        $record_id = $inserted_id;

        $excel_name = null;

        $Fk_branch = $null;

        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

        
 
                
            }
        }

        echo json_encode(['status' => 'success', 'masters_created' => $masters_created]);
    }

   

    public function updateConsultancy()
{
    $this->load->library('upload');
    
    // ⭐ CRITICAL FIX: Get conslt_id from multiple sources
    $conslt_id = $this->input->post('conslt_id');
    
    
    // Check if it's an array and get first value
    if (is_array($conslt_id)) {
        $conslt_id = !empty($conslt_id[0]) ? $conslt_id[0] : null;
    }
    
    // ⭐ FALLBACK: If still empty, check from URI segment
    if (empty($conslt_id)) {
        $conslt_id = $this->uri->segment(4); // From URL: /admin/Consultancy/update/3
    }
    
    // ⭐ VALIDATION: Check if conslt_id exists
    if (empty($conslt_id)) {
        log_message('error', 'No consultancy ID found in POST or URI');
        echo json_encode([
            'status' => 'error', 
            'message' => 'No consultancy ID found. Please try again from the list page.'
        ]);
        return;
    }

    log_message('debug', 'Update Consultancy ID: ' . $conslt_id);

    // Handle new branches, faculties, years
    $new_branches = json_decode($this->input->post('new_branches'), true) ?: [];
    $branch_mapping = [];
    $masters_created = ['branches' => 0, 'faculties' => 0, 'years' => 0];

    foreach ($new_branches as $branch_name) {
        if (!empty($branch_name)) {
            $existing_id = $this->Consultancy_model->getBranchIdByName($branch_name);
            if ($existing_id) {
                $branch_mapping['NEW::' . $branch_name] = $existing_id;
            } else {
                $branch_data = ['branch_name' => $branch_name, 'is_active' => 1, 'created_date' => date('Y-m-d H:i:s')];
                $new_branch_id = $this->Consultancy_model->insertBranch($branch_data);
                if ($new_branch_id) {
                    $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
                    $masters_created['branches']++;
                }
            }
        }
    }

    // Handle new faculties
    $new_faculties = json_decode($this->input->post('new_faculties'), true) ?: [];
    $faculty_mapping = [];

    foreach ($new_faculties as $faculty_name) {
        if (!empty($faculty_name)) {
            $existing_id = $this->Consultancy_model->getFacultyIdByName($faculty_name);
            if ($existing_id) {
                $faculty_mapping['NEW::' . $faculty_name] = $existing_id;
            } else {
                $faculty_data = ['fac_Fullname' => $faculty_name, 'is_active' => 1, 'created_date' => date('Y-m-d H:i:s')];
                $new_faculty_id = $this->Consultancy_model->insertFaculty($faculty_data);
                if ($new_faculty_id) {
                    $faculty_mapping['NEW::' . $faculty_name] = $new_faculty_id;
                    $masters_created['faculties']++;
                }
            }
        }
    }

    // Handle new years
    $new_years = json_decode($this->input->post('new_years'), true) ?: [];
    $year_mapping = [];

    foreach ($new_years as $year_label) {
        if (!empty($year_label)) {
            $existing_id = $this->Consultancy_model->getYearIdByLabel($year_label);
            if ($existing_id) {
                $year_mapping['NEW::' . $year_label] = $existing_id;
            } else {
                $year_data = ['fini_Label' => $year_label, 'is_active' => 1, 'created_date' => date('Y-m-d H:i:s')];
                $new_year_id = $this->Consultancy_model->insertYear($year_data);
                if ($new_year_id) {
                    $year_mapping['NEW::' . $year_label] = $new_year_id;
                    $masters_created['years']++;
                }
            }
        }
    }

    // Handle excel file upload
    $excel_file = $this->input->post('existing_excel_file');
    if (!empty($_FILES['excel_file']['name'])) {
        $config_excel['upload_path'] = './uploads/consultancy/excel/';
        $config_excel['allowed_types'] = 'xls|xlsx';
        $config_excel['file_name'] = 'consultancy_' . time() . '_' . $_FILES['excel_file']['name'];
        
        if (!is_dir($config_excel['upload_path'])) {
            mkdir($config_excel['upload_path'], 0777, TRUE);
        }
        
        $this->upload->initialize($config_excel);
        if ($this->upload->do_upload('excel_file')) {
            $excel_file = '/uploads/consultancy/excel/' . $this->upload->data()['file_name'];
        }
    }

    // Get form data (single values from arrays)
    $fk_fac = $this->input->post('fk_fac');
    $fk_branch = $this->input->post('fk_branch');
    $Financial_year = $this->input->post('Financial_year');
    $startdate = $this->input->post('startdate');
    $enddate = $this->input->post('enddate');
    $Area = $this->input->post('Area');
    $Industry_name = $this->input->post('Industry_name');
    $project_name = $this->input->post('project_name');
    $Revenue = $this->input->post('Revenue');
    $fk_submenuId = $this->input->post('fk_submenuId');

    // Get first values from arrays
    $faculty_id = is_array($fk_fac) ? $fk_fac[0] : $fk_fac;
    $branch_id = is_array($fk_branch) ? $fk_branch[0] : $fk_branch;
    $year_id = is_array($Financial_year) ? $Financial_year[0] : $Financial_year;

    // Map NEW:: values
    if ($branch_id && strpos($branch_id, 'NEW::') === 0 && isset($branch_mapping[$branch_id])) {
        $branch_id = $branch_mapping[$branch_id];
    }

    if ($faculty_id && strpos($faculty_id, 'NEW::') === 0 && isset($faculty_mapping[$faculty_id])) {
        $faculty_id = $faculty_mapping[$faculty_id];
    }

    if ($year_id && strpos($year_id, 'NEW::') === 0 && isset($year_mapping[$year_id])) {
        $year_id = $year_mapping[$year_id];
    }

    // Process file uploads
    $request_letter = $this->processSingleFileUpload('request_letter', 'existing_request_letter');
    $approve_letter = $this->processSingleFileUpload('approve_letter', 'existing_approve_letter');
    $invoice = $this->processSingleFileUpload('invoice', 'existing_invoice');
    $report = $this->processSingleFileUpload('report', 'existing_report');

    // Prepare update data
    $fields = array(
        'conslt_id' => $conslt_id,
        'excel_file' => $excel_file,
        'fk_branch' => $branch_id,
        'fk_fac' => $faculty_id,
        'Financial_year' => $year_id,
        'startdate' => is_array($startdate) ? $startdate[0] : $startdate,
        'enddate' => is_array($enddate) ? $enddate[0] : $enddate,
        'Area' => is_array($Area) ? $Area[0] : $Area,
        'Industry_name' => is_array($Industry_name) ? $Industry_name[0] : $Industry_name,
        'project_name' => is_array($project_name) ? $project_name[0] : $project_name,
        'Revenue' => is_array($Revenue) ? $Revenue[0] : $Revenue,
        'request_letter' => $request_letter,
        'approve_letter' => $approve_letter,
        'invoice' => $invoice,
        'report' => $report,
        'modified_date' => date('Y-m-d H:i:s'),
        'modified_by'=>$_SESSION['userID']
        
    );

    log_message('debug', 'Update fields: ' . print_r($fields, true));

    // Update record
    $update_result = $this->Consultancy_model->update($fields);
    
    // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $conslt_id;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

    if ($update_result) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Data updated successfully',
            'masters_created' => $masters_created
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update data']);
    }
}
    // Helper function to process multiple file uploads
    private function processFileUploads($field_name)
    {
        $file_paths = [];
        
        if (!empty($_FILES[$field_name]['name'])) {
            foreach ($_FILES[$field_name]['name'] as $key => $file_name) {
                if (!empty($file_name)) {
                    $_FILES['upload_file']['name'] = $_FILES[$field_name]['name'][$key];
                    $_FILES['upload_file']['type'] = $_FILES[$field_name]['type'][$key];
                    $_FILES['upload_file']['tmp_name'] = $_FILES[$field_name]['tmp_name'][$key];
                    $_FILES['upload_file']['error'] = $_FILES[$field_name]['error'][$key];
                    $_FILES['upload_file']['size'] = $_FILES[$field_name]['size'][$key];

                    $config['upload_path'] = './uploads/consultancy/documents/';
                    $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx';
                    // $config['max_size'] = 5120;
                    $config['file_name'] = $field_name . '_' . time() . '_' . $key . '_' . $file_name;
                    $config['encrypt_name'] = FALSE;

                    if (!is_dir($config['upload_path'])) {
                        mkdir($config['upload_path'], 0777, TRUE);
                    }

                    $this->upload->initialize($config);

                    if ($this->upload->do_upload('upload_file')) {
                        $uploadData = $this->upload->data();
                        $file_paths[$key] = '/uploads/consultancy/documents/' . $uploadData['file_name'];
                    } else {
                        $file_paths[$key] = null;
                    }
                } else {
                    $file_paths[$key] = null;
                }
            }
        }
        
        return $file_paths;
    }

    // ⭐ NEW: Helper for single file upload (for update mode)
    private function processSingleFileUpload($field_name, $existing_field)
    {
        // Check if new file is uploaded
        if (!empty($_FILES[$field_name]['name']) && !empty($_FILES[$field_name]['name'][0])) {
            $config['upload_path'] = './uploads/consultancy/documents/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx';
            // $config['max_size'] = 5120;
            $config['file_name'] = $field_name . '_' . time() . '_' . $_FILES[$field_name]['name'][0];
            $config['encrypt_name'] = FALSE;

            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, TRUE);
            }

            // Temporarily move array file to single file for upload
            $_FILES['temp_file']['name'] = $_FILES[$field_name]['name'][0];
            $_FILES['temp_file']['type'] = $_FILES[$field_name]['type'][0];
            $_FILES['temp_file']['tmp_name'] = $_FILES[$field_name]['tmp_name'][0];
            $_FILES['temp_file']['error'] = $_FILES[$field_name]['error'][0];
            $_FILES['temp_file']['size'] = $_FILES[$field_name]['size'][0];

            $this->upload->initialize($config);

            if ($this->upload->do_upload('temp_file')) {
                $uploadData = $this->upload->data();
                return '/uploads/consultancy/documents/' . $uploadData['file_name'];
            }
        }
        
        // Return existing file if no new file uploaded
        $existing = $this->input->post($existing_field);
        return is_array($existing) ? $existing[0] : $existing;
    }
}