<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class EnterImport extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('EnterImport_model');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    // Load Import View
    public function create()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/EnterImport_view');
        $this->load->view('admin/footer_view');
    }

    // Load Import View
    public function Report()
    {

        $data['Branch'] = $this->EnterImport_model->getDistinctDepartments();

        $data['institutedata'] = $this->EnterImport_model->get_all_institute();
//  $data['Branch'] = $this->Import_techExcel_model->get_all_Branch();
      
$data['yeardata'] = $this->EnterImport_model->getyear();
 $activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;

        $this->load->view('admin/header_view');
        $this->load->view('admin/NSS_Report',$data);
        $this->load->view('admin/footer_view');
    }



public function showDataByInstitute()
{
    $license_type_id = $this->input->post('InstituteId');
    $startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');
    $departments  = $this->input->post('Department');  // coming from multi-select

    $data = $this->Import_techExcel_model->getDataByInstitute(
        $license_type_id,
        $startdate,
        $enddate,
        $departments
    );

    echo json_encode($data);
}


public function getPrintHeadings()
{
    $data = $this->Import_techExcel_model->getPrintHeadings();
    echo json_encode($data);
}



public function import_excel_save() {
    try {
        $postData = $this->input->post('tableData');
        if (empty($postData)) {
            echo "no_data";
            return;
        }

        $rows = json_decode($postData, true);
 $institute = $this->db->select('Institu_id')
         ->from('institute_master')
         ->get()
         ->row();
             $fkInstitute_id = $institute ? $institute->Institu_id : null;
 

        // ✅ Load maps for existing master data
        $yearMap = [];
        $enterMap = [];
        $licenceMap = [];
        $studentMap = [];
        $branchMap = [];
        $industryMap = [];

        foreach ($this->db->get_where('finiyear_master', ['is_active' => 1, 'is_active' => 1])->result() as $g) {
            $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
        }
        foreach ($this->db->get_where('entrepreneurship_type', ['is_active' => 1, 'is_active' => 1])->result() as $d) {
            $enterMap[strtolower(trim($d->type_name))] = $d->type_id;
        }
        foreach ($this->db->get_where('license_types', ['is_active' => 1, 'is_active' => 1])->result() as $t) {
            $licenceMap[strtolower(trim($t->license_type_name))] = $t->license_type_id;
        }
        foreach ($this->db->get_where('branch_master', ['is_active' => 1, 'is_active' => 1])->result() as $r) {
            $branchMap[strtolower(trim($r->branch_name))] = $r->branch_id;
        }
        foreach ($this->db->get_where('student_reg', ['is_active' => 1, 'is_active' => 1])->result() as $s) {
            $studentMap[strtolower(trim($s->FullName))] = $s->Student_id;
        }
          foreach ($this->db->get_where('industry_types', ['is_active' => 1, 'is_active' => 1])->result() as $s) {
            $industryMap[strtolower(trim($s->industry_type_name))] = $s->industry_type_id;
        }

    
        $rowCount = 0;
        foreach ($rows as $row) {
            $rowCount++;

            // ✅ Header skip
            if ($rowCount === 1) {
                continue;
            }

            // ✅ year Master
            $yearStr = strtolower(trim($row['fkFiniYear_id'] ?? ''));
            if ($yearStr !== '') {
                if (!isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', [
                        'fini_Label' => ucfirst($yearStr),
                        'is_active' => 1,
                        'is_active' => 1
                    ]);
                    $finiYear_id = $this->db->insert_id();
                    $yearMap[$yearStr] = $finiYear_id;
                } else {
                    $finiYear_id = $yearMap[$yearStr];
                }
            } else {
                $finiYear_id = null;
            }

            // ✅ Enter Master
            $enterStr = strtolower(trim($row['fkEnterType_id'] ?? ''));
            if ($enterStr !== '') {
                if (!isset($enterMap[$enterStr])) {
                    $this->db->insert('entrepreneurship_type', [
                        'type_name' => ucfirst($enterStr),
                        'is_active' => 1,
                        'is_active' => 1
                    ]);
                    $type_id = $this->db->insert_id();
                    $enterMap[$enterStr] = $type_id;
                } else {
                    $type_id = $enterMap[$enterStr];
                }
            } else {
                $type_id = null;
            }

            // ✅ License Master
            $licenseStr = strtolower(trim($row['fkLicType_id'] ?? ''));
            if ($licenseStr !== '') {
                if (!isset($licenceMap[$licenseStr])) {
                    $this->db->insert('license_types', [
                        'license_type_name' => ucfirst($licenseStr),
                        'is_active' => 1,
                        'is_active' => 1
                    ]);
                    $license_type_id = $this->db->insert_id();
                    $licenceMap[$licenseStr] = $license_type_id;
                } else {
                    $license_type_id = $licenceMap[$licenseStr];
                }
            } else {
                $license_type_id = null;
            }

            // ✅ Student Master
            $studentStr = strtolower(trim($row['fkStud_id'] ?? ''));
            if ($studentStr !== '') {
                if (!isset($studentMap[$studentStr])) {
                    $this->db->insert('student_reg', [
                        'FullName' => ucfirst($studentStr),
                        'is_active' => 1,
                        'is_active' => 1
                    ]);
                    $Student_id = $this->db->insert_id();
                    $studentMap[$studentStr] = $Student_id;
                } else {
                    $Student_id = $studentMap[$studentStr];
                }
            } else {
                $Student_id = null;
            }

            // ✅ Branch Master
            $branchStr = strtolower(trim($row['fkBranch_id'] ?? ''));
            if ($branchStr !== '') {
                if (!isset($branchMap[$branchStr])) {   // ✅ yahan galti thi tumhare code me (rankeMap use kiya tha)
                    $this->db->insert('branch_master', [
                        'branch_name' => ucfirst($branchStr),
                        'is_active' => 1,
                        'is_active' => 1
                    ]);
                    $branch_id = $this->db->insert_id();
                    $branchMap[$branchStr] = $branch_id;
                } else {
                    $branch_id = $branchMap[$branchStr];
                }
            } else {
                $branch_id = null;
            }

              // ✅ industry Master
            $induStr = strtolower(trim($row['fkInduType_id'] ?? ''));
            if ($induStr !== '') {
                if (!isset($branchMap[$induStr])) {   // ✅ yahan galti thi tumhare code me (rankeMap use kiya tha)
                    $this->db->insert('industry_types', [
                        'industry_type_name' => ucfirst($induStr),
                        'is_active' => 1,
                        'is_active' => 1
                    ]);
                    $industry_type_id = $this->db->insert_id();
                    $branchMap[$induStr] = $industry_type_id;
                } else {
                    $industry_type_id = $branchMap[$induStr];
                }
            } else {
                $industry_type_id = null;
            }

            // ✅ Insert row
            $insertData[] = [
                'fkFiniYear_id'   => $finiYear_id,
                'fkBranch_id'      => $branch_id,
                'fkStud_id'      => $Student_id,
                'prn'    => $row['prn'] ?? '',
                'Mobile'    => $row['Mobile'] ?? '',
                'Email'    => $row['Email'] ?? '',
                'URL'    => $row['URL'] ?? '',
                'CompName'    => $row['CompName'] ?? '',
                'Address'    => $row['Address'] ?? '',
                'ConferCond'    => $row['ConferCond'] ?? '',
                'Feedback'    => $row['Feedback'] ?? '',
                'Suggestion'    => $row['Suggestion'] ?? '',
                'fkEnterType_id'     => $type_id, 
                'fkLicType_id'    => $license_type_id,   
                'fkBranch_id'     => $branch_id,   
                'fkInduType_id'    => $industry_type_id,
                'Activity'    => $row['Activity'] ?? '',
                'fkInstitute_id' => $fkInstitute_id   
            ];
        }

        if (!empty($insertData)) {
            $this->db->insert_batch('enter_master', $insertData);
            echo "success";
        } else {
            echo "no_data";
        }
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}

}
