<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class FacultyReport extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('FacultyReport_model');
    }

    public function Report()
    {
        $data['talukadata'] = $this->FacultyReport_model->getTaluka();
        $data['branchdata'] = $this->FacultyReport_model->getbranch();
        $data['citydata'] = $this->FacultyReport_model->getCity();
        $data['genderdata'] = $this->FacultyReport_model->getGender();
        $data['emptypedata'] = $this->FacultyReport_model->getEMP();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/FacultyReport_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function getReportData()
    {
        $taluka = $this->input->post('fkTaluka_id');
        $branches = $this->input->post('fkbranch_id');
        $city = $this->input->post('fkPresentDist_id');
        $empType = $this->input->post('teaching_type');
        $gender = $this->input->post('fkgender');

        $data = $this->FacultyReport_model->getFilteredData($taluka, $branches, $city, $empType, $gender);
        
        echo json_encode($data);
    }

    public function getPrintHeadings()
    {
        $data = $this->FacultyReport_model->getPrintHeadings();
        echo json_encode($data);
    }
}