<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Faculty extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Faculty_model');

        $this->load->model('Log_model');
        $this->load->helper('log');
        
    }

     public function index()
	{
            $data['Institute'] = $this->Faculty_model->get_all_institute();
        $data['Department'] = $this->Faculty_model->get_all_department();
        $data['Branch'] = $this->Faculty_model->get_all_branch();
         $data['alldata']=$this->Faculty_model->getdetailFaculty();

		$this->load->view('admin/header_view');
		// $this->load->view('Faculty/Faculty_view', $data);
		$this->load->view('admin/Faculty_detailView', $data);
		$this->load->view('admin/footer_view');
	
	

	}

      public function dashboard()
    {
        // $data['alldata']=$this->MiniImport_model->getdetailview();

        $this->load->view('admin/header_view');
        $this->load->view('admin/Faculty_dash_view');
        $this->load->view('admin/footer_view');
    }

    public function create()
	{
       
        $data['genders'] = $this->Faculty_model->get_all_genders();
         $data['Blood'] = $this->Faculty_model->get_all_blood();
        $data['Handi'] = $this->Faculty_model->get_all_handicap();
        $data['Institute'] = $this->Faculty_model->get_all_institute();
        $data['Department'] = $this->Faculty_model->get_all_department();
        $data['Branch'] = $this->Faculty_model->get_all_branch();
        $data['Subject'] = $this->Faculty_model->get_all_subject();
        $data['Designation'] = $this->Faculty_model->get_all_designation();
        $data['Qualification'] = $this->Faculty_model->get_all_Qualification();
        $data['Religion'] = $this->Faculty_model->get_all_Religion();
        $data['Caste'] = $this->Faculty_model->get_all_Caste();
        $data['CasteCate'] = $this->Faculty_model->get_all_CasteCate();
       $data['SubCaste'] = $this->Faculty_model->get_all_SubCaste();
       $data['District'] = $this->Faculty_model->get_all_District();
       $data['State'] = $this->Faculty_model->get_all_State();
       $data['Title'] = $this->Faculty_model->get_all_Title();
        $data['Taluka'] = $this->Faculty_model->get_all_Taluka();


        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
 
 

		$this->load->view('admin/header_view');
		// $this->load->view('Faculty/Faculty_view', $data);
		$this->load->view('admin/Faculty2_view', $data);
		$this->load->view('admin/footer_view');
	

	}

 // File upload method with improved error handling
    private function upload_file($file_name, $upload_path = './upload/')
    {
        // Ensure upload directory exists and is writable
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, TRUE);
        }
 
        $config['upload_path'] = $upload_path;
        $config['allowed_types'] = 'gif|jpg|png|jpeg|pdf';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE; // Use encrypted file names
 
        $this->upload->initialize($config);
 
        if (!$this->upload->do_upload($file_name)) {
            // If upload fails, return false or the current file
            return $this->input->post("hidden_photo{$file_name}");
        } else {
            $upload_data = $this->upload->data();
            return $upload_data['file_name'];
        }
    }
	
// function insertPersonalInfo() {
//     $fkTitle_id = $this->input->post('fkTitle_id'); 
//     $fac_Fullname = $this->input->post('fac_Fullname');
//     $fac_Fname = $this->input->post('fac_Fname');
//     $fac_Mname = $this->input->post('fac_Mname');
//     $fac_Lname = $this->input->post('fac_Lname');
//     $Active_Deactive = $this->input->post('Active_Deactive');
//     $fac_mailId = $this->input->post('fac_mailId');
//     $fac_mobileNo = $this->input->post('fac_mobileNo');
//     $fac_WpNo = $this->input->post('fac_WpNo');

//     // ✅ Mobile number duplication check (right after getting mobile number)
//     $this->load->model('Faculty_model');
//     $exists = $this->Faculty_model->check_mobile_exists($fac_mobileNo);
//     if ($exists) {
//         echo json_encode([
//             'status' => 'error',
//             'message' => 'Mobile number already exists.'
//         ]);
//         return; // ❌ Stop execution if mobile already exists
//     }

//     $fkgender = $this->input->post('fkgender');
//     $fac_EmpID = $this->input->post('fac_EmpID');
//     $fkBloodgrp = $this->input->post('fkBloodgrp');
//     $fkQualify_id = $this->input->post('fkQualify_id');
//     $is_handikaped = $this->input->post('is_handikaped') ? 1 : 0;
//     $fkhandikap_type = $this->input->post('fkhandikap_type');

//     $this->load->library('upload');
//     $photo_filename = $this->upload_file('fac_Photo', './uploads/faculty/');
//     $fac_Photo = $photo_filename ? 'uploads/faculty/' . $photo_filename : '';

//     $fkReligion_id = $this->input->post('fkReligion_id');
//     $fkCaste_id = $this->input->post('fkCaste_id');
//     $fkCasteCateg_id = $this->input->post('fkCasteCateg_id');
//     $fkSubCaste_id = $this->input->post('fkSubCaste_id');
//     $Password = $this->input->post('Password');
//     $CasteNo = $this->input->post('CasteNo');
//       $fkbranch_id = $this->input->post('fkbranch_id');

//     $fields = array(
//         'fkTitle_id' => $fkTitle_id,
//         'fac_Fullname' => $fac_Fullname,
//         'fac_Fname' => $fac_Fname,
//         'fac_Mname' => $fac_Mname,
//         'fac_Lname' => $fac_Lname,
//         'Active_Deactive' => $Active_Deactive,
//         'fac_mailId' => $fac_mailId,
//         'fac_mobileNo' => $fac_mobileNo,
//         'fac_WpNo' => $fac_WpNo,
//         'fkgender' => $fkgender,
//         'fac_EmpID' => $fac_EmpID,
//         'fkBloodgrp' => $fkBloodgrp,
//         'is_handikaped' => $is_handikaped,
//         'fkQualify_id' => $fkQualify_id,
//         'fac_Photo' => $fac_Photo,
//         'fkhandikap_type' => $fkhandikap_type,
//         'CasteNo' => $CasteNo,
//         'Password' => $Password,
//         'fkSubCaste_id' => $fkSubCaste_id,
//         'fkCasteCateg_id' => $fkCasteCateg_id,
//         'fkCaste_id' => $fkCaste_id,
//         'fkReligion_id' => $fkReligion_id,
//         'fkbranch_id'   => $this->input->post('fkbranch_id')
//     );

//     $inserted = $this->Faculty_model->insertdata($fields);
//     $fac_id = $this->db->insert_id();

//     echo json_encode([
//         'status' => 'success',
//         'fac_id' => $fac_id
//     ]);
// }

function insertPersonalInfo() {
    $teaching_type = $this->input->post('teaching_type'); 
    $fktypeDesgnation = $this->input->post('fktypeDesgnation'); 
    $joining_date = $this->input->post('joining_date'); 
     $DOB = $this->input->post('DOB'); 
    $fkTitle_id = $this->input->post('fkTitle_id'); 
    $fac_Fullname = $this->input->post('fac_Fullname');
    $fac_Fname = $this->input->post('fac_Fname');
    $fac_Mname = $this->input->post('fac_Mname');
    $fac_Lname = $this->input->post('fac_Lname');
    $Active_Deactive = $this->input->post('Active_Deactive');
    $fac_mailId = $this->input->post('fac_mailId');
    $fac_mobileNo = $this->input->post('fac_mobileNo');
    $fac_WpNo = $this->input->post('fac_WpNo');
    $fkgender = $this->input->post('fkgender');
    $fac_EmpID = $this->input->post('fac_EmpID');  // ✅ Moved here BEFORE checks
    $fkBloodgrp = $this->input->post('fkBloodgrp');
    $fkQualify_id = $this->input->post('fkQualify_id');
    $is_handikaped = $this->input->post('is_handikaped') ? 1 : 0;
    $fkhandikap_type = $this->input->post('fkhandikap_type');
$fk_submenuId = $this->input->post('fk_submenuId');
 
    // ✅ Now check for duplicates AFTER variables are defined
    $this->load->model('Faculty_model');
    
    // Mobile number duplication check
    $exists = $this->Faculty_model->check_mobile_exists($fac_mobileNo);
    if ($exists) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Mobile number already exists.'
        ]);
        return;
    }

    // Employee ID duplication check
    $emp_exists = $this->Faculty_model->check_empid_exists($fac_EmpID);
    if ($emp_exists) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Employee ID already exists.'
        ]);
        return;
    }

    $this->load->library('upload');
    $photo_filename = $this->upload_file('fac_Photo', './uploads/faculty/');
    $fac_Photo = $photo_filename ? 'uploads/faculty/' . $photo_filename : '';

    $fkReligion_id = $this->input->post('fkReligion_id');
    $fkCaste_id = $this->input->post('fkCaste_id');
    $fkCasteCateg_id = $this->input->post('fkCasteCateg_id');
    $fkSubCaste_id = $this->input->post('fkSubCaste_id');
    $Password = $this->input->post('Password');
    $CasteNo = $this->input->post('CasteNo');
    $fkbranch_id = $this->input->post('fkbranch_id');

    // Validate required fields
    if (empty($teaching_type) || empty($fktypeDesgnation)) {
        echo json_encode(['status' => 'error', 'message' => 'Teaching Type and Type Designation are required']);
        return;
    }

    $fields = array(
        'teaching_type' => $teaching_type,
        'fktypeDesgnation' => $fktypeDesgnation,
        'joining_date' => $joining_date,
        'DOB' => $DOB,
        'fkTitle_id' => $fkTitle_id,
        'fac_Fullname' => $fac_Fullname,
        'fac_Fname' => $fac_Fname,
        'fac_Mname' => $fac_Mname,
        'fac_Lname' => $fac_Lname,
        'Active_Deactive' => $Active_Deactive,
        'fac_mailId' => $fac_mailId,
        'fac_mobileNo' => $fac_mobileNo,
        'fac_WpNo' => $fac_WpNo,
        'fkgender' => $fkgender,
        'fac_EmpID' => $fac_EmpID,
        'fkBloodgrp' => $fkBloodgrp,
        'is_handikaped' => $is_handikaped,
        'fkQualify_id' => $fkQualify_id,
        'fac_Photo' => $fac_Photo,
        'fkhandikap_type' => $fkhandikap_type,
        'CasteNo' => $CasteNo,
        'Password' => $Password,
        'fkSubCaste_id' => $fkSubCaste_id,
        'fkCasteCateg_id' => $fkCasteCateg_id,
        'fkCaste_id' => $fkCaste_id,
        'fkReligion_id' => $fkReligion_id,
        'fkbranch_id' => $fkbranch_id,
        'with_form' => 1,
        'created_by'=>$_SESSION['userID'] // ✅ Flag indicating entry from form
    );

    // ✅ Get active financial year and add to fields
    $finiYear = $this->db
                    ->select('finiYear_id')
                    ->from('finiyear_master')
                    ->where('Active_Deactive', 1)
                    ->get()
                    ->row();
     
    if ($finiYear) {
        $fields['finicial_Year'] = $finiYear->finiYear_id;
    }

    $institute = $this->db
        ->select('Institu_id')
        ->from('institute_master')
        ->get()
        ->row();
 
    if ($institute) {
        $fields['fkInstitute'] = $institute->Institu_id;
    }

    // $inserted = $this->Faculty_model->insertdata($fields);
    $inserted_id = $this->Faculty_model->insertdata($fields);
        $fac_id =$inserted_id ;
 
        // Insert log - Action 1 (Insert)
        $action = 1;
        $record_id = $inserted_id;
        $excel_name = null;
        $Fk_branch = $fkbranch_id;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
    // $fac_id = $this->db->insert_id();

    echo json_encode([
        'status' => 'success',
        'fac_id' => $fac_id
    ]);
}


public function insertAddressInfo() {
    $fac_id = $this->input->post('fac_id'); // Get fac_id from hidden input

    // ✅ Get values from POST request
    $fac_PresentAdd = $this->input->post('fac_PresentAdd');
    $fkPresentDist_id = $this->input->post('fkPresentDist_id');
    $fkPresentState_id = $this->input->post('fkPresentState_id');
      $fkTaluka_id = $this->input->post('fkTaluka_id');
    $fac_PermanantAdd = $this->input->post('fac_PermanantAdd');
    $fkPermanantDist_id = $this->input->post('fkPermanantDist_id');
    $fkPermanantState_id = $this->input->post('fkPermanantState_id');
      $fkCorrTaluka_id = $this->input->post('fkCorrTaluka_id');
$fk_submenuId = $this->input->post('fk_submenuId');
 
    // ✅ Assign to $fields array
    $fields = array(
        'fac_PresentAdd' => $fac_PresentAdd,
        'fkPresentDist_id' => $fkPresentDist_id,
        'fkPresentState_id' => $fkPresentState_id,
        'fkTaluka_id' => $fkTaluka_id,
        'fac_PermanantAdd' => $fac_PermanantAdd,
        'fkPermanantDist_id' => $fkPermanantDist_id,
        'fkPermanantState_id' => $fkPermanantState_id,
        'fkCorrTaluka_id' => $fkCorrTaluka_id,
        'created_by'=>$_SESSION['userID']
    );

    // ✅ Update the row in faculty_master where fac_id matches
    $this->db->where('fac_id', $fac_id);
    $updated = $this->db->update('faculty_master', $fields);

    if ($updated) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Update failed']);
    }
}

// function insertEducationInfo() {
//     $fac_id = $this->input->post('fac_id');
//     $fk_submenuId = $this->input->post('fk_submenuId');
 
//     // ✅ ADD THIS LINE to get experience data
//     $experience_data = $this->input->post('experience_data');
    
//     // Collect all fields from POST
//     $fields = array(
//         'fkfac_HighestQualify' => $this->input->post('fkfac_HighestQualify'),
//         'Board'         => $this->input->post('Board'),
//         'Stream'             => $this->input->post('Stream'),
//         'HSCDipMarks'          => $this->input->post('HSCDipMarks'),
//         'HSCDip_CompliYear'             => $this->input->post('HSCDip_CompliYear'),
//         'Btech_branchID'       => $this->input->post('Btech_branchID'),
//         'Btech_Uni'       => $this->input->post('Btech_Uni'),
//         'Btech_Mark'           => $this->input->post('Btech_Mark'),
//         'Btech_CompliYear'     => $this->input->post('Btech_CompliYear'),
//         'Mtech_branchID'       => $this->input->post('Mtech_branchID'),
//         'Mtech_Uni'       => $this->input->post('Mtech_Uni'),
//         'Mtech_Mark'           => $this->input->post('Mtech_Mark'),
//         'Mtech_CompliYear'     => $this->input->post('Mtech_CompliYear'),
//         'PHD_flag'             => $this->input->post('PHD_flag') ? 1 : 0,
//         'PHD_branchID'         => $this->input->post('PHD_branchID'),
//         'PHD_CompliYear'       => $this->input->post('PHD_CompliYear'),
//         'Teach_Exp'        => $this->input->post('Teach_Exp'),
//         'Indu_Exp'         => $this->input->post('Indu_Exp'),
//         'Pre_work'         => $this->input->post('Pre_work'),
//         'experience_data'  => $experience_data,  // ✅ ADD THIS LINE
//         'created_by'=>$_SESSION['userID']
//     );

//     // Update the row in faculty_master where fac_id matches
//     $this->db->where('fac_id', $fac_id);
//     $updated = $this->db->update('faculty_master', $fields);

//     if ($updated) {
//         echo json_encode(['status' => 'success']);
//     } else {
//         echo json_encode(['status' => 'error', 'message' => 'Update failed']);
//     }
// }
function insertEducationInfo() {
    $fac_id = $this->input->post('fac_id');
    $fk_submenuId = $this->input->post('fk_submenuId');
    
    // Get experience data from POST
    $experience_data_json = $this->input->post('experience_data');
    
    // Process experience data and save files
    $processed_experience_data = null;
    if (!empty($experience_data_json)) {
        $experiences = json_decode($experience_data_json, true);
        
        if (is_array($experiences) && count($experiences) > 0) {
            $upload_path = './uploads/experience/';
            
            // Create directory if it doesn't exist
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, TRUE);
            }
            
            $processed_experiences = [];
            
            foreach ($experiences as $index => $exp) {
                // Process file if present
                if (isset($exp['exp_letter']) && !empty($exp['exp_letter'])) {
                    
                    // ✅ Check if it's an array (new upload with base64 data)
                    if (is_array($exp['exp_letter']) && isset($exp['exp_letter']['data'])) {
                        $fileData = $exp['exp_letter']['data'];
                        $fileName = $exp['exp_letter']['name'];
                        
                        // Extract base64 data
                        if (preg_match('/^data:([^;]+);base64,(.+)$/', $fileData, $matches)) {
                            $data = base64_decode($matches[2]);
                            
                            // Generate unique filename
                            $extension = pathinfo($fileName, PATHINFO_EXTENSION);
                            $newFileName = 'exp_' . $fac_id . '_' . time() . '_' . $index . '.' . $extension;
                            $uploadFilePath = $upload_path . $newFileName;
                            
                            // Save file
                            if (file_put_contents($uploadFilePath, $data)) {
                                // Update exp_letter with saved path
                                $exp['exp_letter'] = $uploadFilePath;
                            } else {
                                // If file save fails, set to null
                                $exp['exp_letter'] = null;
                            }
                        } else {
                            $exp['exp_letter'] = null;
                        }
                    } 
                    // ✅ Check if it's a string (existing file path)
                    elseif (is_string($exp['exp_letter'])) {
                        // If it's already a path, verify it exists
                        if (!file_exists($exp['exp_letter'])) {
                            $exp['exp_letter'] = null;
                        }
                        // Otherwise keep the existing path as is
                    } 
                    // ✅ Handle any other unexpected data type
                    else {
                        $exp['exp_letter'] = null;
                    }
                } else {
                    // No file data present
                    $exp['exp_letter'] = null;
                }
                
                $processed_experiences[] = $exp;
            }
            
            $processed_experience_data = json_encode($processed_experiences);
        }
    }
    
    // Collect all fields from POST
    $fields = array(
        'fkfac_HighestQualify' => $this->input->post('fkfac_HighestQualify'),
        'Board'         => $this->input->post('Board'),
        'Stream'        => $this->input->post('Stream'),
        'HSCDipMarks'   => $this->input->post('HSCDipMarks'),
        'HSCDip_CompliYear' => $this->input->post('HSCDip_CompliYear'),
        'Btech_branchID' => $this->input->post('Btech_branchID'),
        'Btech_Uni'     => $this->input->post('Btech_Uni'),
        'Btech_Mark'    => $this->input->post('Btech_Mark'),
        'Btech_CompliYear' => $this->input->post('Btech_CompliYear'),
        'Mtech_branchID' => $this->input->post('Mtech_branchID'),
        'Mtech_Uni'     => $this->input->post('Mtech_Uni'),
        'Mtech_Mark'    => $this->input->post('Mtech_Mark'),
        'Mtech_CompliYear' => $this->input->post('Mtech_CompliYear'),
        'PHD_flag'      => $this->input->post('PHD_flag') ? 1 : 0,
        'PHD_branchID'  => $this->input->post('PHD_branchID'),
        'PHD_CompliYear' => $this->input->post('PHD_CompliYear'),
        'Teach_Exp'     => $this->input->post('Teach_Exp'),
        'Indu_Exp'      => $this->input->post('Indu_Exp'),
        'Pre_work'      => $this->input->post('Pre_work'),
        'experience_data' => $processed_experience_data,
        'modified_by'   => $_SESSION['userID']  // ✅ Changed to modified_by for updates
    );

    // Update the row in faculty_master where fac_id matches
    $this->db->where('fac_id', $fac_id);
    $updated = $this->db->update('faculty_master', $fields);

    if ($updated || $this->db->affected_rows() >= 0) {
        echo json_encode(['status' => 'success', 'message' => 'Education information saved successfully']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Update failed']);
    }
}
public function insertDocumentInfo()
{
    $fac_id = $this->input->post('fac_id');
    
    if (!$fac_id) {
        echo json_encode(['status' => 'error', 'message' => 'Faculty ID is missing']);
        return;
    }

    $upload_path = './uploads/documents/';
    $this->load->library('upload');

    // Reusable file upload function
    function upload_file($field_name, $upload_path)
    {
        $CI =& get_instance();

        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, TRUE);
        }

        $config['upload_path']   = $upload_path;
        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx';
        $config['max_size']      = 5120; // 5MB
        $config['encrypt_name']  = TRUE;

        $CI->upload->initialize($config);

        if (!$CI->upload->do_upload($field_name)) {
            // If no new file uploaded, get from hidden input
            return $CI->input->post('hidden_' . $field_name);
        } else {
            $data = $CI->upload->data();
            return $upload_path . $data['file_name'];
        }
    }

    // Upload file fields (with fallback)
    $fac_AadharPhoto     = upload_file('fac_AadharPhoto', $upload_path);
    $fac_PanCardPhoto    = upload_file('fac_PanCardPhoto', $upload_path);
    $Doc1                = upload_file('Doc1', $upload_path);
    $SSCCer                = upload_file('SSCCer', $upload_path);
    $Doc2                = upload_file('Doc2', $upload_path);
    $DiplomaHSC_Cer                = upload_file('DiplomaHSC_Cer', $upload_path);
    $Doc3                = upload_file('Doc3', $upload_path);
    $BECer                = upload_file('BECer', $upload_path);
    $fac_CasteValPhoto   = upload_file('fac_CasteValPhoto', $upload_path);
    $MeCer                = upload_file('MeCer', $upload_path);
    $Resume              = upload_file('Resume', $upload_path);
    $phdCer                = upload_file('phdCer', $upload_path);
    $RationCard              = upload_file('RationCard', $upload_path);
    $jobApply              = upload_file('jobApply', $upload_path);
    $BankPass              = upload_file('BankPass', $upload_path);
    $Gazzette              = upload_file('Gazzette', $upload_path);
$fk_submenuId = $this->input->post('fk_submenuId');
 
    // Collect text inputs
    $fields = array(
        'fac_AadharNo'     => $this->input->post('fac_AadharNo'),
        'fac_PanCardNo'    => $this->input->post('fac_PanCardNo'),
        'fac_VoterCard'    => $this->input->post('fac_VoterCard'),
        'fac_DrivingLic'   => $this->input->post('fac_DrivingLic'),
        // 'Teach_Exp'        => $this->input->post('Teach_Exp'),
        // 'Indu_Exp'         => $this->input->post('Indu_Exp'),
        // 'joining_date'     => $this->input->post('joining_date'),
        // 'Pre_work'         => $this->input->post('Pre_work'),
        'fac_AadharPhoto'  => $fac_AadharPhoto,
        'fac_PanCardPhoto' => $fac_PanCardPhoto,
        'Doc1'             => $Doc1,
        'SSCCer'             => $SSCCer,
        'Doc2'             => $Doc2,
        'DiplomaHSC_Cer'             => $DiplomaHSC_Cer,
        'Doc3'             => $Doc3,
        'BECer'             => $BECer,
        'fac_CasteValPhoto'=> $fac_CasteValPhoto,
        'MeCer'             => $MeCer,
        'Resume'           => $Resume,
        'phdCer'             => $phdCer,
         'RationCard'           => $RationCard,
          'jobApply'           => $jobApply,
           'BankPass'           => $BankPass,
            'Gazzette'           => $Gazzette,
            'created_by'=>$_SESSION['userID'],
    );

    $this->db->where('fac_id', $fac_id);
    $updated = $this->db->update('faculty_master', $fields);

    if ($updated) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Update failed']);
    }
}


// public function insertDepartmentInfo()
// {
//     $fac_id = $this->input->post('fac_id');

//     if (!$fac_id) {
//         echo json_encode(['status' => 'error', 'message' => 'Faculty ID is missing']);
//         return;
//     }

//     // Gather inputs
//     $fields = array(
//         'fkInstitute'  => $this->input->post('fkInstitute'),
//         'fkdep_id'      => $this->input->post('fkdep_id'),
//         // 'fkbranch_id'   => $this->input->post('fkbranch_id'),
//         'fkSubject'      => $this->input->post('fkSubject'),
//         'fkDesignation'    => $this->input->post('fkDesignation'),
//         'joining_date'     => $this->input->post('joining_date'),
//     );

//     // Update in DB
//     $this->db->where('fac_id', $fac_id);
//     $updated = $this->db->update('faculty_master', $fields);

//     if ($updated) {
//         echo json_encode(['status' => 'success']);
//     } else {
//         echo json_encode(['status' => 'error', 'message' => 'Update failed']);
//     }
// }

public function insertDepartmentInfo()
{
    $fac_id = $this->input->post('fac_id');
$fk_submenuId = $this->input->post('fk_submenuId');
 
    if (!$fac_id) {
        echo json_encode(['status' => 'error', 'message' => 'Faculty ID is missing']);
        return;
    }

    // Gather inputs (including both teaching_type and fktypeDesgnation)
    $fields = array(
        'fkInstitute'       => $this->input->post('fkInstitute'),
        'fkdep_id'          => $this->input->post('fkdep_id'),
        'fkSubject'         => $this->input->post('fkSubject'),
         'working_branch'     => $this->input->post('working_branch'),
        'teaching_type'     => $this->input->post('teaching_type'),      // Teaching/Non-Teaching
        'fktypeDesgnation'  => $this->input->post('fktypeDesgnation'),   // Specific designation
        'fkDesignation'     => $this->input->post('fkDesignation'),
       
        'joining_date'      => $this->input->post('joining_date'),
        'created_by'=>$_SESSION['userID'],
    );

    // Validate required fields
    if (empty($fields['teaching_type']) || empty($fields['fktypeDesgnation'])) {
        echo json_encode(['status' => 'error', 'message' => 'Teaching Type and Type Designation are required']);
        return;
    }

    // Update in DB
    $this->db->where('fac_id', $fac_id);
    $updated = $this->db->update('faculty_master', $fields);

    if ($updated) {
        echo json_encode(['status' => 'success', 'message' => 'Department information updated successfully']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Update failed']);
    }
}

 public function update()
    {
        $id=$this->uri->segment(4);
          $data['data']=$this->Faculty_model->getbyid($id);
     $data['genders'] = $this->Faculty_model->get_all_genders();
         $data['Blood'] = $this->Faculty_model->get_all_blood();
        $data['Handi'] = $this->Faculty_model->get_all_handicap();
        $data['Institute'] = $this->Faculty_model->get_all_institute();
        $data['Department'] = $this->Faculty_model->get_all_department();
        $data['Branch'] = $this->Faculty_model->get_all_branch();
        $data['Subject'] = $this->Faculty_model->get_all_subject();
        $data['Designation'] = $this->Faculty_model->get_all_designation();
        $data['Qualification'] = $this->Faculty_model->get_all_Qualification();
        $data['Religion'] = $this->Faculty_model->get_all_Religion();
        $data['Caste'] = $this->Faculty_model->get_all_Caste();
        $data['CasteCate'] = $this->Faculty_model->get_all_CasteCate();
       $data['SubCaste'] = $this->Faculty_model->get_all_SubCaste();
       $data['District'] = $this->Faculty_model->get_all_District();
       $data['State'] = $this->Faculty_model->get_all_State();
       $data['Title'] = $this->Faculty_model->get_all_Title();
       $data['Taluka'] = $this->Faculty_model->get_all_Taluka();



        $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
   
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

		$this->load->view('admin/header_view');
		// $this->load->view('Faculty/Faculty_view', $data);
		$this->load->view('admin/FacultyUpdate_view', $data);
		$this->load->view('admin/footer_view');

    }


// Updated updatePersonalInfo() method
public function updatePersonalInfo()
{
    $fac_id = $this->input->post('fac_id');
    
    // ✅ Define ALL variables FIRST before using them
    $teaching_type = $this->input->post('teaching_type');
    $fktypeDesgnation = $this->input->post('fktypeDesgnation');
    $joining_date = $this->input->post('joining_date');
     $DOB = $this->input->post('DOB'); 
    $fkTitle_id = $this->input->post('fkTitle_id');
    $fac_Fullname = $this->input->post('fac_Fullname');
    $fac_Fname = $this->input->post('fac_Fname');
    $fac_Mname = $this->input->post('fac_Mname');
    $fac_Lname = $this->input->post('fac_Lname');
    $Active_Deactive = $this->input->post('Active_Deactive');
    $fac_mailId = $this->input->post('fac_mailId');
    $fac_mobileNo = $this->input->post('fac_mobileNo');
    $fac_WpNo = $this->input->post('fac_WpNo');
    $fkgender = $this->input->post('fkgender');
    $fac_EmpID = $this->input->post('fac_EmpID');
    $fkBloodgrp = $this->input->post('fkBloodgrp');
    $is_handikaped = $this->input->post('is_handikaped') ? 1 : 0;
    $fkhandikap_type = $this->input->post('fkhandikap_type');
    $fkQualify_id = $this->input->post('fkQualify_id');
    $fkReligion_id = $this->input->post('fkReligion_id');
    $fkCaste_id = $this->input->post('fkCaste_id');
    $fkCasteCateg_id = $this->input->post('fkCasteCateg_id');
    $fkSubCaste_id = $this->input->post('fkSubCaste_id');
    $Password = $this->input->post('Password');
    $CasteNo = $this->input->post('CasteNo');
    $fkbranch_id = $this->input->post('fkbranch_id');
$fk_submenuId = $this->input->post('fk_submenuId');
 
    // Now build the fields array
    $fields = array(
        'teaching_type' => $teaching_type,
        'fktypeDesgnation' => $fktypeDesgnation,
        'joining_date' => $joining_date,
        'DOB' => $DOB,
        'fkTitle_id' => $fkTitle_id,
        'fac_Fullname' => $fac_Fullname,
        'fac_Fname' => $fac_Fname,
        'fac_Mname' => $fac_Mname,
        'fac_Lname' => $fac_Lname,
        'Active_Deactive' => $Active_Deactive,
        'fac_mailId' => $fac_mailId,
        'fac_mobileNo' => $fac_mobileNo,
        'fac_WpNo' => $fac_WpNo,
        'fkgender' => $fkgender,
        'fac_EmpID' => $fac_EmpID,
        'fkBloodgrp' => $fkBloodgrp,
        'is_handikaped' => $is_handikaped,
        'fkhandikap_type' => $fkhandikap_type,
        'fkQualify_id' => $fkQualify_id,
        'fkReligion_id' => $fkReligion_id,
        'fkCaste_id' => $fkCaste_id,
        'fkCasteCateg_id' => $fkCasteCateg_id,
        'fkSubCaste_id' => $fkSubCaste_id,
        'Password' => $Password,
        'CasteNo' => $CasteNo,
        'fkbranch_id' => $fkbranch_id,
        'with_form' => 1,
        'modified_by'=>$_SESSION['userID']
    );

    // ✅ Get active financial year
    $finiYear = $this->db
                    ->select('finiYear_id')
                    ->from('finiyear_master')
                    ->where('Active_Deactive', 1)
                    ->get()
                    ->row();
     
    if ($finiYear) {
        $fields['finicial_Year'] = $finiYear->finiYear_id;
    }

    // ✅ Get institute
    $institute = $this->db
        ->select('Institu_id')
        ->from('institute_master')
        ->get()
        ->row();
 
    if ($institute) {
        $fields['fkInstitute'] = $institute->Institu_id;
    }

    // Handle photo upload
    $this->load->library('upload');
    $photo_filename = $this->upload_file('fac_Photo', './uploads/faculty/');
    if ($photo_filename) {
        $fields['fac_Photo'] = 'uploads/faculty/' . $photo_filename;
    }

    // Update in database
    $this->db->where('fac_id', $fac_id);
    $updated = $this->db->update('faculty_master', $fields);
    // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $fac_id;
        $excel_name = null;
        $Fk_branch = $fkbranch_id;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

    // Return JSON response
    if ($updated || $this->db->affected_rows() >= 0) {
        echo json_encode([
            'status' => 'success',
            'fac_id' => $fac_id,
            'message' => 'Personal information updated successfully'
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to update personal information'
        ]);
    }
}
 
//  public function insertDocumentInfo() {
//     $fac_id = $this->input->post('fac_id');

//     if (!$fac_id) {
//         echo json_encode(['status' => 'error', 'message' => 'Faculty ID is missing']);
//         return;
//     }

//     $upload_path = './uploads/documents/';
//     $allowed_types = 'jpg|jpeg|png|pdf|doc|docx';
//     $this->load->library('upload');

//     // Helper function to upload files
//     function uploadFile($field, $upload_path, $allowed_types) {
//         $CI =& get_instance();
//         if (!empty($_FILES[$field]['name'])) {
//             $config['upload_path'] = $upload_path;
//             $config['allowed_types'] = $allowed_types;
//             $config['file_name'] = time() . '_' . $field . '_' . $_FILES[$field]['name'];
//             $CI->upload->initialize($config);

//             if ($CI->upload->do_upload($field)) {
//                 $uploadData = $CI->upload->data();
//                 return $upload_path . $uploadData['file_name'];
//             }
//         }
//         return '';
//     }

//     // Upload file fields
//     $fac_AadharPhoto = uploadFile('fac_AadharPhoto', $upload_path, $allowed_types);
//     $fac_PanCardPhoto = uploadFile('fac_PanCardPhoto', $upload_path, $allowed_types);
//     $Doc1 = uploadFile('Doc1', $upload_path, $allowed_types);
//     $Doc2 = uploadFile('Doc2', $upload_path, $allowed_types);
//     $Doc3 = uploadFile('Doc3', $upload_path, $allowed_types);
//     $fac_CasteValPhoto = uploadFile('fac_CasteValPhoto', $upload_path, $allowed_types);
//     $Resume = uploadFile('Resume', $upload_path, $allowed_types);

//     // Collect text fields
//     $fields = array(
//         'fac_AadharNo'       => $this->input->post('fac_AadharNo'),
//         'fac_PanCardNo'      => $this->input->post('fac_PanCardNo'),
//         'fac_VoterCard'      => $this->input->post('fac_VoterCard'),
//         'fac_DrivingLic'     => $this->input->post('fac_DrivingLic'),
//         'Teach_Exp'          => $this->input->post('Teach_Exp'),
//         'Indu_Exp'           => $this->input->post('Indu_Exp'),
//         'joining_date'       => $this->input->post('joining_date'),
//         'Pre_work'           => $this->input->post('Pre_work')
//     );

//     // Add file paths if uploaded
//     if ($fac_AadharPhoto) $fields['fac_AadharPhoto'] = $fac_AadharPhoto;
//     if ($fac_PanCardPhoto) $fields['fac_PanCardPhoto'] = $fac_PanCardPhoto;
//     if ($Doc1) $fields['Doc1'] = $Doc1;
//     if ($Doc2) $fields['Doc2'] = $Doc2;
//     if ($Doc3) $fields['Doc3'] = $Doc3;
//     if ($fac_CasteValPhoto) $fields['fac_CasteValPhoto'] = $fac_CasteValPhoto;
//     if ($Resume) $fields['Resume'] = $Resume;

//     // Update database
//     $this->db->where('fac_id', $fac_id);
//     $updated = $this->db->update('faculty_master', $fields);

//     if ($updated) {
//         echo json_encode(['status' => 'success']);
//     } else {
//         echo json_encode(['status' => 'error', 'message' => 'Update failed']);
//     }
// }

public function searchQualifications()
{
    $search = $this->input->post('search');

    if (empty($search)) {
        echo json_encode(['success' => false, 'data' => []]);
        return;
    }

    $this->db->select('DISTINCT fkQualify_id as Qualification', false);
    $this->db->from('faculty_master');
    $this->db->like('fkQualify_id', $search);
    $this->db->where('fkQualify_id IS NOT NULL');
    $this->db->where('fkQualify_id !=', '');
    $this->db->order_by('fkQualify_id', 'ASC');
    $this->db->limit(10);

    $query = $this->db->get();

    echo json_encode([
        'success' => true,
        'data' => $query->result_array()
    ]);
}

// Search Job Details
public function searchJobDetails() {
    $search = $this->input->post('search', TRUE);
    
    // Check if search is empty
    if (empty($search)) {
        echo json_encode([
            'success' => false,
            'data' => []
        ]);
        return;
    }
    
    // Get all faculty with experience data
    $this->db->select('experience_data');
    $this->db->from('faculty_master');
    $this->db->where('experience_data IS NOT NULL');
    $this->db->where('experience_data !=', '');
    $query = $this->db->get();
    
    $jobDetailsArray = [];
    
    if ($query->num_rows() > 0) {
        foreach ($query->result() as $row) {
            $experienceData = json_decode($row->experience_data, true);
            
            if (is_array($experienceData)) {
                foreach ($experienceData as $exp) {
                    if (isset($exp['job_details']) && !empty($exp['job_details'])) {
                        // Check if search term matches
                        if (stripos($exp['job_details'], $search) !== false) {
                            // Avoid duplicates
                            if (!in_array($exp['job_details'], $jobDetailsArray)) {
                                $jobDetailsArray[] = $exp['job_details'];
                            }
                        }
                    }
                }
            }
        }
    }
    
    // Sort alphabetically
    sort($jobDetailsArray);
    
    // Limit to 10 results
    $jobDetailsArray = array_slice($jobDetailsArray, 0, 10);
    
    // Format for response
    $result = [];
    foreach ($jobDetailsArray as $jobDetail) {
        $result[] = ['job_details' => $jobDetail];
    }
    
    if (count($result) > 0) {
        echo json_encode([
            'success' => true,
            'data' => $result
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'data' => []
        ]);
    }
}

// Search Company Name
public function searchCompanyName() {
    $search = $this->input->post('search', TRUE);
    
    // Check if search is empty
    if (empty($search)) {
        echo json_encode([
            'success' => false,
            'data' => []
        ]);
        return;
    }
    
    // Get all faculty with experience data
    $this->db->select('experience_data');
    $this->db->from('faculty_master');
    $this->db->where('experience_data IS NOT NULL');
    $this->db->where('experience_data !=', '');
    $query = $this->db->get();
    
    $companyNamesArray = [];
    
    if ($query->num_rows() > 0) {
        foreach ($query->result() as $row) {
            $experienceData = json_decode($row->experience_data, true);
            
            if (is_array($experienceData)) {
                foreach ($experienceData as $exp) {
                    if (isset($exp['company_name']) && !empty($exp['company_name'])) {
                        // Check if search term matches
                        if (stripos($exp['company_name'], $search) !== false) {
                            // Avoid duplicates
                            if (!in_array($exp['company_name'], $companyNamesArray)) {
                                $companyNamesArray[] = $exp['company_name'];
                            }
                        }
                    }
                }
            }
        }
    }
    
    // Sort alphabetically
    sort($companyNamesArray);
    
    // Limit to 10 results
    $companyNamesArray = array_slice($companyNamesArray, 0, 10);
    
    // Format for response
    $result = [];
    foreach ($companyNamesArray as $companyName) {
        $result[] = ['company_name' => $companyName];
    }
    
    if (count($result) > 0) {
        echo json_encode([
            'success' => true,
            'data' => $result
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'data' => []
        ]);
    }
}

// Search Job Type
public function searchJobType() {
    $search = $this->input->post('search', TRUE);
    
    // Check if search is empty
    if (empty($search)) {
        echo json_encode([
            'success' => false,
            'data' => []
        ]);
        return;
    }
    
    // Get all faculty with experience data
    $this->db->select('experience_data');
    $this->db->from('faculty_master');
    $this->db->where('experience_data IS NOT NULL');
    $this->db->where('experience_data !=', '');
    $query = $this->db->get();
    
    $jobTypesArray = [];
    
    if ($query->num_rows() > 0) {
        foreach ($query->result() as $row) {
            $experienceData = json_decode($row->experience_data, true);
            
            if (is_array($experienceData)) {
                foreach ($experienceData as $exp) {
                    if (isset($exp['job_type']) && !empty($exp['job_type'])) {
                        // Check if search term matches
                        if (stripos($exp['job_type'], $search) !== false) {
                            // Avoid duplicates
                            if (!in_array($exp['job_type'], $jobTypesArray)) {
                                $jobTypesArray[] = $exp['job_type'];
                            }
                        }
                    }
                }
            }
        }
    }
    
    // Sort alphabetically
    sort($jobTypesArray);
    
    // Limit to 10 results
    $jobTypesArray = array_slice($jobTypesArray, 0, 10);
    
    // Format for response
    $result = [];
    foreach ($jobTypesArray as $jobType) {
        $result[] = ['job_type' => $jobType];
    }
    
    if (count($result) > 0) {
        echo json_encode([
            'success' => true,
            'data' => $result
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'data' => []
        ]);
    }
}

public function addSubCaste()
{
    // Allow only AJAX
    if (!$this->input->is_ajax_request()) {
        show_404();
        return;
    }

    $subcaste_name = trim($this->input->post('subcaste_name'));

    // Validation
    if (empty($subcaste_name)) {
        echo json_encode([
            'success' => false,
            'message' => 'Sub-Caste name is required!'
        ]);
        return;
    }

    // Check if sub-caste already exists
    $this->db->where('SubCaste_name', $subcaste_name);
    $existing = $this->db->get('subcaste_master')->row();

    if ($existing) {
        echo json_encode([
            'success' => false,
            'message' => 'This Sub-Caste already exists!'
        ]);
        return;
    }

    // Insert new sub-caste
    $data = [
        'SubCaste_name' => $subcaste_name,
        'is_active'     => 1
    ];

    $this->db->insert('subcaste_master', $data);
    $insert_id = $this->db->insert_id();

    if ($insert_id) {
        echo json_encode([
            'success' => true,
            'message' => 'Sub-Caste added successfully!',
            'data' => [
                'SubCaste_id'   => $insert_id,
                'SubCaste_name' => $subcaste_name
            ]
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Failed to add Sub-Caste. Please try again.'
        ]);
    }
}

}