<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Firstinduction extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Firstinduction_model');
        $this->load->library('upload');
        $this->load->helper('url');
        $this->load->library('session');
    }
    
    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Firstinduction_dash_view.php');
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['yeardata'] = $this->Firstinduction_model->getyear();
        $data['activeYear'] = $this->Firstinduction_model->getActiveYear();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Firstinduction_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function index()
    {
        $data['alldata'] = $this->Firstinduction_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Firstinduction_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function update($id)
    {
        $data['yeardata'] = $this->Firstinduction_model->getyear();
        $data['activeYear'] = $this->Firstinduction_model->getActiveYear();
        $data['data'] = $this->Firstinduction_model->getInductionById($id);
        $data['childData'] = array(
            'sec' => $this->Firstinduction_model->getSecDataByMainId($id),
            'third' => $this->Firstinduction_model->getThirdDataByMainId($id),
            'fourth' => $this->Firstinduction_model->getFourthDataByMainId($id),
            'fifth' => $this->Firstinduction_model->getFifthDataByMainId($id)
        );
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Firstinduction_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function delete($id)
    {
        $result = $this->Firstinduction_model->deleteByMainId($id);
        
        if($result) {
            $this->session->set_flashdata('success', 'Record deleted successfully');
        } else {
            $this->session->set_flashdata('error', 'Failed to delete record');
        }
        
        redirect('admin/Firstinduction/index');
    }

    /**
     * Optimized Save Function - Processes all data efficiently
     */
    public function save()
    {
        try {
            // Start transaction for faster execution
            $this->db->trans_start();
            
            // Get form data
            $mainId = $this->input->post('Main_id');
            $isUpdate = !empty($mainId);
            
            // Prepare main table data
            $mainData = array(
                'finicial_Year' => $this->input->post('finicial_Year'),
                'Start_date' => $this->input->post('Start_date'),
                'End_date' => $this->input->post('End_date')
            );
            
            // Handle file uploads for main table
            $mainData = $this->processMainFiles($mainData, $isUpdate);
            
            // Insert or update main data
            if($isUpdate) {
                $this->db->where('Main_id', $mainId);
                $this->db->update('firstinduction_main_master', $mainData);
            } else {
                $this->db->insert('firstinduction_main_master', $mainData);
                $mainId = $this->db->insert_id();
            }
            
            // Process all tabs with batch operations for efficiency
            $this->processTab2Data($mainId, $isUpdate);
            $this->processTab6Data($mainId, $isUpdate);
            $this->processTab7Data($mainId, $isUpdate);
            $this->processTab8Data($mainId, $isUpdate);
            
            // Complete transaction
            $this->db->trans_complete();
            
            // Check if transaction was successful
            if ($this->db->trans_status() === FALSE) {
                throw new Exception('Database transaction failed');
            }
            
            // Return success response
            echo json_encode(array(
                'status' => 'success',
                'message' => $isUpdate ? 'Data updated successfully' : 'Data saved successfully',
                'main_id' => $mainId
            ));
            
        } catch(Exception $e) {
            // Rollback transaction if there's an error
            $this->db->trans_rollback();
            
            echo json_encode(array(
                'status' => 'error',
                'message' => 'Error: ' . $e->getMessage()
            ));
        }
    }
    
    /**
     * Optimized Update Function - Updates only changed data efficiently
     */
    public function updateData()
    {
        try {
            // Start transaction for faster execution
            $this->db->trans_start();
            
            // Get main ID
            $mainId = $this->input->post('Main_id');
            
            if(empty($mainId)) {
                throw new Exception('Main ID is required for update');
            }
            
            // Prepare main table data
            $mainData = array(
                'finicial_Year' => $this->input->post('finicial_Year'),
                'Start_date' => $this->input->post('Start_date'),
                'End_date' => $this->input->post('End_date')
            );
            
            // Handle file uploads for main table
            $mainData = $this->processMainFiles($mainData, true);
            
            // Update main data
            $this->db->where('Main_id', $mainId);
            $this->db->update('firstinduction_main_master', $mainData);
            
            // Process all tabs with smart update operations
            $this->processTab2Data($mainId, true);
            $this->processTab6Data($mainId, true);
            $this->processTab7Data($mainId, true);
            $this->processTab8Data($mainId, true);
            
            // Complete transaction
            $this->db->trans_complete();
            
            // Check if transaction was successful
            if ($this->db->trans_status() === FALSE) {
                throw new Exception('Database transaction failed');
            }
            
            // Return success response
            echo json_encode(array(
                'status' => 'success',
                'message' => 'Data updated successfully',
                'main_id' => $mainId
            ));
            
        } catch(Exception $e) {
            // Rollback transaction if there's an error
            $this->db->trans_rollback();
            
            echo json_encode(array(
                'status' => 'error',
                'message' => 'Error: ' . $e->getMessage()
            ));
        }
    }

    /**
     * Process main table file uploads
     */
    private function processMainFiles($mainData, $isUpdate)
    {
        // Tab 1 - ALCTE Program
        if(!empty($_FILES['ALCTE_program']['name'])) {
            $upload = $this->uploadFile('ALCTE_program', 'induction/tab1/');
            if($upload['status']) {
                $mainData['ALCTE_program'] = $upload['path'];
            }
        } elseif($isUpdate && $this->input->post('hidden_ALCTE_program')) {
            $mainData['ALCTE_program'] = $this->input->post('hidden_ALCTE_program');
        }
        
        // Tab 3 - Institute Calendar
        if(!empty($_FILES['Insti_cal']['name'])) {
            $upload = $this->uploadFile('Insti_cal', 'induction/tab3/');
            if($upload['status']) {
                $mainData['Insti_cal'] = $upload['path'];
            }
        } elseif($isUpdate && $this->input->post('hidden_Insti_cal')) {
            $mainData['Insti_cal'] = $this->input->post('hidden_Insti_cal');
        }
        
        // Tab 4 - Department Calendar
        if(!empty($_FILES['Dep_cal']['name'])) {
            $upload = $this->uploadFile('Dep_cal', 'induction/tab4/');
            if($upload['status']) {
                $mainData['Dep_cal'] = $upload['path'];
            }
        } elseif($isUpdate && $this->input->post('hidden_Dep_cal')) {
            $mainData['Dep_cal'] = $this->input->post('hidden_Dep_cal');
        }
        
        // Tab 5 - Notice Time Table
        if(!empty($_FILES['Notice_table']['name'])) {
            $upload = $this->uploadFile('Notice_table', 'induction/tab5/');
            if($upload['status']) {
                $mainData['Notice_table'] = $upload['path'];
            }
        } elseif($isUpdate && $this->input->post('hidden_Notice_table')) {
            $mainData['Notice_table'] = $this->input->post('hidden_Notice_table');
        }
        
        return $mainData;
    }

    /**
     * Upload file with proper validation
     */
    private function uploadFile($fieldName, $subFolder = '')
    {
        $uploadPath = './uploads/' . $subFolder;
        
        // Create directory if not exists
        if(!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, TRUE);
        }
        
        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png|xls|xlsx';
        $config['max_size'] = 10240; // 10MB
        $config['encrypt_name'] = TRUE;
        
        $this->upload->initialize($config);
        
        if($this->upload->do_upload($fieldName)) {
            $fileData = $this->upload->data();
            return array(
                'status' => true,
                'path' => 'uploads/' . $subFolder . $fileData['file_name'],
                'data' => $fileData
            );
        }
        
        return array(
            'status' => false,
            'error' => $this->upload->display_errors()
        );
    }

    /**
     * Process Tab 2 - Faculty Training Letter (Smart Update)
     */
    private function processTab2Data($mainId, $isUpdate)
    {
        $secIds = $this->input->post('Sec_id');
        $dates = $this->input->post('Date');
        $startTimes = $this->input->post('Start_time');
        $endTimes = $this->input->post('End_time');
        $activities = $this->input->post('Activity');
        $resPersons = $this->input->post('Res_person');
        $venueLocations = $this->input->post('Venue_location');
        $photoUrls = $this->input->post('Photo_url');
        
        // Collect all IDs that should be kept
        $keepIds = array();
        
        if(!empty($dates)) {
            foreach($dates as $key => $date) {
                if(empty($date)) continue;
                
                $data = array(
                    'fkMain_id' => $mainId,
                    'Date' => $date,
                    'Start_time' => isset($startTimes[$key]) ? $startTimes[$key] : '',
                    'End_time' => isset($endTimes[$key]) ? $endTimes[$key] : '',
                    'Activity' => isset($activities[$key]) ? $activities[$key] : '',
                    'Res_person' => isset($resPersons[$key]) ? $resPersons[$key] : '',
                    'Venue_location' => isset($venueLocations[$key]) ? $venueLocations[$key] : '',
                    'Photo_url' => isset($photoUrls[$key]) ? $photoUrls[$key] : ''
                );
                
                if($isUpdate && !empty($secIds[$key])) {
                    // Update existing record
                    $this->db->where('Sec_id', $secIds[$key]);
                    $this->db->update('firstind_sec_master', $data);
                    $keepIds[] = $secIds[$key];
                } else {
                    // Insert new record
                    $this->db->insert('firstind_sec_master', $data);
                    $keepIds[] = $this->db->insert_id();
                }
            }
        }
        
        // Delete records that are not in the form anymore
        if($isUpdate && !empty($keepIds)) {
            $this->db->where('fkMain_id', $mainId);
            $this->db->where_not_in('Sec_id', $keepIds);
            $this->db->delete('firstind_sec_master');
        }
    }

    /**
     * Process Tab 6 - Photographs Of Activities (Smart Update)
     */
    private function processTab6Data($mainId, $isUpdate)
    {
        $thirdIds = $this->input->post('Third_id');
        $photosUrls = $this->input->post('Photos_URL');
        
        // Collect all IDs that should be kept
        $keepIds = array();
        
        if(!empty($photosUrls)) {
            foreach($photosUrls as $key => $photoUrl) {
                if(empty($photoUrl)) continue;
                
                $data = array(
                    'fkMain_id' => $mainId,
                    'Photos_URL' => $photoUrl
                );
                
                if($isUpdate && !empty($thirdIds[$key])) {
                    // Update existing record
                    $this->db->where('Third_id', $thirdIds[$key]);
                    $this->db->update('firstind_third_master', $data);
                    $keepIds[] = $thirdIds[$key];
                } else {
                    // Insert new record
                    $this->db->insert('firstind_third_master', $data);
                    $keepIds[] = $this->db->insert_id();
                }
            }
        }
        
        // Delete records that are not in the form anymore
        if($isUpdate && !empty($keepIds)) {
            $this->db->where('fkMain_id', $mainId);
            $this->db->where_not_in('Third_id', $keepIds);
            $this->db->delete('firstind_third_master');
        }
    }

    /**
     * Process Tab 7 - Invitation And Thanking Letter (Smart Update)
     */
    private function processTab7Data($mainId, $isUpdate)
    {
        try {
            $fourthIds = $this->input->post('Fourth_id');
            $existingFiles = $this->input->post('existing_Doc_letter');
            $guestNames = $this->input->post('Guest_name');
            
            // Collect all IDs that should be kept
            $keepIds = array();
            
            // Get count of entries
            $entryCount = 0;
            if (!empty($fourthIds) && is_array($fourthIds)) {
                $entryCount = count($fourthIds);
            } elseif (!empty($_FILES['Doc_letter']['name'])) {
                $entryCount = count($_FILES['Doc_letter']['name']);
            }
            
            // Process each entry
            for ($i = 0; $i < $entryCount; $i++) {
                $filePath = '';
                
                // Check if new file is uploaded
                if (!empty($_FILES['Doc_letter']['name'][$i])) {
                    // Prepare file for upload
                    $_FILES['temp_file']['name'] = $_FILES['Doc_letter']['name'][$i];
                    $_FILES['temp_file']['type'] = $_FILES['Doc_letter']['type'][$i];
                    $_FILES['temp_file']['tmp_name'] = $_FILES['Doc_letter']['tmp_name'][$i];
                    $_FILES['temp_file']['error'] = $_FILES['Doc_letter']['error'][$i];
                    $_FILES['temp_file']['size'] = $_FILES['Doc_letter']['size'][$i];
                    
                    $upload = $this->uploadFile('temp_file', 'induction/tab7/');
                    
                    if ($upload['status']) {
                        $filePath = $upload['path'];
                    }
                } elseif (isset($existingFiles[$i]) && !empty($existingFiles[$i])) {
                    $filePath = $existingFiles[$i];
                }
                
                // Only insert/update if we have a file path
                if (!empty($filePath)) {
                    $data = array(
                        'fkMain_id' => $mainId,
                        'Doc_letter' => $filePath,
                        'Guest_name' => isset($guestNames[$i]) ? $guestNames[$i] : ''
                    );
                    
                    if ($isUpdate && !empty($fourthIds[$i]) && is_numeric($fourthIds[$i])) {
                        // Update existing record
                        $this->db->where('Fourth_id', $fourthIds[$i]);
                        $this->db->update('firstind_fourth_master', $data);
                        $keepIds[] = $fourthIds[$i];
                    } else {
                        // Insert new record
                        $this->db->insert('firstind_fourth_master', $data);
                        $keepIds[] = $this->db->insert_id();
                    }
                }
            }
            
            // Delete records that are not in the form anymore
            if($isUpdate && !empty($keepIds)) {
                $this->db->where('fkMain_id', $mainId);
                $this->db->where_not_in('Fourth_id', $keepIds);
                $this->db->delete('firstind_fourth_master');
            }
            
            return true;
            
        } catch (Exception $e) {
            log_message('error', 'Tab 7 Error: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Process Tab 8 - Feedback Analysis (Smart Update)
     */
    private function processTab8Data($mainId, $isUpdate)
    {
        try {
            $fifthIds = $this->input->post('Fifth_id');
            $existingFiles = $this->input->post('existing_Doc_feedback');
            
            // Collect all IDs that should be kept
            $keepIds = array();
            
            // Get count of entries
            $entryCount = 0;
            if (!empty($fifthIds) && is_array($fifthIds)) {
                $entryCount = count($fifthIds);
            } elseif (!empty($_FILES['Doc_feedback']['name'])) {
                $entryCount = count($_FILES['Doc_feedback']['name']);
            }
            
            // Process each entry
            for ($i = 0; $i < $entryCount; $i++) {
                $filePath = '';
                
                // Check if new file is uploaded
                if (!empty($_FILES['Doc_feedback']['name'][$i])) {
                    // Prepare file for upload
                    $_FILES['temp_file']['name'] = $_FILES['Doc_feedback']['name'][$i];
                    $_FILES['temp_file']['type'] = $_FILES['Doc_feedback']['type'][$i];
                    $_FILES['temp_file']['tmp_name'] = $_FILES['Doc_feedback']['tmp_name'][$i];
                    $_FILES['temp_file']['error'] = $_FILES['Doc_feedback']['error'][$i];
                    $_FILES['temp_file']['size'] = $_FILES['Doc_feedback']['size'][$i];
                    
                    $upload = $this->uploadFile('temp_file', 'induction/tab8/');
                    
                    if ($upload['status']) {
                        $filePath = $upload['path'];
                    }
                } elseif (isset($existingFiles[$i]) && !empty($existingFiles[$i])) {
                    $filePath = $existingFiles[$i];
                }
                
                // Only insert/update if we have a file path
                if (!empty($filePath)) {
                    $data = array(
                        'fkMain_id' => $mainId,
                        'Doc_feedback' => $filePath
                    );
                    
                    if ($isUpdate && !empty($fifthIds[$i]) && is_numeric($fifthIds[$i])) {
                        // Update existing record
                        $this->db->where('Fifth_id', $fifthIds[$i]);
                        $this->db->update('firstind_fifth_master', $data);
                        $keepIds[] = $fifthIds[$i];
                    } else {
                        // Insert new record
                        $this->db->insert('firstind_fifth_master', $data);
                        $keepIds[] = $this->db->insert_id();
                    }
                }
            }
            
            // Delete records that are not in the form anymore
            if($isUpdate && !empty($keepIds)) {
                $this->db->where('fkMain_id', $mainId);
                $this->db->where_not_in('Fifth_id', $keepIds);
                $this->db->delete('firstind_fifth_master');
            }
            
            return true;
            
        } catch (Exception $e) {
            log_message('error', 'Tab 8 Error: ' . $e->getMessage());
            return false;
        }
    }
}