<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class GuestReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('GuestReport_model');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
        
    }

public function Report()
{
    $data['alldata'] = []; // Empty by default
     $data['yeardata'] = $this->GuestReport_model->getyear();
      $data['institutedata'] = $this->GuestReport_model->getinstitu();
    $data['branchdata'] = $this->GuestReport_model->getbranch();
    $data['classdata'] = $this->GuestReport_model->getclass();

    $activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
   
    $this->load->view('admin/header_view');
    $this->load->view('admin/GuestReport_view.php',$data);
    $this->load->view('admin/footer_view');
}



public function getguestData()
{
    $institu_id = $this->input->post('fk_institu'); 
    $branch_ids = $this->input->post('fkbranch_id');
     $class_ids = $this->input->post('fkclass_id');
    $year_id = $this->input->post('year');  
    $start_date = $this->input->post('start_date');  // Add this
    $end_date = $this->input->post('end_date');      // Add this

    $data = $this->GuestReport_model->getGuestDataFiltered(
        $institu_id, 
        $branch_ids, 
        $class_ids, 
        $year_id, 
        $start_date, 
        $end_date
    );
    

    echo json_encode($data);
}

  

public function getPrintHeadings()
{
    $data = $this->GuestReport_model->getPrintHeadings();
    echo json_encode($data);
}


// studenet view

public function getStudentList()
{
    $fkGuest_id = $this->input->post('fkGuest_id');
    if (!$fkGuest_id) {
        echo json_encode([]);
        return;
    }
 
    // $this->load->model('ParentMeet_model');
    $students = $this->GuestReport_model->getStudentsByMeetId($fkGuest_id);
 
    echo json_encode($students);
}

// pai and ghraph new 

public function getYearwiseData()
{
    $year = $this->input->post('year');
    $branches  = $this->input->post('branches');   // may be an array
 
    
    
    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->GuestReport_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year
        $summary = $this->GuestReport_model->getSingleYearData($year,$branches);
        $types   = $this->GuestReport_model->getYearwiseTypes($year,$branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('start_date');  // match JS
    $endDate   = $this->input->post('end_date');    // match JS
 
    $result = $this->GuestReport_model->getBranchwiseCount($institu, $branches, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('start_date');  // match JS
    $endDate   = $this->input->post('end_date');    // match JS
 
    $result = $this->GuestReport_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
    $startDate = $this->input->post('start_date');
    $endDate   = $this->input->post('end_date');
 
    $result = $this->GuestReport_model->getCombinedData($institu, $branches, $years, $startDate, $endDate);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}
 
}
