<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Honor_Minor extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Honor_Minor_model');
        $this->load->library('upload');
         $this->load->model('Log_model');
        $this->load->helper('log');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    public function dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Honor_Minor_dash');
        $this->load->view('admin/footer_view');
    }

    public function index()
    {
        $data['alldata'] = $this->Honor_Minor_model->getdetailview();
        $this->load->view('admin/header_view');
        $this->load->view('admin/Honor_Minor_detailview', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['honor_minor_types'] = $this->Honor_Minor_model->getHonorMinorTypes();
        $data['branchdata'] = $this->Honor_Minor_model->getRegisteredBranches();
        $data['yeardata'] = $this->Honor_Minor_model->getyear();
        $data['activeYear'] = $this->Honor_Minor_model->getActiveYear();
        $data['durations'] = $this->Honor_Minor_model->getDurations();

// ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Honor_Minor_view', $data);
        $this->load->view('admin/footer_view');
    }

    function inserthonorminor()
    {
        try {
            $fk_honor_minor_type = $this->input->post('fk_honor_minor_type');
            $student_name = $this->input->post('student_name');
            $prn_no = $this->input->post('prn_no');
            $fkbranch_id = $this->input->post('fkbranch_id');
            $fk_year = $this->input->post('fk_year');
            $honor_minor_date = $this->input->post('honor_minor_date');
            $faculty_name = $this->input->post('faculty_name');
            $details = $this->input->post('details');
$fk_submenuId = $this->input->post('fk_submenuId');

            $upload_dir = './uploads/honor_minor_pdf/';
            $pdf_filename = $this->upload_file('pdf_file', $upload_dir); 
            
            if ($pdf_filename === false && !empty($_FILES['pdf_file']['name'])) {
                echo json_encode(['status' => 'error', 'message' => 'Failed to upload PDF file.']);
                return;
            }
            
            $pdf_file = $pdf_filename ? '/uploads/honor_minor_pdf/' . $pdf_filename : ''; 

            $fields = array(
                'fk_honor_minor_type' => $fk_honor_minor_type,
                'student_name' => $student_name,
                'prn_no' => $prn_no,
                'fkbranch_id' => $fkbranch_id,
                'fk_year' => $fk_year,
                'honor_minor_date' => $honor_minor_date,
                'faculty_name' => $faculty_name,
                'details' => $details,
                'pdf_file' => $pdf_file, 
                'created_date' => date('Y-m-d H:i:s'),
                'created_by'=>$_SESSION['userID']
            );

            $institute = $this->db
                ->select('Institu_id')
                ->from('institute_master')
                ->get()
                ->row();

            if ($institute) {
                $fields['fkInstitu_id'] = $institute->Institu_id;
            } else {
                $fields['fkInstitu_id'] = 1; 
            }

            $insertSuccess = $this->Honor_Minor_model->insertdata($fields);
            // Insert log - Action 1 (Insert)

    $honor_minor_id =$insertSuccess ;

        $action = 1;

        $record_id = $insertSuccess;

        $excel_name = null;

        $Fk_branch = $fkbranch_id;

        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

        //  $sub_id = $this->db->insert_id();
            
            
            if (!$insertSuccess) {
                echo json_encode(['status' => 'error', 'message' => 'Failed to insert honor/minor data']);
                return;
            }

            // $honor_minor_id = $this->db->insert_id();

            // Insert Course Details
            $course_names = $this->input->post('course_name');
            $duration_ids = $this->input->post('duration'); // YE DURATION_ID HAI
            $start_dates = $this->input->post('start_date');
            $end_dates = $this->input->post('end_date');
            $grades = $this->input->post('grade');
            $course_years = $this->input->post('course_year');

            if (!empty($course_names)) {
                foreach ($course_names as $i => $course) {
                    if (trim($course) == '') continue;

                    // Handle certificate file upload for each course
                    $certificate_file = '';
                    if (!empty($_FILES['certificate_file']['name'][$i])) {
                        $certificate_file = $this->upload_course_certificate($i);
                    }
                    
                    // DURATION_ID KO INT MEIN CONVERT KARO
                    $duration_value = isset($duration_ids[$i]) && !empty($duration_ids[$i]) ? (int)$duration_ids[$i] : null;
                    
                    $courseData = array(
                        'fk_honor_minor_id' => $honor_minor_id,
                        'course_name' => $course,
                        'duration' => $duration_value, // AB YE INT HAI
                        'start_date' => $start_dates[$i] ?? null,
                        'end_date' => $end_dates[$i] ?? null,
                        'grade' => $grades[$i] ?? null,
                        'certificate_file' => $certificate_file,
                        'fk_year' => $course_years[$i] ?? null,
                        'created_date' => date('Y-m-d H:i:s')
                    );

                    $courseSuccess = $this->Honor_Minor_model->insertCourseDetail($courseData);
                    
                    if (!$courseSuccess) {
                        echo json_encode([
                            'status' => 'error', 
                            'message' => 'Failed to insert course detail: ' . $course,
                            'course_data' => $courseData
                        ]);
                        return;
                    }
                }
            }

            echo json_encode(['status' => 'success']);
            
        } catch (Exception $e) {
            echo json_encode([
                'status' => 'error', 
                'message' => 'Exception: ' . $e->getMessage(),
                'line' => $e->getLine(),
                'file' => $e->getFile()
            ]);
        }
    }

    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->Honor_Minor_model->getbyid($id);
        $data['honor_minor_types'] = $this->Honor_Minor_model->getHonorMinorTypes();
        $data['branchdata'] = $this->Honor_Minor_model->getRegisteredBranches();
        $data['courseDetails'] = $this->Honor_Minor_model->getCourseDetailsByMainId($id);
        $data['yeardata'] = $this->Honor_Minor_model->getyear();
        $data['activeYear'] = $this->Honor_Minor_model->getActiveYear();
        $data['durations'] = $this->Honor_Minor_model->getDurations();

$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Honor_Minor_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function updatehonorminor()
    {
        try {
            $honor_minor_id = $this->input->post('honor_minor_id');
            $fk_honor_minor_type = $this->input->post('fk_honor_minor_type');
            $student_name = $this->input->post('student_name');
            $prn_no = $this->input->post('prn_no');
            $fkbranch_id = $this->input->post('fkbranch_id');
            $fk_year = $this->input->post('fk_year');
            $honor_minor_date = $this->input->post('honor_minor_date');
            $faculty_name = $this->input->post('faculty_name');
            $details = $this->input->post('details');
$fk_submenuId = $this->input->post('fk_submenuId');

            $upload_dir = './uploads/honor_minor_pdf/';
            $existing_pdf = $this->input->post('hidden_pdf'); 
            $pdf_filename = false;

            if (!empty($_FILES['pdf_file']['name'])) {
                $pdf_filename = $this->upload_file('pdf_file', $upload_dir);
                
                if ($pdf_filename === false) {
                    echo json_encode(['status' => 'error', 'message' => 'Failed to upload PDF file.']);
                    return;
                }
            }
            
            $pdf_file = $pdf_filename ? '/uploads/honor_minor_pdf/' . $pdf_filename : $existing_pdf;

            $fields = [
                'honor_minor_id' => $honor_minor_id,
                'fk_honor_minor_type' => $fk_honor_minor_type,
                'student_name' => $student_name,
                'prn_no' => $prn_no,
                'fkbranch_id' => $fkbranch_id,
                'fk_year' => $fk_year,
                'honor_minor_date' => $honor_minor_date,
                'faculty_name' => $faculty_name,
                'details' => $details,
                'pdf_file' => $pdf_file, 
                'modified_date' => date('Y-m-d H:i:s'),
                'modified_by'=>$_SESSION['userID']
            ];

            $updateSuccess = $this->Honor_Minor_model->update($fields);
            // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $honor_minor_id;
        $excel_name = null;
        $Fk_branch = $fkbranch_id;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
        
            
            if (!$updateSuccess) {
                echo json_encode(['status' => 'error', 'message' => 'Failed to update honor/minor data']);
                return;
            }

            // Update Course Details
            $existing_courses = $this->Honor_Minor_model->getCourseDetailsByMainId($honor_minor_id);
            $existing_ids = array();
            foreach($existing_courses as $course) {
                $existing_ids[] = $course->course_detail_id;
            }

            $course_detail_ids = $this->input->post('course_detail_id');
            $course_names = $this->input->post('course_name');
            $duration_ids = $this->input->post('duration'); // YE DURATION_ID HAI
            $start_dates = $this->input->post('start_date');
            $end_dates = $this->input->post('end_date');
            $grades = $this->input->post('grade');
            $course_years = $this->input->post('course_year');
            $hidden_certificates = $this->input->post('hidden_certificate');

            $processed_ids = array();

            if (!empty($course_names)) {
                foreach ($course_names as $i => $course) {
                    if (trim($course) == '') continue;

                    // Handle certificate file
                    $certificate_file = $hidden_certificates[$i] ?? '';
                    if (!empty($_FILES['certificate_file']['name'][$i])) {
                        $new_cert = $this->upload_course_certificate($i);
                        if ($new_cert) {
                            $certificate_file = $new_cert;
                        }
                    }
                    
                    // DURATION_ID KO INT MEIN CONVERT KARO
                    $duration_value = isset($duration_ids[$i]) && !empty($duration_ids[$i]) ? (int)$duration_ids[$i] : null;
                    
                    $courseData = array(
                        'fk_honor_minor_id' => $honor_minor_id,
                        'course_name' => $course,
                        'duration' => $duration_value, // AB YE INT HAI
                        'start_date' => $start_dates[$i] ?? null,
                        'end_date' => $end_dates[$i] ?? null,
                        'grade' => $grades[$i] ?? null,
                        'certificate_file' => $certificate_file,
                        'fk_year' => $course_years[$i] ?? null,
                        'modified_date' => date('Y-m-d H:i:s')
                    );

                    $existing_id = $course_detail_ids[$i] ?? null;
                    
                    if (!empty($existing_id) && is_numeric($existing_id)) {
                        $this->Honor_Minor_model->updateCourseDetail($existing_id, $courseData);
                        $processed_ids[] = $existing_id;
                    } else {
                        $courseData['created_date'] = date('Y-m-d H:i:s');
                        $this->Honor_Minor_model->insertCourseDetail($courseData);
                    }
                }
            }

            // Delete removed courses
            $ids_to_delete = array_diff($existing_ids, $processed_ids);
            if (!empty($ids_to_delete)) {
                foreach($ids_to_delete as $delete_id) {
                    $this->Honor_Minor_model->deleteCourseDetail($delete_id);
                }
            }

            echo json_encode(['status' => 'success']);
            
        } catch (Exception $e) {
            echo json_encode([
                'status' => 'error', 
                'message' => 'Exception: ' . $e->getMessage(),
                'line' => $e->getLine(),
                'file' => $e->getFile()
            ]);
        }
    }

    private function upload_file($field_name, $upload_path) {
        if (!empty($_FILES[$field_name]['name'])) {
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'pdf|doc|docx';
            $config['max_size'] = 10000; 
            $config['encrypt_name'] = TRUE; 
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $this->upload->initialize($config); 
            
            if ($this->upload->do_upload($field_name)) {
                $upload_data = $this->upload->data();
                return $upload_data['file_name'];
            } else {
                return false;
            }
        }
        return false;
    }

    private function upload_course_certificate($index) {
        $upload_dir = './uploads/honor_minor_certificates/';
        
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }

        $config['upload_path'] = $upload_dir;
        $config['allowed_types'] = 'pdf|jpg|jpeg|png';
        $config['max_size'] = 5000;
        $config['encrypt_name'] = TRUE;

        $this->upload->initialize($config);

        $_FILES['userfile']['name'] = $_FILES['certificate_file']['name'][$index];
        $_FILES['userfile']['type'] = $_FILES['certificate_file']['type'][$index];
        $_FILES['userfile']['tmp_name'] = $_FILES['certificate_file']['tmp_name'][$index];
        $_FILES['userfile']['error'] = $_FILES['certificate_file']['error'][$index];
        $_FILES['userfile']['size'] = $_FILES['certificate_file']['size'][$index];

        if ($this->upload->do_upload('userfile')) {
            $upload_data = $this->upload->data();
            return '/uploads/honor_minor_certificates/' . $upload_data['file_name'];
        }
        
        return '';
    }

    public function insert_honor_minor_type()
    {
        $honor_minor_type_name = $this->input->post('honor_minor_type_name');
        
        $fields = array(
            'honor_minor_type_name' => $honor_minor_type_name,
            'created_date' => date('Y-m-d H:i:s')
        );

        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        if ($institute) {
            $fields['fkInstitu_id'] = $institute->Institu_id;
        } else {
            $fields['fkInstitu_id'] = 1;
        }

        $insertSuccess = $this->Honor_Minor_model->insertHonorMinorType($fields);
        
        if (!$insertSuccess) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to insert honor/minor type']);
            return;
        }
        
        echo json_encode(['status' => 'success']);
    }
}