<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class ICTtools extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('ICTtools_model');
        $this->load->library('upload');
        $this->load->model('Log_model');
        $this->load->helper('log');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }
    
    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/ICTtools_dash_view.php');
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['branchdata'] = $this->ICTtools_model->getbranch();
        $data['facultydata'] = $this->ICTtools_model->getfaculty();
        $data['yeardata'] = $this->ICTtools_model->getyear();
        
// ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/ICTtools_view.php', $data);
        $this->load->view('admin/footer_view');
    }

     public function index()
    {
        // Load list view
        $data['alldata'] = $this->ICTtools_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/ICTtools_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function insertICTTools()
{
    try {
        $this->output->set_content_type('application/json');
        
        // Get arrays from POST
        $fkbranch_id = $this->input->post('fkbranch_id');
        $fkfac_id = $this->input->post('fkfac_id');
        $ict_link = $this->input->post('ict_link');
        $description = $this->input->post('description');
        $publish_date = $this->input->post('publish_date');
        $finicial_Year = $this->input->post('finicial_Year');
        $fk_submenuId = $this->input->post('fk_submenuId');
        // Get new master data
        $new_branches = json_decode($this->input->post('new_branches'), true) ?: [];
        $new_faculties = json_decode($this->input->post('new_faculties'), true) ?: [];
        $new_years = json_decode($this->input->post('new_years'), true) ?: [];
        
        // Validation
        if (empty($fkbranch_id) || !is_array($fkbranch_id)) {
            echo json_encode(['status' => 'error', 'message' => 'At least one ICT tool record is required']);
            return;
        }
        
        // Create mapping arrays for new entries
        $branch_mapping = [];
        $faculty_mapping = [];
        $year_mapping = [];
        
        // Insert new branches
        foreach ($new_branches as $branch_name) {
            if (!empty($branch_name)) {
                $existing_id = $this->ICTtools_model->getBranchIdByName($branch_name);
                
                if ($existing_id) {
                    $branch_mapping['NEW::' . $branch_name] = $existing_id;
                } else {
                    $branch_data = [
                        'branch_name' => $branch_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_branch_id = $this->ICTtools_model->insertBranch($branch_data);
                    if ($new_branch_id) {
                        $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
                    }
                }
            }
        }
        
        // Insert new faculties
        foreach ($new_faculties as $faculty_name) {
            if (!empty($faculty_name)) {
                $existing_id = $this->ICTtools_model->getFacultyIdByName($faculty_name);
                
                if ($existing_id) {
                    $faculty_mapping['NEW::' . $faculty_name] = $existing_id;
                } else {
                    $faculty_data = [
                        'fac_Fullname' => $faculty_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_faculty_id = $this->ICTtools_model->insertFaculty($faculty_data);
                    if ($new_faculty_id) {
                        $faculty_mapping['NEW::' . $faculty_name] = $new_faculty_id;
                    }
                }
            }
        }
        
        // Insert new years
        foreach ($new_years as $year_name) {
            if (!empty($year_name)) {
                $existing_id = $this->ICTtools_model->getYearIdByName($year_name);
                
                if ($existing_id) {
                    $year_mapping['NEW::' . $year_name] = $existing_id;
                } else {
                    $year_data = [
                        'fini_Label' => $year_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_year_id = $this->ICTtools_model->insertYear($year_data);
                    if ($new_year_id) {
                        $year_mapping['NEW::' . $year_name] = $new_year_id;
                    }
                }
            }
        }
        
        // ============================================
        // HANDLE EXCEL FILE - SINGLE FILE, NOT PER ROW
        // ============================================
        $excel_name = null;
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'xlsx|xls';
            $config['max_size'] = 10240;
            $config['file_name'] = 'ict_tools_excel_' . time() . '_' . $_FILES['excel_file']['name'];
            $config['overwrite'] = FALSE;
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
                log_message('debug', "Excel file uploaded: {$excel_name}");
            } else {
                log_message('error', "Excel upload failed: " . $this->upload->display_errors());
            }
        }

        // ============================================
        // HANDLE OTHER_DOC FILES - MULTIPLE FILES
        // ============================================
        $other_files = [];
        
        if (!empty($_FILES['Other_doc']['name'])) {
            $file_count = count($_FILES['Other_doc']['name']);
            
            log_message('debug', "Total Other_doc files to process: {$file_count}");
            
            for ($i = 0; $i < $file_count; $i++) {
                // Skip empty files
                if (empty($_FILES['Other_doc']['name'][$i])) {
                    log_message('debug', "Skipping empty file at index {$i}");
                    continue;
                }
                
                // Check for upload errors
                if ($_FILES['Other_doc']['error'][$i] !== UPLOAD_ERR_OK) {
                    log_message('error', "Upload error at index {$i}: " . $_FILES['Other_doc']['error'][$i]);
                    continue;
                }
                
                // Prepare file for individual upload
                $_FILES['temp_file'] = [
                    'name' => $_FILES['Other_doc']['name'][$i],
                    'type' => $_FILES['Other_doc']['type'][$i],
                    'tmp_name' => $_FILES['Other_doc']['tmp_name'][$i],
                    'error' => $_FILES['Other_doc']['error'][$i],
                    'size' => $_FILES['Other_doc']['size'][$i]
                ];
                
                $upload_path = './uploads/ict_tools/Other_doc/';
                if (!is_dir($upload_path)) {
                    mkdir($upload_path, 0777, true);
                }
                
                $config = [
                    'upload_path' => $upload_path,
                    'allowed_types' => 'pdf|doc|docx',
                    'file_name' => 'other_' . time() . '_' . $i . '_' . $_FILES['Other_doc']['name'][$i],
                    // 'max_size' => 5120,
                    'overwrite' => FALSE
                ];
                
                $this->upload->initialize($config);
                
                if ($this->upload->do_upload('temp_file')) {
                    $upload_data = $this->upload->data();
                    $other_files[$i] = $upload_data['file_name'];
                    log_message('debug', "Other_doc uploaded at index {$i}: {$other_files[$i]}");
                } else {
                    log_message('error', "Other_doc upload failed at index {$i}: " . $this->upload->display_errors());
                }
            }
        }

        // Get institute
        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $institute_id = $institute ? $institute->Institu_id : null;

        $inserted_count = 0;
        $failed_count = 0;
        $total_rows = count($fkbranch_id);

        // Insert all ICT tool records
        for ($i = 0; $i < $total_rows; $i++) {
            // Get and resolve branch ID
            $branch_id = $fkbranch_id[$i];
            if (empty($branch_id)) {
                $failed_count++;
                log_message('debug', "Row {$i} skipped: Empty branch ID");
                continue;
            }
            
            // Resolve branch mapping
            if (strpos($branch_id, 'NEW::') === 0) {
                if (isset($branch_mapping[$branch_id])) {
                    $branch_id = $branch_mapping[$branch_id];
                } else {
                    $failed_count++;
                    log_message('error', "Row {$i}: Branch mapping not found");
                    continue;
                }
            }
            
            // Resolve faculty
            $faculty_id = isset($fkfac_id[$i]) && !empty($fkfac_id[$i]) ? $fkfac_id[$i] : null;
            if ($faculty_id && strpos($faculty_id, 'NEW::') === 0) {
                $faculty_id = isset($faculty_mapping[$faculty_id]) ? $faculty_mapping[$faculty_id] : null;
            }
            
            // Resolve year
            $year_id = isset($finicial_Year[$i]) && !empty($finicial_Year[$i]) ? $finicial_Year[$i] : null;
            if ($year_id && strpos($year_id, 'NEW::') === 0) {
                $year_id = isset($year_mapping[$year_id]) ? $year_mapping[$year_id] : null;
            }
            
            // Prepare data for insertion
            $toolData = array(
                'fkbranch_id' => $branch_id,
                'fkfac_id' => $faculty_id,
                'ict_link' => isset($ict_link[$i]) && !empty($ict_link[$i]) ? $ict_link[$i] : null,
                'Desscription' => isset($description[$i]) && !empty($description[$i]) ? $description[$i] : null,
                'Publish_date' => isset($publish_date[$i]) && !empty($publish_date[$i]) ? $publish_date[$i] : null,
                'finicial_Year' => $year_id,
                'institute' => $institute_id,
                'excel_file' => $excel_name, // SAME EXCEL FILE FOR ALL ROWS
                'Other_doc' => isset($other_files[$i]) ? $other_files[$i] : null, // INDIVIDUAL FILE PER ROW
                'is_on' => 1,
                'is_active' => 1,
                'created_date' => date('Y-m-d H:i:s'),
                'created_by'=>$_SESSION['userID']
            );

            log_message('debug', "Inserting row {$i}: " . print_r($toolData, true));

            // Insert into database
            // if ($this->ICTtools_model->insertICTTool($toolData)) {
            //     $inserted_count++;
            // }
            $inserted_id = $this->ICTtools_model->insertICTTool($toolData);

if ($inserted_id) {

    $inserted_count++;

    // 🔹 log insert
    $action = 1; // Insert
    $record_id = $inserted_id;
    $excel_name = null;
    $Fk_branch = $branch_id;

    insert_log(
        $this,
        $fk_submenuId,
        $action,
        $record_id,
        $excel_name,
        $Fk_branch,
        $_SESSION['userID']
    );
}


            else {
                $failed_count++;
                log_message('error', "Failed to insert row {$i}");
            }
        }

        // Response
        if ($inserted_count > 0) {
            $message = "Successfully saved {$inserted_count} out of {$total_rows} ICT tool records";
            if ($failed_count > 0) {
                $message .= ". {$failed_count} records failed.";
            }
            
            echo json_encode([
                'status' => 'success', 
                'inserted_count' => $inserted_count,
                'failed_count' => $failed_count,
                'total_rows' => $total_rows,
                'message' => $message
            ]);
        } else {
            echo json_encode([
                'status' => 'error', 
                'message' => "No records were saved"
            ]);
        }
        
    } catch (Exception $e) {
        log_message('error', 'ICT Tools insertion error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}
    // ICTtools Controller mein yeh methods add karein

public function update($ict_id)
{
    // Get existing record
    $data['record'] = $this->ICTtools_model->getICTToolById($ict_id);
    
   
    
    $data['branchdata'] = $this->ICTtools_model->getbranch();
    $data['facultydata'] = $this->ICTtools_model->getfaculty();
    $data['yeardata'] = $this->ICTtools_model->getyear();
    
$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
     $this->load->view('admin/ICTtools_view.php', $data);
    $this->load->view('admin/footer_view');
}


// ICTtools Controller mein ye method add karein

public function updateICTTools()
{
    try {
        $this->output->set_content_type('application/json');
        
        // Get ICT ID
        $ict_id = $this->input->post('ict_id');
        
        if (empty($ict_id)) {
            echo json_encode(['status' => 'error', 'message' => 'ICT ID is required']);
            return;
        }
        
        // Get existing record
        $existing_record = $this->ICTtools_model->getICTToolById($ict_id);
        if (!$existing_record) {
            echo json_encode(['status' => 'error', 'message' => 'Record not found']);
            return;
        }
        
        // Get form data - ARRAYS
        $fkbranch_id = $this->input->post('fkbranch_id');
        $fkfac_id = $this->input->post('fkfac_id');
        $ict_link = $this->input->post('ict_link');
        $description = $this->input->post('description');
        $publish_date = $this->input->post('publish_date');
        $finicial_Year = $this->input->post('finicial_Year');
        $fk_submenuId = $this->input->post('fk_submenuId');
        // Validation
        if (empty($fkbranch_id) || !is_array($fkbranch_id) || empty($fkbranch_id[0])) {
            echo json_encode(['status' => 'error', 'message' => 'Branch is required']);
            return;
        }
        
        // Get new master data
        $new_branches_json = $this->input->post('new_branches');
        $new_faculties_json = $this->input->post('new_faculties');
        $new_years_json = $this->input->post('new_years');
        
        $new_branches = (!empty($new_branches_json)) ? json_decode($new_branches_json, true) : [];
        $new_faculties = (!empty($new_faculties_json)) ? json_decode($new_faculties_json, true) : [];
        $new_years = (!empty($new_years_json)) ? json_decode($new_years_json, true) : [];
        
        // Ensure arrays
        $new_branches = is_array($new_branches) ? $new_branches : [];
        $new_faculties = is_array($new_faculties) ? $new_faculties : [];
        $new_years = is_array($new_years) ? $new_years : [];
        
        // Create mappings
        $branch_mapping = [];
        $faculty_mapping = [];
        $year_mapping = [];
        
        // Insert new branches
        foreach ($new_branches as $branch_name) {
            if (!empty($branch_name)) {
                $existing_id = $this->ICTtools_model->getBranchIdByName($branch_name);
                
                if ($existing_id) {
                    $branch_mapping['NEW::' . $branch_name] = $existing_id;
                } else {
                    $branch_data = [
                        'branch_name' => $branch_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_branch_id = $this->ICTtools_model->insertBranch($branch_data);
                    if ($new_branch_id) {
                        $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
                    }
                }
            }
        }
        
        // Insert new faculties
        foreach ($new_faculties as $faculty_name) {
            if (!empty($faculty_name)) {
                $existing_id = $this->ICTtools_model->getFacultyIdByName($faculty_name);
                
                if ($existing_id) {
                    $faculty_mapping['NEW::' . $faculty_name] = $existing_id;
                } else {
                    $faculty_data = [
                        'fac_Fullname' => $faculty_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_faculty_id = $this->ICTtools_model->insertFaculty($faculty_data);
                    if ($new_faculty_id) {
                        $faculty_mapping['NEW::' . $faculty_name] = $new_faculty_id;
                    }
                }
            }
        }
        
        // Insert new years
        foreach ($new_years as $year_name) {
            if (!empty($year_name)) {
                $existing_id = $this->ICTtools_model->getYearIdByName($year_name);
                
                if ($existing_id) {
                    $year_mapping['NEW::' . $year_name] = $existing_id;
                } else {
                    $year_data = [
                        'fini_Label' => $year_name,
                        'is_active' => 1,
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    
                    $new_year_id = $this->ICTtools_model->insertYear($year_data);
                    if ($new_year_id) {
                        $year_mapping['NEW::' . $year_name] = $new_year_id;
                    }
                }
            }
        }
        
        // Get first row data
        $branch_val = $fkbranch_id[0];
        $faculty_val = isset($fkfac_id[0]) ? $fkfac_id[0] : null;
        $year_val = isset($finicial_Year[0]) ? $finicial_Year[0] : null;
        
        // Resolve IDs
        $resolved_branch_id = $branch_val;
        if (strpos($branch_val, 'NEW::') === 0) {
            $resolved_branch_id = isset($branch_mapping[$branch_val]) ? $branch_mapping[$branch_val] : null;
            if (!$resolved_branch_id) {
                echo json_encode(['status' => 'error', 'message' => 'Branch mapping not found']);
                return;
            }
        }
        
        $resolved_faculty_id = $faculty_val;
        if ($faculty_val && strpos($faculty_val, 'NEW::') === 0) {
            $resolved_faculty_id = isset($faculty_mapping[$faculty_val]) ? $faculty_mapping[$faculty_val] : null;
        }
        
        $resolved_year_id = $year_val;
        if ($year_val && strpos($year_val, 'NEW::') === 0) {
            $resolved_year_id = isset($year_mapping[$year_val]) ? $year_mapping[$year_val] : null;
        }
        
        // ============================================
        // HANDLE EXCEL FILE
        // ============================================
        $excel_name = $existing_record->excel_file; // Keep existing by default
        
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $config = [
                'upload_path' => $upload_path,
                'allowed_types' => 'xlsx|xls',
                // 'max_size' => 10240,
                'file_name' => 'ict_tools_excel_' . time() . '_' . $_FILES['excel_file']['name'],
                'overwrite' => FALSE
            ];
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
                
                // Delete old excel file
                if (!empty($existing_record->excel_file)) {
                    $old_file = $upload_path . $existing_record->excel_file;
                    if (file_exists($old_file)) {
                        @unlink($old_file);
                    }
                }
                
                log_message('debug', "Excel file updated: {$excel_name}");
            } else {
                log_message('error', "Excel upload failed: " . $this->upload->display_errors());
            }
        }
        
        // ============================================
        // HANDLE OTHER_DOC FILE (SINGLE FILE FOR UPDATE)
        // ============================================
        $other_doc_name = $existing_record->Other_doc; // Keep existing by default
        
        if (!empty($_FILES['Other_doc']['name'][0])) {
            $_FILES['temp_file'] = [
                'name' => $_FILES['Other_doc']['name'][0],
                'type' => $_FILES['Other_doc']['type'][0],
                'tmp_name' => $_FILES['Other_doc']['tmp_name'][0],
                'error' => $_FILES['Other_doc']['error'][0],
                'size' => $_FILES['Other_doc']['size'][0]
            ];
            
            $upload_path = './uploads/ict_tools/Other_doc/';
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $config = [
                'upload_path' => $upload_path,
                'allowed_types' => 'pdf|doc|docx',
                'file_name' => 'other_' . time() . '_' . $_FILES['Other_doc']['name'][0],
                'max_size' => 5120,
                'overwrite' => FALSE
            ];
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('temp_file')) {
                $upload_data = $this->upload->data();
                $other_doc_name = $upload_data['file_name'];
                
                // Delete old other_doc file
                if (!empty($existing_record->Other_doc)) {
                    $old_file = $upload_path . $existing_record->Other_doc;
                    if (file_exists($old_file)) {
                        @unlink($old_file);
                    }
                }
                
                log_message('debug', "Other_doc updated: {$other_doc_name}");
            } else {
                log_message('error', "Other_doc upload failed: " . $this->upload->display_errors());
            }
        }
        
        // Prepare update data
        $updateData = array(
            'fkbranch_id' => $resolved_branch_id,
            'fkfac_id' => $resolved_faculty_id,
            'ict_link' => isset($ict_link[0]) && !empty($ict_link[0]) ? $ict_link[0] : null,
            'Desscription' => isset($description[0]) && !empty($description[0]) ? $description[0] : null,
            'Publish_date' => isset($publish_date[0]) && !empty($publish_date[0]) ? $publish_date[0] : null,
            'finicial_Year' => $resolved_year_id,
            'excel_file' => $excel_name,
            'Other_doc' => $other_doc_name,
            'modified_date' => date('Y-m-d H:i:s'),
            'modified_by'=>$_SESSION['userID']
        );
        
        log_message('debug', 'Update data: ' . print_r($updateData, true));
        
        // Update record
        if ($this->ICTtools_model->updateICTTool($ict_id, $updateData))
             {
                // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $ict_id;
        $excel_name = null;
        $Fk_branch = $resolved_branch_id;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
            echo json_encode([
                'status' => 'success',
                'message' => 'ICT Tool updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to update ICT Tool'
            ]);
        }
        
    } catch (Exception $e) {
        log_message('error', 'ICT Tools update error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}

}