<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ICTtoolsReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('ICTtoolsReport_model');
           if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
        
    }

public function Report()
{

     $data['yeardata'] = $this->ICTtoolsReport_model->getyear();
       $data['facultydata'] = $this->ICTtoolsReport_model->getfaculty();
             $data['institutedata'] = $this->ICTtoolsReport_model->getinstitu();
   
    $data['branchdata'] = $this->ICTtoolsReport_model->getbranch();

//      $activeYear = $this->db
//     ->select('finiYear_id')
//     ->from('finiyear_master')
//     ->where('Active_Deactive', 1)
//     ->get()
//     ->row();
 
// $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
    
    $this->load->view('admin/header_view');
    $this->load->view('admin/ICTtoolsReport_view.php',$data);
    $this->load->view('admin/footer_view');
}


public function getReportData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('fkbranch_id');
    $faculty   = $this->input->post('fkfac_id'); // ✅ Match the form field
    $year_id   = $this->input->post('year');
    $startDate = $this->input->post('startdate');
    $endDate   = $this->input->post('enddate');

    $data = $this->ICTtoolsReport_model->getFilteredData($institu, $branches, $faculty, $year_id, $startDate, $endDate);
    echo json_encode($data);
}

public function getPrintHeadings()
{
    $data = $this->ICTtoolsReport_model->getPrintHeadings();
    echo json_encode($data);
}



// new 

public function getYearwiseData()
{
    $year = $this->input->post('year');
    $branches  = $this->input->post('branches');   // may be an array
    

    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->ICTtoolsReport_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year
        $summary = $this->ICTtoolsReport_model->getSingleYearData($year,$branches);
        $types   = $this->ICTtoolsReport_model->getYearwiseTypes($year,$branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS
 
    $result = $this->ICTtoolsReport_model->getBranchwiseCount($institu, $branches, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS
 
    $result = $this->ICTtoolsReport_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');
 
    $result = $this->ICTtoolsReport_model->getCombinedData($institu, $branches, $years, $startDate, $endDate);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}
 



}